/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.trafficmanager;

import com.microsoft.azure.management.trafficmanager.models.EndpointCreateOrUpdateParameters;
import com.microsoft.azure.management.trafficmanager.models.EndpointCreateOrUpdateResponse;
import com.microsoft.azure.management.trafficmanager.models.EndpointGetResponse;
import com.microsoft.azure.management.trafficmanager.models.EndpointUpdateParameters;
import com.microsoft.azure.management.trafficmanager.models.EndpointUpdateResponse;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.exception.ServiceException;

import java.io.IOException;
import java.util.concurrent.Future;

/**
* Operations for managing Traffic Manager endpoints.
*/
public interface EndpointOperations {
    /**
    * Create or update a Traffic Manager endpoint.
    *
    * @param resourceGroupName Required. The name of the resource group
    * containing the Traffic Manager endpoint to be created or updated.
    * @param profileName Required. The name of the Traffic Manager endpoint to
    * be created or updated.
    * @param endpointType Required. The type of the Traffic Manager endpoint to
    * be created or updated.
    * @param endpointName Required. The name of the Traffic Manager endpoint to
    * be created or updated.
    * @param parameters Required. The Traffic Manager endpoint parameters
    * supplied to the CreateOrUpdate operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The response to a Traffic Manager endpoint 'CreateOrUpdate'
    * operation.
    */
    EndpointCreateOrUpdateResponse createOrUpdate(String resourceGroupName, String profileName, String endpointType, String endpointName, EndpointCreateOrUpdateParameters parameters) throws IOException, ServiceException;
    
    /**
    * Create or update a Traffic Manager endpoint.
    *
    * @param resourceGroupName Required. The name of the resource group
    * containing the Traffic Manager endpoint to be created or updated.
    * @param profileName Required. The name of the Traffic Manager endpoint to
    * be created or updated.
    * @param endpointType Required. The type of the Traffic Manager endpoint to
    * be created or updated.
    * @param endpointName Required. The name of the Traffic Manager endpoint to
    * be created or updated.
    * @param parameters Required. The Traffic Manager endpoint parameters
    * supplied to the CreateOrUpdate operation.
    * @return The response to a Traffic Manager endpoint 'CreateOrUpdate'
    * operation.
    */
    Future<EndpointCreateOrUpdateResponse> createOrUpdateAsync(String resourceGroupName, String profileName, String endpointType, String endpointName, EndpointCreateOrUpdateParameters parameters);
    
    /**
    * Deletes a Traffic Manager endpoint.
    *
    * @param resourceGroupName Required. The name of the resource group
    * containing the Traffic Manager endpoint to be deleted.
    * @param profileName Required. The name of the Traffic Manager endpoint to
    * be deleted.
    * @param endpointType Required. The type of the Traffic Manager endpoint to
    * be deleted.
    * @param endpointName Required. The name of the Traffic Manager endpoint to
    * be deleted.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse delete(String resourceGroupName, String profileName, String endpointType, String endpointName) throws IOException, ServiceException;
    
    /**
    * Deletes a Traffic Manager endpoint.
    *
    * @param resourceGroupName Required. The name of the resource group
    * containing the Traffic Manager endpoint to be deleted.
    * @param profileName Required. The name of the Traffic Manager endpoint to
    * be deleted.
    * @param endpointType Required. The type of the Traffic Manager endpoint to
    * be deleted.
    * @param endpointName Required. The name of the Traffic Manager endpoint to
    * be deleted.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> deleteAsync(String resourceGroupName, String profileName, String endpointType, String endpointName);
    
    /**
    * Gets a Traffic Manager endpoint.
    *
    * @param resourceGroupName Required. The name of the resource group
    * containing the Traffic Manager endpoint.
    * @param profileName Required. The name of the Traffic Manager endpoint.
    * @param endpointType Required. The type of the Traffic Manager endpoint.
    * @param endpointName Required. The name of the Traffic Manager endpoint.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The response to a Traffic Manager endpoint 'Get' operation.
    */
    EndpointGetResponse get(String resourceGroupName, String profileName, String endpointType, String endpointName) throws IOException, ServiceException;
    
    /**
    * Gets a Traffic Manager endpoint.
    *
    * @param resourceGroupName Required. The name of the resource group
    * containing the Traffic Manager endpoint.
    * @param profileName Required. The name of the Traffic Manager endpoint.
    * @param endpointType Required. The type of the Traffic Manager endpoint.
    * @param endpointName Required. The name of the Traffic Manager endpoint.
    * @return The response to a Traffic Manager endpoint 'Get' operation.
    */
    Future<EndpointGetResponse> getAsync(String resourceGroupName, String profileName, String endpointType, String endpointName);
    
    /**
    * Create or update a Traffic Manager endpoint.
    *
    * @param resourceGroupName Required. The name of the resource group
    * containing the Traffic Manager endpoint to be created or updated.
    * @param profileName Required. The name of the Traffic Manager endpoint to
    * be created or updated.
    * @param endpointType Required. The type of the Traffic Manager endpoint to
    * be created or updated.
    * @param endpointName Required. The name of the Traffic Manager endpoint to
    * be created or updated.
    * @param parameters Required. The Traffic Manager endpoint parameters
    * supplied to the Update operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The response to a Traffic Manager endpoint 'CreateOrUpdate'
    * operation.
    */
    EndpointUpdateResponse update(String resourceGroupName, String profileName, String endpointType, String endpointName, EndpointUpdateParameters parameters) throws IOException, ServiceException;
    
    /**
    * Create or update a Traffic Manager endpoint.
    *
    * @param resourceGroupName Required. The name of the resource group
    * containing the Traffic Manager endpoint to be created or updated.
    * @param profileName Required. The name of the Traffic Manager endpoint to
    * be created or updated.
    * @param endpointType Required. The type of the Traffic Manager endpoint to
    * be created or updated.
    * @param endpointName Required. The name of the Traffic Manager endpoint to
    * be created or updated.
    * @param parameters Required. The Traffic Manager endpoint parameters
    * supplied to the Update operation.
    * @return The response to a Traffic Manager endpoint 'CreateOrUpdate'
    * operation.
    */
    Future<EndpointUpdateResponse> updateAsync(String resourceGroupName, String profileName, String endpointType, String endpointName, EndpointUpdateParameters parameters);
}
