/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.trafficmanager;

import com.microsoft.azure.management.trafficmanager.models.Endpoint;
import com.microsoft.azure.management.trafficmanager.models.EndpointCreateOrUpdateParameters;
import com.microsoft.azure.management.trafficmanager.models.EndpointCreateOrUpdateResponse;
import com.microsoft.azure.management.trafficmanager.models.EndpointGetResponse;
import com.microsoft.azure.management.trafficmanager.models.EndpointProperties;
import com.microsoft.azure.management.trafficmanager.models.EndpointUpdateParameters;
import com.microsoft.azure.management.trafficmanager.models.EndpointUpdateResponse;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.CloudTracing;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.ObjectNode;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

/**
* Operations for managing Traffic Manager endpoints.
*/
public class EndpointOperationsImpl implements ServiceOperations<TrafficManagerManagementClientImpl>, EndpointOperations {
    /**
    * Initializes a new instance of the EndpointOperationsImpl class.
    *
    * @param client Reference to the service client.
    */
    EndpointOperationsImpl(TrafficManagerManagementClientImpl client) {
        this.client = client;
    }
    
    private TrafficManagerManagementClientImpl client;
    
    /**
    * Gets a reference to the
    * microsoft.azure.management.trafficmanager.TrafficManagerManagementClientImpl.
    * @return The Client value.
    */
    public TrafficManagerManagementClientImpl getClient() {
        return this.client;
    }
    
    /**
    * Create or update a Traffic Manager endpoint.
    *
    * @param resourceGroupName Required. The name of the resource group
    * containing the Traffic Manager endpoint to be created or updated.
    * @param profileName Required. The name of the Traffic Manager endpoint to
    * be created or updated.
    * @param endpointType Required. The type of the Traffic Manager endpoint to
    * be created or updated.
    * @param endpointName Required. The name of the Traffic Manager endpoint to
    * be created or updated.
    * @param parameters Required. The Traffic Manager endpoint parameters
    * supplied to the CreateOrUpdate operation.
    * @return The response to a Traffic Manager endpoint 'CreateOrUpdate'
    * operation.
    */
    @Override
    public Future<EndpointCreateOrUpdateResponse> createOrUpdateAsync(final String resourceGroupName, final String profileName, final String endpointType, final String endpointName, final EndpointCreateOrUpdateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<EndpointCreateOrUpdateResponse>() { 
            @Override
            public EndpointCreateOrUpdateResponse call() throws Exception {
                return createOrUpdate(resourceGroupName, profileName, endpointType, endpointName, parameters);
            }
         });
    }
    
    /**
    * Create or update a Traffic Manager endpoint.
    *
    * @param resourceGroupName Required. The name of the resource group
    * containing the Traffic Manager endpoint to be created or updated.
    * @param profileName Required. The name of the Traffic Manager endpoint to
    * be created or updated.
    * @param endpointType Required. The type of the Traffic Manager endpoint to
    * be created or updated.
    * @param endpointName Required. The name of the Traffic Manager endpoint to
    * be created or updated.
    * @param parameters Required. The Traffic Manager endpoint parameters
    * supplied to the CreateOrUpdate operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The response to a Traffic Manager endpoint 'CreateOrUpdate'
    * operation.
    */
    @Override
    public EndpointCreateOrUpdateResponse createOrUpdate(String resourceGroupName, String profileName, String endpointType, String endpointName, EndpointCreateOrUpdateParameters parameters) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (profileName == null) {
            throw new NullPointerException("profileName");
        }
        if (endpointType == null) {
            throw new NullPointerException("endpointType");
        }
        if (endpointName == null) {
            throw new NullPointerException("endpointName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getEndpoint() == null) {
            throw new NullPointerException("parameters.Endpoint");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("profileName", profileName);
            tracingParameters.put("endpointType", endpointType);
            tracingParameters.put("endpointName", endpointName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "createOrUpdateAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/trafficmanagerprofiles/";
        url = url + URLEncoder.encode(profileName, "UTF-8");
        url = url + "/";
        url = url + URLEncoder.encode(endpointType, "UTF-8");
        url = url + "/";
        url = url + URLEncoder.encode(endpointName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-04-28-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Serialize Request
        String requestContent = null;
        JsonNode requestDoc = null;
        
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode endpointCreateOrUpdateParametersValue = objectMapper.createObjectNode();
        requestDoc = endpointCreateOrUpdateParametersValue;
        
        if (parameters.getEndpoint().getId() != null) {
            ((ObjectNode) endpointCreateOrUpdateParametersValue).put("id", parameters.getEndpoint().getId());
        }
        
        if (parameters.getEndpoint().getName() != null) {
            ((ObjectNode) endpointCreateOrUpdateParametersValue).put("name", parameters.getEndpoint().getName());
        }
        
        if (parameters.getEndpoint().getType() != null) {
            ((ObjectNode) endpointCreateOrUpdateParametersValue).put("type", parameters.getEndpoint().getType());
        }
        
        if (parameters.getEndpoint().getProperties() != null) {
            ObjectNode propertiesValue = objectMapper.createObjectNode();
            ((ObjectNode) endpointCreateOrUpdateParametersValue).put("properties", propertiesValue);
            
            if (parameters.getEndpoint().getProperties().getTargetResourceId() != null) {
                ((ObjectNode) propertiesValue).put("targetResourceId", parameters.getEndpoint().getProperties().getTargetResourceId());
            }
            
            if (parameters.getEndpoint().getProperties().getTarget() != null) {
                ((ObjectNode) propertiesValue).put("target", parameters.getEndpoint().getProperties().getTarget());
            }
            
            if (parameters.getEndpoint().getProperties().getEndpointStatus() != null) {
                ((ObjectNode) propertiesValue).put("endpointStatus", parameters.getEndpoint().getProperties().getEndpointStatus());
            }
            
            if (parameters.getEndpoint().getProperties().getWeight() != null) {
                ((ObjectNode) propertiesValue).put("weight", parameters.getEndpoint().getProperties().getWeight());
            }
            
            if (parameters.getEndpoint().getProperties().getPriority() != null) {
                ((ObjectNode) propertiesValue).put("priority", parameters.getEndpoint().getProperties().getPriority());
            }
            
            if (parameters.getEndpoint().getProperties().getEndpointLocation() != null) {
                ((ObjectNode) propertiesValue).put("endpointLocation", parameters.getEndpoint().getProperties().getEndpointLocation());
            }
            
            if (parameters.getEndpoint().getProperties().getEndpointMonitorStatus() != null) {
                ((ObjectNode) propertiesValue).put("endpointMonitorStatus", parameters.getEndpoint().getProperties().getEndpointMonitorStatus());
            }
        }
        
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue(stringWriter, requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode >= HttpStatus.SC_BAD_REQUEST) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            EndpointCreateOrUpdateResponse result = null;
            // Deserialize Response
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new EndpointCreateOrUpdateResponse();
            JsonNode responseDoc = null;
            if (responseContent == null == false) {
                responseDoc = objectMapper.readTree(responseContent);
            }
            
            if (responseDoc != null && responseDoc instanceof NullNode == false) {
                Endpoint endpointInstance = new Endpoint();
                result.setEndpoint(endpointInstance);
                
                JsonNode idValue = responseDoc.get("id");
                if (idValue != null && idValue instanceof NullNode == false) {
                    String idInstance;
                    idInstance = idValue.getTextValue();
                    endpointInstance.setId(idInstance);
                }
                
                JsonNode nameValue = responseDoc.get("name");
                if (nameValue != null && nameValue instanceof NullNode == false) {
                    String nameInstance;
                    nameInstance = nameValue.getTextValue();
                    endpointInstance.setName(nameInstance);
                }
                
                JsonNode typeValue = responseDoc.get("type");
                if (typeValue != null && typeValue instanceof NullNode == false) {
                    String typeInstance;
                    typeInstance = typeValue.getTextValue();
                    endpointInstance.setType(typeInstance);
                }
                
                JsonNode propertiesValue2 = responseDoc.get("properties");
                if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                    EndpointProperties propertiesInstance = new EndpointProperties();
                    endpointInstance.setProperties(propertiesInstance);
                    
                    JsonNode targetResourceIdValue = propertiesValue2.get("targetResourceId");
                    if (targetResourceIdValue != null && targetResourceIdValue instanceof NullNode == false) {
                        String targetResourceIdInstance;
                        targetResourceIdInstance = targetResourceIdValue.getTextValue();
                        propertiesInstance.setTargetResourceId(targetResourceIdInstance);
                    }
                    
                    JsonNode targetValue = propertiesValue2.get("target");
                    if (targetValue != null && targetValue instanceof NullNode == false) {
                        String targetInstance;
                        targetInstance = targetValue.getTextValue();
                        propertiesInstance.setTarget(targetInstance);
                    }
                    
                    JsonNode endpointStatusValue = propertiesValue2.get("endpointStatus");
                    if (endpointStatusValue != null && endpointStatusValue instanceof NullNode == false) {
                        String endpointStatusInstance;
                        endpointStatusInstance = endpointStatusValue.getTextValue();
                        propertiesInstance.setEndpointStatus(endpointStatusInstance);
                    }
                    
                    JsonNode weightValue = propertiesValue2.get("weight");
                    if (weightValue != null && weightValue instanceof NullNode == false) {
                        long weightInstance;
                        weightInstance = weightValue.getLongValue();
                        propertiesInstance.setWeight(weightInstance);
                    }
                    
                    JsonNode priorityValue = propertiesValue2.get("priority");
                    if (priorityValue != null && priorityValue instanceof NullNode == false) {
                        long priorityInstance;
                        priorityInstance = priorityValue.getLongValue();
                        propertiesInstance.setPriority(priorityInstance);
                    }
                    
                    JsonNode endpointLocationValue = propertiesValue2.get("endpointLocation");
                    if (endpointLocationValue != null && endpointLocationValue instanceof NullNode == false) {
                        String endpointLocationInstance;
                        endpointLocationInstance = endpointLocationValue.getTextValue();
                        propertiesInstance.setEndpointLocation(endpointLocationInstance);
                    }
                    
                    JsonNode endpointMonitorStatusValue = propertiesValue2.get("endpointMonitorStatus");
                    if (endpointMonitorStatusValue != null && endpointMonitorStatusValue instanceof NullNode == false) {
                        String endpointMonitorStatusInstance;
                        endpointMonitorStatusInstance = endpointMonitorStatusValue.getTextValue();
                        propertiesInstance.setEndpointMonitorStatus(endpointMonitorStatusInstance);
                    }
                }
            }
            
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Deletes a Traffic Manager endpoint.
    *
    * @param resourceGroupName Required. The name of the resource group
    * containing the Traffic Manager endpoint to be deleted.
    * @param profileName Required. The name of the Traffic Manager endpoint to
    * be deleted.
    * @param endpointType Required. The type of the Traffic Manager endpoint to
    * be deleted.
    * @param endpointName Required. The name of the Traffic Manager endpoint to
    * be deleted.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> deleteAsync(final String resourceGroupName, final String profileName, final String endpointType, final String endpointName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return delete(resourceGroupName, profileName, endpointType, endpointName);
            }
         });
    }
    
    /**
    * Deletes a Traffic Manager endpoint.
    *
    * @param resourceGroupName Required. The name of the resource group
    * containing the Traffic Manager endpoint to be deleted.
    * @param profileName Required. The name of the Traffic Manager endpoint to
    * be deleted.
    * @param endpointType Required. The type of the Traffic Manager endpoint to
    * be deleted.
    * @param endpointName Required. The name of the Traffic Manager endpoint to
    * be deleted.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse delete(String resourceGroupName, String profileName, String endpointType, String endpointName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (profileName == null) {
            throw new NullPointerException("profileName");
        }
        if (endpointType == null) {
            throw new NullPointerException("endpointType");
        }
        if (endpointName == null) {
            throw new NullPointerException("endpointName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("profileName", profileName);
            tracingParameters.put("endpointType", endpointType);
            tracingParameters.put("endpointName", endpointName);
            CloudTracing.enter(invocationId, this, "deleteAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/trafficmanagerprofiles/";
        url = url + URLEncoder.encode(profileName, "UTF-8");
        url = url + "/";
        url = url + URLEncoder.encode(endpointType, "UTF-8");
        url = url + "/";
        url = url + URLEncoder.encode(endpointName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-04-28-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode >= HttpStatus.SC_BAD_REQUEST) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            // Deserialize Response
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Gets a Traffic Manager endpoint.
    *
    * @param resourceGroupName Required. The name of the resource group
    * containing the Traffic Manager endpoint.
    * @param profileName Required. The name of the Traffic Manager endpoint.
    * @param endpointType Required. The type of the Traffic Manager endpoint.
    * @param endpointName Required. The name of the Traffic Manager endpoint.
    * @return The response to a Traffic Manager endpoint 'Get' operation.
    */
    @Override
    public Future<EndpointGetResponse> getAsync(final String resourceGroupName, final String profileName, final String endpointType, final String endpointName) {
        return this.getClient().getExecutorService().submit(new Callable<EndpointGetResponse>() { 
            @Override
            public EndpointGetResponse call() throws Exception {
                return get(resourceGroupName, profileName, endpointType, endpointName);
            }
         });
    }
    
    /**
    * Gets a Traffic Manager endpoint.
    *
    * @param resourceGroupName Required. The name of the resource group
    * containing the Traffic Manager endpoint.
    * @param profileName Required. The name of the Traffic Manager endpoint.
    * @param endpointType Required. The type of the Traffic Manager endpoint.
    * @param endpointName Required. The name of the Traffic Manager endpoint.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The response to a Traffic Manager endpoint 'Get' operation.
    */
    @Override
    public EndpointGetResponse get(String resourceGroupName, String profileName, String endpointType, String endpointName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (profileName == null) {
            throw new NullPointerException("profileName");
        }
        if (endpointType == null) {
            throw new NullPointerException("endpointType");
        }
        if (endpointName == null) {
            throw new NullPointerException("endpointName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("profileName", profileName);
            tracingParameters.put("endpointType", endpointType);
            tracingParameters.put("endpointName", endpointName);
            CloudTracing.enter(invocationId, this, "getAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/trafficmanagerprofiles/";
        url = url + URLEncoder.encode(profileName, "UTF-8");
        url = url + "/";
        url = url + URLEncoder.encode(endpointType, "UTF-8");
        url = url + "/";
        url = url + URLEncoder.encode(endpointName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-04-28-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode >= HttpStatus.SC_BAD_REQUEST) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            EndpointGetResponse result = null;
            // Deserialize Response
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new EndpointGetResponse();
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode responseDoc = null;
            if (responseContent == null == false) {
                responseDoc = objectMapper.readTree(responseContent);
            }
            
            if (responseDoc != null && responseDoc instanceof NullNode == false) {
                Endpoint endpointInstance = new Endpoint();
                result.setEndpoint(endpointInstance);
                
                JsonNode idValue = responseDoc.get("id");
                if (idValue != null && idValue instanceof NullNode == false) {
                    String idInstance;
                    idInstance = idValue.getTextValue();
                    endpointInstance.setId(idInstance);
                }
                
                JsonNode nameValue = responseDoc.get("name");
                if (nameValue != null && nameValue instanceof NullNode == false) {
                    String nameInstance;
                    nameInstance = nameValue.getTextValue();
                    endpointInstance.setName(nameInstance);
                }
                
                JsonNode typeValue = responseDoc.get("type");
                if (typeValue != null && typeValue instanceof NullNode == false) {
                    String typeInstance;
                    typeInstance = typeValue.getTextValue();
                    endpointInstance.setType(typeInstance);
                }
                
                JsonNode propertiesValue = responseDoc.get("properties");
                if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                    EndpointProperties propertiesInstance = new EndpointProperties();
                    endpointInstance.setProperties(propertiesInstance);
                    
                    JsonNode targetResourceIdValue = propertiesValue.get("targetResourceId");
                    if (targetResourceIdValue != null && targetResourceIdValue instanceof NullNode == false) {
                        String targetResourceIdInstance;
                        targetResourceIdInstance = targetResourceIdValue.getTextValue();
                        propertiesInstance.setTargetResourceId(targetResourceIdInstance);
                    }
                    
                    JsonNode targetValue = propertiesValue.get("target");
                    if (targetValue != null && targetValue instanceof NullNode == false) {
                        String targetInstance;
                        targetInstance = targetValue.getTextValue();
                        propertiesInstance.setTarget(targetInstance);
                    }
                    
                    JsonNode endpointStatusValue = propertiesValue.get("endpointStatus");
                    if (endpointStatusValue != null && endpointStatusValue instanceof NullNode == false) {
                        String endpointStatusInstance;
                        endpointStatusInstance = endpointStatusValue.getTextValue();
                        propertiesInstance.setEndpointStatus(endpointStatusInstance);
                    }
                    
                    JsonNode weightValue = propertiesValue.get("weight");
                    if (weightValue != null && weightValue instanceof NullNode == false) {
                        long weightInstance;
                        weightInstance = weightValue.getLongValue();
                        propertiesInstance.setWeight(weightInstance);
                    }
                    
                    JsonNode priorityValue = propertiesValue.get("priority");
                    if (priorityValue != null && priorityValue instanceof NullNode == false) {
                        long priorityInstance;
                        priorityInstance = priorityValue.getLongValue();
                        propertiesInstance.setPriority(priorityInstance);
                    }
                    
                    JsonNode endpointLocationValue = propertiesValue.get("endpointLocation");
                    if (endpointLocationValue != null && endpointLocationValue instanceof NullNode == false) {
                        String endpointLocationInstance;
                        endpointLocationInstance = endpointLocationValue.getTextValue();
                        propertiesInstance.setEndpointLocation(endpointLocationInstance);
                    }
                    
                    JsonNode endpointMonitorStatusValue = propertiesValue.get("endpointMonitorStatus");
                    if (endpointMonitorStatusValue != null && endpointMonitorStatusValue instanceof NullNode == false) {
                        String endpointMonitorStatusInstance;
                        endpointMonitorStatusInstance = endpointMonitorStatusValue.getTextValue();
                        propertiesInstance.setEndpointMonitorStatus(endpointMonitorStatusInstance);
                    }
                }
            }
            
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Create or update a Traffic Manager endpoint.
    *
    * @param resourceGroupName Required. The name of the resource group
    * containing the Traffic Manager endpoint to be created or updated.
    * @param profileName Required. The name of the Traffic Manager endpoint to
    * be created or updated.
    * @param endpointType Required. The type of the Traffic Manager endpoint to
    * be created or updated.
    * @param endpointName Required. The name of the Traffic Manager endpoint to
    * be created or updated.
    * @param parameters Required. The Traffic Manager endpoint parameters
    * supplied to the Update operation.
    * @return The response to a Traffic Manager endpoint 'CreateOrUpdate'
    * operation.
    */
    @Override
    public Future<EndpointUpdateResponse> updateAsync(final String resourceGroupName, final String profileName, final String endpointType, final String endpointName, final EndpointUpdateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<EndpointUpdateResponse>() { 
            @Override
            public EndpointUpdateResponse call() throws Exception {
                return update(resourceGroupName, profileName, endpointType, endpointName, parameters);
            }
         });
    }
    
    /**
    * Create or update a Traffic Manager endpoint.
    *
    * @param resourceGroupName Required. The name of the resource group
    * containing the Traffic Manager endpoint to be created or updated.
    * @param profileName Required. The name of the Traffic Manager endpoint to
    * be created or updated.
    * @param endpointType Required. The type of the Traffic Manager endpoint to
    * be created or updated.
    * @param endpointName Required. The name of the Traffic Manager endpoint to
    * be created or updated.
    * @param parameters Required. The Traffic Manager endpoint parameters
    * supplied to the Update operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The response to a Traffic Manager endpoint 'CreateOrUpdate'
    * operation.
    */
    @Override
    public EndpointUpdateResponse update(String resourceGroupName, String profileName, String endpointType, String endpointName, EndpointUpdateParameters parameters) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (profileName == null) {
            throw new NullPointerException("profileName");
        }
        if (endpointType == null) {
            throw new NullPointerException("endpointType");
        }
        if (endpointName == null) {
            throw new NullPointerException("endpointName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getEndpoint() == null) {
            throw new NullPointerException("parameters.Endpoint");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("profileName", profileName);
            tracingParameters.put("endpointType", endpointType);
            tracingParameters.put("endpointName", endpointName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "updateAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/trafficmanagerprofiles/";
        url = url + URLEncoder.encode(profileName, "UTF-8");
        url = url + "/";
        url = url + URLEncoder.encode(endpointType, "UTF-8");
        url = url + "/";
        url = url + URLEncoder.encode(endpointName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-04-28-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPatch httpRequest = new HttpPatch(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Serialize Request
        String requestContent = null;
        JsonNode requestDoc = null;
        
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode endpointUpdateParametersValue = objectMapper.createObjectNode();
        requestDoc = endpointUpdateParametersValue;
        
        if (parameters.getEndpoint().getId() != null) {
            ((ObjectNode) endpointUpdateParametersValue).put("id", parameters.getEndpoint().getId());
        }
        
        if (parameters.getEndpoint().getName() != null) {
            ((ObjectNode) endpointUpdateParametersValue).put("name", parameters.getEndpoint().getName());
        }
        
        if (parameters.getEndpoint().getType() != null) {
            ((ObjectNode) endpointUpdateParametersValue).put("type", parameters.getEndpoint().getType());
        }
        
        if (parameters.getEndpoint().getProperties() != null) {
            ObjectNode propertiesValue = objectMapper.createObjectNode();
            ((ObjectNode) endpointUpdateParametersValue).put("properties", propertiesValue);
            
            if (parameters.getEndpoint().getProperties().getTargetResourceId() != null) {
                ((ObjectNode) propertiesValue).put("targetResourceId", parameters.getEndpoint().getProperties().getTargetResourceId());
            }
            
            if (parameters.getEndpoint().getProperties().getTarget() != null) {
                ((ObjectNode) propertiesValue).put("target", parameters.getEndpoint().getProperties().getTarget());
            }
            
            if (parameters.getEndpoint().getProperties().getEndpointStatus() != null) {
                ((ObjectNode) propertiesValue).put("endpointStatus", parameters.getEndpoint().getProperties().getEndpointStatus());
            }
            
            if (parameters.getEndpoint().getProperties().getWeight() != null) {
                ((ObjectNode) propertiesValue).put("weight", parameters.getEndpoint().getProperties().getWeight());
            }
            
            if (parameters.getEndpoint().getProperties().getPriority() != null) {
                ((ObjectNode) propertiesValue).put("priority", parameters.getEndpoint().getProperties().getPriority());
            }
            
            if (parameters.getEndpoint().getProperties().getEndpointLocation() != null) {
                ((ObjectNode) propertiesValue).put("endpointLocation", parameters.getEndpoint().getProperties().getEndpointLocation());
            }
            
            if (parameters.getEndpoint().getProperties().getEndpointMonitorStatus() != null) {
                ((ObjectNode) propertiesValue).put("endpointMonitorStatus", parameters.getEndpoint().getProperties().getEndpointMonitorStatus());
            }
        }
        
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue(stringWriter, requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode >= HttpStatus.SC_BAD_REQUEST) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            EndpointUpdateResponse result = null;
            // Deserialize Response
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new EndpointUpdateResponse();
            JsonNode responseDoc = null;
            if (responseContent == null == false) {
                responseDoc = objectMapper.readTree(responseContent);
            }
            
            if (responseDoc != null && responseDoc instanceof NullNode == false) {
                Endpoint endpointInstance = new Endpoint();
                result.setEndpoint(endpointInstance);
                
                JsonNode idValue = responseDoc.get("id");
                if (idValue != null && idValue instanceof NullNode == false) {
                    String idInstance;
                    idInstance = idValue.getTextValue();
                    endpointInstance.setId(idInstance);
                }
                
                JsonNode nameValue = responseDoc.get("name");
                if (nameValue != null && nameValue instanceof NullNode == false) {
                    String nameInstance;
                    nameInstance = nameValue.getTextValue();
                    endpointInstance.setName(nameInstance);
                }
                
                JsonNode typeValue = responseDoc.get("type");
                if (typeValue != null && typeValue instanceof NullNode == false) {
                    String typeInstance;
                    typeInstance = typeValue.getTextValue();
                    endpointInstance.setType(typeInstance);
                }
                
                JsonNode propertiesValue2 = responseDoc.get("properties");
                if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                    EndpointProperties propertiesInstance = new EndpointProperties();
                    endpointInstance.setProperties(propertiesInstance);
                    
                    JsonNode targetResourceIdValue = propertiesValue2.get("targetResourceId");
                    if (targetResourceIdValue != null && targetResourceIdValue instanceof NullNode == false) {
                        String targetResourceIdInstance;
                        targetResourceIdInstance = targetResourceIdValue.getTextValue();
                        propertiesInstance.setTargetResourceId(targetResourceIdInstance);
                    }
                    
                    JsonNode targetValue = propertiesValue2.get("target");
                    if (targetValue != null && targetValue instanceof NullNode == false) {
                        String targetInstance;
                        targetInstance = targetValue.getTextValue();
                        propertiesInstance.setTarget(targetInstance);
                    }
                    
                    JsonNode endpointStatusValue = propertiesValue2.get("endpointStatus");
                    if (endpointStatusValue != null && endpointStatusValue instanceof NullNode == false) {
                        String endpointStatusInstance;
                        endpointStatusInstance = endpointStatusValue.getTextValue();
                        propertiesInstance.setEndpointStatus(endpointStatusInstance);
                    }
                    
                    JsonNode weightValue = propertiesValue2.get("weight");
                    if (weightValue != null && weightValue instanceof NullNode == false) {
                        long weightInstance;
                        weightInstance = weightValue.getLongValue();
                        propertiesInstance.setWeight(weightInstance);
                    }
                    
                    JsonNode priorityValue = propertiesValue2.get("priority");
                    if (priorityValue != null && priorityValue instanceof NullNode == false) {
                        long priorityInstance;
                        priorityInstance = priorityValue.getLongValue();
                        propertiesInstance.setPriority(priorityInstance);
                    }
                    
                    JsonNode endpointLocationValue = propertiesValue2.get("endpointLocation");
                    if (endpointLocationValue != null && endpointLocationValue instanceof NullNode == false) {
                        String endpointLocationInstance;
                        endpointLocationInstance = endpointLocationValue.getTextValue();
                        propertiesInstance.setEndpointLocation(endpointLocationInstance);
                    }
                    
                    JsonNode endpointMonitorStatusValue = propertiesValue2.get("endpointMonitorStatus");
                    if (endpointMonitorStatusValue != null && endpointMonitorStatusValue instanceof NullNode == false) {
                        String endpointMonitorStatusInstance;
                        endpointMonitorStatusInstance = endpointMonitorStatusValue.getTextValue();
                        propertiesInstance.setEndpointMonitorStatus(endpointMonitorStatusInstance);
                    }
                }
            }
            
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}
