/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.trafficmanager;

import com.microsoft.azure.management.trafficmanager.models.CheckTrafficManagerRelativeDnsNameAvailabilityParameters;
import com.microsoft.azure.management.trafficmanager.models.CheckTrafficManagerRelativeDnsNameAvailabilityResponse;
import com.microsoft.azure.management.trafficmanager.models.ProfileCreateOrUpdateParameters;
import com.microsoft.azure.management.trafficmanager.models.ProfileCreateOrUpdateResponse;
import com.microsoft.azure.management.trafficmanager.models.ProfileGetResponse;
import com.microsoft.azure.management.trafficmanager.models.ProfileListResponse;
import com.microsoft.azure.management.trafficmanager.models.ProfileUpdateParameters;
import com.microsoft.azure.management.trafficmanager.models.ProfileUpdateResponse;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.exception.ServiceException;

import java.io.IOException;
import java.util.concurrent.Future;

/**
* Operations for managing Traffic Manager profiles.
*/
public interface ProfileOperations {
    /**
    * Create or update a Traffic Manager endpoint.
    *
    * @param parameters Required. The Traffic Manager name parameters supplied
    * to the CheckTrafficManagerNameAvailability operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The response to a 'CheckTrafficManagerNameAvailability' operation.
    */
    CheckTrafficManagerRelativeDnsNameAvailabilityResponse checkTrafficManagerRelativeDnsNameAvailability(CheckTrafficManagerRelativeDnsNameAvailabilityParameters parameters) throws IOException, ServiceException;
    
    /**
    * Create or update a Traffic Manager endpoint.
    *
    * @param parameters Required. The Traffic Manager name parameters supplied
    * to the CheckTrafficManagerNameAvailability operation.
    * @return The response to a 'CheckTrafficManagerNameAvailability' operation.
    */
    Future<CheckTrafficManagerRelativeDnsNameAvailabilityResponse> checkTrafficManagerRelativeDnsNameAvailabilityAsync(CheckTrafficManagerRelativeDnsNameAvailabilityParameters parameters);
    
    /**
    * Create or update a Traffic Manager profile.
    *
    * @param resourceGroupName Required. The name of the resource group
    * containing the Traffic Manager profile.
    * @param profileName Required. The name of the Traffic Manager profile.
    * @param parameters Required. The Traffic Manager profile parameters
    * supplied to the CreateOrUpdate operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The response to a Traffic Manager profile 'CreateOrUpdate'
    * operation.
    */
    ProfileCreateOrUpdateResponse createOrUpdate(String resourceGroupName, String profileName, ProfileCreateOrUpdateParameters parameters) throws IOException, ServiceException;
    
    /**
    * Create or update a Traffic Manager profile.
    *
    * @param resourceGroupName Required. The name of the resource group
    * containing the Traffic Manager profile.
    * @param profileName Required. The name of the Traffic Manager profile.
    * @param parameters Required. The Traffic Manager profile parameters
    * supplied to the CreateOrUpdate operation.
    * @return The response to a Traffic Manager profile 'CreateOrUpdate'
    * operation.
    */
    Future<ProfileCreateOrUpdateResponse> createOrUpdateAsync(String resourceGroupName, String profileName, ProfileCreateOrUpdateParameters parameters);
    
    /**
    * Deletes a Traffic Manager profile.
    *
    * @param resourceGroupName Required. The name of the resource group
    * containing the Traffic Manager profile to be deleted.
    * @param profileName Required. The name of the Traffic Manager profile to
    * be deleted.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse delete(String resourceGroupName, String profileName) throws IOException, ServiceException;
    
    /**
    * Deletes a Traffic Manager profile.
    *
    * @param resourceGroupName Required. The name of the resource group
    * containing the Traffic Manager profile to be deleted.
    * @param profileName Required. The name of the Traffic Manager profile to
    * be deleted.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> deleteAsync(String resourceGroupName, String profileName);
    
    /**
    * Gets a Traffic Manager profile.
    *
    * @param resourceGroupName Required. The name of the resource group
    * containing the Traffic Manager profile.
    * @param profileName Required. The name of the Traffic Manager profile.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The response to a Traffic Manager profile 'Create' operation.
    */
    ProfileGetResponse get(String resourceGroupName, String profileName) throws IOException, ServiceException;
    
    /**
    * Gets a Traffic Manager profile.
    *
    * @param resourceGroupName Required. The name of the resource group
    * containing the Traffic Manager profile.
    * @param profileName Required. The name of the Traffic Manager profile.
    * @return The response to a Traffic Manager profile 'Create' operation.
    */
    Future<ProfileGetResponse> getAsync(String resourceGroupName, String profileName);
    
    /**
    * Lists all Traffic Manager profiles within a subscription.
    *
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The response to a Traffic Manager profile 'ListAll' or
    * 'ListAllInResourceGroup' operation.
    */
    ProfileListResponse listAll() throws IOException, ServiceException;
    
    /**
    * Lists all Traffic Manager profiles within a subscription.
    *
    * @return The response to a Traffic Manager profile 'ListAll' or
    * 'ListAllInResourceGroup' operation.
    */
    Future<ProfileListResponse> listAllAsync();
    
    /**
    * Lists all Traffic Manager profiles within a resource group.
    *
    * @param resourceGroupName Required. The name of the resource group
    * containing the Traffic Manager profiles to be listed.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The response to a Traffic Manager profile 'ListAll' or
    * 'ListAllInResourceGroup' operation.
    */
    ProfileListResponse listAllInResourceGroup(String resourceGroupName) throws IOException, ServiceException;
    
    /**
    * Lists all Traffic Manager profiles within a resource group.
    *
    * @param resourceGroupName Required. The name of the resource group
    * containing the Traffic Manager profiles to be listed.
    * @return The response to a Traffic Manager profile 'ListAll' or
    * 'ListAllInResourceGroup' operation.
    */
    Future<ProfileListResponse> listAllInResourceGroupAsync(String resourceGroupName);
    
    /**
    * Update a Traffic Manager profile.
    *
    * @param resourceGroupName Required. The name of the resource group
    * containing the Traffic Manager profile.
    * @param profileName Required. The name of the Traffic Manager profile.
    * @param parameters Required. The Traffic Manager profile parameters
    * supplied to the Update operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Parameters supplied to update a Traffic Manager profile.
    */
    ProfileUpdateResponse update(String resourceGroupName, String profileName, ProfileUpdateParameters parameters) throws IOException, ServiceException;
    
    /**
    * Update a Traffic Manager profile.
    *
    * @param resourceGroupName Required. The name of the resource group
    * containing the Traffic Manager profile.
    * @param profileName Required. The name of the Traffic Manager profile.
    * @param parameters Required. The Traffic Manager profile parameters
    * supplied to the Update operation.
    * @return Parameters supplied to update a Traffic Manager profile.
    */
    Future<ProfileUpdateResponse> updateAsync(String resourceGroupName, String profileName, ProfileUpdateParameters parameters);
}
