/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.trafficmanager;

import com.microsoft.azure.management.trafficmanager.models.CheckTrafficManagerRelativeDnsNameAvailabilityParameters;
import com.microsoft.azure.management.trafficmanager.models.CheckTrafficManagerRelativeDnsNameAvailabilityResponse;
import com.microsoft.azure.management.trafficmanager.models.DnsConfig;
import com.microsoft.azure.management.trafficmanager.models.Endpoint;
import com.microsoft.azure.management.trafficmanager.models.EndpointProperties;
import com.microsoft.azure.management.trafficmanager.models.MonitorConfig;
import com.microsoft.azure.management.trafficmanager.models.Profile;
import com.microsoft.azure.management.trafficmanager.models.ProfileCreateOrUpdateParameters;
import com.microsoft.azure.management.trafficmanager.models.ProfileCreateOrUpdateResponse;
import com.microsoft.azure.management.trafficmanager.models.ProfileGetResponse;
import com.microsoft.azure.management.trafficmanager.models.ProfileListResponse;
import com.microsoft.azure.management.trafficmanager.models.ProfileProperties;
import com.microsoft.azure.management.trafficmanager.models.ProfileUpdateParameters;
import com.microsoft.azure.management.trafficmanager.models.ProfileUpdateResponse;
import com.microsoft.azure.management.trafficmanager.models.Reason;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.CloudTracing;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.ObjectNode;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

/**
* Operations for managing Traffic Manager profiles.
*/
public class ProfileOperationsImpl implements ServiceOperations<TrafficManagerManagementClientImpl>, ProfileOperations {
    /**
    * Initializes a new instance of the ProfileOperationsImpl class.
    *
    * @param client Reference to the service client.
    */
    ProfileOperationsImpl(TrafficManagerManagementClientImpl client) {
        this.client = client;
    }
    
    private TrafficManagerManagementClientImpl client;
    
    /**
    * Gets a reference to the
    * microsoft.azure.management.trafficmanager.TrafficManagerManagementClientImpl.
    * @return The Client value.
    */
    public TrafficManagerManagementClientImpl getClient() {
        return this.client;
    }
    
    /**
    * Create or update a Traffic Manager endpoint.
    *
    * @param parameters Required. The Traffic Manager name parameters supplied
    * to the CheckTrafficManagerNameAvailability operation.
    * @return The response to a 'CheckTrafficManagerNameAvailability' operation.
    */
    @Override
    public Future<CheckTrafficManagerRelativeDnsNameAvailabilityResponse> checkTrafficManagerRelativeDnsNameAvailabilityAsync(final CheckTrafficManagerRelativeDnsNameAvailabilityParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<CheckTrafficManagerRelativeDnsNameAvailabilityResponse>() { 
            @Override
            public CheckTrafficManagerRelativeDnsNameAvailabilityResponse call() throws Exception {
                return checkTrafficManagerRelativeDnsNameAvailability(parameters);
            }
         });
    }
    
    /**
    * Create or update a Traffic Manager endpoint.
    *
    * @param parameters Required. The Traffic Manager name parameters supplied
    * to the CheckTrafficManagerNameAvailability operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The response to a 'CheckTrafficManagerNameAvailability' operation.
    */
    @Override
    public CheckTrafficManagerRelativeDnsNameAvailabilityResponse checkTrafficManagerRelativeDnsNameAvailability(CheckTrafficManagerRelativeDnsNameAvailabilityParameters parameters) throws IOException, ServiceException {
        // Validate
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getName() == null) {
            throw new NullPointerException("parameters.Name");
        }
        if (parameters.getType() == null) {
            throw new NullPointerException("parameters.Type");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "checkTrafficManagerRelativeDnsNameAvailabilityAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "providers/";
        url = url + "Microsoft.Network";
        url = url + "/checkTrafficManagerNameAvailability";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-04-28-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Serialize Request
        String requestContent = null;
        JsonNode requestDoc = null;
        
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode checkTrafficManagerRelativeDnsNameAvailabilityParametersValue = objectMapper.createObjectNode();
        requestDoc = checkTrafficManagerRelativeDnsNameAvailabilityParametersValue;
        
        ((ObjectNode) checkTrafficManagerRelativeDnsNameAvailabilityParametersValue).put("name", parameters.getName());
        
        ((ObjectNode) checkTrafficManagerRelativeDnsNameAvailabilityParametersValue).put("type", parameters.getType());
        
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue(stringWriter, requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode >= HttpStatus.SC_BAD_REQUEST) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            CheckTrafficManagerRelativeDnsNameAvailabilityResponse result = null;
            // Deserialize Response
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new CheckTrafficManagerRelativeDnsNameAvailabilityResponse();
            JsonNode responseDoc = null;
            if (responseContent == null == false) {
                responseDoc = objectMapper.readTree(responseContent);
            }
            
            if (responseDoc != null && responseDoc instanceof NullNode == false) {
                JsonNode nameValue = responseDoc.get("name");
                if (nameValue != null && nameValue instanceof NullNode == false) {
                    String nameInstance;
                    nameInstance = nameValue.getTextValue();
                    result.setName(nameInstance);
                }
                
                JsonNode typeValue = responseDoc.get("type");
                if (typeValue != null && typeValue instanceof NullNode == false) {
                    String typeInstance;
                    typeInstance = typeValue.getTextValue();
                    result.setType(typeInstance);
                }
                
                JsonNode nameAvailableValue = responseDoc.get("nameAvailable");
                if (nameAvailableValue != null && nameAvailableValue instanceof NullNode == false) {
                    boolean nameAvailableInstance;
                    nameAvailableInstance = nameAvailableValue.getBooleanValue();
                    result.setNameAvailable(nameAvailableInstance);
                }
                
                JsonNode reasonValue = responseDoc.get("reason");
                if (reasonValue != null && reasonValue instanceof NullNode == false) {
                    Reason reasonInstance;
                    reasonInstance = Enum.valueOf(Reason.class, reasonValue.getTextValue());
                    result.setReason(reasonInstance);
                }
                
                JsonNode messageValue = responseDoc.get("message");
                if (messageValue != null && messageValue instanceof NullNode == false) {
                    String messageInstance;
                    messageInstance = messageValue.getTextValue();
                    result.setMessage(messageInstance);
                }
            }
            
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Create or update a Traffic Manager profile.
    *
    * @param resourceGroupName Required. The name of the resource group
    * containing the Traffic Manager profile.
    * @param profileName Required. The name of the Traffic Manager profile.
    * @param parameters Required. The Traffic Manager profile parameters
    * supplied to the CreateOrUpdate operation.
    * @return The response to a Traffic Manager profile 'CreateOrUpdate'
    * operation.
    */
    @Override
    public Future<ProfileCreateOrUpdateResponse> createOrUpdateAsync(final String resourceGroupName, final String profileName, final ProfileCreateOrUpdateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<ProfileCreateOrUpdateResponse>() { 
            @Override
            public ProfileCreateOrUpdateResponse call() throws Exception {
                return createOrUpdate(resourceGroupName, profileName, parameters);
            }
         });
    }
    
    /**
    * Create or update a Traffic Manager profile.
    *
    * @param resourceGroupName Required. The name of the resource group
    * containing the Traffic Manager profile.
    * @param profileName Required. The name of the Traffic Manager profile.
    * @param parameters Required. The Traffic Manager profile parameters
    * supplied to the CreateOrUpdate operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The response to a Traffic Manager profile 'CreateOrUpdate'
    * operation.
    */
    @Override
    public ProfileCreateOrUpdateResponse createOrUpdate(String resourceGroupName, String profileName, ProfileCreateOrUpdateParameters parameters) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (profileName == null) {
            throw new NullPointerException("profileName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getProfile() == null) {
            throw new NullPointerException("parameters.Profile");
        }
        if (parameters.getProfile().getLocation() == null) {
            throw new NullPointerException("parameters.Profile.Location");
        }
        if (parameters.getProfile().getProperties() != null) {
            if (parameters.getProfile().getProperties().getDnsConfig() != null) {
                if (parameters.getProfile().getProperties().getDnsConfig().getRelativeName() == null) {
                    throw new NullPointerException("parameters.Profile.Properties.DnsConfig.RelativeName");
                }
            }
            if (parameters.getProfile().getProperties().getMonitorConfig() != null) {
                if (parameters.getProfile().getProperties().getMonitorConfig().getPath() == null) {
                    throw new NullPointerException("parameters.Profile.Properties.MonitorConfig.Path");
                }
                if (parameters.getProfile().getProperties().getMonitorConfig().getProtocol() == null) {
                    throw new NullPointerException("parameters.Profile.Properties.MonitorConfig.Protocol");
                }
            }
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("profileName", profileName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "createOrUpdateAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/trafficmanagerprofiles/";
        url = url + URLEncoder.encode(profileName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-04-28-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Serialize Request
        String requestContent = null;
        JsonNode requestDoc = null;
        
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode profileCreateOrUpdateParametersValue = objectMapper.createObjectNode();
        requestDoc = profileCreateOrUpdateParametersValue;
        
        if (parameters.getProfile().getProperties() != null) {
            ObjectNode propertiesValue = objectMapper.createObjectNode();
            ((ObjectNode) profileCreateOrUpdateParametersValue).put("properties", propertiesValue);
            
            if (parameters.getProfile().getProperties().getProfileStatus() != null) {
                ((ObjectNode) propertiesValue).put("profileStatus", parameters.getProfile().getProperties().getProfileStatus());
            }
            
            if (parameters.getProfile().getProperties().getTrafficRoutingMethod() != null) {
                ((ObjectNode) propertiesValue).put("trafficRoutingMethod", parameters.getProfile().getProperties().getTrafficRoutingMethod());
            }
            
            if (parameters.getProfile().getProperties().getDnsConfig() != null) {
                ObjectNode dnsConfigValue = objectMapper.createObjectNode();
                ((ObjectNode) propertiesValue).put("dnsConfig", dnsConfigValue);
                
                ((ObjectNode) dnsConfigValue).put("relativeName", parameters.getProfile().getProperties().getDnsConfig().getRelativeName());
                
                if (parameters.getProfile().getProperties().getDnsConfig().getFqdn() != null) {
                    ((ObjectNode) dnsConfigValue).put("fqdn", parameters.getProfile().getProperties().getDnsConfig().getFqdn());
                }
                
                ((ObjectNode) dnsConfigValue).put("ttl", parameters.getProfile().getProperties().getDnsConfig().getTtl());
            }
            
            if (parameters.getProfile().getProperties().getMonitorConfig() != null) {
                ObjectNode monitorConfigValue = objectMapper.createObjectNode();
                ((ObjectNode) propertiesValue).put("monitorConfig", monitorConfigValue);
                
                if (parameters.getProfile().getProperties().getMonitorConfig().getProfileMonitorStatus() != null) {
                    ((ObjectNode) monitorConfigValue).put("profileMonitorStatus", parameters.getProfile().getProperties().getMonitorConfig().getProfileMonitorStatus());
                }
                
                ((ObjectNode) monitorConfigValue).put("protocol", parameters.getProfile().getProperties().getMonitorConfig().getProtocol());
                
                ((ObjectNode) monitorConfigValue).put("port", parameters.getProfile().getProperties().getMonitorConfig().getPort());
                
                ((ObjectNode) monitorConfigValue).put("path", parameters.getProfile().getProperties().getMonitorConfig().getPath());
            }
            
            if (parameters.getProfile().getProperties().getEndpoints() != null) {
                ArrayNode endpointsArray = objectMapper.createArrayNode();
                for (Endpoint endpointsItem : parameters.getProfile().getProperties().getEndpoints()) {
                    ObjectNode endpointValue = objectMapper.createObjectNode();
                    endpointsArray.add(endpointValue);
                    
                    if (endpointsItem.getId() != null) {
                        ((ObjectNode) endpointValue).put("id", endpointsItem.getId());
                    }
                    
                    if (endpointsItem.getName() != null) {
                        ((ObjectNode) endpointValue).put("name", endpointsItem.getName());
                    }
                    
                    if (endpointsItem.getType() != null) {
                        ((ObjectNode) endpointValue).put("type", endpointsItem.getType());
                    }
                    
                    if (endpointsItem.getProperties() != null) {
                        ObjectNode propertiesValue2 = objectMapper.createObjectNode();
                        ((ObjectNode) endpointValue).put("properties", propertiesValue2);
                        
                        if (endpointsItem.getProperties().getTargetResourceId() != null) {
                            ((ObjectNode) propertiesValue2).put("targetResourceId", endpointsItem.getProperties().getTargetResourceId());
                        }
                        
                        if (endpointsItem.getProperties().getTarget() != null) {
                            ((ObjectNode) propertiesValue2).put("target", endpointsItem.getProperties().getTarget());
                        }
                        
                        if (endpointsItem.getProperties().getEndpointStatus() != null) {
                            ((ObjectNode) propertiesValue2).put("endpointStatus", endpointsItem.getProperties().getEndpointStatus());
                        }
                        
                        if (endpointsItem.getProperties().getWeight() != null) {
                            ((ObjectNode) propertiesValue2).put("weight", endpointsItem.getProperties().getWeight());
                        }
                        
                        if (endpointsItem.getProperties().getPriority() != null) {
                            ((ObjectNode) propertiesValue2).put("priority", endpointsItem.getProperties().getPriority());
                        }
                        
                        if (endpointsItem.getProperties().getEndpointLocation() != null) {
                            ((ObjectNode) propertiesValue2).put("endpointLocation", endpointsItem.getProperties().getEndpointLocation());
                        }
                        
                        if (endpointsItem.getProperties().getEndpointMonitorStatus() != null) {
                            ((ObjectNode) propertiesValue2).put("endpointMonitorStatus", endpointsItem.getProperties().getEndpointMonitorStatus());
                        }
                    }
                }
                ((ObjectNode) propertiesValue).put("endpoints", endpointsArray);
            }
        }
        
        if (parameters.getProfile().getId() != null) {
            ((ObjectNode) profileCreateOrUpdateParametersValue).put("id", parameters.getProfile().getId());
        }
        
        if (parameters.getProfile().getName() != null) {
            ((ObjectNode) profileCreateOrUpdateParametersValue).put("name", parameters.getProfile().getName());
        }
        
        if (parameters.getProfile().getType() != null) {
            ((ObjectNode) profileCreateOrUpdateParametersValue).put("type", parameters.getProfile().getType());
        }
        
        ((ObjectNode) profileCreateOrUpdateParametersValue).put("location", parameters.getProfile().getLocation());
        
        if (parameters.getProfile().getTags() != null) {
            ObjectNode tagsDictionary = objectMapper.createObjectNode();
            for (Map.Entry<String, String> entry : parameters.getProfile().getTags().entrySet()) {
                String tagsKey = entry.getKey();
                String tagsValue = entry.getValue();
                ((ObjectNode) tagsDictionary).put(tagsKey, tagsValue);
            }
            ((ObjectNode) profileCreateOrUpdateParametersValue).put("tags", tagsDictionary);
        }
        
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue(stringWriter, requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode >= HttpStatus.SC_BAD_REQUEST) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ProfileCreateOrUpdateResponse result = null;
            // Deserialize Response
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new ProfileCreateOrUpdateResponse();
            JsonNode responseDoc = null;
            if (responseContent == null == false) {
                responseDoc = objectMapper.readTree(responseContent);
            }
            
            if (responseDoc != null && responseDoc instanceof NullNode == false) {
                Profile profileInstance = new Profile();
                result.setProfile(profileInstance);
                
                JsonNode propertiesValue3 = responseDoc.get("properties");
                if (propertiesValue3 != null && propertiesValue3 instanceof NullNode == false) {
                    ProfileProperties propertiesInstance = new ProfileProperties();
                    profileInstance.setProperties(propertiesInstance);
                    
                    JsonNode profileStatusValue = propertiesValue3.get("profileStatus");
                    if (profileStatusValue != null && profileStatusValue instanceof NullNode == false) {
                        String profileStatusInstance;
                        profileStatusInstance = profileStatusValue.getTextValue();
                        propertiesInstance.setProfileStatus(profileStatusInstance);
                    }
                    
                    JsonNode trafficRoutingMethodValue = propertiesValue3.get("trafficRoutingMethod");
                    if (trafficRoutingMethodValue != null && trafficRoutingMethodValue instanceof NullNode == false) {
                        String trafficRoutingMethodInstance;
                        trafficRoutingMethodInstance = trafficRoutingMethodValue.getTextValue();
                        propertiesInstance.setTrafficRoutingMethod(trafficRoutingMethodInstance);
                    }
                    
                    JsonNode dnsConfigValue2 = propertiesValue3.get("dnsConfig");
                    if (dnsConfigValue2 != null && dnsConfigValue2 instanceof NullNode == false) {
                        DnsConfig dnsConfigInstance = new DnsConfig();
                        propertiesInstance.setDnsConfig(dnsConfigInstance);
                        
                        JsonNode relativeNameValue = dnsConfigValue2.get("relativeName");
                        if (relativeNameValue != null && relativeNameValue instanceof NullNode == false) {
                            String relativeNameInstance;
                            relativeNameInstance = relativeNameValue.getTextValue();
                            dnsConfigInstance.setRelativeName(relativeNameInstance);
                        }
                        
                        JsonNode fqdnValue = dnsConfigValue2.get("fqdn");
                        if (fqdnValue != null && fqdnValue instanceof NullNode == false) {
                            String fqdnInstance;
                            fqdnInstance = fqdnValue.getTextValue();
                            dnsConfigInstance.setFqdn(fqdnInstance);
                        }
                        
                        JsonNode ttlValue = dnsConfigValue2.get("ttl");
                        if (ttlValue != null && ttlValue instanceof NullNode == false) {
                            long ttlInstance;
                            ttlInstance = ttlValue.getLongValue();
                            dnsConfigInstance.setTtl(ttlInstance);
                        }
                    }
                    
                    JsonNode monitorConfigValue2 = propertiesValue3.get("monitorConfig");
                    if (monitorConfigValue2 != null && monitorConfigValue2 instanceof NullNode == false) {
                        MonitorConfig monitorConfigInstance = new MonitorConfig();
                        propertiesInstance.setMonitorConfig(monitorConfigInstance);
                        
                        JsonNode profileMonitorStatusValue = monitorConfigValue2.get("profileMonitorStatus");
                        if (profileMonitorStatusValue != null && profileMonitorStatusValue instanceof NullNode == false) {
                            String profileMonitorStatusInstance;
                            profileMonitorStatusInstance = profileMonitorStatusValue.getTextValue();
                            monitorConfigInstance.setProfileMonitorStatus(profileMonitorStatusInstance);
                        }
                        
                        JsonNode protocolValue = monitorConfigValue2.get("protocol");
                        if (protocolValue != null && protocolValue instanceof NullNode == false) {
                            String protocolInstance;
                            protocolInstance = protocolValue.getTextValue();
                            monitorConfigInstance.setProtocol(protocolInstance);
                        }
                        
                        JsonNode portValue = monitorConfigValue2.get("port");
                        if (portValue != null && portValue instanceof NullNode == false) {
                            long portInstance;
                            portInstance = portValue.getLongValue();
                            monitorConfigInstance.setPort(portInstance);
                        }
                        
                        JsonNode pathValue = monitorConfigValue2.get("path");
                        if (pathValue != null && pathValue instanceof NullNode == false) {
                            String pathInstance;
                            pathInstance = pathValue.getTextValue();
                            monitorConfigInstance.setPath(pathInstance);
                        }
                    }
                    
                    JsonNode endpointsArray2 = propertiesValue3.get("endpoints");
                    if (endpointsArray2 != null && endpointsArray2 instanceof NullNode == false) {
                        propertiesInstance.setEndpoints(new ArrayList<Endpoint>());
                        for (JsonNode endpointsValue : ((ArrayNode) endpointsArray2)) {
                            Endpoint endpointInstance = new Endpoint();
                            propertiesInstance.getEndpoints().add(endpointInstance);
                            
                            JsonNode idValue = endpointsValue.get("id");
                            if (idValue != null && idValue instanceof NullNode == false) {
                                String idInstance;
                                idInstance = idValue.getTextValue();
                                endpointInstance.setId(idInstance);
                            }
                            
                            JsonNode nameValue = endpointsValue.get("name");
                            if (nameValue != null && nameValue instanceof NullNode == false) {
                                String nameInstance;
                                nameInstance = nameValue.getTextValue();
                                endpointInstance.setName(nameInstance);
                            }
                            
                            JsonNode typeValue = endpointsValue.get("type");
                            if (typeValue != null && typeValue instanceof NullNode == false) {
                                String typeInstance;
                                typeInstance = typeValue.getTextValue();
                                endpointInstance.setType(typeInstance);
                            }
                            
                            JsonNode propertiesValue4 = endpointsValue.get("properties");
                            if (propertiesValue4 != null && propertiesValue4 instanceof NullNode == false) {
                                EndpointProperties propertiesInstance2 = new EndpointProperties();
                                endpointInstance.setProperties(propertiesInstance2);
                                
                                JsonNode targetResourceIdValue = propertiesValue4.get("targetResourceId");
                                if (targetResourceIdValue != null && targetResourceIdValue instanceof NullNode == false) {
                                    String targetResourceIdInstance;
                                    targetResourceIdInstance = targetResourceIdValue.getTextValue();
                                    propertiesInstance2.setTargetResourceId(targetResourceIdInstance);
                                }
                                
                                JsonNode targetValue = propertiesValue4.get("target");
                                if (targetValue != null && targetValue instanceof NullNode == false) {
                                    String targetInstance;
                                    targetInstance = targetValue.getTextValue();
                                    propertiesInstance2.setTarget(targetInstance);
                                }
                                
                                JsonNode endpointStatusValue = propertiesValue4.get("endpointStatus");
                                if (endpointStatusValue != null && endpointStatusValue instanceof NullNode == false) {
                                    String endpointStatusInstance;
                                    endpointStatusInstance = endpointStatusValue.getTextValue();
                                    propertiesInstance2.setEndpointStatus(endpointStatusInstance);
                                }
                                
                                JsonNode weightValue = propertiesValue4.get("weight");
                                if (weightValue != null && weightValue instanceof NullNode == false) {
                                    long weightInstance;
                                    weightInstance = weightValue.getLongValue();
                                    propertiesInstance2.setWeight(weightInstance);
                                }
                                
                                JsonNode priorityValue = propertiesValue4.get("priority");
                                if (priorityValue != null && priorityValue instanceof NullNode == false) {
                                    long priorityInstance;
                                    priorityInstance = priorityValue.getLongValue();
                                    propertiesInstance2.setPriority(priorityInstance);
                                }
                                
                                JsonNode endpointLocationValue = propertiesValue4.get("endpointLocation");
                                if (endpointLocationValue != null && endpointLocationValue instanceof NullNode == false) {
                                    String endpointLocationInstance;
                                    endpointLocationInstance = endpointLocationValue.getTextValue();
                                    propertiesInstance2.setEndpointLocation(endpointLocationInstance);
                                }
                                
                                JsonNode endpointMonitorStatusValue = propertiesValue4.get("endpointMonitorStatus");
                                if (endpointMonitorStatusValue != null && endpointMonitorStatusValue instanceof NullNode == false) {
                                    String endpointMonitorStatusInstance;
                                    endpointMonitorStatusInstance = endpointMonitorStatusValue.getTextValue();
                                    propertiesInstance2.setEndpointMonitorStatus(endpointMonitorStatusInstance);
                                }
                            }
                        }
                    }
                }
                
                JsonNode idValue2 = responseDoc.get("id");
                if (idValue2 != null && idValue2 instanceof NullNode == false) {
                    String idInstance2;
                    idInstance2 = idValue2.getTextValue();
                    profileInstance.setId(idInstance2);
                }
                
                JsonNode nameValue2 = responseDoc.get("name");
                if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                    String nameInstance2;
                    nameInstance2 = nameValue2.getTextValue();
                    profileInstance.setName(nameInstance2);
                }
                
                JsonNode typeValue2 = responseDoc.get("type");
                if (typeValue2 != null && typeValue2 instanceof NullNode == false) {
                    String typeInstance2;
                    typeInstance2 = typeValue2.getTextValue();
                    profileInstance.setType(typeInstance2);
                }
                
                JsonNode locationValue = responseDoc.get("location");
                if (locationValue != null && locationValue instanceof NullNode == false) {
                    String locationInstance;
                    locationInstance = locationValue.getTextValue();
                    profileInstance.setLocation(locationInstance);
                }
                
                JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                    Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                    while (itr.hasNext()) {
                        Map.Entry<String, JsonNode> property = itr.next();
                        String tagsKey2 = property.getKey();
                        String tagsValue2 = property.getValue().getTextValue();
                        profileInstance.getTags().put(tagsKey2, tagsValue2);
                    }
                }
            }
            
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Deletes a Traffic Manager profile.
    *
    * @param resourceGroupName Required. The name of the resource group
    * containing the Traffic Manager profile to be deleted.
    * @param profileName Required. The name of the Traffic Manager profile to
    * be deleted.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> deleteAsync(final String resourceGroupName, final String profileName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return delete(resourceGroupName, profileName);
            }
         });
    }
    
    /**
    * Deletes a Traffic Manager profile.
    *
    * @param resourceGroupName Required. The name of the resource group
    * containing the Traffic Manager profile to be deleted.
    * @param profileName Required. The name of the Traffic Manager profile to
    * be deleted.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse delete(String resourceGroupName, String profileName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (profileName == null) {
            throw new NullPointerException("profileName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("profileName", profileName);
            CloudTracing.enter(invocationId, this, "deleteAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/trafficmanagerprofiles/";
        url = url + URLEncoder.encode(profileName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-04-28-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode >= HttpStatus.SC_BAD_REQUEST) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            // Deserialize Response
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Gets a Traffic Manager profile.
    *
    * @param resourceGroupName Required. The name of the resource group
    * containing the Traffic Manager profile.
    * @param profileName Required. The name of the Traffic Manager profile.
    * @return The response to a Traffic Manager profile 'Create' operation.
    */
    @Override
    public Future<ProfileGetResponse> getAsync(final String resourceGroupName, final String profileName) {
        return this.getClient().getExecutorService().submit(new Callable<ProfileGetResponse>() { 
            @Override
            public ProfileGetResponse call() throws Exception {
                return get(resourceGroupName, profileName);
            }
         });
    }
    
    /**
    * Gets a Traffic Manager profile.
    *
    * @param resourceGroupName Required. The name of the resource group
    * containing the Traffic Manager profile.
    * @param profileName Required. The name of the Traffic Manager profile.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The response to a Traffic Manager profile 'Create' operation.
    */
    @Override
    public ProfileGetResponse get(String resourceGroupName, String profileName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (profileName == null) {
            throw new NullPointerException("profileName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("profileName", profileName);
            CloudTracing.enter(invocationId, this, "getAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/trafficmanagerprofiles/";
        url = url + URLEncoder.encode(profileName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-04-28-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode >= HttpStatus.SC_BAD_REQUEST) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ProfileGetResponse result = null;
            // Deserialize Response
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new ProfileGetResponse();
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode responseDoc = null;
            if (responseContent == null == false) {
                responseDoc = objectMapper.readTree(responseContent);
            }
            
            if (responseDoc != null && responseDoc instanceof NullNode == false) {
                Profile profileInstance = new Profile();
                result.setProfile(profileInstance);
                
                JsonNode propertiesValue = responseDoc.get("properties");
                if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                    ProfileProperties propertiesInstance = new ProfileProperties();
                    profileInstance.setProperties(propertiesInstance);
                    
                    JsonNode profileStatusValue = propertiesValue.get("profileStatus");
                    if (profileStatusValue != null && profileStatusValue instanceof NullNode == false) {
                        String profileStatusInstance;
                        profileStatusInstance = profileStatusValue.getTextValue();
                        propertiesInstance.setProfileStatus(profileStatusInstance);
                    }
                    
                    JsonNode trafficRoutingMethodValue = propertiesValue.get("trafficRoutingMethod");
                    if (trafficRoutingMethodValue != null && trafficRoutingMethodValue instanceof NullNode == false) {
                        String trafficRoutingMethodInstance;
                        trafficRoutingMethodInstance = trafficRoutingMethodValue.getTextValue();
                        propertiesInstance.setTrafficRoutingMethod(trafficRoutingMethodInstance);
                    }
                    
                    JsonNode dnsConfigValue = propertiesValue.get("dnsConfig");
                    if (dnsConfigValue != null && dnsConfigValue instanceof NullNode == false) {
                        DnsConfig dnsConfigInstance = new DnsConfig();
                        propertiesInstance.setDnsConfig(dnsConfigInstance);
                        
                        JsonNode relativeNameValue = dnsConfigValue.get("relativeName");
                        if (relativeNameValue != null && relativeNameValue instanceof NullNode == false) {
                            String relativeNameInstance;
                            relativeNameInstance = relativeNameValue.getTextValue();
                            dnsConfigInstance.setRelativeName(relativeNameInstance);
                        }
                        
                        JsonNode fqdnValue = dnsConfigValue.get("fqdn");
                        if (fqdnValue != null && fqdnValue instanceof NullNode == false) {
                            String fqdnInstance;
                            fqdnInstance = fqdnValue.getTextValue();
                            dnsConfigInstance.setFqdn(fqdnInstance);
                        }
                        
                        JsonNode ttlValue = dnsConfigValue.get("ttl");
                        if (ttlValue != null && ttlValue instanceof NullNode == false) {
                            long ttlInstance;
                            ttlInstance = ttlValue.getLongValue();
                            dnsConfigInstance.setTtl(ttlInstance);
                        }
                    }
                    
                    JsonNode monitorConfigValue = propertiesValue.get("monitorConfig");
                    if (monitorConfigValue != null && monitorConfigValue instanceof NullNode == false) {
                        MonitorConfig monitorConfigInstance = new MonitorConfig();
                        propertiesInstance.setMonitorConfig(monitorConfigInstance);
                        
                        JsonNode profileMonitorStatusValue = monitorConfigValue.get("profileMonitorStatus");
                        if (profileMonitorStatusValue != null && profileMonitorStatusValue instanceof NullNode == false) {
                            String profileMonitorStatusInstance;
                            profileMonitorStatusInstance = profileMonitorStatusValue.getTextValue();
                            monitorConfigInstance.setProfileMonitorStatus(profileMonitorStatusInstance);
                        }
                        
                        JsonNode protocolValue = monitorConfigValue.get("protocol");
                        if (protocolValue != null && protocolValue instanceof NullNode == false) {
                            String protocolInstance;
                            protocolInstance = protocolValue.getTextValue();
                            monitorConfigInstance.setProtocol(protocolInstance);
                        }
                        
                        JsonNode portValue = monitorConfigValue.get("port");
                        if (portValue != null && portValue instanceof NullNode == false) {
                            long portInstance;
                            portInstance = portValue.getLongValue();
                            monitorConfigInstance.setPort(portInstance);
                        }
                        
                        JsonNode pathValue = monitorConfigValue.get("path");
                        if (pathValue != null && pathValue instanceof NullNode == false) {
                            String pathInstance;
                            pathInstance = pathValue.getTextValue();
                            monitorConfigInstance.setPath(pathInstance);
                        }
                    }
                    
                    JsonNode endpointsArray = propertiesValue.get("endpoints");
                    if (endpointsArray != null && endpointsArray instanceof NullNode == false) {
                        propertiesInstance.setEndpoints(new ArrayList<Endpoint>());
                        for (JsonNode endpointsValue : ((ArrayNode) endpointsArray)) {
                            Endpoint endpointInstance = new Endpoint();
                            propertiesInstance.getEndpoints().add(endpointInstance);
                            
                            JsonNode idValue = endpointsValue.get("id");
                            if (idValue != null && idValue instanceof NullNode == false) {
                                String idInstance;
                                idInstance = idValue.getTextValue();
                                endpointInstance.setId(idInstance);
                            }
                            
                            JsonNode nameValue = endpointsValue.get("name");
                            if (nameValue != null && nameValue instanceof NullNode == false) {
                                String nameInstance;
                                nameInstance = nameValue.getTextValue();
                                endpointInstance.setName(nameInstance);
                            }
                            
                            JsonNode typeValue = endpointsValue.get("type");
                            if (typeValue != null && typeValue instanceof NullNode == false) {
                                String typeInstance;
                                typeInstance = typeValue.getTextValue();
                                endpointInstance.setType(typeInstance);
                            }
                            
                            JsonNode propertiesValue2 = endpointsValue.get("properties");
                            if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                                EndpointProperties propertiesInstance2 = new EndpointProperties();
                                endpointInstance.setProperties(propertiesInstance2);
                                
                                JsonNode targetResourceIdValue = propertiesValue2.get("targetResourceId");
                                if (targetResourceIdValue != null && targetResourceIdValue instanceof NullNode == false) {
                                    String targetResourceIdInstance;
                                    targetResourceIdInstance = targetResourceIdValue.getTextValue();
                                    propertiesInstance2.setTargetResourceId(targetResourceIdInstance);
                                }
                                
                                JsonNode targetValue = propertiesValue2.get("target");
                                if (targetValue != null && targetValue instanceof NullNode == false) {
                                    String targetInstance;
                                    targetInstance = targetValue.getTextValue();
                                    propertiesInstance2.setTarget(targetInstance);
                                }
                                
                                JsonNode endpointStatusValue = propertiesValue2.get("endpointStatus");
                                if (endpointStatusValue != null && endpointStatusValue instanceof NullNode == false) {
                                    String endpointStatusInstance;
                                    endpointStatusInstance = endpointStatusValue.getTextValue();
                                    propertiesInstance2.setEndpointStatus(endpointStatusInstance);
                                }
                                
                                JsonNode weightValue = propertiesValue2.get("weight");
                                if (weightValue != null && weightValue instanceof NullNode == false) {
                                    long weightInstance;
                                    weightInstance = weightValue.getLongValue();
                                    propertiesInstance2.setWeight(weightInstance);
                                }
                                
                                JsonNode priorityValue = propertiesValue2.get("priority");
                                if (priorityValue != null && priorityValue instanceof NullNode == false) {
                                    long priorityInstance;
                                    priorityInstance = priorityValue.getLongValue();
                                    propertiesInstance2.setPriority(priorityInstance);
                                }
                                
                                JsonNode endpointLocationValue = propertiesValue2.get("endpointLocation");
                                if (endpointLocationValue != null && endpointLocationValue instanceof NullNode == false) {
                                    String endpointLocationInstance;
                                    endpointLocationInstance = endpointLocationValue.getTextValue();
                                    propertiesInstance2.setEndpointLocation(endpointLocationInstance);
                                }
                                
                                JsonNode endpointMonitorStatusValue = propertiesValue2.get("endpointMonitorStatus");
                                if (endpointMonitorStatusValue != null && endpointMonitorStatusValue instanceof NullNode == false) {
                                    String endpointMonitorStatusInstance;
                                    endpointMonitorStatusInstance = endpointMonitorStatusValue.getTextValue();
                                    propertiesInstance2.setEndpointMonitorStatus(endpointMonitorStatusInstance);
                                }
                            }
                        }
                    }
                }
                
                JsonNode idValue2 = responseDoc.get("id");
                if (idValue2 != null && idValue2 instanceof NullNode == false) {
                    String idInstance2;
                    idInstance2 = idValue2.getTextValue();
                    profileInstance.setId(idInstance2);
                }
                
                JsonNode nameValue2 = responseDoc.get("name");
                if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                    String nameInstance2;
                    nameInstance2 = nameValue2.getTextValue();
                    profileInstance.setName(nameInstance2);
                }
                
                JsonNode typeValue2 = responseDoc.get("type");
                if (typeValue2 != null && typeValue2 instanceof NullNode == false) {
                    String typeInstance2;
                    typeInstance2 = typeValue2.getTextValue();
                    profileInstance.setType(typeInstance2);
                }
                
                JsonNode locationValue = responseDoc.get("location");
                if (locationValue != null && locationValue instanceof NullNode == false) {
                    String locationInstance;
                    locationInstance = locationValue.getTextValue();
                    profileInstance.setLocation(locationInstance);
                }
                
                JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                    Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                    while (itr.hasNext()) {
                        Map.Entry<String, JsonNode> property = itr.next();
                        String tagsKey = property.getKey();
                        String tagsValue = property.getValue().getTextValue();
                        profileInstance.getTags().put(tagsKey, tagsValue);
                    }
                }
            }
            
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Lists all Traffic Manager profiles within a subscription.
    *
    * @return The response to a Traffic Manager profile 'ListAll' or
    * 'ListAllInResourceGroup' operation.
    */
    @Override
    public Future<ProfileListResponse> listAllAsync() {
        return this.getClient().getExecutorService().submit(new Callable<ProfileListResponse>() { 
            @Override
            public ProfileListResponse call() throws Exception {
                return listAll();
            }
         });
    }
    
    /**
    * Lists all Traffic Manager profiles within a subscription.
    *
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The response to a Traffic Manager profile 'ListAll' or
    * 'ListAllInResourceGroup' operation.
    */
    @Override
    public ProfileListResponse listAll() throws IOException, ServiceException {
        // Validate
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            CloudTracing.enter(invocationId, this, "listAllAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/trafficmanagerprofiles";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-04-28-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode >= HttpStatus.SC_BAD_REQUEST) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ProfileListResponse result = null;
            // Deserialize Response
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new ProfileListResponse();
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode responseDoc = null;
            if (responseContent == null == false) {
                responseDoc = objectMapper.readTree(responseContent);
            }
            
            if (responseDoc != null && responseDoc instanceof NullNode == false) {
                JsonNode valuesArray = responseDoc.get("values");
                if (valuesArray != null && valuesArray instanceof NullNode == false) {
                    for (JsonNode valuesValue : ((ArrayNode) valuesArray)) {
                        Profile profileInstance = new Profile();
                        result.getProfiles().add(profileInstance);
                        
                        JsonNode propertiesValue = valuesValue.get("properties");
                        if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                            ProfileProperties propertiesInstance = new ProfileProperties();
                            profileInstance.setProperties(propertiesInstance);
                            
                            JsonNode profileStatusValue = propertiesValue.get("profileStatus");
                            if (profileStatusValue != null && profileStatusValue instanceof NullNode == false) {
                                String profileStatusInstance;
                                profileStatusInstance = profileStatusValue.getTextValue();
                                propertiesInstance.setProfileStatus(profileStatusInstance);
                            }
                            
                            JsonNode trafficRoutingMethodValue = propertiesValue.get("trafficRoutingMethod");
                            if (trafficRoutingMethodValue != null && trafficRoutingMethodValue instanceof NullNode == false) {
                                String trafficRoutingMethodInstance;
                                trafficRoutingMethodInstance = trafficRoutingMethodValue.getTextValue();
                                propertiesInstance.setTrafficRoutingMethod(trafficRoutingMethodInstance);
                            }
                            
                            JsonNode dnsConfigValue = propertiesValue.get("dnsConfig");
                            if (dnsConfigValue != null && dnsConfigValue instanceof NullNode == false) {
                                DnsConfig dnsConfigInstance = new DnsConfig();
                                propertiesInstance.setDnsConfig(dnsConfigInstance);
                                
                                JsonNode relativeNameValue = dnsConfigValue.get("relativeName");
                                if (relativeNameValue != null && relativeNameValue instanceof NullNode == false) {
                                    String relativeNameInstance;
                                    relativeNameInstance = relativeNameValue.getTextValue();
                                    dnsConfigInstance.setRelativeName(relativeNameInstance);
                                }
                                
                                JsonNode fqdnValue = dnsConfigValue.get("fqdn");
                                if (fqdnValue != null && fqdnValue instanceof NullNode == false) {
                                    String fqdnInstance;
                                    fqdnInstance = fqdnValue.getTextValue();
                                    dnsConfigInstance.setFqdn(fqdnInstance);
                                }
                                
                                JsonNode ttlValue = dnsConfigValue.get("ttl");
                                if (ttlValue != null && ttlValue instanceof NullNode == false) {
                                    long ttlInstance;
                                    ttlInstance = ttlValue.getLongValue();
                                    dnsConfigInstance.setTtl(ttlInstance);
                                }
                            }
                            
                            JsonNode monitorConfigValue = propertiesValue.get("monitorConfig");
                            if (monitorConfigValue != null && monitorConfigValue instanceof NullNode == false) {
                                MonitorConfig monitorConfigInstance = new MonitorConfig();
                                propertiesInstance.setMonitorConfig(monitorConfigInstance);
                                
                                JsonNode profileMonitorStatusValue = monitorConfigValue.get("profileMonitorStatus");
                                if (profileMonitorStatusValue != null && profileMonitorStatusValue instanceof NullNode == false) {
                                    String profileMonitorStatusInstance;
                                    profileMonitorStatusInstance = profileMonitorStatusValue.getTextValue();
                                    monitorConfigInstance.setProfileMonitorStatus(profileMonitorStatusInstance);
                                }
                                
                                JsonNode protocolValue = monitorConfigValue.get("protocol");
                                if (protocolValue != null && protocolValue instanceof NullNode == false) {
                                    String protocolInstance;
                                    protocolInstance = protocolValue.getTextValue();
                                    monitorConfigInstance.setProtocol(protocolInstance);
                                }
                                
                                JsonNode portValue = monitorConfigValue.get("port");
                                if (portValue != null && portValue instanceof NullNode == false) {
                                    long portInstance;
                                    portInstance = portValue.getLongValue();
                                    monitorConfigInstance.setPort(portInstance);
                                }
                                
                                JsonNode pathValue = monitorConfigValue.get("path");
                                if (pathValue != null && pathValue instanceof NullNode == false) {
                                    String pathInstance;
                                    pathInstance = pathValue.getTextValue();
                                    monitorConfigInstance.setPath(pathInstance);
                                }
                            }
                            
                            JsonNode endpointsArray = propertiesValue.get("endpoints");
                            if (endpointsArray != null && endpointsArray instanceof NullNode == false) {
                                propertiesInstance.setEndpoints(new ArrayList<Endpoint>());
                                for (JsonNode endpointsValue : ((ArrayNode) endpointsArray)) {
                                    Endpoint endpointInstance = new Endpoint();
                                    propertiesInstance.getEndpoints().add(endpointInstance);
                                    
                                    JsonNode idValue = endpointsValue.get("id");
                                    if (idValue != null && idValue instanceof NullNode == false) {
                                        String idInstance;
                                        idInstance = idValue.getTextValue();
                                        endpointInstance.setId(idInstance);
                                    }
                                    
                                    JsonNode nameValue = endpointsValue.get("name");
                                    if (nameValue != null && nameValue instanceof NullNode == false) {
                                        String nameInstance;
                                        nameInstance = nameValue.getTextValue();
                                        endpointInstance.setName(nameInstance);
                                    }
                                    
                                    JsonNode typeValue = endpointsValue.get("type");
                                    if (typeValue != null && typeValue instanceof NullNode == false) {
                                        String typeInstance;
                                        typeInstance = typeValue.getTextValue();
                                        endpointInstance.setType(typeInstance);
                                    }
                                    
                                    JsonNode propertiesValue2 = endpointsValue.get("properties");
                                    if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                                        EndpointProperties propertiesInstance2 = new EndpointProperties();
                                        endpointInstance.setProperties(propertiesInstance2);
                                        
                                        JsonNode targetResourceIdValue = propertiesValue2.get("targetResourceId");
                                        if (targetResourceIdValue != null && targetResourceIdValue instanceof NullNode == false) {
                                            String targetResourceIdInstance;
                                            targetResourceIdInstance = targetResourceIdValue.getTextValue();
                                            propertiesInstance2.setTargetResourceId(targetResourceIdInstance);
                                        }
                                        
                                        JsonNode targetValue = propertiesValue2.get("target");
                                        if (targetValue != null && targetValue instanceof NullNode == false) {
                                            String targetInstance;
                                            targetInstance = targetValue.getTextValue();
                                            propertiesInstance2.setTarget(targetInstance);
                                        }
                                        
                                        JsonNode endpointStatusValue = propertiesValue2.get("endpointStatus");
                                        if (endpointStatusValue != null && endpointStatusValue instanceof NullNode == false) {
                                            String endpointStatusInstance;
                                            endpointStatusInstance = endpointStatusValue.getTextValue();
                                            propertiesInstance2.setEndpointStatus(endpointStatusInstance);
                                        }
                                        
                                        JsonNode weightValue = propertiesValue2.get("weight");
                                        if (weightValue != null && weightValue instanceof NullNode == false) {
                                            long weightInstance;
                                            weightInstance = weightValue.getLongValue();
                                            propertiesInstance2.setWeight(weightInstance);
                                        }
                                        
                                        JsonNode priorityValue = propertiesValue2.get("priority");
                                        if (priorityValue != null && priorityValue instanceof NullNode == false) {
                                            long priorityInstance;
                                            priorityInstance = priorityValue.getLongValue();
                                            propertiesInstance2.setPriority(priorityInstance);
                                        }
                                        
                                        JsonNode endpointLocationValue = propertiesValue2.get("endpointLocation");
                                        if (endpointLocationValue != null && endpointLocationValue instanceof NullNode == false) {
                                            String endpointLocationInstance;
                                            endpointLocationInstance = endpointLocationValue.getTextValue();
                                            propertiesInstance2.setEndpointLocation(endpointLocationInstance);
                                        }
                                        
                                        JsonNode endpointMonitorStatusValue = propertiesValue2.get("endpointMonitorStatus");
                                        if (endpointMonitorStatusValue != null && endpointMonitorStatusValue instanceof NullNode == false) {
                                            String endpointMonitorStatusInstance;
                                            endpointMonitorStatusInstance = endpointMonitorStatusValue.getTextValue();
                                            propertiesInstance2.setEndpointMonitorStatus(endpointMonitorStatusInstance);
                                        }
                                    }
                                }
                            }
                        }
                        
                        JsonNode idValue2 = valuesValue.get("id");
                        if (idValue2 != null && idValue2 instanceof NullNode == false) {
                            String idInstance2;
                            idInstance2 = idValue2.getTextValue();
                            profileInstance.setId(idInstance2);
                        }
                        
                        JsonNode nameValue2 = valuesValue.get("name");
                        if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                            String nameInstance2;
                            nameInstance2 = nameValue2.getTextValue();
                            profileInstance.setName(nameInstance2);
                        }
                        
                        JsonNode typeValue2 = valuesValue.get("type");
                        if (typeValue2 != null && typeValue2 instanceof NullNode == false) {
                            String typeInstance2;
                            typeInstance2 = typeValue2.getTextValue();
                            profileInstance.setType(typeInstance2);
                        }
                        
                        JsonNode locationValue = valuesValue.get("location");
                        if (locationValue != null && locationValue instanceof NullNode == false) {
                            String locationInstance;
                            locationInstance = locationValue.getTextValue();
                            profileInstance.setLocation(locationInstance);
                        }
                        
                        JsonNode tagsSequenceElement = ((JsonNode) valuesValue.get("tags"));
                        if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                            Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                            while (itr.hasNext()) {
                                Map.Entry<String, JsonNode> property = itr.next();
                                String tagsKey = property.getKey();
                                String tagsValue = property.getValue().getTextValue();
                                profileInstance.getTags().put(tagsKey, tagsValue);
                            }
                        }
                    }
                }
            }
            
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Lists all Traffic Manager profiles within a resource group.
    *
    * @param resourceGroupName Required. The name of the resource group
    * containing the Traffic Manager profiles to be listed.
    * @return The response to a Traffic Manager profile 'ListAll' or
    * 'ListAllInResourceGroup' operation.
    */
    @Override
    public Future<ProfileListResponse> listAllInResourceGroupAsync(final String resourceGroupName) {
        return this.getClient().getExecutorService().submit(new Callable<ProfileListResponse>() { 
            @Override
            public ProfileListResponse call() throws Exception {
                return listAllInResourceGroup(resourceGroupName);
            }
         });
    }
    
    /**
    * Lists all Traffic Manager profiles within a resource group.
    *
    * @param resourceGroupName Required. The name of the resource group
    * containing the Traffic Manager profiles to be listed.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The response to a Traffic Manager profile 'ListAll' or
    * 'ListAllInResourceGroup' operation.
    */
    @Override
    public ProfileListResponse listAllInResourceGroup(String resourceGroupName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            CloudTracing.enter(invocationId, this, "listAllInResourceGroupAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/trafficmanagerprofiles";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-04-28-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode >= HttpStatus.SC_BAD_REQUEST) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ProfileListResponse result = null;
            // Deserialize Response
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new ProfileListResponse();
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode responseDoc = null;
            if (responseContent == null == false) {
                responseDoc = objectMapper.readTree(responseContent);
            }
            
            if (responseDoc != null && responseDoc instanceof NullNode == false) {
                JsonNode valuesArray = responseDoc.get("values");
                if (valuesArray != null && valuesArray instanceof NullNode == false) {
                    for (JsonNode valuesValue : ((ArrayNode) valuesArray)) {
                        Profile profileInstance = new Profile();
                        result.getProfiles().add(profileInstance);
                        
                        JsonNode propertiesValue = valuesValue.get("properties");
                        if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                            ProfileProperties propertiesInstance = new ProfileProperties();
                            profileInstance.setProperties(propertiesInstance);
                            
                            JsonNode profileStatusValue = propertiesValue.get("profileStatus");
                            if (profileStatusValue != null && profileStatusValue instanceof NullNode == false) {
                                String profileStatusInstance;
                                profileStatusInstance = profileStatusValue.getTextValue();
                                propertiesInstance.setProfileStatus(profileStatusInstance);
                            }
                            
                            JsonNode trafficRoutingMethodValue = propertiesValue.get("trafficRoutingMethod");
                            if (trafficRoutingMethodValue != null && trafficRoutingMethodValue instanceof NullNode == false) {
                                String trafficRoutingMethodInstance;
                                trafficRoutingMethodInstance = trafficRoutingMethodValue.getTextValue();
                                propertiesInstance.setTrafficRoutingMethod(trafficRoutingMethodInstance);
                            }
                            
                            JsonNode dnsConfigValue = propertiesValue.get("dnsConfig");
                            if (dnsConfigValue != null && dnsConfigValue instanceof NullNode == false) {
                                DnsConfig dnsConfigInstance = new DnsConfig();
                                propertiesInstance.setDnsConfig(dnsConfigInstance);
                                
                                JsonNode relativeNameValue = dnsConfigValue.get("relativeName");
                                if (relativeNameValue != null && relativeNameValue instanceof NullNode == false) {
                                    String relativeNameInstance;
                                    relativeNameInstance = relativeNameValue.getTextValue();
                                    dnsConfigInstance.setRelativeName(relativeNameInstance);
                                }
                                
                                JsonNode fqdnValue = dnsConfigValue.get("fqdn");
                                if (fqdnValue != null && fqdnValue instanceof NullNode == false) {
                                    String fqdnInstance;
                                    fqdnInstance = fqdnValue.getTextValue();
                                    dnsConfigInstance.setFqdn(fqdnInstance);
                                }
                                
                                JsonNode ttlValue = dnsConfigValue.get("ttl");
                                if (ttlValue != null && ttlValue instanceof NullNode == false) {
                                    long ttlInstance;
                                    ttlInstance = ttlValue.getLongValue();
                                    dnsConfigInstance.setTtl(ttlInstance);
                                }
                            }
                            
                            JsonNode monitorConfigValue = propertiesValue.get("monitorConfig");
                            if (monitorConfigValue != null && monitorConfigValue instanceof NullNode == false) {
                                MonitorConfig monitorConfigInstance = new MonitorConfig();
                                propertiesInstance.setMonitorConfig(monitorConfigInstance);
                                
                                JsonNode profileMonitorStatusValue = monitorConfigValue.get("profileMonitorStatus");
                                if (profileMonitorStatusValue != null && profileMonitorStatusValue instanceof NullNode == false) {
                                    String profileMonitorStatusInstance;
                                    profileMonitorStatusInstance = profileMonitorStatusValue.getTextValue();
                                    monitorConfigInstance.setProfileMonitorStatus(profileMonitorStatusInstance);
                                }
                                
                                JsonNode protocolValue = monitorConfigValue.get("protocol");
                                if (protocolValue != null && protocolValue instanceof NullNode == false) {
                                    String protocolInstance;
                                    protocolInstance = protocolValue.getTextValue();
                                    monitorConfigInstance.setProtocol(protocolInstance);
                                }
                                
                                JsonNode portValue = monitorConfigValue.get("port");
                                if (portValue != null && portValue instanceof NullNode == false) {
                                    long portInstance;
                                    portInstance = portValue.getLongValue();
                                    monitorConfigInstance.setPort(portInstance);
                                }
                                
                                JsonNode pathValue = monitorConfigValue.get("path");
                                if (pathValue != null && pathValue instanceof NullNode == false) {
                                    String pathInstance;
                                    pathInstance = pathValue.getTextValue();
                                    monitorConfigInstance.setPath(pathInstance);
                                }
                            }
                            
                            JsonNode endpointsArray = propertiesValue.get("endpoints");
                            if (endpointsArray != null && endpointsArray instanceof NullNode == false) {
                                propertiesInstance.setEndpoints(new ArrayList<Endpoint>());
                                for (JsonNode endpointsValue : ((ArrayNode) endpointsArray)) {
                                    Endpoint endpointInstance = new Endpoint();
                                    propertiesInstance.getEndpoints().add(endpointInstance);
                                    
                                    JsonNode idValue = endpointsValue.get("id");
                                    if (idValue != null && idValue instanceof NullNode == false) {
                                        String idInstance;
                                        idInstance = idValue.getTextValue();
                                        endpointInstance.setId(idInstance);
                                    }
                                    
                                    JsonNode nameValue = endpointsValue.get("name");
                                    if (nameValue != null && nameValue instanceof NullNode == false) {
                                        String nameInstance;
                                        nameInstance = nameValue.getTextValue();
                                        endpointInstance.setName(nameInstance);
                                    }
                                    
                                    JsonNode typeValue = endpointsValue.get("type");
                                    if (typeValue != null && typeValue instanceof NullNode == false) {
                                        String typeInstance;
                                        typeInstance = typeValue.getTextValue();
                                        endpointInstance.setType(typeInstance);
                                    }
                                    
                                    JsonNode propertiesValue2 = endpointsValue.get("properties");
                                    if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                                        EndpointProperties propertiesInstance2 = new EndpointProperties();
                                        endpointInstance.setProperties(propertiesInstance2);
                                        
                                        JsonNode targetResourceIdValue = propertiesValue2.get("targetResourceId");
                                        if (targetResourceIdValue != null && targetResourceIdValue instanceof NullNode == false) {
                                            String targetResourceIdInstance;
                                            targetResourceIdInstance = targetResourceIdValue.getTextValue();
                                            propertiesInstance2.setTargetResourceId(targetResourceIdInstance);
                                        }
                                        
                                        JsonNode targetValue = propertiesValue2.get("target");
                                        if (targetValue != null && targetValue instanceof NullNode == false) {
                                            String targetInstance;
                                            targetInstance = targetValue.getTextValue();
                                            propertiesInstance2.setTarget(targetInstance);
                                        }
                                        
                                        JsonNode endpointStatusValue = propertiesValue2.get("endpointStatus");
                                        if (endpointStatusValue != null && endpointStatusValue instanceof NullNode == false) {
                                            String endpointStatusInstance;
                                            endpointStatusInstance = endpointStatusValue.getTextValue();
                                            propertiesInstance2.setEndpointStatus(endpointStatusInstance);
                                        }
                                        
                                        JsonNode weightValue = propertiesValue2.get("weight");
                                        if (weightValue != null && weightValue instanceof NullNode == false) {
                                            long weightInstance;
                                            weightInstance = weightValue.getLongValue();
                                            propertiesInstance2.setWeight(weightInstance);
                                        }
                                        
                                        JsonNode priorityValue = propertiesValue2.get("priority");
                                        if (priorityValue != null && priorityValue instanceof NullNode == false) {
                                            long priorityInstance;
                                            priorityInstance = priorityValue.getLongValue();
                                            propertiesInstance2.setPriority(priorityInstance);
                                        }
                                        
                                        JsonNode endpointLocationValue = propertiesValue2.get("endpointLocation");
                                        if (endpointLocationValue != null && endpointLocationValue instanceof NullNode == false) {
                                            String endpointLocationInstance;
                                            endpointLocationInstance = endpointLocationValue.getTextValue();
                                            propertiesInstance2.setEndpointLocation(endpointLocationInstance);
                                        }
                                        
                                        JsonNode endpointMonitorStatusValue = propertiesValue2.get("endpointMonitorStatus");
                                        if (endpointMonitorStatusValue != null && endpointMonitorStatusValue instanceof NullNode == false) {
                                            String endpointMonitorStatusInstance;
                                            endpointMonitorStatusInstance = endpointMonitorStatusValue.getTextValue();
                                            propertiesInstance2.setEndpointMonitorStatus(endpointMonitorStatusInstance);
                                        }
                                    }
                                }
                            }
                        }
                        
                        JsonNode idValue2 = valuesValue.get("id");
                        if (idValue2 != null && idValue2 instanceof NullNode == false) {
                            String idInstance2;
                            idInstance2 = idValue2.getTextValue();
                            profileInstance.setId(idInstance2);
                        }
                        
                        JsonNode nameValue2 = valuesValue.get("name");
                        if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                            String nameInstance2;
                            nameInstance2 = nameValue2.getTextValue();
                            profileInstance.setName(nameInstance2);
                        }
                        
                        JsonNode typeValue2 = valuesValue.get("type");
                        if (typeValue2 != null && typeValue2 instanceof NullNode == false) {
                            String typeInstance2;
                            typeInstance2 = typeValue2.getTextValue();
                            profileInstance.setType(typeInstance2);
                        }
                        
                        JsonNode locationValue = valuesValue.get("location");
                        if (locationValue != null && locationValue instanceof NullNode == false) {
                            String locationInstance;
                            locationInstance = locationValue.getTextValue();
                            profileInstance.setLocation(locationInstance);
                        }
                        
                        JsonNode tagsSequenceElement = ((JsonNode) valuesValue.get("tags"));
                        if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                            Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                            while (itr.hasNext()) {
                                Map.Entry<String, JsonNode> property = itr.next();
                                String tagsKey = property.getKey();
                                String tagsValue = property.getValue().getTextValue();
                                profileInstance.getTags().put(tagsKey, tagsValue);
                            }
                        }
                    }
                }
            }
            
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Update a Traffic Manager profile.
    *
    * @param resourceGroupName Required. The name of the resource group
    * containing the Traffic Manager profile.
    * @param profileName Required. The name of the Traffic Manager profile.
    * @param parameters Required. The Traffic Manager profile parameters
    * supplied to the Update operation.
    * @return Parameters supplied to update a Traffic Manager profile.
    */
    @Override
    public Future<ProfileUpdateResponse> updateAsync(final String resourceGroupName, final String profileName, final ProfileUpdateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<ProfileUpdateResponse>() { 
            @Override
            public ProfileUpdateResponse call() throws Exception {
                return update(resourceGroupName, profileName, parameters);
            }
         });
    }
    
    /**
    * Update a Traffic Manager profile.
    *
    * @param resourceGroupName Required. The name of the resource group
    * containing the Traffic Manager profile.
    * @param profileName Required. The name of the Traffic Manager profile.
    * @param parameters Required. The Traffic Manager profile parameters
    * supplied to the Update operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Parameters supplied to update a Traffic Manager profile.
    */
    @Override
    public ProfileUpdateResponse update(String resourceGroupName, String profileName, ProfileUpdateParameters parameters) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (profileName == null) {
            throw new NullPointerException("profileName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getProfile() == null) {
            throw new NullPointerException("parameters.Profile");
        }
        if (parameters.getProfile().getLocation() == null) {
            throw new NullPointerException("parameters.Profile.Location");
        }
        if (parameters.getProfile().getProperties() != null) {
            if (parameters.getProfile().getProperties().getDnsConfig() != null) {
                if (parameters.getProfile().getProperties().getDnsConfig().getRelativeName() == null) {
                    throw new NullPointerException("parameters.Profile.Properties.DnsConfig.RelativeName");
                }
            }
            if (parameters.getProfile().getProperties().getMonitorConfig() != null) {
                if (parameters.getProfile().getProperties().getMonitorConfig().getPath() == null) {
                    throw new NullPointerException("parameters.Profile.Properties.MonitorConfig.Path");
                }
                if (parameters.getProfile().getProperties().getMonitorConfig().getProtocol() == null) {
                    throw new NullPointerException("parameters.Profile.Properties.MonitorConfig.Protocol");
                }
            }
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("profileName", profileName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "updateAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/trafficmanagerprofiles/";
        url = url + URLEncoder.encode(profileName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-04-28-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPatch httpRequest = new HttpPatch(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Serialize Request
        String requestContent = null;
        JsonNode requestDoc = null;
        
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode profileUpdateParametersValue = objectMapper.createObjectNode();
        requestDoc = profileUpdateParametersValue;
        
        if (parameters.getProfile().getProperties() != null) {
            ObjectNode propertiesValue = objectMapper.createObjectNode();
            ((ObjectNode) profileUpdateParametersValue).put("properties", propertiesValue);
            
            if (parameters.getProfile().getProperties().getProfileStatus() != null) {
                ((ObjectNode) propertiesValue).put("profileStatus", parameters.getProfile().getProperties().getProfileStatus());
            }
            
            if (parameters.getProfile().getProperties().getTrafficRoutingMethod() != null) {
                ((ObjectNode) propertiesValue).put("trafficRoutingMethod", parameters.getProfile().getProperties().getTrafficRoutingMethod());
            }
            
            if (parameters.getProfile().getProperties().getDnsConfig() != null) {
                ObjectNode dnsConfigValue = objectMapper.createObjectNode();
                ((ObjectNode) propertiesValue).put("dnsConfig", dnsConfigValue);
                
                ((ObjectNode) dnsConfigValue).put("relativeName", parameters.getProfile().getProperties().getDnsConfig().getRelativeName());
                
                if (parameters.getProfile().getProperties().getDnsConfig().getFqdn() != null) {
                    ((ObjectNode) dnsConfigValue).put("fqdn", parameters.getProfile().getProperties().getDnsConfig().getFqdn());
                }
                
                ((ObjectNode) dnsConfigValue).put("ttl", parameters.getProfile().getProperties().getDnsConfig().getTtl());
            }
            
            if (parameters.getProfile().getProperties().getMonitorConfig() != null) {
                ObjectNode monitorConfigValue = objectMapper.createObjectNode();
                ((ObjectNode) propertiesValue).put("monitorConfig", monitorConfigValue);
                
                if (parameters.getProfile().getProperties().getMonitorConfig().getProfileMonitorStatus() != null) {
                    ((ObjectNode) monitorConfigValue).put("profileMonitorStatus", parameters.getProfile().getProperties().getMonitorConfig().getProfileMonitorStatus());
                }
                
                ((ObjectNode) monitorConfigValue).put("protocol", parameters.getProfile().getProperties().getMonitorConfig().getProtocol());
                
                ((ObjectNode) monitorConfigValue).put("port", parameters.getProfile().getProperties().getMonitorConfig().getPort());
                
                ((ObjectNode) monitorConfigValue).put("path", parameters.getProfile().getProperties().getMonitorConfig().getPath());
            }
            
            if (parameters.getProfile().getProperties().getEndpoints() != null) {
                ArrayNode endpointsArray = objectMapper.createArrayNode();
                for (Endpoint endpointsItem : parameters.getProfile().getProperties().getEndpoints()) {
                    ObjectNode endpointValue = objectMapper.createObjectNode();
                    endpointsArray.add(endpointValue);
                    
                    if (endpointsItem.getId() != null) {
                        ((ObjectNode) endpointValue).put("id", endpointsItem.getId());
                    }
                    
                    if (endpointsItem.getName() != null) {
                        ((ObjectNode) endpointValue).put("name", endpointsItem.getName());
                    }
                    
                    if (endpointsItem.getType() != null) {
                        ((ObjectNode) endpointValue).put("type", endpointsItem.getType());
                    }
                    
                    if (endpointsItem.getProperties() != null) {
                        ObjectNode propertiesValue2 = objectMapper.createObjectNode();
                        ((ObjectNode) endpointValue).put("properties", propertiesValue2);
                        
                        if (endpointsItem.getProperties().getTargetResourceId() != null) {
                            ((ObjectNode) propertiesValue2).put("targetResourceId", endpointsItem.getProperties().getTargetResourceId());
                        }
                        
                        if (endpointsItem.getProperties().getTarget() != null) {
                            ((ObjectNode) propertiesValue2).put("target", endpointsItem.getProperties().getTarget());
                        }
                        
                        if (endpointsItem.getProperties().getEndpointStatus() != null) {
                            ((ObjectNode) propertiesValue2).put("endpointStatus", endpointsItem.getProperties().getEndpointStatus());
                        }
                        
                        if (endpointsItem.getProperties().getWeight() != null) {
                            ((ObjectNode) propertiesValue2).put("weight", endpointsItem.getProperties().getWeight());
                        }
                        
                        if (endpointsItem.getProperties().getPriority() != null) {
                            ((ObjectNode) propertiesValue2).put("priority", endpointsItem.getProperties().getPriority());
                        }
                        
                        if (endpointsItem.getProperties().getEndpointLocation() != null) {
                            ((ObjectNode) propertiesValue2).put("endpointLocation", endpointsItem.getProperties().getEndpointLocation());
                        }
                        
                        if (endpointsItem.getProperties().getEndpointMonitorStatus() != null) {
                            ((ObjectNode) propertiesValue2).put("endpointMonitorStatus", endpointsItem.getProperties().getEndpointMonitorStatus());
                        }
                    }
                }
                ((ObjectNode) propertiesValue).put("endpoints", endpointsArray);
            }
        }
        
        if (parameters.getProfile().getId() != null) {
            ((ObjectNode) profileUpdateParametersValue).put("id", parameters.getProfile().getId());
        }
        
        if (parameters.getProfile().getName() != null) {
            ((ObjectNode) profileUpdateParametersValue).put("name", parameters.getProfile().getName());
        }
        
        if (parameters.getProfile().getType() != null) {
            ((ObjectNode) profileUpdateParametersValue).put("type", parameters.getProfile().getType());
        }
        
        ((ObjectNode) profileUpdateParametersValue).put("location", parameters.getProfile().getLocation());
        
        if (parameters.getProfile().getTags() != null) {
            ObjectNode tagsDictionary = objectMapper.createObjectNode();
            for (Map.Entry<String, String> entry : parameters.getProfile().getTags().entrySet()) {
                String tagsKey = entry.getKey();
                String tagsValue = entry.getValue();
                ((ObjectNode) tagsDictionary).put(tagsKey, tagsValue);
            }
            ((ObjectNode) profileUpdateParametersValue).put("tags", tagsDictionary);
        }
        
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue(stringWriter, requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode >= HttpStatus.SC_BAD_REQUEST) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ProfileUpdateResponse result = null;
            // Deserialize Response
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new ProfileUpdateResponse();
            JsonNode responseDoc = null;
            if (responseContent == null == false) {
                responseDoc = objectMapper.readTree(responseContent);
            }
            
            JsonNode profileUpdateResponseValue = responseDoc.get("ProfileUpdateResponse");
            if (profileUpdateResponseValue != null && profileUpdateResponseValue instanceof NullNode == false) {
                ProfileUpdateParameters profileUpdateResponseInstance = new ProfileUpdateParameters();
                
                Profile profileInstance = new Profile();
                result.setProfile(profileInstance);
                
                JsonNode propertiesValue3 = profileUpdateResponseValue.get("properties");
                if (propertiesValue3 != null && propertiesValue3 instanceof NullNode == false) {
                    ProfileProperties propertiesInstance = new ProfileProperties();
                    profileInstance.setProperties(propertiesInstance);
                    
                    JsonNode profileStatusValue = propertiesValue3.get("profileStatus");
                    if (profileStatusValue != null && profileStatusValue instanceof NullNode == false) {
                        String profileStatusInstance;
                        profileStatusInstance = profileStatusValue.getTextValue();
                        propertiesInstance.setProfileStatus(profileStatusInstance);
                    }
                    
                    JsonNode trafficRoutingMethodValue = propertiesValue3.get("trafficRoutingMethod");
                    if (trafficRoutingMethodValue != null && trafficRoutingMethodValue instanceof NullNode == false) {
                        String trafficRoutingMethodInstance;
                        trafficRoutingMethodInstance = trafficRoutingMethodValue.getTextValue();
                        propertiesInstance.setTrafficRoutingMethod(trafficRoutingMethodInstance);
                    }
                    
                    JsonNode dnsConfigValue2 = propertiesValue3.get("dnsConfig");
                    if (dnsConfigValue2 != null && dnsConfigValue2 instanceof NullNode == false) {
                        DnsConfig dnsConfigInstance = new DnsConfig();
                        propertiesInstance.setDnsConfig(dnsConfigInstance);
                        
                        JsonNode relativeNameValue = dnsConfigValue2.get("relativeName");
                        if (relativeNameValue != null && relativeNameValue instanceof NullNode == false) {
                            String relativeNameInstance;
                            relativeNameInstance = relativeNameValue.getTextValue();
                            dnsConfigInstance.setRelativeName(relativeNameInstance);
                        }
                        
                        JsonNode fqdnValue = dnsConfigValue2.get("fqdn");
                        if (fqdnValue != null && fqdnValue instanceof NullNode == false) {
                            String fqdnInstance;
                            fqdnInstance = fqdnValue.getTextValue();
                            dnsConfigInstance.setFqdn(fqdnInstance);
                        }
                        
                        JsonNode ttlValue = dnsConfigValue2.get("ttl");
                        if (ttlValue != null && ttlValue instanceof NullNode == false) {
                            long ttlInstance;
                            ttlInstance = ttlValue.getLongValue();
                            dnsConfigInstance.setTtl(ttlInstance);
                        }
                    }
                    
                    JsonNode monitorConfigValue2 = propertiesValue3.get("monitorConfig");
                    if (monitorConfigValue2 != null && monitorConfigValue2 instanceof NullNode == false) {
                        MonitorConfig monitorConfigInstance = new MonitorConfig();
                        propertiesInstance.setMonitorConfig(monitorConfigInstance);
                        
                        JsonNode profileMonitorStatusValue = monitorConfigValue2.get("profileMonitorStatus");
                        if (profileMonitorStatusValue != null && profileMonitorStatusValue instanceof NullNode == false) {
                            String profileMonitorStatusInstance;
                            profileMonitorStatusInstance = profileMonitorStatusValue.getTextValue();
                            monitorConfigInstance.setProfileMonitorStatus(profileMonitorStatusInstance);
                        }
                        
                        JsonNode protocolValue = monitorConfigValue2.get("protocol");
                        if (protocolValue != null && protocolValue instanceof NullNode == false) {
                            String protocolInstance;
                            protocolInstance = protocolValue.getTextValue();
                            monitorConfigInstance.setProtocol(protocolInstance);
                        }
                        
                        JsonNode portValue = monitorConfigValue2.get("port");
                        if (portValue != null && portValue instanceof NullNode == false) {
                            long portInstance;
                            portInstance = portValue.getLongValue();
                            monitorConfigInstance.setPort(portInstance);
                        }
                        
                        JsonNode pathValue = monitorConfigValue2.get("path");
                        if (pathValue != null && pathValue instanceof NullNode == false) {
                            String pathInstance;
                            pathInstance = pathValue.getTextValue();
                            monitorConfigInstance.setPath(pathInstance);
                        }
                    }
                    
                    JsonNode endpointsArray2 = propertiesValue3.get("endpoints");
                    if (endpointsArray2 != null && endpointsArray2 instanceof NullNode == false) {
                        propertiesInstance.setEndpoints(new ArrayList<Endpoint>());
                        for (JsonNode endpointsValue : ((ArrayNode) endpointsArray2)) {
                            Endpoint endpointInstance = new Endpoint();
                            propertiesInstance.getEndpoints().add(endpointInstance);
                            
                            JsonNode idValue = endpointsValue.get("id");
                            if (idValue != null && idValue instanceof NullNode == false) {
                                String idInstance;
                                idInstance = idValue.getTextValue();
                                endpointInstance.setId(idInstance);
                            }
                            
                            JsonNode nameValue = endpointsValue.get("name");
                            if (nameValue != null && nameValue instanceof NullNode == false) {
                                String nameInstance;
                                nameInstance = nameValue.getTextValue();
                                endpointInstance.setName(nameInstance);
                            }
                            
                            JsonNode typeValue = endpointsValue.get("type");
                            if (typeValue != null && typeValue instanceof NullNode == false) {
                                String typeInstance;
                                typeInstance = typeValue.getTextValue();
                                endpointInstance.setType(typeInstance);
                            }
                            
                            JsonNode propertiesValue4 = endpointsValue.get("properties");
                            if (propertiesValue4 != null && propertiesValue4 instanceof NullNode == false) {
                                EndpointProperties propertiesInstance2 = new EndpointProperties();
                                endpointInstance.setProperties(propertiesInstance2);
                                
                                JsonNode targetResourceIdValue = propertiesValue4.get("targetResourceId");
                                if (targetResourceIdValue != null && targetResourceIdValue instanceof NullNode == false) {
                                    String targetResourceIdInstance;
                                    targetResourceIdInstance = targetResourceIdValue.getTextValue();
                                    propertiesInstance2.setTargetResourceId(targetResourceIdInstance);
                                }
                                
                                JsonNode targetValue = propertiesValue4.get("target");
                                if (targetValue != null && targetValue instanceof NullNode == false) {
                                    String targetInstance;
                                    targetInstance = targetValue.getTextValue();
                                    propertiesInstance2.setTarget(targetInstance);
                                }
                                
                                JsonNode endpointStatusValue = propertiesValue4.get("endpointStatus");
                                if (endpointStatusValue != null && endpointStatusValue instanceof NullNode == false) {
                                    String endpointStatusInstance;
                                    endpointStatusInstance = endpointStatusValue.getTextValue();
                                    propertiesInstance2.setEndpointStatus(endpointStatusInstance);
                                }
                                
                                JsonNode weightValue = propertiesValue4.get("weight");
                                if (weightValue != null && weightValue instanceof NullNode == false) {
                                    long weightInstance;
                                    weightInstance = weightValue.getLongValue();
                                    propertiesInstance2.setWeight(weightInstance);
                                }
                                
                                JsonNode priorityValue = propertiesValue4.get("priority");
                                if (priorityValue != null && priorityValue instanceof NullNode == false) {
                                    long priorityInstance;
                                    priorityInstance = priorityValue.getLongValue();
                                    propertiesInstance2.setPriority(priorityInstance);
                                }
                                
                                JsonNode endpointLocationValue = propertiesValue4.get("endpointLocation");
                                if (endpointLocationValue != null && endpointLocationValue instanceof NullNode == false) {
                                    String endpointLocationInstance;
                                    endpointLocationInstance = endpointLocationValue.getTextValue();
                                    propertiesInstance2.setEndpointLocation(endpointLocationInstance);
                                }
                                
                                JsonNode endpointMonitorStatusValue = propertiesValue4.get("endpointMonitorStatus");
                                if (endpointMonitorStatusValue != null && endpointMonitorStatusValue instanceof NullNode == false) {
                                    String endpointMonitorStatusInstance;
                                    endpointMonitorStatusInstance = endpointMonitorStatusValue.getTextValue();
                                    propertiesInstance2.setEndpointMonitorStatus(endpointMonitorStatusInstance);
                                }
                            }
                        }
                    }
                }
                
                JsonNode idValue2 = profileUpdateResponseValue.get("id");
                if (idValue2 != null && idValue2 instanceof NullNode == false) {
                    String idInstance2;
                    idInstance2 = idValue2.getTextValue();
                    profileInstance.setId(idInstance2);
                }
                
                JsonNode nameValue2 = profileUpdateResponseValue.get("name");
                if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                    String nameInstance2;
                    nameInstance2 = nameValue2.getTextValue();
                    profileInstance.setName(nameInstance2);
                }
                
                JsonNode typeValue2 = profileUpdateResponseValue.get("type");
                if (typeValue2 != null && typeValue2 instanceof NullNode == false) {
                    String typeInstance2;
                    typeInstance2 = typeValue2.getTextValue();
                    profileInstance.setType(typeInstance2);
                }
                
                JsonNode locationValue = profileUpdateResponseValue.get("location");
                if (locationValue != null && locationValue instanceof NullNode == false) {
                    String locationInstance;
                    locationInstance = locationValue.getTextValue();
                    profileInstance.setLocation(locationInstance);
                }
                
                JsonNode tagsSequenceElement = ((JsonNode) profileUpdateResponseValue.get("tags"));
                if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                    Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                    while (itr.hasNext()) {
                        Map.Entry<String, JsonNode> property = itr.next();
                        String tagsKey2 = property.getKey();
                        String tagsValue2 = property.getValue().getTextValue();
                        profileInstance.getTags().put(tagsKey2, tagsValue2);
                    }
                }
            }
            
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}
