/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.trafficmanager.models;

/**
* Parameters supplied to check Traffic Manager name operation.
*/
public class CheckTrafficManagerRelativeDnsNameAvailabilityParameters {
    private String name;
    
    /**
    * Required. Gets or sets the name of the resource.
    * @return The Name value.
    */
    public String getName() {
        return this.name;
    }
    
    /**
    * Required. Gets or sets the name of the resource.
    * @param nameValue The Name value.
    */
    public void setName(final String nameValue) {
        this.name = nameValue;
    }
    
    private String type;
    
    /**
    * Required. Gets or sets the type of the resource.
    * @return The Type value.
    */
    public String getType() {
        return this.type;
    }
    
    /**
    * Required. Gets or sets the type of the resource.
    * @param typeValue The Type value.
    */
    public void setType(final String typeValue) {
        this.type = typeValue;
    }
    
    /**
    * Initializes a new instance of the
    * CheckTrafficManagerRelativeDnsNameAvailabilityParameters class.
    *
    */
    public CheckTrafficManagerRelativeDnsNameAvailabilityParameters() {
    }
    
    /**
    * Initializes a new instance of the
    * CheckTrafficManagerRelativeDnsNameAvailabilityParameters class with
    * required arguments.
    *
    * @param name Gets or sets the name of the resource.
    * @param type Gets or sets the type of the resource.
    */
    public CheckTrafficManagerRelativeDnsNameAvailabilityParameters(String name, String type) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (type == null) {
            throw new NullPointerException("type");
        }
        this.setName(name);
        this.setType(type);
    }
}
