/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.trafficmanager.models;

/**
* Class containing DNS settings in a Traffic Manager profile.
*/
public class DnsConfig {
    private String fqdn;
    
    /**
    * Optional. Gets or sets the fully-qualified domain name (FQDN) of the
    * Traffic Manager profile.  This is formed from the concatenation of the
    * RelativeName with the DNS domain used by Azure Traffic Manager.
    * @return The Fqdn value.
    */
    public String getFqdn() {
        return this.fqdn;
    }
    
    /**
    * Optional. Gets or sets the fully-qualified domain name (FQDN) of the
    * Traffic Manager profile.  This is formed from the concatenation of the
    * RelativeName with the DNS domain used by Azure Traffic Manager.
    * @param fqdnValue The Fqdn value.
    */
    public void setFqdn(final String fqdnValue) {
        this.fqdn = fqdnValue;
    }
    
    private String relativeName;
    
    /**
    * Required. Gets or sets the relative DNS name provided by this Traffic
    * Manager profile.  This value is combined with the DNS domain name used
    * by Azure Traffic Manager to form the fully-qualified domain name (FQDN)
    * of the profile.
    * @return The RelativeName value.
    */
    public String getRelativeName() {
        return this.relativeName;
    }
    
    /**
    * Required. Gets or sets the relative DNS name provided by this Traffic
    * Manager profile.  This value is combined with the DNS domain name used
    * by Azure Traffic Manager to form the fully-qualified domain name (FQDN)
    * of the profile.
    * @param relativeNameValue The RelativeName value.
    */
    public void setRelativeName(final String relativeNameValue) {
        this.relativeName = relativeNameValue;
    }
    
    private long ttl;
    
    /**
    * Required. Gets or sets the DNS Ttime-To-Live (TTL), in seconds.  This
    * informs the local DNS resolvers and DNS clients how long to cache DNS
    * responses provided by this Traffic Manager profile.
    * @return The Ttl value.
    */
    public long getTtl() {
        return this.ttl;
    }
    
    /**
    * Required. Gets or sets the DNS Ttime-To-Live (TTL), in seconds.  This
    * informs the local DNS resolvers and DNS clients how long to cache DNS
    * responses provided by this Traffic Manager profile.
    * @param ttlValue The Ttl value.
    */
    public void setTtl(final long ttlValue) {
        this.ttl = ttlValue;
    }
    
    /**
    * Initializes a new instance of the DnsConfig class.
    *
    */
    public DnsConfig() {
    }
    
    /**
    * Initializes a new instance of the DnsConfig class with required arguments.
    *
    * @param relativeName Gets or sets the relative DNS name provided by this
    * Traffic Manager profile.  This value is combined with the DNS domain
    * name used by Azure Traffic Manager to form the fully-qualified domain
    * name (FQDN) of the profile.
    * @param ttl Gets or sets the DNS Ttime-To-Live (TTL), in seconds.  This
    * informs the local DNS resolvers and DNS clients how long to cache DNS
    * responses provided by this Traffic Manager profile.
    */
    public DnsConfig(String relativeName, long ttl) {
        if (relativeName == null) {
            throw new NullPointerException("relativeName");
        }
        this.setRelativeName(relativeName);
        this.setTtl(ttl);
    }
}
