/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.trafficmanager.models;

/**
* Class containing the properties of a Traffic Manager endpoint.
*/
public class EndpointProperties {
    private String endpointLocation;
    
    /**
    * Optional. Specifies the location of the external or nested endpoints when
    * using the ‘Performance’ traffic routing method.
    * @return The EndpointLocation value.
    */
    public String getEndpointLocation() {
        return this.endpointLocation;
    }
    
    /**
    * Optional. Specifies the location of the external or nested endpoints when
    * using the ‘Performance’ traffic routing method.
    * @param endpointLocationValue The EndpointLocation value.
    */
    public void setEndpointLocation(final String endpointLocationValue) {
        this.endpointLocation = endpointLocationValue;
    }
    
    private String endpointMonitorStatus;
    
    /**
    * Optional. Gets or sets the monitoring status of the endpoint.
    * @return The EndpointMonitorStatus value.
    */
    public String getEndpointMonitorStatus() {
        return this.endpointMonitorStatus;
    }
    
    /**
    * Optional. Gets or sets the monitoring status of the endpoint.
    * @param endpointMonitorStatusValue The EndpointMonitorStatus value.
    */
    public void setEndpointMonitorStatus(final String endpointMonitorStatusValue) {
        this.endpointMonitorStatus = endpointMonitorStatusValue;
    }
    
    private String endpointStatus;
    
    /**
    * Optional. Gets or sets the status of the endpoint..  If the endpoint is
    * Enabled, it is probed for endpoint health and is included in the traffic
    * routing method.  Possible values are 'Enabled' and 'Disabled'.
    * @return The EndpointStatus value.
    */
    public String getEndpointStatus() {
        return this.endpointStatus;
    }
    
    /**
    * Optional. Gets or sets the status of the endpoint..  If the endpoint is
    * Enabled, it is probed for endpoint health and is included in the traffic
    * routing method.  Possible values are 'Enabled' and 'Disabled'.
    * @param endpointStatusValue The EndpointStatus value.
    */
    public void setEndpointStatus(final String endpointStatusValue) {
        this.endpointStatus = endpointStatusValue;
    }
    
    private Long priority;
    
    /**
    * Optional. Gets or sets the priority of this endpoint when using the
    * ‘Priority’ traffic routing method. Possible values are from 1 to 1000,
    * lower values represent higher priority. This is an optional parameter.
    * If specified, it must be specified on all endpoints, and no two
    * endpoints can share the same priority value.
    * @return The Priority value.
    */
    public Long getPriority() {
        return this.priority;
    }
    
    /**
    * Optional. Gets or sets the priority of this endpoint when using the
    * ‘Priority’ traffic routing method. Possible values are from 1 to 1000,
    * lower values represent higher priority. This is an optional parameter.
    * If specified, it must be specified on all endpoints, and no two
    * endpoints can share the same priority value.
    * @param priorityValue The Priority value.
    */
    public void setPriority(final Long priorityValue) {
        this.priority = priorityValue;
    }
    
    private String target;
    
    /**
    * Optional. Gets or sets the fully-qualified DNS name of the endpoint.
    * Traffic Manager returns this value in DNS responses to direct traffic
    * to this endpoint.
    * @return The Target value.
    */
    public String getTarget() {
        return this.target;
    }
    
    /**
    * Optional. Gets or sets the fully-qualified DNS name of the endpoint.
    * Traffic Manager returns this value in DNS responses to direct traffic
    * to this endpoint.
    * @param targetValue The Target value.
    */
    public void setTarget(final String targetValue) {
        this.target = targetValue;
    }
    
    private String targetResourceId;
    
    /**
    * Optional. Gets or sets the Azure Resource URI of the of the endpoint.
    * Not applicable to endpoints of type 'ExternalEndpoints'.
    * @return The TargetResourceId value.
    */
    public String getTargetResourceId() {
        return this.targetResourceId;
    }
    
    /**
    * Optional. Gets or sets the Azure Resource URI of the of the endpoint.
    * Not applicable to endpoints of type 'ExternalEndpoints'.
    * @param targetResourceIdValue The TargetResourceId value.
    */
    public void setTargetResourceId(final String targetResourceIdValue) {
        this.targetResourceId = targetResourceIdValue;
    }
    
    private Long weight;
    
    /**
    * Optional. Gets or sets the weight of this endpoint when using the
    * 'Weighted' traffic routing method. Possible values are from 1 to 1000.
    * @return The Weight value.
    */
    public Long getWeight() {
        return this.weight;
    }
    
    /**
    * Optional. Gets or sets the weight of this endpoint when using the
    * 'Weighted' traffic routing method. Possible values are from 1 to 1000.
    * @param weightValue The Weight value.
    */
    public void setWeight(final Long weightValue) {
        this.weight = weightValue;
    }
}
