/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.trafficmanager.models;

/**
* Parameters supplied to create or update a Traffic Manager endpoint.
*/
public class EndpointUpdateParameters {
    private Endpoint endpoint;
    
    /**
    * Required. Gets or sets parameters for the Traffic Manager endpoint being
    * created or updated.
    * @return The Endpoint value.
    */
    public Endpoint getEndpoint() {
        return this.endpoint;
    }
    
    /**
    * Required. Gets or sets parameters for the Traffic Manager endpoint being
    * created or updated.
    * @param endpointValue The Endpoint value.
    */
    public void setEndpoint(final Endpoint endpointValue) {
        this.endpoint = endpointValue;
    }
    
    /**
    * Initializes a new instance of the EndpointUpdateParameters class.
    *
    */
    public EndpointUpdateParameters() {
    }
    
    /**
    * Initializes a new instance of the EndpointUpdateParameters class with
    * required arguments.
    *
    * @param endpoint Gets or sets parameters for the Traffic Manager endpoint
    * being created or updated.
    */
    public EndpointUpdateParameters(Endpoint endpoint) {
        if (endpoint == null) {
            throw new NullPointerException("endpoint");
        }
        this.setEndpoint(endpoint);
    }
}
