/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.trafficmanager.models;

/**
* Class containing endpoint monitoring settings in a Traffic Manager profile.
*/
public class MonitorConfig {
    private String path;
    
    /**
    * Required. Gets or sets the path relative to the endpoint domain name used
    * to probe for endpoint health.
    * @return The Path value.
    */
    public String getPath() {
        return this.path;
    }
    
    /**
    * Required. Gets or sets the path relative to the endpoint domain name used
    * to probe for endpoint health.
    * @param pathValue The Path value.
    */
    public void setPath(final String pathValue) {
        this.path = pathValue;
    }
    
    private long port;
    
    /**
    * Required. Gets or sets the TCP port used to probe for endpoint health.
    * @return The Port value.
    */
    public long getPort() {
        return this.port;
    }
    
    /**
    * Required. Gets or sets the TCP port used to probe for endpoint health.
    * @param portValue The Port value.
    */
    public void setPort(final long portValue) {
        this.port = portValue;
    }
    
    private String profileMonitorStatus;
    
    /**
    * Optional. Gets or sets the profile-level monitoring status of the Traffic
    * Manager profile.
    * @return The ProfileMonitorStatus value.
    */
    public String getProfileMonitorStatus() {
        return this.profileMonitorStatus;
    }
    
    /**
    * Optional. Gets or sets the profile-level monitoring status of the Traffic
    * Manager profile.
    * @param profileMonitorStatusValue The ProfileMonitorStatus value.
    */
    public void setProfileMonitorStatus(final String profileMonitorStatusValue) {
        this.profileMonitorStatus = profileMonitorStatusValue;
    }
    
    private String protocol;
    
    /**
    * Required. Gets or sets the protocol (HTTP or HTTPS) used to probe for
    * endpoint health.
    * @return The Protocol value.
    */
    public String getProtocol() {
        return this.protocol;
    }
    
    /**
    * Required. Gets or sets the protocol (HTTP or HTTPS) used to probe for
    * endpoint health.
    * @param protocolValue The Protocol value.
    */
    public void setProtocol(final String protocolValue) {
        this.protocol = protocolValue;
    }
    
    /**
    * Initializes a new instance of the MonitorConfig class.
    *
    */
    public MonitorConfig() {
    }
    
    /**
    * Initializes a new instance of the MonitorConfig class with required
    * arguments.
    *
    * @param protocol Gets or sets the protocol (HTTP or HTTPS) used to probe
    * for endpoint health.
    * @param port Gets or sets the TCP port used to probe for endpoint health.
    * @param path Gets or sets the path relative to the endpoint domain name
    * used to probe for endpoint health.
    */
    public MonitorConfig(String protocol, long port, String path) {
        if (protocol == null) {
            throw new NullPointerException("protocol");
        }
        if (path == null) {
            throw new NullPointerException("path");
        }
        this.setProtocol(protocol);
        this.setPort(port);
        this.setPath(path);
    }
}
