/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.trafficmanager.models;

/**
* Parameters supplied to create or update a Traffic Manager profile.
*/
public class ProfileCreateOrUpdateParameters {
    private Profile profile;
    
    /**
    * Required. Gets or sets parameters for the Traffic Manager profile being
    * created or updated.
    * @return The Profile value.
    */
    public Profile getProfile() {
        return this.profile;
    }
    
    /**
    * Required. Gets or sets parameters for the Traffic Manager profile being
    * created or updated.
    * @param profileValue The Profile value.
    */
    public void setProfile(final Profile profileValue) {
        this.profile = profileValue;
    }
    
    /**
    * Initializes a new instance of the ProfileCreateOrUpdateParameters class.
    *
    */
    public ProfileCreateOrUpdateParameters() {
    }
    
    /**
    * Initializes a new instance of the ProfileCreateOrUpdateParameters class
    * with required arguments.
    *
    * @param profile Gets or sets parameters for the Traffic Manager profile
    * being created or updated.
    */
    public ProfileCreateOrUpdateParameters(Profile profile) {
        if (profile == null) {
            throw new NullPointerException("profile");
        }
        this.setProfile(profile);
    }
}
