/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.trafficmanager.models;

import com.microsoft.windowsazure.core.LazyArrayList;
import com.microsoft.windowsazure.core.OperationResponse;

import java.util.ArrayList;
import java.util.Iterator;

/**
* The response to a Traffic Manager profile 'ListAll' or
* 'ListAllInResourceGroup' operation.
*/
public class ProfileListResponse extends OperationResponse implements Iterable<Profile> {
    private ArrayList<Profile> profiles;
    
    /**
    * Required. Gets or sets information about the Traffic Manager profiles in
    * the response to the 'ListAll' or 'ListAllInResourceGroup' operation.
    * @return The Profiles value.
    */
    public ArrayList<Profile> getProfiles() {
        return this.profiles;
    }
    
    /**
    * Required. Gets or sets information about the Traffic Manager profiles in
    * the response to the 'ListAll' or 'ListAllInResourceGroup' operation.
    * @param profilesValue The Profiles value.
    */
    public void setProfiles(final ArrayList<Profile> profilesValue) {
        this.profiles = profilesValue;
    }
    
    /**
    * Initializes a new instance of the ProfileListResponse class.
    *
    */
    public ProfileListResponse() {
        super();
        this.setProfiles(new LazyArrayList<Profile>());
    }
    
    /**
    * Initializes a new instance of the ProfileListResponse class with required
    * arguments.
    *
    * @param profiles Gets or sets information about the Traffic Manager
    * profiles in the response to the 'ListAll' or 'ListAllInResourceGroup'
    * operation.
    */
    public ProfileListResponse(ArrayList<Profile> profiles) {
        this();
        if (profiles == null) {
            throw new NullPointerException("profiles");
        }
        this.setProfiles(profiles);
    }
    
    /**
    * Gets the sequence of Profiles.
    *
    */
    public Iterator<Profile> iterator() {
        return this.getProfiles().iterator();
    }
}
