/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.trafficmanager.models;

import java.util.ArrayList;

/**
* Class containing the properties of a Traffic Manager profile.
*/
public class ProfileProperties {
    private DnsConfig dnsConfig;
    
    /**
    * Optional. Gets or sets the DNS settings of the Traffic Manager profile.
    * @return The DnsConfig value.
    */
    public DnsConfig getDnsConfig() {
        return this.dnsConfig;
    }
    
    /**
    * Optional. Gets or sets the DNS settings of the Traffic Manager profile.
    * @param dnsConfigValue The DnsConfig value.
    */
    public void setDnsConfig(final DnsConfig dnsConfigValue) {
        this.dnsConfig = dnsConfigValue;
    }
    
    private ArrayList<Endpoint> endpoints;
    
    /**
    * Optional. Gets or sets the list of endpoints in the Traffic Manager
    * profile.
    * @return The Endpoints value.
    */
    public ArrayList<Endpoint> getEndpoints() {
        return this.endpoints;
    }
    
    /**
    * Optional. Gets or sets the list of endpoints in the Traffic Manager
    * profile.
    * @param endpointsValue The Endpoints value.
    */
    public void setEndpoints(final ArrayList<Endpoint> endpointsValue) {
        this.endpoints = endpointsValue;
    }
    
    private MonitorConfig monitorConfig;
    
    /**
    * Optional. Gets or sets the endpoint monitoring settings of the Traffic
    * Manager profile.
    * @return The MonitorConfig value.
    */
    public MonitorConfig getMonitorConfig() {
        return this.monitorConfig;
    }
    
    /**
    * Optional. Gets or sets the endpoint monitoring settings of the Traffic
    * Manager profile.
    * @param monitorConfigValue The MonitorConfig value.
    */
    public void setMonitorConfig(final MonitorConfig monitorConfigValue) {
        this.monitorConfig = monitorConfigValue;
    }
    
    private String profileStatus;
    
    /**
    * Optional. Gets or sets the status of the Traffic Manager profile.
    * Possible values are 'Enabled' and 'Disabled'.
    * @return The ProfileStatus value.
    */
    public String getProfileStatus() {
        return this.profileStatus;
    }
    
    /**
    * Optional. Gets or sets the status of the Traffic Manager profile.
    * Possible values are 'Enabled' and 'Disabled'.
    * @param profileStatusValue The ProfileStatus value.
    */
    public void setProfileStatus(final String profileStatusValue) {
        this.profileStatus = profileStatusValue;
    }
    
    private String trafficRoutingMethod;
    
    /**
    * Optional. Gets or sets the traffic routing method of the Traffic Manager
    * profile.  Possible values are 'Performance', 'Weighted', or 'Priority'.
    * @return The TrafficRoutingMethod value.
    */
    public String getTrafficRoutingMethod() {
        return this.trafficRoutingMethod;
    }
    
    /**
    * Optional. Gets or sets the traffic routing method of the Traffic Manager
    * profile.  Possible values are 'Performance', 'Weighted', or 'Priority'.
    * @param trafficRoutingMethodValue The TrafficRoutingMethod value.
    */
    public void setTrafficRoutingMethod(final String trafficRoutingMethodValue) {
        this.trafficRoutingMethod = trafficRoutingMethodValue;
    }
    
    /**
    * Initializes a new instance of the ProfileProperties class.
    *
    */
    public ProfileProperties() {
    }
}
