/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.websites;

import com.microsoft.azure.management.websites.models.SourceControlGetResponse;
import com.microsoft.azure.management.websites.models.SourceControlListResponse;
import com.microsoft.azure.management.websites.models.SourceControlUpdateParameters;
import com.microsoft.azure.management.websites.models.SourceControlUpdateResponse;
import com.microsoft.windowsazure.exception.ServiceException;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.concurrent.Future;

/**
* User source controls operations
*/
public interface SourceControlOperations {
    /**
    * Get user source control
    *
    * @param name Required. The name of the source control (GitHub, Bitbucket,
    * CodePlex or Dropbox)
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The get source control operation response.
    */
    SourceControlGetResponse get(String name) throws IOException, ServiceException, URISyntaxException;
    
    /**
    * Get user source control
    *
    * @param name Required. The name of the source control (GitHub, Bitbucket,
    * CodePlex or Dropbox)
    * @return The get source control operation response.
    */
    Future<SourceControlGetResponse> getAsync(String name);
    
    /**
    * List source controls for user.
    *
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The list source controls operation response.
    */
    SourceControlListResponse list() throws IOException, ServiceException, URISyntaxException;
    
    /**
    * List source controls for user.
    *
    * @return The list source controls operation response.
    */
    Future<SourceControlListResponse> listAsync();
    
    /**
    * Update source control for user.
    *
    * @param name Required. The name of the source control (can be: GitHub,
    * Bitbucket, CodePlex, Dropbox)
    * @param parameters Required. Parameters supplied to the Update Source
    * Control operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The update source control operation response.
    */
    SourceControlUpdateResponse update(String name, SourceControlUpdateParameters parameters) throws IOException, ServiceException;
    
    /**
    * Update source control for user.
    *
    * @param name Required. The name of the source control (can be: GitHub,
    * Bitbucket, CodePlex, Dropbox)
    * @param parameters Required. Parameters supplied to the Update Source
    * Control operation.
    * @return The update source control operation response.
    */
    Future<SourceControlUpdateResponse> updateAsync(String name, SourceControlUpdateParameters parameters);
}
