/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.websites;

import com.microsoft.azure.management.websites.models.SourceControl;
import com.microsoft.azure.management.websites.models.SourceControlGetResponse;
import com.microsoft.azure.management.websites.models.SourceControlListResponse;
import com.microsoft.azure.management.websites.models.SourceControlProperties;
import com.microsoft.azure.management.websites.models.SourceControlUpdateParameters;
import com.microsoft.azure.management.websites.models.SourceControlUpdateResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.CloudTracing;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.ObjectNode;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

/**
* User source controls operations
*/
public class SourceControlOperationsImpl implements ServiceOperations<WebSiteManagementClientImpl>, SourceControlOperations {
    /**
    * Initializes a new instance of the SourceControlOperationsImpl class.
    *
    * @param client Reference to the service client.
    */
    SourceControlOperationsImpl(WebSiteManagementClientImpl client) {
        this.client = client;
    }
    
    private WebSiteManagementClientImpl client;
    
    /**
    * Gets a reference to the
    * microsoft.azure.management.websites.WebSiteManagementClientImpl.
    * @return The Client value.
    */
    public WebSiteManagementClientImpl getClient() {
        return this.client;
    }
    
    /**
    * Get user source control
    *
    * @param name Required. The name of the source control (GitHub, Bitbucket,
    * CodePlex or Dropbox)
    * @return The get source control operation response.
    */
    @Override
    public Future<SourceControlGetResponse> getAsync(final String name) {
        return this.getClient().getExecutorService().submit(new Callable<SourceControlGetResponse>() { 
            @Override
            public SourceControlGetResponse call() throws Exception {
                return get(name);
            }
         });
    }
    
    /**
    * Get user source control
    *
    * @param name Required. The name of the source control (GitHub, Bitbucket,
    * CodePlex or Dropbox)
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The get source control operation response.
    */
    @Override
    public SourceControlGetResponse get(String name) throws IOException, ServiceException, URISyntaxException {
        // Validate
        if (name == null) {
            throw new NullPointerException("name");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("name", name);
            CloudTracing.enter(invocationId, this, "getAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/providers/";
        url = url + "Microsoft.Web";
        url = url + "/SourceControls/";
        url = url + URLEncoder.encode(name, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-06-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            SourceControlGetResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new SourceControlGetResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    SourceControl sourceControlInstance = new SourceControl();
                    result.setSourceControl(sourceControlInstance);
                    
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                        SourceControlProperties propertiesInstance = new SourceControlProperties();
                        sourceControlInstance.setProperties(propertiesInstance);
                        
                        JsonNode tokenValue = propertiesValue.get("token");
                        if (tokenValue != null && tokenValue instanceof NullNode == false) {
                            String tokenInstance;
                            tokenInstance = tokenValue.getTextValue();
                            propertiesInstance.setToken(tokenInstance);
                        }
                        
                        JsonNode tokenSecretValue = propertiesValue.get("tokenSecret");
                        if (tokenSecretValue != null && tokenSecretValue instanceof NullNode == false) {
                            String tokenSecretInstance;
                            tokenSecretInstance = tokenSecretValue.getTextValue();
                            propertiesInstance.setTokenSecret(tokenSecretInstance);
                        }
                    }
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        sourceControlInstance.setId(idInstance);
                    }
                    
                    JsonNode nameValue = responseDoc.get("name");
                    if (nameValue != null && nameValue instanceof NullNode == false) {
                        String nameInstance;
                        nameInstance = nameValue.getTextValue();
                        sourceControlInstance.setName(nameInstance);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        sourceControlInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry<String, JsonNode> property = itr.next();
                            String tagsKey = property.getKey();
                            String tagsValue = property.getValue().getTextValue();
                            sourceControlInstance.getTags().put(tagsKey, tagsValue);
                        }
                    }
                    
                    JsonNode typeValue = responseDoc.get("type");
                    if (typeValue != null && typeValue instanceof NullNode == false) {
                        String typeInstance;
                        typeInstance = typeValue.getTextValue();
                        sourceControlInstance.setType(typeInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * List source controls for user.
    *
    * @return The list source controls operation response.
    */
    @Override
    public Future<SourceControlListResponse> listAsync() {
        return this.getClient().getExecutorService().submit(new Callable<SourceControlListResponse>() { 
            @Override
            public SourceControlListResponse call() throws Exception {
                return list();
            }
         });
    }
    
    /**
    * List source controls for user.
    *
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The list source controls operation response.
    */
    @Override
    public SourceControlListResponse list() throws IOException, ServiceException, URISyntaxException {
        // Validate
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            CloudTracing.enter(invocationId, this, "listAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/providers/";
        url = url + "Microsoft.Web";
        url = url + "/SourceControls";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-06-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            SourceControlListResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new SourceControlListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && valueArray instanceof NullNode == false) {
                        for (JsonNode valueValue : ((ArrayNode) valueArray)) {
                            SourceControl propertiesInstance = new SourceControl();
                            result.getSourceControls().add(propertiesInstance);
                            
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                                SourceControlProperties propertiesInstance2 = new SourceControlProperties();
                                propertiesInstance.setProperties(propertiesInstance2);
                                
                                JsonNode tokenValue = propertiesValue.get("token");
                                if (tokenValue != null && tokenValue instanceof NullNode == false) {
                                    String tokenInstance;
                                    tokenInstance = tokenValue.getTextValue();
                                    propertiesInstance2.setToken(tokenInstance);
                                }
                                
                                JsonNode tokenSecretValue = propertiesValue.get("tokenSecret");
                                if (tokenSecretValue != null && tokenSecretValue instanceof NullNode == false) {
                                    String tokenSecretInstance;
                                    tokenSecretInstance = tokenSecretValue.getTextValue();
                                    propertiesInstance2.setTokenSecret(tokenSecretInstance);
                                }
                            }
                            
                            JsonNode idValue = valueValue.get("id");
                            if (idValue != null && idValue instanceof NullNode == false) {
                                String idInstance;
                                idInstance = idValue.getTextValue();
                                propertiesInstance.setId(idInstance);
                            }
                            
                            JsonNode nameValue = valueValue.get("name");
                            if (nameValue != null && nameValue instanceof NullNode == false) {
                                String nameInstance;
                                nameInstance = nameValue.getTextValue();
                                propertiesInstance.setName(nameInstance);
                            }
                            
                            JsonNode locationValue = valueValue.get("location");
                            if (locationValue != null && locationValue instanceof NullNode == false) {
                                String locationInstance;
                                locationInstance = locationValue.getTextValue();
                                propertiesInstance.setLocation(locationInstance);
                            }
                            
                            JsonNode tagsSequenceElement = ((JsonNode) valueValue.get("tags"));
                            if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                                while (itr.hasNext()) {
                                    Map.Entry<String, JsonNode> property = itr.next();
                                    String tagsKey = property.getKey();
                                    String tagsValue = property.getValue().getTextValue();
                                    propertiesInstance.getTags().put(tagsKey, tagsValue);
                                }
                            }
                            
                            JsonNode typeValue = valueValue.get("type");
                            if (typeValue != null && typeValue instanceof NullNode == false) {
                                String typeInstance;
                                typeInstance = typeValue.getTextValue();
                                propertiesInstance.setType(typeInstance);
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Update source control for user.
    *
    * @param name Required. The name of the source control (can be: GitHub,
    * Bitbucket, CodePlex, Dropbox)
    * @param parameters Required. Parameters supplied to the Update Source
    * Control operation.
    * @return The update source control operation response.
    */
    @Override
    public Future<SourceControlUpdateResponse> updateAsync(final String name, final SourceControlUpdateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<SourceControlUpdateResponse>() { 
            @Override
            public SourceControlUpdateResponse call() throws Exception {
                return update(name, parameters);
            }
         });
    }
    
    /**
    * Update source control for user.
    *
    * @param name Required. The name of the source control (can be: GitHub,
    * Bitbucket, CodePlex, Dropbox)
    * @param parameters Required. Parameters supplied to the Update Source
    * Control operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The update source control operation response.
    */
    @Override
    public SourceControlUpdateResponse update(String name, SourceControlUpdateParameters parameters) throws IOException, ServiceException {
        // Validate
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getProperties() == null) {
            throw new NullPointerException("parameters.Properties");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("name", name);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "updateAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/providers/";
        url = url + "Microsoft.Web";
        url = url + "/SourceControls/";
        url = url + URLEncoder.encode(name, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-06-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Serialize Request
        String requestContent = null;
        JsonNode requestDoc = null;
        
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode sourceControlUpdateParametersValue = objectMapper.createObjectNode();
        requestDoc = sourceControlUpdateParametersValue;
        
        ObjectNode propertiesValue = objectMapper.createObjectNode();
        ((ObjectNode) sourceControlUpdateParametersValue).put("properties", propertiesValue);
        
        if (parameters.getProperties().getToken() != null) {
            ((ObjectNode) propertiesValue).put("token", parameters.getProperties().getToken());
        }
        
        if (parameters.getProperties().getTokenSecret() != null) {
            ((ObjectNode) propertiesValue).put("tokenSecret", parameters.getProperties().getTokenSecret());
        }
        
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue(stringWriter, requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            SourceControlUpdateResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new SourceControlUpdateResponse();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                JsonNode sourceControlValue = responseDoc.get("SourceControl");
                if (sourceControlValue != null && sourceControlValue instanceof NullNode == false) {
                    SourceControlUpdateResponse sourceControlInstance = new SourceControlUpdateResponse();
                    
                    SourceControl sourceControlInstance2 = new SourceControl();
                    result.setSourceControl(sourceControlInstance2);
                    
                    JsonNode propertiesValue2 = sourceControlValue.get("properties");
                    if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                        SourceControlProperties propertiesInstance = new SourceControlProperties();
                        sourceControlInstance2.setProperties(propertiesInstance);
                        
                        JsonNode tokenValue = propertiesValue2.get("token");
                        if (tokenValue != null && tokenValue instanceof NullNode == false) {
                            String tokenInstance;
                            tokenInstance = tokenValue.getTextValue();
                            propertiesInstance.setToken(tokenInstance);
                        }
                        
                        JsonNode tokenSecretValue = propertiesValue2.get("tokenSecret");
                        if (tokenSecretValue != null && tokenSecretValue instanceof NullNode == false) {
                            String tokenSecretInstance;
                            tokenSecretInstance = tokenSecretValue.getTextValue();
                            propertiesInstance.setTokenSecret(tokenSecretInstance);
                        }
                    }
                    
                    JsonNode idValue = sourceControlValue.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        sourceControlInstance2.setId(idInstance);
                    }
                    
                    JsonNode nameValue = sourceControlValue.get("name");
                    if (nameValue != null && nameValue instanceof NullNode == false) {
                        String nameInstance;
                        nameInstance = nameValue.getTextValue();
                        sourceControlInstance2.setName(nameInstance);
                    }
                    
                    JsonNode locationValue = sourceControlValue.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        sourceControlInstance2.setLocation(locationInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) sourceControlValue.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry<String, JsonNode> property = itr.next();
                            String tagsKey = property.getKey();
                            String tagsValue = property.getValue().getTextValue();
                            sourceControlInstance2.getTags().put(tagsKey, tagsValue);
                        }
                    }
                    
                    JsonNode typeValue = sourceControlValue.get("type");
                    if (typeValue != null && typeValue instanceof NullNode == false) {
                        String typeInstance;
                        typeInstance = typeValue.getTextValue();
                        sourceControlInstance2.setType(typeInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}
