/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.websites;

import com.microsoft.azure.management.websites.models.HistoricalUsageMetric;
import com.microsoft.azure.management.websites.models.HistoricalUsageMetricData;
import com.microsoft.azure.management.websites.models.HistoricalUsageMetricSample;
import com.microsoft.azure.management.websites.models.SkuOptions;
import com.microsoft.azure.management.websites.models.WebHostingPlan;
import com.microsoft.azure.management.websites.models.WebHostingPlanCreateOrUpdateParameters;
import com.microsoft.azure.management.websites.models.WebHostingPlanCreateOrUpdateResponse;
import com.microsoft.azure.management.websites.models.WebHostingPlanGetHistoricalUsageMetricsParameters;
import com.microsoft.azure.management.websites.models.WebHostingPlanGetHistoricalUsageMetricsResponse;
import com.microsoft.azure.management.websites.models.WebHostingPlanGetResponse;
import com.microsoft.azure.management.websites.models.WebHostingPlanListResponse;
import com.microsoft.azure.management.websites.models.WebHostingPlanProperties;
import com.microsoft.azure.management.websites.models.WorkerSizeOptions;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.CloudTracing;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.ObjectNode;

import javax.xml.bind.DatatypeConverter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

/**
* Operations for managing the Web Hosting Plans in a resource group. Web
* hosting plans (WHPs) represent a set of features and capacity that you can
* share across your web sites. Web hosting plans support the 4 Azure Web Sites
* pricing tiers (Free, Shared, Basic, and Standard) where each tier has its
* own capabilities and capacity. Sites in the same subscription, resource
* group, and geographic location can share a web hosting plan. All the sites
* sharing a web hosting plan can leverage all the capabilities and features
* defined by the web hosting plan tier. All web sites associated with a given
* web hosting plan run on the resources defined by the web hosting plan.  (see
* http://azure.microsoft.com/en-us/documentation/articles/azure-web-sites-web-hosting-plans-in-depth-overview/
* for more information)
*/
public class WebHostingPlanOperationsImpl implements ServiceOperations<WebSiteManagementClientImpl>, WebHostingPlanOperations {
    /**
    * Initializes a new instance of the WebHostingPlanOperationsImpl class.
    *
    * @param client Reference to the service client.
    */
    WebHostingPlanOperationsImpl(WebSiteManagementClientImpl client) {
        this.client = client;
    }
    
    private WebSiteManagementClientImpl client;
    
    /**
    * Gets a reference to the
    * microsoft.azure.management.websites.WebSiteManagementClientImpl.
    * @return The Client value.
    */
    public WebSiteManagementClientImpl getClient() {
        return this.client;
    }
    
    /**
    * Creates a new Web Hosting Plan or updates an existing one.  (see
    * http://azure.microsoft.com/en-us/documentation/articles/azure-web-sites-web-hosting-plans-in-depth-overview/
    * for more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param parameters Required. Parameters supplied to the Create Server Farm
    * operation.
    * @return The Create Web Hosting Plan operation response.
    */
    @Override
    public Future<WebHostingPlanCreateOrUpdateResponse> createOrUpdateAsync(final String resourceGroupName, final WebHostingPlanCreateOrUpdateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<WebHostingPlanCreateOrUpdateResponse>() { 
            @Override
            public WebHostingPlanCreateOrUpdateResponse call() throws Exception {
                return createOrUpdate(resourceGroupName, parameters);
            }
         });
    }
    
    /**
    * Creates a new Web Hosting Plan or updates an existing one.  (see
    * http://azure.microsoft.com/en-us/documentation/articles/azure-web-sites-web-hosting-plans-in-depth-overview/
    * for more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param parameters Required. Parameters supplied to the Create Server Farm
    * operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The Create Web Hosting Plan operation response.
    */
    @Override
    public WebHostingPlanCreateOrUpdateResponse createOrUpdate(String resourceGroupName, WebHostingPlanCreateOrUpdateParameters parameters) throws IOException, ServiceException, URISyntaxException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getWebHostingPlan() == null) {
            throw new NullPointerException("parameters.WebHostingPlan");
        }
        if (parameters.getWebHostingPlan().getLocation() == null) {
            throw new NullPointerException("parameters.WebHostingPlan.Location");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "createOrUpdateAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Web";
        url = url + "/serverFarms/";
        if (parameters.getWebHostingPlan().getName() != null) {
            url = url + URLEncoder.encode(parameters.getWebHostingPlan().getName(), "UTF-8");
        }
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-06-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Serialize Request
        String requestContent = null;
        JsonNode requestDoc = null;
        
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode webHostingPlanCreateOrUpdateParametersValue = objectMapper.createObjectNode();
        requestDoc = webHostingPlanCreateOrUpdateParametersValue;
        
        if (parameters.getWebHostingPlan().getProperties() != null) {
            ObjectNode propertiesValue = objectMapper.createObjectNode();
            ((ObjectNode) webHostingPlanCreateOrUpdateParametersValue).put("properties", propertiesValue);
            
            if (parameters.getWebHostingPlan().getProperties().getSku() != null) {
                ((ObjectNode) propertiesValue).put("sku", parameters.getWebHostingPlan().getProperties().getSku().toString());
            }
            
            ((ObjectNode) propertiesValue).put("numberOfWorkers", parameters.getWebHostingPlan().getProperties().getNumberOfWorkers());
            
            if (parameters.getWebHostingPlan().getProperties().getWorkerSize() != null) {
                ((ObjectNode) propertiesValue).put("workerSize", parameters.getWebHostingPlan().getProperties().getWorkerSize().toString());
            }
            
            if (parameters.getWebHostingPlan().getProperties().getAdminSiteName() != null) {
                ((ObjectNode) propertiesValue).put("adminSiteName", parameters.getWebHostingPlan().getProperties().getAdminSiteName());
            }
        }
        
        if (parameters.getWebHostingPlan().getId() != null) {
            ((ObjectNode) webHostingPlanCreateOrUpdateParametersValue).put("id", parameters.getWebHostingPlan().getId());
        }
        
        if (parameters.getWebHostingPlan().getName() != null) {
            ((ObjectNode) webHostingPlanCreateOrUpdateParametersValue).put("name", parameters.getWebHostingPlan().getName());
        }
        
        ((ObjectNode) webHostingPlanCreateOrUpdateParametersValue).put("location", parameters.getWebHostingPlan().getLocation());
        
        if (parameters.getWebHostingPlan().getTags() != null) {
            ObjectNode tagsDictionary = objectMapper.createObjectNode();
            for (Map.Entry<String, String> entry : parameters.getWebHostingPlan().getTags().entrySet()) {
                String tagsKey = entry.getKey();
                String tagsValue = entry.getValue();
                ((ObjectNode) tagsDictionary).put(tagsKey, tagsValue);
            }
            ((ObjectNode) webHostingPlanCreateOrUpdateParametersValue).put("tags", tagsDictionary);
        }
        
        if (parameters.getWebHostingPlan().getType() != null) {
            ((ObjectNode) webHostingPlanCreateOrUpdateParametersValue).put("type", parameters.getWebHostingPlan().getType());
        }
        
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue(stringWriter, requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            WebHostingPlanCreateOrUpdateResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new WebHostingPlanCreateOrUpdateResponse();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                JsonNode serverFarmValue = responseDoc.get("ServerFarm");
                if (serverFarmValue != null && serverFarmValue instanceof NullNode == false) {
                    WebHostingPlanCreateOrUpdateResponse serverFarmInstance = new WebHostingPlanCreateOrUpdateResponse();
                    
                    WebHostingPlan webHostingPlanInstance = new WebHostingPlan();
                    result.setWebHostingPlan(webHostingPlanInstance);
                    
                    JsonNode propertiesValue2 = serverFarmValue.get("properties");
                    if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                        WebHostingPlanProperties propertiesInstance = new WebHostingPlanProperties();
                        webHostingPlanInstance.setProperties(propertiesInstance);
                        
                        JsonNode skuValue = propertiesValue2.get("sku");
                        if (skuValue != null && skuValue instanceof NullNode == false) {
                            SkuOptions skuInstance;
                            skuInstance = Enum.valueOf(SkuOptions.class, skuValue.getTextValue());
                            propertiesInstance.setSku(skuInstance);
                        }
                        
                        JsonNode numberOfWorkersValue = propertiesValue2.get("numberOfWorkers");
                        if (numberOfWorkersValue != null && numberOfWorkersValue instanceof NullNode == false) {
                            int numberOfWorkersInstance;
                            numberOfWorkersInstance = numberOfWorkersValue.getIntValue();
                            propertiesInstance.setNumberOfWorkers(numberOfWorkersInstance);
                        }
                        
                        JsonNode workerSizeValue = propertiesValue2.get("workerSize");
                        if (workerSizeValue != null && workerSizeValue instanceof NullNode == false) {
                            WorkerSizeOptions workerSizeInstance;
                            workerSizeInstance = Enum.valueOf(WorkerSizeOptions.class, workerSizeValue.getTextValue());
                            propertiesInstance.setWorkerSize(workerSizeInstance);
                        }
                        
                        JsonNode adminSiteNameValue = propertiesValue2.get("adminSiteName");
                        if (adminSiteNameValue != null && adminSiteNameValue instanceof NullNode == false) {
                            String adminSiteNameInstance;
                            adminSiteNameInstance = adminSiteNameValue.getTextValue();
                            propertiesInstance.setAdminSiteName(adminSiteNameInstance);
                        }
                    }
                    
                    JsonNode idValue = serverFarmValue.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        webHostingPlanInstance.setId(idInstance);
                    }
                    
                    JsonNode nameValue = serverFarmValue.get("name");
                    if (nameValue != null && nameValue instanceof NullNode == false) {
                        String nameInstance;
                        nameInstance = nameValue.getTextValue();
                        webHostingPlanInstance.setName(nameInstance);
                    }
                    
                    JsonNode locationValue = serverFarmValue.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        webHostingPlanInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) serverFarmValue.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry<String, JsonNode> property = itr.next();
                            String tagsKey2 = property.getKey();
                            String tagsValue2 = property.getValue().getTextValue();
                            webHostingPlanInstance.getTags().put(tagsKey2, tagsValue2);
                        }
                    }
                    
                    JsonNode typeValue = serverFarmValue.get("type");
                    if (typeValue != null && typeValue instanceof NullNode == false) {
                        String typeInstance;
                        typeInstance = typeValue.getTextValue();
                        webHostingPlanInstance.setType(typeInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Deletes a Web Hosting Plan  (see
    * http://azure.microsoft.com/en-us/documentation/articles/azure-web-sites-web-hosting-plans-in-depth-overview/
    * for more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webHostingPlanName Required. The name of the Web Hosting Plan to
    * delete.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> deleteAsync(final String resourceGroupName, final String webHostingPlanName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return delete(resourceGroupName, webHostingPlanName);
            }
         });
    }
    
    /**
    * Deletes a Web Hosting Plan  (see
    * http://azure.microsoft.com/en-us/documentation/articles/azure-web-sites-web-hosting-plans-in-depth-overview/
    * for more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webHostingPlanName Required. The name of the Web Hosting Plan to
    * delete.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse delete(String resourceGroupName, String webHostingPlanName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (webHostingPlanName == null) {
            throw new NullPointerException("webHostingPlanName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("webHostingPlanName", webHostingPlanName);
            CloudTracing.enter(invocationId, this, "deleteAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Web";
        url = url + "/serverFarms/";
        url = url + URLEncoder.encode(webHostingPlanName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-06-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            // Deserialize Response
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Gets details of an existing Web Hosting Plan  (see
    * http://azure.microsoft.com/en-us/documentation/articles/azure-web-sites-web-hosting-plans-in-depth-overview/
    * for more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webHostingPlanName Required. The name of the Web Hosting Plan.
    * @return The Get Web Hosting Plan operation response.
    */
    @Override
    public Future<WebHostingPlanGetResponse> getAsync(final String resourceGroupName, final String webHostingPlanName) {
        return this.getClient().getExecutorService().submit(new Callable<WebHostingPlanGetResponse>() { 
            @Override
            public WebHostingPlanGetResponse call() throws Exception {
                return get(resourceGroupName, webHostingPlanName);
            }
         });
    }
    
    /**
    * Gets details of an existing Web Hosting Plan  (see
    * http://azure.microsoft.com/en-us/documentation/articles/azure-web-sites-web-hosting-plans-in-depth-overview/
    * for more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webHostingPlanName Required. The name of the Web Hosting Plan.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The Get Web Hosting Plan operation response.
    */
    @Override
    public WebHostingPlanGetResponse get(String resourceGroupName, String webHostingPlanName) throws IOException, ServiceException, URISyntaxException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (webHostingPlanName == null) {
            throw new NullPointerException("webHostingPlanName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("webHostingPlanName", webHostingPlanName);
            CloudTracing.enter(invocationId, this, "getAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Web";
        url = url + "/serverFarms/";
        url = url + URLEncoder.encode(webHostingPlanName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-06-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            WebHostingPlanGetResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new WebHostingPlanGetResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    WebHostingPlan webHostingPlanInstance = new WebHostingPlan();
                    result.setWebHostingPlan(webHostingPlanInstance);
                    
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                        WebHostingPlanProperties propertiesInstance = new WebHostingPlanProperties();
                        webHostingPlanInstance.setProperties(propertiesInstance);
                        
                        JsonNode skuValue = propertiesValue.get("sku");
                        if (skuValue != null && skuValue instanceof NullNode == false) {
                            SkuOptions skuInstance;
                            skuInstance = Enum.valueOf(SkuOptions.class, skuValue.getTextValue());
                            propertiesInstance.setSku(skuInstance);
                        }
                        
                        JsonNode numberOfWorkersValue = propertiesValue.get("numberOfWorkers");
                        if (numberOfWorkersValue != null && numberOfWorkersValue instanceof NullNode == false) {
                            int numberOfWorkersInstance;
                            numberOfWorkersInstance = numberOfWorkersValue.getIntValue();
                            propertiesInstance.setNumberOfWorkers(numberOfWorkersInstance);
                        }
                        
                        JsonNode workerSizeValue = propertiesValue.get("workerSize");
                        if (workerSizeValue != null && workerSizeValue instanceof NullNode == false) {
                            WorkerSizeOptions workerSizeInstance;
                            workerSizeInstance = Enum.valueOf(WorkerSizeOptions.class, workerSizeValue.getTextValue());
                            propertiesInstance.setWorkerSize(workerSizeInstance);
                        }
                        
                        JsonNode adminSiteNameValue = propertiesValue.get("adminSiteName");
                        if (adminSiteNameValue != null && adminSiteNameValue instanceof NullNode == false) {
                            String adminSiteNameInstance;
                            adminSiteNameInstance = adminSiteNameValue.getTextValue();
                            propertiesInstance.setAdminSiteName(adminSiteNameInstance);
                        }
                    }
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        webHostingPlanInstance.setId(idInstance);
                    }
                    
                    JsonNode nameValue = responseDoc.get("name");
                    if (nameValue != null && nameValue instanceof NullNode == false) {
                        String nameInstance;
                        nameInstance = nameValue.getTextValue();
                        webHostingPlanInstance.setName(nameInstance);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        webHostingPlanInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry<String, JsonNode> property = itr.next();
                            String tagsKey = property.getKey();
                            String tagsValue = property.getValue().getTextValue();
                            webHostingPlanInstance.getTags().put(tagsKey, tagsValue);
                        }
                    }
                    
                    JsonNode typeValue = responseDoc.get("type");
                    if (typeValue != null && typeValue instanceof NullNode == false) {
                        String typeInstance;
                        typeInstance = typeValue.getTextValue();
                        webHostingPlanInstance.setType(typeInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * You can retrieve historical usage metrics for a site by issuing an HTTP
    * GET request.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166964.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webHostingPlanName Required. The name of the web hosting plan.
    * @param parameters Required. Parameters supplied to the Get Historical
    * Usage Metrics Web hosting plan operation.
    * @return The Get Historical Usage Metrics Web hosting plan operation
    * response.
    */
    @Override
    public Future<WebHostingPlanGetHistoricalUsageMetricsResponse> getHistoricalUsageMetricsAsync(final String resourceGroupName, final String webHostingPlanName, final WebHostingPlanGetHistoricalUsageMetricsParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<WebHostingPlanGetHistoricalUsageMetricsResponse>() { 
            @Override
            public WebHostingPlanGetHistoricalUsageMetricsResponse call() throws Exception {
                return getHistoricalUsageMetrics(resourceGroupName, webHostingPlanName, parameters);
            }
         });
    }
    
    /**
    * You can retrieve historical usage metrics for a site by issuing an HTTP
    * GET request.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166964.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webHostingPlanName Required. The name of the web hosting plan.
    * @param parameters Required. Parameters supplied to the Get Historical
    * Usage Metrics Web hosting plan operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The Get Historical Usage Metrics Web hosting plan operation
    * response.
    */
    @Override
    public WebHostingPlanGetHistoricalUsageMetricsResponse getHistoricalUsageMetrics(String resourceGroupName, String webHostingPlanName, WebHostingPlanGetHistoricalUsageMetricsParameters parameters) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (webHostingPlanName == null) {
            throw new NullPointerException("webHostingPlanName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("webHostingPlanName", webHostingPlanName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "getHistoricalUsageMetricsAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Web";
        url = url + "/serverFarms/";
        url = url + URLEncoder.encode(webHostingPlanName, "UTF-8");
        url = url + "/metrics";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-06-01");
        if (parameters.getMetricNames() != null && parameters.getMetricNames().size() > 0) {
            queryParameters.add("names=" + URLEncoder.encode(CollectionStringBuilder.join(parameters.getMetricNames(), ","), "UTF-8"));
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        if (parameters.getStartTime() != null) {
            queryParameters.add("StartTime=" + URLEncoder.encode(simpleDateFormat.format(parameters.getStartTime().getTime()), "UTF-8"));
        }
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
        simpleDateFormat2.setTimeZone(TimeZone.getTimeZone("UTC"));
        if (parameters.getEndTime() != null) {
            queryParameters.add("EndTime=" + URLEncoder.encode(simpleDateFormat2.format(parameters.getEndTime().getTime()), "UTF-8"));
        }
        if (parameters.getTimeGrain() != null) {
            queryParameters.add("timeGrain=" + URLEncoder.encode(parameters.getTimeGrain(), "UTF-8"));
        }
        queryParameters.add("details=" + URLEncoder.encode(Boolean.toString(parameters.isIncludeInstanceBreakdown()).toLowerCase(), "UTF-8"));
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("x-ms-version", "2014-06-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            WebHostingPlanGetHistoricalUsageMetricsResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new WebHostingPlanGetHistoricalUsageMetricsResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode propertiesArray = responseDoc.get("properties");
                    if (propertiesArray != null && propertiesArray instanceof NullNode == false) {
                        for (JsonNode propertiesValue : ((ArrayNode) propertiesArray)) {
                            HistoricalUsageMetric historicalUsageMetricInstance = new HistoricalUsageMetric();
                            result.getUsageMetrics().add(historicalUsageMetricInstance);
                            
                            JsonNode codeValue = propertiesValue.get("code");
                            if (codeValue != null && codeValue instanceof NullNode == false) {
                                String codeInstance;
                                codeInstance = codeValue.getTextValue();
                                historicalUsageMetricInstance.setCode(codeInstance);
                            }
                            
                            JsonNode dataValue = propertiesValue.get("data");
                            if (dataValue != null && dataValue instanceof NullNode == false) {
                                HistoricalUsageMetricData dataInstance = new HistoricalUsageMetricData();
                                historicalUsageMetricInstance.setData(dataInstance);
                                
                                JsonNode displayNameValue = dataValue.get("displayName");
                                if (displayNameValue != null && displayNameValue instanceof NullNode == false) {
                                    String displayNameInstance;
                                    displayNameInstance = displayNameValue.getTextValue();
                                    dataInstance.setDisplayName(displayNameInstance);
                                }
                                
                                JsonNode endTimeValue = dataValue.get("EndTime");
                                if (endTimeValue != null && endTimeValue instanceof NullNode == false) {
                                    Calendar endTimeInstance;
                                    endTimeInstance = DatatypeConverter.parseDateTime(endTimeValue.getTextValue());
                                    dataInstance.setEndTime(endTimeInstance);
                                }
                                
                                JsonNode nameValue = dataValue.get("name");
                                if (nameValue != null && nameValue instanceof NullNode == false) {
                                    String nameInstance;
                                    nameInstance = nameValue.getTextValue();
                                    dataInstance.setName(nameInstance);
                                }
                                
                                JsonNode primaryAggregationTypeValue = dataValue.get("primaryAggregationType");
                                if (primaryAggregationTypeValue != null && primaryAggregationTypeValue instanceof NullNode == false) {
                                    String primaryAggregationTypeInstance;
                                    primaryAggregationTypeInstance = primaryAggregationTypeValue.getTextValue();
                                    dataInstance.setPrimaryAggregationType(primaryAggregationTypeInstance);
                                }
                                
                                JsonNode startTimeValue = dataValue.get("startTime");
                                if (startTimeValue != null && startTimeValue instanceof NullNode == false) {
                                    Calendar startTimeInstance;
                                    startTimeInstance = DatatypeConverter.parseDateTime(startTimeValue.getTextValue());
                                    dataInstance.setStartTime(startTimeInstance);
                                }
                                
                                JsonNode timeGrainValue = dataValue.get("timeGrain");
                                if (timeGrainValue != null && timeGrainValue instanceof NullNode == false) {
                                    String timeGrainInstance;
                                    timeGrainInstance = timeGrainValue.getTextValue();
                                    dataInstance.setTimeGrain(timeGrainInstance);
                                }
                                
                                JsonNode unitValue = dataValue.get("unit");
                                if (unitValue != null && unitValue instanceof NullNode == false) {
                                    String unitInstance;
                                    unitInstance = unitValue.getTextValue();
                                    dataInstance.setUnit(unitInstance);
                                }
                                
                                JsonNode valuesArray = dataValue.get("values");
                                if (valuesArray != null && valuesArray instanceof NullNode == false) {
                                    for (JsonNode valuesValue : ((ArrayNode) valuesArray)) {
                                        HistoricalUsageMetricSample metricSampleInstance = new HistoricalUsageMetricSample();
                                        dataInstance.getValues().add(metricSampleInstance);
                                        
                                        JsonNode countValue = valuesValue.get("count");
                                        if (countValue != null && countValue instanceof NullNode == false) {
                                            int countInstance;
                                            countInstance = countValue.getIntValue();
                                            metricSampleInstance.setCount(countInstance);
                                        }
                                        
                                        JsonNode maximumValue = valuesValue.get("maximum");
                                        if (maximumValue != null && maximumValue instanceof NullNode == false) {
                                            String maximumInstance;
                                            maximumInstance = maximumValue.getTextValue();
                                            metricSampleInstance.setMaximum(maximumInstance);
                                        }
                                        
                                        JsonNode minimumValue = valuesValue.get("minimum");
                                        if (minimumValue != null && minimumValue instanceof NullNode == false) {
                                            String minimumInstance;
                                            minimumInstance = minimumValue.getTextValue();
                                            metricSampleInstance.setMinimum(minimumInstance);
                                        }
                                        
                                        JsonNode timeCreatedValue = valuesValue.get("timeCreated");
                                        if (timeCreatedValue != null && timeCreatedValue instanceof NullNode == false) {
                                            Calendar timeCreatedInstance;
                                            timeCreatedInstance = DatatypeConverter.parseDateTime(timeCreatedValue.getTextValue());
                                            metricSampleInstance.setTimeCreated(timeCreatedInstance);
                                        }
                                        
                                        JsonNode totalValue = valuesValue.get("total");
                                        if (totalValue != null && totalValue instanceof NullNode == false) {
                                            String totalInstance;
                                            totalInstance = totalValue.getTextValue();
                                            metricSampleInstance.setTotal(totalInstance);
                                        }
                                        
                                        JsonNode instanceNameValue = valuesValue.get("instanceName");
                                        if (instanceNameValue != null && instanceNameValue instanceof NullNode == false) {
                                            String instanceNameInstance;
                                            instanceNameInstance = instanceNameValue.getTextValue();
                                            metricSampleInstance.setInstanceName(instanceNameInstance);
                                        }
                                    }
                                }
                            }
                            
                            JsonNode messageValue = propertiesValue.get("message");
                            if (messageValue != null && messageValue instanceof NullNode == false) {
                                String messageInstance;
                                messageInstance = messageValue.getTextValue();
                                historicalUsageMetricInstance.setMessage(messageInstance);
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Gets all Web Hosting Plans in a current subscription and Resource Group.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/dn194277.aspx
    * for more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @return The List Web Hosting Plans operation response.
    */
    @Override
    public Future<WebHostingPlanListResponse> listAsync(final String resourceGroupName) {
        return this.getClient().getExecutorService().submit(new Callable<WebHostingPlanListResponse>() { 
            @Override
            public WebHostingPlanListResponse call() throws Exception {
                return list(resourceGroupName);
            }
         });
    }
    
    /**
    * Gets all Web Hosting Plans in a current subscription and Resource Group.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/dn194277.aspx
    * for more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The List Web Hosting Plans operation response.
    */
    @Override
    public WebHostingPlanListResponse list(String resourceGroupName) throws IOException, ServiceException, URISyntaxException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            CloudTracing.enter(invocationId, this, "listAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Web";
        url = url + "/serverFarms";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-06-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            WebHostingPlanListResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new WebHostingPlanListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && valueArray instanceof NullNode == false) {
                        for (JsonNode valueValue : ((ArrayNode) valueArray)) {
                            WebHostingPlan webHostingPlanInstance = new WebHostingPlan();
                            result.getWebHostingPlans().add(webHostingPlanInstance);
                            
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                                WebHostingPlanProperties propertiesInstance = new WebHostingPlanProperties();
                                webHostingPlanInstance.setProperties(propertiesInstance);
                                
                                JsonNode skuValue = propertiesValue.get("sku");
                                if (skuValue != null && skuValue instanceof NullNode == false) {
                                    SkuOptions skuInstance;
                                    skuInstance = Enum.valueOf(SkuOptions.class, skuValue.getTextValue());
                                    propertiesInstance.setSku(skuInstance);
                                }
                                
                                JsonNode numberOfWorkersValue = propertiesValue.get("numberOfWorkers");
                                if (numberOfWorkersValue != null && numberOfWorkersValue instanceof NullNode == false) {
                                    int numberOfWorkersInstance;
                                    numberOfWorkersInstance = numberOfWorkersValue.getIntValue();
                                    propertiesInstance.setNumberOfWorkers(numberOfWorkersInstance);
                                }
                                
                                JsonNode workerSizeValue = propertiesValue.get("workerSize");
                                if (workerSizeValue != null && workerSizeValue instanceof NullNode == false) {
                                    WorkerSizeOptions workerSizeInstance;
                                    workerSizeInstance = Enum.valueOf(WorkerSizeOptions.class, workerSizeValue.getTextValue());
                                    propertiesInstance.setWorkerSize(workerSizeInstance);
                                }
                                
                                JsonNode adminSiteNameValue = propertiesValue.get("adminSiteName");
                                if (adminSiteNameValue != null && adminSiteNameValue instanceof NullNode == false) {
                                    String adminSiteNameInstance;
                                    adminSiteNameInstance = adminSiteNameValue.getTextValue();
                                    propertiesInstance.setAdminSiteName(adminSiteNameInstance);
                                }
                            }
                            
                            JsonNode idValue = valueValue.get("id");
                            if (idValue != null && idValue instanceof NullNode == false) {
                                String idInstance;
                                idInstance = idValue.getTextValue();
                                webHostingPlanInstance.setId(idInstance);
                            }
                            
                            JsonNode nameValue = valueValue.get("name");
                            if (nameValue != null && nameValue instanceof NullNode == false) {
                                String nameInstance;
                                nameInstance = nameValue.getTextValue();
                                webHostingPlanInstance.setName(nameInstance);
                            }
                            
                            JsonNode locationValue = valueValue.get("location");
                            if (locationValue != null && locationValue instanceof NullNode == false) {
                                String locationInstance;
                                locationInstance = locationValue.getTextValue();
                                webHostingPlanInstance.setLocation(locationInstance);
                            }
                            
                            JsonNode tagsSequenceElement = ((JsonNode) valueValue.get("tags"));
                            if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                                while (itr.hasNext()) {
                                    Map.Entry<String, JsonNode> property = itr.next();
                                    String tagsKey = property.getKey();
                                    String tagsValue = property.getValue().getTextValue();
                                    webHostingPlanInstance.getTags().put(tagsKey, tagsValue);
                                }
                            }
                            
                            JsonNode typeValue = valueValue.get("type");
                            if (typeValue != null && typeValue instanceof NullNode == false) {
                                String typeInstance;
                                typeInstance = typeValue.getTextValue();
                                webHostingPlanInstance.setType(typeInstance);
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}
