/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.websites;

/**
* In addition to standard HTTP status codes, the Windows Azure Web Sites
* Management REST API returns extended error codes and error messages. The
* extended codes do not replace the standard HTTP status codes, but provide
* additional, actionable information that can be used in conjunction with the
* standard HTTP status codes. For example, an HTTP 404 error can occur for
* numerous reasons, so having the additional information in the extended
* message can assist with problem resolution. (For more information on the
* standard HTTP codes returned by the REST API, see Service Management Status
* and Error Codes.)  (see
* http://msdn.microsoft.com/en-us/library/windowsazure/dn166968.aspx for more
* information)
*/
public abstract class WebSiteExtendedErrorCodes {
    /**
    * Access is denied.
    */
    public static final String ACCESSDENIED = "01001";
    
    /**
    * Command resource object is not present in the request body.
    */
    public static final String COMMANDRESOURCENOTPRESENT = "01002";
    
    /**
    * Invalid name {0}.
    */
    public static final String INVALIDNAME = "01003";
    
    /**
    * Cannot understand command verb {0}.
    */
    public static final String UNKNOWNCOMMANDVERB = "01004";
    
    /**
    * The service is currently in read only mode.
    */
    public static final String ISINREADONLYMODE = "01005";
    
    /**
    * The {0} parameter is not specified.
    */
    public static final String PARAMETERISNOTSPECIFIED = "01006";
    
    /**
    * Parameter {0} has invalid value.
    */
    public static final String INVALIDPARAMETERVALUE = "01007";
    
    /**
    * {0} object is not present in the request body.
    */
    public static final String INVALIDREQUEST = "01008";
    
    /**
    * The from value in the query string is bigger than or equal to the to
    * value.
    */
    public static final String INCORRECTDATETIMERANGE = "01009";
    
    /**
    * Required parameter {0} is missing.
    */
    public static final String REQUIREDPARAMETERMISSING = "01010";
    
    /**
    * Name of the web quota cannot change.
    */
    public static final String RESOURCENAMECANNOTCHANGE = "01011";
    
    /**
    * The value of the query string parameter cannot be converted to Boolean.
    */
    public static final String FAILEDTOCONVERTPARAMETERVALUE = "01012";
    
    /**
    * Parameter with name {0} already exists in the request.
    */
    public static final String PARAMETERNAMEALREADYEXISTS = "01013";
    
    /**
    * Parameter name cannot be empty.
    */
    public static final String PARAMETERNAMEISEMPTY = "01014";
    
    /**
    * Not ready.
    */
    public static final String NOTREADY = "01015";
    
    /**
    * Ready.
    */
    public static final String READY = "01016";
    
    /**
    * Update is not allowed for the {0} field.
    */
    public static final String UPDATEFORFIELDNOTALLOWED = "01017";
    
    /**
    * Web Service does not support Command {0}. Only supported command(s) is
    * {1}.
    */
    public static final String NOTSUPPORTEDCOMMAND = "01018";
    
    /**
    * Invalid data ({0}).
    */
    public static final String INVALIDDATA = "01019";
    
    /**
    * There was a conflict. {0}
    */
    public static final String GENERICCONFLICT = "01020";
    
    /**
    * Internal server error occurred. {0}
    */
    public static final String INTERNALSERVERERROR = "01021";
    
    /**
    * Number of sites exceeds the maximum allowed.
    */
    public static final String NUMBEROFSITESLIMIT = "03001";
    
    /**
    * NumberOfWorkers exceeds the maximum allowed.
    */
    public static final String NUMBEROFWORKERSLIMIT = "03002";
    
    /**
    * There is not enough space on the disk.
    */
    public static final String NOSTORAGEVOLUMEAVAILABLE = "03003";
    
    /**
    * WebSpace with name {0} already exists for subscription {1}.
    */
    public static final String WEBSPACEALREADYEXISTS = "03004";
    
    /**
    * Cannot find webspace {0} for subscription {1}
    */
    public static final String WEBSPACENOTFOUND = "03005";
    
    /**
    * Web space contains resources.
    */
    public static final String WEBSPACECONTAINSRESOURCES = "03006";
    
    /**
    * The file storage capacity exceeds the limit.
    */
    public static final String FILESTORAGELIMIT = "03007";
    
    /**
    * Failed to delete web space {0}: {1}
    */
    public static final String WEBSPACEDELETEERROR = "03008";
    
    /**
    * Not enough available Standard Instance servers to satisfy this request.
    */
    public static final String NOWORKERSAVAILABLE = "03009";
    
    /**
    * Failed to create web space {0} on storage volume {1}: {2}
    */
    public static final String WEBSPACECREATEERROR = "03010";
    
    /**
    * Directory already exists for site {0}.
    */
    public static final String DIRECTORYALREADYEXISTS = "04001";
    
    /**
    * Failed to delete directory {0}.
    */
    public static final String DIRECTORYDELETEERROR = "04002";
    
    /**
    * Invalid host name {0}.
    */
    public static final String INVALIDHOSTNAME = "04003";
    
    /**
    * NumberOfWorkers value must be more than zero.
    */
    public static final String INVALIDNUMBEROFWORKERS = "04004";
    
    /**
    * Hostname '{0}' already exists.
    */
    public static final String HOSTNAMEALREADYEXISTS = "04005";
    
    /**
    * No CNAME pointing from {0} to a site in a default DNS zone (or too many).
    */
    public static final String INVALIDCUSTOMHOSTNAMEVALIDATION = "04006";
    
    /**
    * There are no hostnames which could be used for validation.
    */
    public static final String INVALIDCUSTOMHOSTNAMEVALIDATIONNOBASEHOSTNAME = "04007";
    
    /**
    * Site with name {0} already exists.
    */
    public static final String SITEALREADYEXISTS = "04008";
    
    /**
    * Cannot find site {0}.
    */
    public static final String SITENOTFOUND = "04009";
    
    /**
    * The external URL "{0}" specified on request header "{1}" is invalid.
    */
    public static final String INVALIDEXTERNALURIHEADER = "04010";
    
    /**
    * Failed to delete file {0}.
    */
    public static final String FILEDELETEERROR = "04011";
    
    /**
    * Number of workers for this site exceeds the maximum allowed.
    */
    public static final String NUMBEROFWORKERSPERSITELIMIT = "04012";
    
    /**
    * WebSiteManager.CreateWebSite: Creating Site using storageVolume {0}.
    */
    public static final String TRACEWEBSITESTORAGEVOLUME = "04013";
    
    /**
    * Cannot delete repository with name {0}.
    */
    public static final String REPOSITORYDELETEERROR = "05001";
    
    /**
    * Development site already exists in the repository for site {0}.
    */
    public static final String REPOSITORYDEVSITEALREADYEXISTS = "05002";
    
    /**
    * Development site does not exist in the repository for site {0}.
    */
    public static final String REPOSITORYDEVSITENOTEXIST = "05003";
    
    /**
    * Site {0} already has repository created for it.
    */
    public static final String REPOSITORYSITEALREADYEXISTS = "05004";
    
    /**
    * Repository does not exist for site {0}.
    */
    public static final String REPOSITORYSITENOTEXIST = "05005";
    
    /**
    * Failed to create a development site.
    */
    public static final String TRACEFAILEDTOCREATEDEVSITE = "05006";
    
    /**
    * User {0} has been rejected.
    */
    public static final String AUTHENTICATEDFAILED = "06001";
    
    /**
    * User {0} has been successfully authenticated.
    */
    public static final String AUTHENTICATEDPASSED = "06002";
    
    /**
    * User {0} has been rejected.
    */
    public static final String AUTHORIZATIONFAILED = "06003";
    
    /**
    * User {0} has been authorized.
    */
    public static final String AUTHORIZATIONPASSED = "06004";
    
    /**
    * Publishing credentials have to be trimmed from white characters.
    */
    public static final String PUBLISHINGCREDENTIALSNOTTRIMMED = "06005";
    
    /**
    * Publishing password cannot be empty.
    */
    public static final String PUBLISHINGPASSWORDISEMPTY = "06006";
    
    /**
    * Publishing password must be specified.
    */
    public static final String PUBLISHINGPASSWORDNOTSPECIFIED = "06007";
    
    /**
    * Publishing username {0} is already used. Specify a different publishing
    * username.
    */
    public static final String PUBLISHINGUSERNAMEALREADYEXISTS = "06008";
    
    /**
    * Publishing user name cannot be empty.
    */
    public static final String PUBLISHINGUSERNAMEISEMPTY = "06009";
    
    /**
    * An error occurred when adding the {0} entry: {1}
    */
    public static final String ERRORADDING = "51001";
    
    /**
    * An error occurred when deleting the {0} entry: {1}
    */
    public static final String ERRORDELETING = "51002";
    
    /**
    * An error occurred when updating the {0} entry: {1}
    */
    public static final String ERRORUPDATING = "51003";
    
    /**
    * Cannot find {0} with name {1}.
    */
    public static final String CANNOTFINDENTITY = "51004";
    
    /**
    * Subscription with specified name already exists.
    */
    public static final String SUBSCRIPTIONCONFLICT = "52001";
    
    /**
    * Subscripton Name cannot be null or empty.
    */
    public static final String SUBSCRIPTIONNONEMPTY = "52002";
    
    /**
    * Subscription {0} not found.
    */
    public static final String SUBSCRIPTIONNOTFOUND = "52003";
    
    /**
    * Subscription {0} is Suspended.
    */
    public static final String SUBSCRIPTIONSUSPENDED = "52004";
    
    /**
    * Subscription contains WebSpaces.
    */
    public static final String NONEMPTYSUBSCRIPTION = "52005";
    
    /**
    * WebSpace with specified name already exists.
    */
    public static final String WEBSPACECONFLICT = "53001";
    
    /**
    * WebSpace Name cannot be null or empty.
    */
    public static final String WEBSPACENONEMPTY = "53002";
    
    /**
    * WebSpace contains web sites.
    */
    public static final String NONEMPTYWEBSPACE = "53003";
    
    /**
    * An Error occurred when picking Stamp for WebSpace {0}.
    */
    public static final String ERRORPICKINGSTAMP = "53004";
    
    /**
    * Web site with given name {0} already exists in the specified Subscription
    * and Webspace.
    */
    public static final String WEBSITECONFLICT = "54001";
    
    /**
    * WebSiteName cannot be null or empty.
    */
    public static final String WEBSITENONEMPTY = "54002";
    
    /**
    * Specified Host Name {0} is already taken by another site.
    */
    public static final String HOSTNAMECONFLICT = "54003";
}
