/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.websites;

import com.microsoft.azure.management.websites.models.BackupRequestEnvelope;
import com.microsoft.azure.management.websites.models.RestoreRequestEnvelope;
import com.microsoft.azure.management.websites.models.SiteSourceControlUpdateParameters;
import com.microsoft.azure.management.websites.models.SiteSourceControlUpdateResponse;
import com.microsoft.azure.management.websites.models.SlotConfigNamesResult;
import com.microsoft.azure.management.websites.models.SlotConfigNamesUpdateParameters;
import com.microsoft.azure.management.websites.models.WebSiteAppSettingsResult;
import com.microsoft.azure.management.websites.models.WebSiteAsyncOperationResponse;
import com.microsoft.azure.management.websites.models.WebSiteBackupResponse;
import com.microsoft.azure.management.websites.models.WebSiteCloneParameters;
import com.microsoft.azure.management.websites.models.WebSiteConnectionStringsResult;
import com.microsoft.azure.management.websites.models.WebSiteCreateOrUpdateParameters;
import com.microsoft.azure.management.websites.models.WebSiteCreateResponse;
import com.microsoft.azure.management.websites.models.WebSiteDeleteParameters;
import com.microsoft.azure.management.websites.models.WebSiteDeleteRepositoryResponse;
import com.microsoft.azure.management.websites.models.WebSiteGetBackupConfigurationResponse;
import com.microsoft.azure.management.websites.models.WebSiteGetBackupsResponse;
import com.microsoft.azure.management.websites.models.WebSiteGetConfigurationParameters;
import com.microsoft.azure.management.websites.models.WebSiteGetConfigurationResult;
import com.microsoft.azure.management.websites.models.WebSiteGetHistoricalUsageMetricsParameters;
import com.microsoft.azure.management.websites.models.WebSiteGetHistoricalUsageMetricsResponse;
import com.microsoft.azure.management.websites.models.WebSiteGetParameters;
import com.microsoft.azure.management.websites.models.WebSiteGetPublishProfileResponse;
import com.microsoft.azure.management.websites.models.WebSiteGetRepositoryResponse;
import com.microsoft.azure.management.websites.models.WebSiteGetResponse;
import com.microsoft.azure.management.websites.models.WebSiteGetUsageMetricsResponse;
import com.microsoft.azure.management.websites.models.WebSiteListParameters;
import com.microsoft.azure.management.websites.models.WebSiteListResponse;
import com.microsoft.azure.management.websites.models.WebSiteMetadataResult;
import com.microsoft.azure.management.websites.models.WebSiteNameValueParameters;
import com.microsoft.azure.management.websites.models.WebSitePublishingCredentialsResult;
import com.microsoft.azure.management.websites.models.WebSiteRestoreDiscoverResponse;
import com.microsoft.azure.management.websites.models.WebSiteRestoreResponse;
import com.microsoft.azure.management.websites.models.WebSiteUpdateConfigurationParameters;
import com.microsoft.azure.management.websites.models.WebSiteUpdateConnectionStringsParameters;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.exception.ServiceException;
import org.xml.sax.SAXException;

import javax.xml.parsers.ParserConfigurationException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.concurrent.Future;

/**
* Operations for managing the web sites in a web space.
*/
public interface WebSiteOperations {
    /**
    * Backups a site on-demand.
    *
    * @param resourceGroupName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @param backupRequestEnvelope Required. A backup specification.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The backup record created based on the backup request.
    */
    WebSiteBackupResponse backup(String resourceGroupName, String webSiteName, String slotName, BackupRequestEnvelope backupRequestEnvelope) throws IOException, ServiceException;
    
    /**
    * Backups a site on-demand.
    *
    * @param resourceGroupName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @param backupRequestEnvelope Required. A backup specification.
    * @return The backup record created based on the backup request.
    */
    Future<WebSiteBackupResponse> backupAsync(String resourceGroupName, String webSiteName, String slotName, BackupRequestEnvelope backupRequestEnvelope);
    
    /**
    * You can clone a web site by using a PUT request that includes the name of
    * the web site and other information in the request body.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166986.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @param parameters Required. Parameters supplied to the clone Web Site
    * operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The website operation response.
    */
    WebSiteAsyncOperationResponse cloneMethod(String resourceGroupName, String webSiteName, String slotName, WebSiteCloneParameters parameters) throws IOException, ServiceException;
    
    /**
    * You can clone a web site by using a PUT request that includes the name of
    * the web site and other information in the request body.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166986.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @param parameters Required. Parameters supplied to the clone Web Site
    * operation.
    * @return The website operation response.
    */
    Future<WebSiteAsyncOperationResponse> cloneMethodAsync(String resourceGroupName, String webSiteName, String slotName, WebSiteCloneParameters parameters);
    
    /**
    * You can create a web site by using a POST request that includes the name
    * of the web site and other information in the request body.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166986.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @param parameters Required. Parameters supplied to the Create Web Site
    * operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The Create Web Space operation response.
    */
    WebSiteCreateResponse createOrUpdate(String resourceGroupName, String webSiteName, String slotName, WebSiteCreateOrUpdateParameters parameters) throws IOException, ServiceException, URISyntaxException;
    
    /**
    * You can create a web site by using a POST request that includes the name
    * of the web site and other information in the request body.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166986.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @param parameters Required. Parameters supplied to the Create Web Site
    * operation.
    * @return The Create Web Space operation response.
    */
    Future<WebSiteCreateResponse> createOrUpdateAsync(String resourceGroupName, String webSiteName, String slotName, WebSiteCreateOrUpdateParameters parameters);
    
    /**
    * A web site repository is essentially a GIT repository that you can use to
    * manage your web site content. By using GIT source control tools, you can
    * push or pull version controlled changes to your site. You can create a
    * repository for your web site by issuing an HTTP POST request, or
    * retrieve information about the repository by using HTTP GET.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166967.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse createRepository(String resourceGroupName, String webSiteName, String slotName) throws IOException, ServiceException;
    
    /**
    * A web site repository is essentially a GIT repository that you can use to
    * manage your web site content. By using GIT source control tools, you can
    * push or pull version controlled changes to your site. You can create a
    * repository for your web site by issuing an HTTP POST request, or
    * retrieve information about the repository by using HTTP GET.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166967.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> createRepositoryAsync(String resourceGroupName, String webSiteName, String slotName);
    
    /**
    * Deletes the web site.
    *
    * @param resourceGroupName Required. The name of the resource group..
    * @param webSiteName Required. The name of the Web Site resource.
    * @param slotName Optional. The name of the slot.
    * @param parameters Required. The parameters to delete a web site.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse delete(String resourceGroupName, String webSiteName, String slotName, WebSiteDeleteParameters parameters) throws IOException, ServiceException;
    
    /**
    * Deletes the web site.
    *
    * @param resourceGroupName Required. The name of the resource group..
    * @param webSiteName Required. The name of the Web Site resource.
    * @param slotName Optional. The name of the slot.
    * @param parameters Required. The parameters to delete a web site.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> deleteAsync(String resourceGroupName, String webSiteName, String slotName, WebSiteDeleteParameters parameters);
    
    /**
    * A web site repository is essentially a GIT repository that you can use to
    * manage your web site content. By using GIT source control tools, you can
    * push or pull version controlled changes to your site. You can create a
    * repository for your web site by issuing an HTTP POST request, or
    * retrieve information about the repository by using HTTP GET.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166967.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The Delete Web Site Repository operation response.
    */
    WebSiteDeleteRepositoryResponse deleteRepository(String resourceGroupName, String webSiteName, String slotName) throws IOException, ServiceException, URISyntaxException;
    
    /**
    * A web site repository is essentially a GIT repository that you can use to
    * manage your web site content. By using GIT source control tools, you can
    * push or pull version controlled changes to your site. You can create a
    * repository for your web site by issuing an HTTP POST request, or
    * retrieve information about the repository by using HTTP GET.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166967.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @return The Delete Web Site Repository operation response.
    */
    Future<WebSiteDeleteRepositoryResponse> deleteRepositoryAsync(String resourceGroupName, String webSiteName, String slotName);
    
    /**
    * Unlink source control from website
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @param repoUrl Required. The repository url.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse deleteSiteSourceControl(String resourceGroupName, String webSiteName, String slotName, String repoUrl) throws IOException, ServiceException;
    
    /**
    * Unlink source control from website
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @param repoUrl Required. The repository url.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> deleteSiteSourceControlAsync(String resourceGroupName, String webSiteName, String slotName, String repoUrl);
    
    /**
    * Scans a backup in a storage account and returns database information etc.
    * Should be called before calling Restore to discover what parameters are
    * needed for the restore operation. KNOWN BUG: This has to be called
    * against an exisingsite, otherwise will hit an error about non-existing
    * resource.
    *
    * @param resourceGroupName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @param restoreRequestEnvelope Required. A restore request.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The information gathered about a backup storaged in a storage
    * account.
    */
    WebSiteRestoreDiscoverResponse discover(String resourceGroupName, String webSiteName, String slotName, RestoreRequestEnvelope restoreRequestEnvelope) throws IOException, ServiceException;
    
    /**
    * Scans a backup in a storage account and returns database information etc.
    * Should be called before calling Restore to discover what parameters are
    * needed for the restore operation. KNOWN BUG: This has to be called
    * against an exisingsite, otherwise will hit an error about non-existing
    * resource.
    *
    * @param resourceGroupName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @param restoreRequestEnvelope Required. A restore request.
    * @return The information gathered about a backup storaged in a storage
    * account.
    */
    Future<WebSiteRestoreDiscoverResponse> discoverAsync(String resourceGroupName, String webSiteName, String slotName, RestoreRequestEnvelope restoreRequestEnvelope);
    
    /**
    * You can generate a new random password for publishing a site by issuing
    * an HTTP POST request.  Tip: If you want to verify that the publish
    * password has changed, call HTTP GET on /publishxml before calling
    * /newpassword. In the publish XML, note the hash value in the userPWD
    * attribute. After calling /newpassword, call /publishxml again. You can
    * then compare the new value of userPWD in the Publish XML with the one
    * you noted earlier.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn236428.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse generatePassword(String resourceGroupName, String webSiteName, String slotName) throws IOException, ServiceException;
    
    /**
    * You can generate a new random password for publishing a site by issuing
    * an HTTP POST request.  Tip: If you want to verify that the publish
    * password has changed, call HTTP GET on /publishxml before calling
    * /newpassword. In the publish XML, note the hash value in the userPWD
    * attribute. After calling /newpassword, call /publishxml again. You can
    * then compare the new value of userPWD in the Publish XML with the one
    * you noted earlier.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn236428.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> generatePasswordAsync(String resourceGroupName, String webSiteName, String slotName);
    
    /**
    * You can retrieve details for a web site by issuing an HTTP GET request.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/dn167007.aspx
    * for more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @param parameters Optional. Additional parameters.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The Get Web Site Details operation response.
    */
    WebSiteGetResponse get(String resourceGroupName, String webSiteName, String slotName, WebSiteGetParameters parameters) throws IOException, ServiceException, URISyntaxException;
    
    /**
    * You can retrieve details for a web site by issuing an HTTP GET request.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/dn167007.aspx
    * for more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @param parameters Optional. Additional parameters.
    * @return The Get Web Site Details operation response.
    */
    Future<WebSiteGetResponse> getAsync(String resourceGroupName, String webSiteName, String slotName, WebSiteGetParameters parameters);
    
    /**
    * Restart the web site.
    *
    * @param resourceGroupName Required. The name of the resource group
    * @param webSiteName Required. Name of website
    * @param slotName Optional. The name of the slot of the website
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return List of app settings for the website.
    */
    WebSiteAppSettingsResult getAppSettings(String resourceGroupName, String webSiteName, String slotName) throws IOException, ServiceException;
    
    /**
    * Restart the web site.
    *
    * @param resourceGroupName Required. The name of the resource group
    * @param webSiteName Required. Name of website
    * @param slotName Optional. The name of the slot of the website
    * @return List of app settings for the website.
    */
    Future<WebSiteAppSettingsResult> getAppSettingsAsync(String resourceGroupName, String webSiteName, String slotName);
    
    /**
    * Gets a schedule configuration for site backups.
    *
    * @param resourceGroupName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Scheduled backup definition.
    */
    WebSiteGetBackupConfigurationResponse getBackupConfiguration(String resourceGroupName, String webSiteName, String slotName) throws IOException, ServiceException;
    
    /**
    * Gets a schedule configuration for site backups.
    *
    * @param resourceGroupName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @return Scheduled backup definition.
    */
    Future<WebSiteGetBackupConfigurationResponse> getBackupConfigurationAsync(String resourceGroupName, String webSiteName, String slotName);
    
    /**
    * You can retrieve the config settings for a web site by issuing an HTTP
    * GET request, or update them by using HTTP PUT with a request body that
    * contains the settings to be updated.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166985.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @param parameters Optional. Additional parameters.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Config for the website.
    */
    WebSiteGetConfigurationResult getConfiguration(String resourceGroupName, String webSiteName, String slotName, WebSiteGetConfigurationParameters parameters) throws IOException, ServiceException;
    
    /**
    * You can retrieve the config settings for a web site by issuing an HTTP
    * GET request, or update them by using HTTP PUT with a request body that
    * contains the settings to be updated.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166985.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @param parameters Optional. Additional parameters.
    * @return Config for the website.
    */
    Future<WebSiteGetConfigurationResult> getConfigurationAsync(String resourceGroupName, String webSiteName, String slotName, WebSiteGetConfigurationParameters parameters);
    
    /**
    * Restart the web site.
    *
    * @param resourceGroupName Required. The name of the resource group
    * @param webSiteName Required. Name of website
    * @param slotName Optional. The name of the slot of the web site
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return List of connection strings for the website.
    */
    WebSiteConnectionStringsResult getConnectionStrings(String resourceGroupName, String webSiteName, String slotName) throws IOException, ServiceException;
    
    /**
    * Restart the web site.
    *
    * @param resourceGroupName Required. The name of the resource group
    * @param webSiteName Required. Name of website
    * @param slotName Optional. The name of the slot of the web site
    * @return List of connection strings for the website.
    */
    Future<WebSiteConnectionStringsResult> getConnectionStringsAsync(String resourceGroupName, String webSiteName, String slotName);
    
    /**
    * You can retrieve historical usage metrics for a site by issuing an HTTP
    * GET request.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166964.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @param parameters Required. The Get Web Site Historical Usage Metrics
    * parameters.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The Get Web Site Historical Usage Metrics operation response.
    */
    WebSiteGetHistoricalUsageMetricsResponse getHistoricalUsageMetrics(String resourceGroupName, String webSiteName, String slotName, WebSiteGetHistoricalUsageMetricsParameters parameters) throws IOException, ServiceException;
    
    /**
    * You can retrieve historical usage metrics for a site by issuing an HTTP
    * GET request.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166964.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @param parameters Required. The Get Web Site Historical Usage Metrics
    * parameters.
    * @return The Get Web Site Historical Usage Metrics operation response.
    */
    Future<WebSiteGetHistoricalUsageMetricsResponse> getHistoricalUsageMetricsAsync(String resourceGroupName, String webSiteName, String slotName, WebSiteGetHistoricalUsageMetricsParameters parameters);
    
    /**
    * Restart the web site.
    *
    * @param resourceGroupName Required. The name of the resource group
    * @param webSiteName Required. Name of website
    * @param slotName Optional. The name of the slot of the web site
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return List of metadata for the website.
    */
    WebSiteMetadataResult getMetadata(String resourceGroupName, String webSiteName, String slotName) throws IOException, ServiceException;
    
    /**
    * Restart the web site.
    *
    * @param resourceGroupName Required. The name of the resource group
    * @param webSiteName Required. Name of website
    * @param slotName Optional. The name of the slot of the web site
    * @return List of metadata for the website.
    */
    Future<WebSiteMetadataResult> getMetadataAsync(String resourceGroupName, String webSiteName, String slotName);
    
    /**
    * You can retrieve details for a web site by issuing an HTTP GET request.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/dn167007.aspx
    * for more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @param operationId Required. Additional parameters.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The website operation response.
    */
    WebSiteAsyncOperationResponse getOperation(String resourceGroupName, String webSiteName, String slotName, String operationId) throws IOException, ServiceException;
    
    /**
    * You can retrieve details for a web site by issuing an HTTP GET request.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/dn167007.aspx
    * for more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @param operationId Required. Additional parameters.
    * @return The website operation response.
    */
    Future<WebSiteAsyncOperationResponse> getOperationAsync(String resourceGroupName, String webSiteName, String slotName, String operationId);
    
    /**
    * Get publishing credentials for the web site.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. Name of website
    * @param slotName Optional. The name of the slot of the web site.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Publishing credentials for the website.
    */
    WebSitePublishingCredentialsResult getPublishingCredentials(String resourceGroupName, String webSiteName, String slotName) throws IOException, ServiceException;
    
    /**
    * Get publishing credentials for the web site.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. Name of website
    * @param slotName Optional. The name of the slot of the web site.
    * @return Publishing credentials for the website.
    */
    Future<WebSitePublishingCredentialsResult> getPublishingCredentialsAsync(String resourceGroupName, String webSiteName, String slotName);
    
    /**
    * Retrieve the publish settings information for a web site.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166996.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The Get Web Site Publish Profile operation response.
    */
    WebSiteGetPublishProfileResponse getPublishProfile(String resourceGroupName, String webSiteName, String slotName) throws IOException, ServiceException, ParserConfigurationException, SAXException, URISyntaxException;
    
    /**
    * Retrieve the publish settings information for a web site.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166996.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @return The Get Web Site Publish Profile operation response.
    */
    Future<WebSiteGetPublishProfileResponse> getPublishProfileAsync(String resourceGroupName, String webSiteName, String slotName);
    
    /**
    * A web site repository is essentially a GIT repository that you can use to
    * manage your web site content. By using GIT source control tools, you can
    * push or pull version controlled changes to your site. You can create a
    * repository for your web site by issuing an HTTP POST request, or
    * retrieve information about the repository by using HTTP GET.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166967.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The Get Web Site Repository operation response.
    */
    WebSiteGetRepositoryResponse getRepository(String resourceGroupName, String webSiteName, String slotName) throws IOException, ServiceException, URISyntaxException;
    
    /**
    * A web site repository is essentially a GIT repository that you can use to
    * manage your web site content. By using GIT source control tools, you can
    * push or pull version controlled changes to your site. You can create a
    * repository for your web site by issuing an HTTP POST request, or
    * retrieve information about the repository by using HTTP GET.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166967.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @return The Get Web Site Repository operation response.
    */
    Future<WebSiteGetRepositoryResponse> getRepositoryAsync(String resourceGroupName, String webSiteName, String slotName);
    
    /**
    * Update list of app settings and connection strings which to be slot
    * specific. E.g. settings in staging slots remain in staging after swap
    * with production.
    *
    * @param resourceGroupName Required. The name of the resource group
    * @param webSiteName Required. The name of the website
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return List of slot specific settings.
    */
    SlotConfigNamesResult getSlotConfigNames(String resourceGroupName, String webSiteName) throws IOException, ServiceException;
    
    /**
    * Update list of app settings and connection strings which to be slot
    * specific. E.g. settings in staging slots remain in staging after swap
    * with production.
    *
    * @param resourceGroupName Required. The name of the resource group
    * @param webSiteName Required. The name of the website
    * @return List of slot specific settings.
    */
    Future<SlotConfigNamesResult> getSlotConfigNamesAsync(String resourceGroupName, String webSiteName);
    
    /**
    * Get a web site's current usage metrics. The metrics returned include CPU
    * Time, Data In, Data Out, Local bytes read, Local bytes written, Network
    * bytes read, Network bytes written, WP stop requests, Memory Usage, CPU
    * Time - Minute Limit, and File System Storage.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166991.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The Get Web Site Usage Metrics operation response.
    */
    WebSiteGetUsageMetricsResponse getUsageMetrics(String resourceGroupName, String webSiteName, String slotName) throws IOException, ServiceException;
    
    /**
    * Get a web site's current usage metrics. The metrics returned include CPU
    * Time, Data In, Data Out, Local bytes read, Local bytes written, Network
    * bytes read, Network bytes written, WP stop requests, Memory Usage, CPU
    * Time - Minute Limit, and File System Storage.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166991.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @return The Get Web Site Usage Metrics operation response.
    */
    Future<WebSiteGetUsageMetricsResponse> getUsageMetricsAsync(String resourceGroupName, String webSiteName, String slotName);
    
    /**
    * List the Web Sites in a resource group.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Optional. The name of the web site.
    * @param parameters Optional. Additional parameters.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The List Web Sites operation response.
    */
    WebSiteListResponse list(String resourceGroupName, String webSiteName, WebSiteListParameters parameters) throws IOException, ServiceException, URISyntaxException;
    
    /**
    * List the Web Sites in a resource group.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Optional. The name of the web site.
    * @param parameters Optional. Additional parameters.
    * @return The List Web Sites operation response.
    */
    Future<WebSiteListResponse> listAsync(String resourceGroupName, String webSiteName, WebSiteListParameters parameters);
    
    /**
    * Returns list of all backups which are tracked by the system.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return List of backups for the website.
    */
    WebSiteGetBackupsResponse listBackups(String resourceGroupName, String webSiteName, String slotName) throws IOException, ServiceException;
    
    /**
    * Returns list of all backups which are tracked by the system.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @return List of backups for the website.
    */
    Future<WebSiteGetBackupsResponse> listBackupsAsync(String resourceGroupName, String webSiteName, String slotName);
    
    /**
    * Restart the web site.
    *
    * @param resourceGroupName Required. The name of the resource group
    * @param webSiteName Required. Name of website
    * @param slotName Optional. The name of the slot.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse restart(String resourceGroupName, String webSiteName, String slotName) throws IOException, ServiceException;
    
    /**
    * Restart the web site.
    *
    * @param resourceGroupName Required. The name of the resource group
    * @param webSiteName Required. Name of website
    * @param slotName Optional. The name of the slot.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> restartAsync(String resourceGroupName, String webSiteName, String slotName);
    
    /**
    * Restores a site to either a new site or existing site (Overwrite flag has
    * to be set to true for that).
    *
    * @param resourceGroupName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @param restoreRequestEnvelope Required. A restore request.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Restore operation information.
    */
    WebSiteRestoreResponse restore(String resourceGroupName, String webSiteName, String slotName, RestoreRequestEnvelope restoreRequestEnvelope) throws IOException, ServiceException;
    
    /**
    * Restores a site to either a new site or existing site (Overwrite flag has
    * to be set to true for that).
    *
    * @param resourceGroupName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @param restoreRequestEnvelope Required. A restore request.
    * @return Restore operation information.
    */
    Future<WebSiteRestoreResponse> restoreAsync(String resourceGroupName, String webSiteName, String slotName, RestoreRequestEnvelope restoreRequestEnvelope);
    
    /**
    * Restart the web site.
    *
    * @param resourceGroupName Required. The name of the resource group
    * @param webSiteName Required. Name of website
    * @param slotName Optional. The name of the slot of the website
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse start(String resourceGroupName, String webSiteName, String slotName) throws IOException, ServiceException;
    
    /**
    * Restart the web site.
    *
    * @param resourceGroupName Required. The name of the resource group
    * @param webSiteName Required. Name of website
    * @param slotName Optional. The name of the slot of the website
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> startAsync(String resourceGroupName, String webSiteName, String slotName);
    
    /**
    * Restart the web site.
    *
    * @param resourceGroupName Required. The name of the resource group
    * @param webSiteName Required. Name of website
    * @param slotName Optional. The name of the slot of the web site
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse stop(String resourceGroupName, String webSiteName, String slotName) throws IOException, ServiceException;
    
    /**
    * Restart the web site.
    *
    * @param resourceGroupName Required. The name of the resource group
    * @param webSiteName Required. Name of website
    * @param slotName Optional. The name of the slot of the web site
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> stopAsync(String resourceGroupName, String webSiteName, String slotName);
    
    /**
    * You can retrieve the application settings for a web site by issuing an
    * HTTP GET request, or update them by using HTTP PUT with a request body
    * that contains the settings to be updated.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166985.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group
    * @param webSiteName Required. The name of the web site
    * @param slotName Optional. The name of the slot of the website
    * @param parameters Required. The Update Web Site app settings parameters
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return List of app settings for the website.
    */
    WebSiteAppSettingsResult updateAppSettings(String resourceGroupName, String webSiteName, String slotName, WebSiteNameValueParameters parameters) throws IOException, ServiceException;
    
    /**
    * You can retrieve the application settings for a web site by issuing an
    * HTTP GET request, or update them by using HTTP PUT with a request body
    * that contains the settings to be updated.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166985.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group
    * @param webSiteName Required. The name of the web site
    * @param slotName Optional. The name of the slot of the website
    * @param parameters Required. The Update Web Site app settings parameters
    * @return List of app settings for the website.
    */
    Future<WebSiteAppSettingsResult> updateAppSettingsAsync(String resourceGroupName, String webSiteName, String slotName, WebSiteNameValueParameters parameters);
    
    /**
    * Updates a backup schedule for a site.
    *
    * @param resourceGroupName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @param backupRequestEnvelope Required. A backup schedule specification.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse updateBackupConfiguration(String resourceGroupName, String webSiteName, String slotName, BackupRequestEnvelope backupRequestEnvelope) throws IOException, ServiceException;
    
    /**
    * Updates a backup schedule for a site.
    *
    * @param resourceGroupName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @param backupRequestEnvelope Required. A backup schedule specification.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> updateBackupConfigurationAsync(String resourceGroupName, String webSiteName, String slotName, BackupRequestEnvelope backupRequestEnvelope);
    
    /**
    * You can retrieve the config settings for a web site by issuing an HTTP
    * GET request, or update them by using HTTP PUT with a request body that
    * contains the settings to be updated.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166985.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @param parameters Required. The Update Web Site Configuration parameters.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse updateConfiguration(String resourceGroupName, String webSiteName, String slotName, WebSiteUpdateConfigurationParameters parameters) throws IOException, ServiceException;
    
    /**
    * You can retrieve the config settings for a web site by issuing an HTTP
    * GET request, or update them by using HTTP PUT with a request body that
    * contains the settings to be updated.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166985.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @param parameters Required. The Update Web Site Configuration parameters.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> updateConfigurationAsync(String resourceGroupName, String webSiteName, String slotName, WebSiteUpdateConfigurationParameters parameters);
    
    /**
    * You can retrieve the connection strings for a web site by issuing an HTTP
    * GET request, or update them by using HTTP PUT with a request body that
    * contains the settings to be updated.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166985.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group
    * @param webSiteName Required. The name of the website
    * @param slotName Optional. The name of the slot of the website
    * @param parameters Required. The Update Web Site connection strings
    * parameters
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return List of connection strings for the website.
    */
    WebSiteConnectionStringsResult updateConnectionStrings(String resourceGroupName, String webSiteName, String slotName, WebSiteUpdateConnectionStringsParameters parameters) throws IOException, ServiceException;
    
    /**
    * You can retrieve the connection strings for a web site by issuing an HTTP
    * GET request, or update them by using HTTP PUT with a request body that
    * contains the settings to be updated.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166985.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group
    * @param webSiteName Required. The name of the website
    * @param slotName Optional. The name of the slot of the website
    * @param parameters Required. The Update Web Site connection strings
    * parameters
    * @return List of connection strings for the website.
    */
    Future<WebSiteConnectionStringsResult> updateConnectionStringsAsync(String resourceGroupName, String webSiteName, String slotName, WebSiteUpdateConnectionStringsParameters parameters);
    
    /**
    * You can retrieve the metadata for a web site by issuing an HTTP GET
    * request, or update them by using HTTP PUT with a request body that
    * contains the settings to be updated.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166985.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group
    * @param webSiteName Required. The name of the website
    * @param slotName Optional. The name of the slot of the website
    * @param parameters Required. The Update Web Site metadata parameters
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return List of metadata for the website.
    */
    WebSiteMetadataResult updateMetadata(String resourceGroupName, String webSiteName, String slotName, WebSiteNameValueParameters parameters) throws IOException, ServiceException;
    
    /**
    * You can retrieve the metadata for a web site by issuing an HTTP GET
    * request, or update them by using HTTP PUT with a request body that
    * contains the settings to be updated.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166985.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group
    * @param webSiteName Required. The name of the website
    * @param slotName Optional. The name of the slot of the website
    * @param parameters Required. The Update Web Site metadata parameters
    * @return List of metadata for the website.
    */
    Future<WebSiteMetadataResult> updateMetadataAsync(String resourceGroupName, String webSiteName, String slotName, WebSiteNameValueParameters parameters);
    
    /**
    * Link source control to website (do not forget to setup the token, and if
    * needed token secret, for the specific source control type used).
    *
    * @param resourceGroupName Required. The name of the resource group
    * @param webSiteName Required. The name of the web site
    * @param slotName Optional. The name of the slot of the website
    * @param parameters Required. The update site source control parameters.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The link site to source control operation response.
    */
    SiteSourceControlUpdateResponse updateSiteSourceControl(String resourceGroupName, String webSiteName, String slotName, SiteSourceControlUpdateParameters parameters) throws IOException, ServiceException;
    
    /**
    * Link source control to website (do not forget to setup the token, and if
    * needed token secret, for the specific source control type used).
    *
    * @param resourceGroupName Required. The name of the resource group
    * @param webSiteName Required. The name of the web site
    * @param slotName Optional. The name of the slot of the website
    * @param parameters Required. The update site source control parameters.
    * @return The link site to source control operation response.
    */
    Future<SiteSourceControlUpdateResponse> updateSiteSourceControlAsync(String resourceGroupName, String webSiteName, String slotName, SiteSourceControlUpdateParameters parameters);
    
    /**
    * Update list of app settings and connection strings which to be slot
    * specific. E.g. settings in staging slots remain in staging after swap
    * with production.
    *
    * @param resourceGroupName Required. The name of the resource group
    * @param webSiteName Required. The name of the website
    * @param parameters Required. The Update slot configs parameters
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse updateSlotConfigNames(String resourceGroupName, String webSiteName, SlotConfigNamesUpdateParameters parameters) throws IOException, ServiceException;
    
    /**
    * Update list of app settings and connection strings which to be slot
    * specific. E.g. settings in staging slots remain in staging after swap
    * with production.
    *
    * @param resourceGroupName Required. The name of the resource group
    * @param webSiteName Required. The name of the website
    * @param parameters Required. The Update slot configs parameters
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> updateSlotConfigNamesAsync(String resourceGroupName, String webSiteName, SlotConfigNamesUpdateParameters parameters);
}
