/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.websites;

import com.microsoft.azure.management.websites.models.BackupItem;
import com.microsoft.azure.management.websites.models.BackupItemEnvelope;
import com.microsoft.azure.management.websites.models.BackupItemStatus;
import com.microsoft.azure.management.websites.models.BackupItemsEnvelope;
import com.microsoft.azure.management.websites.models.BackupRequestEnvelope;
import com.microsoft.azure.management.websites.models.BackupSchedule;
import com.microsoft.azure.management.websites.models.BackupScheduleRequestEnvelope;
import com.microsoft.azure.management.websites.models.BackupScheduleRequestResponse;
import com.microsoft.azure.management.websites.models.ConnectionStringInfo;
import com.microsoft.azure.management.websites.models.DatabaseBackupSetting;
import com.microsoft.azure.management.websites.models.DatabaseServerType;
import com.microsoft.azure.management.websites.models.FrequencyUnit;
import com.microsoft.azure.management.websites.models.HistoricalUsageMetric;
import com.microsoft.azure.management.websites.models.HistoricalUsageMetricData;
import com.microsoft.azure.management.websites.models.HistoricalUsageMetricSample;
import com.microsoft.azure.management.websites.models.HostType;
import com.microsoft.azure.management.websites.models.ManagedPipelineMode;
import com.microsoft.azure.management.websites.models.NameValuePair;
import com.microsoft.azure.management.websites.models.PublishingCredentials;
import com.microsoft.azure.management.websites.models.RemoteDebuggingVersion;
import com.microsoft.azure.management.websites.models.RestoreRequestEnvelope;
import com.microsoft.azure.management.websites.models.SiteLimits;
import com.microsoft.azure.management.websites.models.SiteSourceControl;
import com.microsoft.azure.management.websites.models.SiteSourceControlProperties;
import com.microsoft.azure.management.websites.models.SiteSourceControlUpdateParameters;
import com.microsoft.azure.management.websites.models.SiteSourceControlUpdateResponse;
import com.microsoft.azure.management.websites.models.SkuOptions;
import com.microsoft.azure.management.websites.models.SlotConfigNames;
import com.microsoft.azure.management.websites.models.SlotConfigNamesEnvelope;
import com.microsoft.azure.management.websites.models.SlotConfigNamesResult;
import com.microsoft.azure.management.websites.models.SlotConfigNamesUpdateParameters;
import com.microsoft.azure.management.websites.models.WebSite;
import com.microsoft.azure.management.websites.models.WebSiteAppSettingsEnvelope;
import com.microsoft.azure.management.websites.models.WebSiteAppSettingsResult;
import com.microsoft.azure.management.websites.models.WebSiteAsyncOperationResponse;
import com.microsoft.azure.management.websites.models.WebSiteBackupResponse;
import com.microsoft.azure.management.websites.models.WebSiteCloneParameters;
import com.microsoft.azure.management.websites.models.WebSiteConfiguration;
import com.microsoft.azure.management.websites.models.WebSiteConfigurationEnvelope;
import com.microsoft.azure.management.websites.models.WebSiteConnectionStringsEnvelope;
import com.microsoft.azure.management.websites.models.WebSiteConnectionStringsResult;
import com.microsoft.azure.management.websites.models.WebSiteCreateOrUpdateParameters;
import com.microsoft.azure.management.websites.models.WebSiteCreateResponse;
import com.microsoft.azure.management.websites.models.WebSiteDeleteParameters;
import com.microsoft.azure.management.websites.models.WebSiteDeleteRepositoryResponse;
import com.microsoft.azure.management.websites.models.WebSiteGetBackupConfigurationResponse;
import com.microsoft.azure.management.websites.models.WebSiteGetBackupsResponse;
import com.microsoft.azure.management.websites.models.WebSiteGetConfigurationParameters;
import com.microsoft.azure.management.websites.models.WebSiteGetConfigurationResult;
import com.microsoft.azure.management.websites.models.WebSiteGetHistoricalUsageMetricsParameters;
import com.microsoft.azure.management.websites.models.WebSiteGetHistoricalUsageMetricsResponse;
import com.microsoft.azure.management.websites.models.WebSiteGetParameters;
import com.microsoft.azure.management.websites.models.WebSiteGetPublishProfileResponse;
import com.microsoft.azure.management.websites.models.WebSiteGetRepositoryResponse;
import com.microsoft.azure.management.websites.models.WebSiteGetResponse;
import com.microsoft.azure.management.websites.models.WebSiteGetUsageMetricsResponse;
import com.microsoft.azure.management.websites.models.WebSiteListParameters;
import com.microsoft.azure.management.websites.models.WebSiteListResponse;
import com.microsoft.azure.management.websites.models.WebSiteMetadataEnvelope;
import com.microsoft.azure.management.websites.models.WebSiteMetadataResult;
import com.microsoft.azure.management.websites.models.WebSiteNameValueParameters;
import com.microsoft.azure.management.websites.models.WebSiteProperties;
import com.microsoft.azure.management.websites.models.WebSitePublishingCredentialsEnvelope;
import com.microsoft.azure.management.websites.models.WebSitePublishingCredentialsResult;
import com.microsoft.azure.management.websites.models.WebSiteRestoreDiscover;
import com.microsoft.azure.management.websites.models.WebSiteRestoreDiscoverProperties;
import com.microsoft.azure.management.websites.models.WebSiteRestoreDiscoverResponse;
import com.microsoft.azure.management.websites.models.WebSiteRestoreResponse;
import com.microsoft.azure.management.websites.models.WebSiteRuntimeAvailabilityState;
import com.microsoft.azure.management.websites.models.WebSiteSslState;
import com.microsoft.azure.management.websites.models.WebSiteState;
import com.microsoft.azure.management.websites.models.WebSiteUpdateConfigurationDetails;
import com.microsoft.azure.management.websites.models.WebSiteUpdateConfigurationParameters;
import com.microsoft.azure.management.websites.models.WebSiteUpdateConnectionStringsParameters;
import com.microsoft.azure.management.websites.models.WebSiteUsageState;
import com.microsoft.azure.management.websites.models.WebSpaceAvailabilityState;
import com.microsoft.windowsazure.core.LazyCollection;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.utils.BOMInputStream;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.core.utils.XmlUtility;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.CloudTracing;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.ObjectNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

/**
* Operations for managing the web sites in a web space.
*/
public class WebSiteOperationsImpl implements ServiceOperations<WebSiteManagementClientImpl>, WebSiteOperations {
    /**
    * Initializes a new instance of the WebSiteOperationsImpl class.
    *
    * @param client Reference to the service client.
    */
    WebSiteOperationsImpl(WebSiteManagementClientImpl client) {
        this.client = client;
    }
    
    private WebSiteManagementClientImpl client;
    
    /**
    * Gets a reference to the
    * microsoft.azure.management.websites.WebSiteManagementClientImpl.
    * @return The Client value.
    */
    public WebSiteManagementClientImpl getClient() {
        return this.client;
    }
    
    /**
    * Backups a site on-demand.
    *
    * @param resourceGroupName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @param backupRequestEnvelope Required. A backup specification.
    * @return The backup record created based on the backup request.
    */
    @Override
    public Future<WebSiteBackupResponse> backupAsync(final String resourceGroupName, final String webSiteName, final String slotName, final BackupRequestEnvelope backupRequestEnvelope) {
        return this.getClient().getExecutorService().submit(new Callable<WebSiteBackupResponse>() { 
            @Override
            public WebSiteBackupResponse call() throws Exception {
                return backup(resourceGroupName, webSiteName, slotName, backupRequestEnvelope);
            }
         });
    }
    
    /**
    * Backups a site on-demand.
    *
    * @param resourceGroupName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @param backupRequestEnvelope Required. A backup specification.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The backup record created based on the backup request.
    */
    @Override
    public WebSiteBackupResponse backup(String resourceGroupName, String webSiteName, String slotName, BackupRequestEnvelope backupRequestEnvelope) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (webSiteName == null) {
            throw new NullPointerException("webSiteName");
        }
        if (backupRequestEnvelope == null) {
            throw new NullPointerException("backupRequestEnvelope");
        }
        if (backupRequestEnvelope.getLocation() == null) {
            throw new NullPointerException("backupRequestEnvelope.Location");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("webSiteName", webSiteName);
            tracingParameters.put("slotName", slotName);
            tracingParameters.put("backupRequestEnvelope", backupRequestEnvelope);
            CloudTracing.enter(invocationId, this, "backupAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Web";
        url = url + "/";
        url = url + "sites";
        url = url + "/";
        url = url + URLEncoder.encode(webSiteName, "UTF-8");
        if (slotName != null) {
            url = url + "/slots/" + URLEncoder.encode(slotName, "UTF-8");
        }
        url = url + "/backup";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-06-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        httpRequest.setHeader("x-ms-version", "2014-06-01");
        
        // Serialize Request
        String requestContent = null;
        JsonNode requestDoc = null;
        
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode backupRequestEnvelopeValue = objectMapper.createObjectNode();
        requestDoc = backupRequestEnvelopeValue;
        
        if (backupRequestEnvelope.getRequest() != null) {
            ObjectNode propertiesValue = objectMapper.createObjectNode();
            ((ObjectNode) backupRequestEnvelopeValue).put("properties", propertiesValue);
            
            if (backupRequestEnvelope.getRequest().getBackupSchedule() != null) {
                ObjectNode backupScheduleValue = objectMapper.createObjectNode();
                ((ObjectNode) propertiesValue).put("backupSchedule", backupScheduleValue);
                
                ((ObjectNode) backupScheduleValue).put("frequencyInterval", backupRequestEnvelope.getRequest().getBackupSchedule().getFrequencyInterval());
                
                if (backupRequestEnvelope.getRequest().getBackupSchedule().getFrequencyUnit() != null) {
                    ((ObjectNode) backupScheduleValue).put("frequencyUnit", backupRequestEnvelope.getRequest().getBackupSchedule().getFrequencyUnit().toString());
                }
                
                ((ObjectNode) backupScheduleValue).put("keepAtLeastOneBackup", backupRequestEnvelope.getRequest().getBackupSchedule().isKeepAtLeastOneBackup());
                
                if (backupRequestEnvelope.getRequest().getBackupSchedule().getLastExecutionTime() != null) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                    simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                    ((ObjectNode) backupScheduleValue).put("lastExecutionTime", simpleDateFormat.format(backupRequestEnvelope.getRequest().getBackupSchedule().getLastExecutionTime().getTime()));
                }
                
                ((ObjectNode) backupScheduleValue).put("retentionPeriodInDays", backupRequestEnvelope.getRequest().getBackupSchedule().getRetentionPeriodInDays());
                
                if (backupRequestEnvelope.getRequest().getBackupSchedule().getStartTime() != null) {
                    SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                    simpleDateFormat2.setTimeZone(TimeZone.getTimeZone("UTC"));
                    ((ObjectNode) backupScheduleValue).put("startTime", simpleDateFormat2.format(backupRequestEnvelope.getRequest().getBackupSchedule().getStartTime().getTime()));
                }
            }
            
            if (backupRequestEnvelope.getRequest().getDatabases() != null) {
                if (backupRequestEnvelope.getRequest().getDatabases() instanceof LazyCollection == false || ((LazyCollection) backupRequestEnvelope.getRequest().getDatabases()).isInitialized()) {
                    ArrayNode databasesArray = objectMapper.createArrayNode();
                    for (DatabaseBackupSetting databasesItem : backupRequestEnvelope.getRequest().getDatabases()) {
                        ObjectNode databaseBackupSettingValue = objectMapper.createObjectNode();
                        databasesArray.add(databaseBackupSettingValue);
                        
                        if (databasesItem.getConnectionString() != null) {
                            ((ObjectNode) databaseBackupSettingValue).put("connectionString", databasesItem.getConnectionString());
                        }
                        
                        if (databasesItem.getConnectionStringName() != null) {
                            ((ObjectNode) databaseBackupSettingValue).put("connectionStringName", databasesItem.getConnectionStringName());
                        }
                        
                        if (databasesItem.getDatabaseType() != null) {
                            ((ObjectNode) databaseBackupSettingValue).put("databaseType", databasesItem.getDatabaseType());
                        }
                        
                        if (databasesItem.getName() != null) {
                            ((ObjectNode) databaseBackupSettingValue).put("name", databasesItem.getName());
                        }
                    }
                    ((ObjectNode) propertiesValue).put("databases", databasesArray);
                }
            }
            
            if (backupRequestEnvelope.getRequest().isEnabled() != null) {
                ((ObjectNode) propertiesValue).put("enabled", backupRequestEnvelope.getRequest().isEnabled());
            }
            
            if (backupRequestEnvelope.getRequest().getName() != null) {
                ((ObjectNode) propertiesValue).put("name", backupRequestEnvelope.getRequest().getName());
            }
            
            if (backupRequestEnvelope.getRequest().getStorageAccountUrl() != null) {
                ((ObjectNode) propertiesValue).put("storageAccountUrl", backupRequestEnvelope.getRequest().getStorageAccountUrl());
            }
        }
        
        if (backupRequestEnvelope.getId() != null) {
            ((ObjectNode) backupRequestEnvelopeValue).put("id", backupRequestEnvelope.getId());
        }
        
        if (backupRequestEnvelope.getName() != null) {
            ((ObjectNode) backupRequestEnvelopeValue).put("name", backupRequestEnvelope.getName());
        }
        
        ((ObjectNode) backupRequestEnvelopeValue).put("location", backupRequestEnvelope.getLocation());
        
        if (backupRequestEnvelope.getTags() != null) {
            ObjectNode tagsDictionary = objectMapper.createObjectNode();
            for (Map.Entry<String, String> entry : backupRequestEnvelope.getTags().entrySet()) {
                String tagsKey = entry.getKey();
                String tagsValue = entry.getValue();
                ((ObjectNode) tagsDictionary).put(tagsKey, tagsValue);
            }
            ((ObjectNode) backupRequestEnvelopeValue).put("tags", tagsDictionary);
        }
        
        if (backupRequestEnvelope.getType() != null) {
            ((ObjectNode) backupRequestEnvelopeValue).put("type", backupRequestEnvelope.getType());
        }
        
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue(stringWriter, requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            WebSiteBackupResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new WebSiteBackupResponse();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    BackupItemEnvelope backupItemInstance = new BackupItemEnvelope();
                    result.setBackupItem(backupItemInstance);
                    
                    JsonNode propertiesValue2 = responseDoc.get("properties");
                    if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                        BackupItem propertiesInstance = new BackupItem();
                        backupItemInstance.setProperties(propertiesInstance);
                        
                        JsonNode storageAccountUrlValue = propertiesValue2.get("storageAccountUrl");
                        if (storageAccountUrlValue != null && storageAccountUrlValue instanceof NullNode == false) {
                            String storageAccountUrlInstance;
                            storageAccountUrlInstance = storageAccountUrlValue.getTextValue();
                            propertiesInstance.setStorageAccountUrl(storageAccountUrlInstance);
                        }
                        
                        JsonNode blobNameValue = propertiesValue2.get("blobName");
                        if (blobNameValue != null && blobNameValue instanceof NullNode == false) {
                            String blobNameInstance;
                            blobNameInstance = blobNameValue.getTextValue();
                            propertiesInstance.setBlobName(blobNameInstance);
                        }
                        
                        JsonNode nameValue = propertiesValue2.get("name");
                        if (nameValue != null && nameValue instanceof NullNode == false) {
                            String nameInstance;
                            nameInstance = nameValue.getTextValue();
                            propertiesInstance.setName(nameInstance);
                        }
                        
                        JsonNode statusValue = propertiesValue2.get("status");
                        if (statusValue != null && statusValue instanceof NullNode == false) {
                            BackupItemStatus statusInstance;
                            statusInstance = Enum.valueOf(BackupItemStatus.class, statusValue.getTextValue());
                            propertiesInstance.setStatus(statusInstance);
                        }
                        
                        JsonNode sizeInBytesValue = propertiesValue2.get("sizeInBytes");
                        if (sizeInBytesValue != null && sizeInBytesValue instanceof NullNode == false) {
                            long sizeInBytesInstance;
                            sizeInBytesInstance = sizeInBytesValue.getLongValue();
                            propertiesInstance.setSizeInBytes(sizeInBytesInstance);
                        }
                        
                        JsonNode createdValue = propertiesValue2.get("created");
                        if (createdValue != null && createdValue instanceof NullNode == false) {
                            Calendar createdInstance;
                            createdInstance = DatatypeConverter.parseDateTime(createdValue.getTextValue());
                            propertiesInstance.setCreated(createdInstance);
                        }
                        
                        JsonNode logValue = propertiesValue2.get("log");
                        if (logValue != null && logValue instanceof NullNode == false) {
                            String logInstance;
                            logInstance = logValue.getTextValue();
                            propertiesInstance.setLog(logInstance);
                        }
                        
                        JsonNode databasesArray2 = propertiesValue2.get("databases");
                        if (databasesArray2 != null && databasesArray2 instanceof NullNode == false) {
                            for (JsonNode databasesValue : ((ArrayNode) databasesArray2)) {
                                DatabaseBackupSetting databaseBackupSettingInstance = new DatabaseBackupSetting();
                                propertiesInstance.getDatabases().add(databaseBackupSettingInstance);
                                
                                JsonNode connectionStringValue = databasesValue.get("connectionString");
                                if (connectionStringValue != null && connectionStringValue instanceof NullNode == false) {
                                    String connectionStringInstance;
                                    connectionStringInstance = connectionStringValue.getTextValue();
                                    databaseBackupSettingInstance.setConnectionString(connectionStringInstance);
                                }
                                
                                JsonNode connectionStringNameValue = databasesValue.get("connectionStringName");
                                if (connectionStringNameValue != null && connectionStringNameValue instanceof NullNode == false) {
                                    String connectionStringNameInstance;
                                    connectionStringNameInstance = connectionStringNameValue.getTextValue();
                                    databaseBackupSettingInstance.setConnectionStringName(connectionStringNameInstance);
                                }
                                
                                JsonNode databaseTypeValue = databasesValue.get("databaseType");
                                if (databaseTypeValue != null && databaseTypeValue instanceof NullNode == false) {
                                    String databaseTypeInstance;
                                    databaseTypeInstance = databaseTypeValue.getTextValue();
                                    databaseBackupSettingInstance.setDatabaseType(databaseTypeInstance);
                                }
                                
                                JsonNode nameValue2 = databasesValue.get("name");
                                if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                                    String nameInstance2;
                                    nameInstance2 = nameValue2.getTextValue();
                                    databaseBackupSettingInstance.setName(nameInstance2);
                                }
                            }
                        }
                        
                        JsonNode scheduledValue = propertiesValue2.get("scheduled");
                        if (scheduledValue != null && scheduledValue instanceof NullNode == false) {
                            boolean scheduledInstance;
                            scheduledInstance = scheduledValue.getBooleanValue();
                            propertiesInstance.setScheduled(scheduledInstance);
                        }
                        
                        JsonNode lastRestoreTimeStampValue = propertiesValue2.get("lastRestoreTimeStamp");
                        if (lastRestoreTimeStampValue != null && lastRestoreTimeStampValue instanceof NullNode == false) {
                            Calendar lastRestoreTimeStampInstance;
                            lastRestoreTimeStampInstance = DatatypeConverter.parseDateTime(lastRestoreTimeStampValue.getTextValue());
                            propertiesInstance.setLastRestoreTimeStamp(lastRestoreTimeStampInstance);
                        }
                        
                        JsonNode finishedTimeStampValue = propertiesValue2.get("finishedTimeStamp");
                        if (finishedTimeStampValue != null && finishedTimeStampValue instanceof NullNode == false) {
                            Calendar finishedTimeStampInstance;
                            finishedTimeStampInstance = DatatypeConverter.parseDateTime(finishedTimeStampValue.getTextValue());
                            propertiesInstance.setFinishedTimeStamp(finishedTimeStampInstance);
                        }
                        
                        JsonNode correlationIdValue = propertiesValue2.get("correlationId");
                        if (correlationIdValue != null && correlationIdValue instanceof NullNode == false) {
                            String correlationIdInstance;
                            correlationIdInstance = correlationIdValue.getTextValue();
                            propertiesInstance.setCorrelationId(correlationIdInstance);
                        }
                    }
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        backupItemInstance.setId(idInstance);
                    }
                    
                    JsonNode nameValue3 = responseDoc.get("name");
                    if (nameValue3 != null && nameValue3 instanceof NullNode == false) {
                        String nameInstance3;
                        nameInstance3 = nameValue3.getTextValue();
                        backupItemInstance.setName(nameInstance3);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        backupItemInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry<String, JsonNode> property = itr.next();
                            String tagsKey2 = property.getKey();
                            String tagsValue2 = property.getValue().getTextValue();
                            backupItemInstance.getTags().put(tagsKey2, tagsValue2);
                        }
                    }
                    
                    JsonNode typeValue = responseDoc.get("type");
                    if (typeValue != null && typeValue instanceof NullNode == false) {
                        String typeInstance;
                        typeInstance = typeValue.getTextValue();
                        backupItemInstance.setType(typeInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * You can clone a web site by using a PUT request that includes the name of
    * the web site and other information in the request body.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166986.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @param parameters Required. Parameters supplied to the clone Web Site
    * operation.
    * @return The website operation response.
    */
    @Override
    public Future<WebSiteAsyncOperationResponse> cloneMethodAsync(final String resourceGroupName, final String webSiteName, final String slotName, final WebSiteCloneParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<WebSiteAsyncOperationResponse>() { 
            @Override
            public WebSiteAsyncOperationResponse call() throws Exception {
                return cloneMethod(resourceGroupName, webSiteName, slotName, parameters);
            }
         });
    }
    
    /**
    * You can clone a web site by using a PUT request that includes the name of
    * the web site and other information in the request body.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166986.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @param parameters Required. Parameters supplied to the clone Web Site
    * operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The website operation response.
    */
    @Override
    public WebSiteAsyncOperationResponse cloneMethod(String resourceGroupName, String webSiteName, String slotName, WebSiteCloneParameters parameters) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (webSiteName == null) {
            throw new NullPointerException("webSiteName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getWebSiteClone() == null) {
            throw new NullPointerException("parameters.WebSiteClone");
        }
        if (parameters.getWebSiteClone().getLocation() == null) {
            throw new NullPointerException("parameters.WebSiteClone.Location");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("webSiteName", webSiteName);
            tracingParameters.put("slotName", slotName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "cloneMethodAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Web";
        url = url + "/";
        url = url + "sites";
        url = url + "/";
        url = url + URLEncoder.encode(webSiteName, "UTF-8");
        if (slotName != null) {
            url = url + "/slots/" + URLEncoder.encode(slotName, "UTF-8");
        }
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-06-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Serialize Request
        String requestContent = null;
        JsonNode requestDoc = null;
        
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode webSiteCloneParametersValue = objectMapper.createObjectNode();
        requestDoc = webSiteCloneParametersValue;
        
        if (parameters.getWebSiteClone().getProperties() != null) {
            ObjectNode propertiesValue = objectMapper.createObjectNode();
            ((ObjectNode) webSiteCloneParametersValue).put("properties", propertiesValue);
            
            if (parameters.getWebSiteClone().getProperties().getServerFarm() != null) {
                ((ObjectNode) propertiesValue).put("ServerFarm", parameters.getWebSiteClone().getProperties().getServerFarm());
            }
            
            if (parameters.getWebSiteClone().getProperties().getCloningInfo() != null) {
                ObjectNode cloningInfoValue = objectMapper.createObjectNode();
                ((ObjectNode) propertiesValue).put("cloningInfo", cloningInfoValue);
                
                if (parameters.getWebSiteClone().getProperties().getCloningInfo().getCorrelationId() != null) {
                    ((ObjectNode) cloningInfoValue).put("CorrelationId", parameters.getWebSiteClone().getProperties().getCloningInfo().getCorrelationId());
                }
                
                ((ObjectNode) cloningInfoValue).put("Overwrite", parameters.getWebSiteClone().getProperties().getCloningInfo().isOverwrite());
                
                ((ObjectNode) cloningInfoValue).put("CloneCustomHostNames", parameters.getWebSiteClone().getProperties().getCloningInfo().isCloneCustomHostNames());
                
                if (parameters.getWebSiteClone().getProperties().getCloningInfo().getSource() != null) {
                    ObjectNode sourceValue = objectMapper.createObjectNode();
                    ((ObjectNode) cloningInfoValue).put("Source", sourceValue);
                    
                    if (parameters.getWebSiteClone().getProperties().getCloningInfo().getSource().getName() != null) {
                        ((ObjectNode) sourceValue).put("Name", parameters.getWebSiteClone().getProperties().getCloningInfo().getSource().getName());
                    }
                    
                    if (parameters.getWebSiteClone().getProperties().getCloningInfo().getSource().getLocation() != null) {
                        ((ObjectNode) sourceValue).put("Location", parameters.getWebSiteClone().getProperties().getCloningInfo().getSource().getLocation());
                    }
                    
                    if (parameters.getWebSiteClone().getProperties().getCloningInfo().getSource().getResourceGroupName() != null) {
                        ((ObjectNode) sourceValue).put("ResourceGroupName", parameters.getWebSiteClone().getProperties().getCloningInfo().getSource().getResourceGroupName());
                    }
                    
                    if (parameters.getWebSiteClone().getProperties().getCloningInfo().getSource().getSubscriptionId() != null) {
                        ((ObjectNode) sourceValue).put("SubscriptionId", parameters.getWebSiteClone().getProperties().getCloningInfo().getSource().getSubscriptionId());
                    }
                    
                    if (parameters.getWebSiteClone().getProperties().getCloningInfo().getSource().getSlot() != null) {
                        ((ObjectNode) sourceValue).put("Slot", parameters.getWebSiteClone().getProperties().getCloningInfo().getSource().getSlot());
                    }
                }
                
                if (parameters.getWebSiteClone().getProperties().getCloningInfo().getHostingEnvironment() != null) {
                    ((ObjectNode) cloningInfoValue).put("HostingEnvironment", parameters.getWebSiteClone().getProperties().getCloningInfo().getHostingEnvironment());
                }
            }
        }
        
        if (parameters.getWebSiteClone().getId() != null) {
            ((ObjectNode) webSiteCloneParametersValue).put("id", parameters.getWebSiteClone().getId());
        }
        
        if (parameters.getWebSiteClone().getName() != null) {
            ((ObjectNode) webSiteCloneParametersValue).put("name", parameters.getWebSiteClone().getName());
        }
        
        ((ObjectNode) webSiteCloneParametersValue).put("location", parameters.getWebSiteClone().getLocation());
        
        if (parameters.getWebSiteClone().getTags() != null) {
            ObjectNode tagsDictionary = objectMapper.createObjectNode();
            for (Map.Entry<String, String> entry : parameters.getWebSiteClone().getTags().entrySet()) {
                String tagsKey = entry.getKey();
                String tagsValue = entry.getValue();
                ((ObjectNode) tagsDictionary).put(tagsKey, tagsValue);
            }
            ((ObjectNode) webSiteCloneParametersValue).put("tags", tagsDictionary);
        }
        
        if (parameters.getWebSiteClone().getType() != null) {
            ((ObjectNode) webSiteCloneParametersValue).put("type", parameters.getWebSiteClone().getType());
        }
        
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue(stringWriter, requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_ACCEPTED) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            WebSiteAsyncOperationResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_ACCEPTED) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new WebSiteAsyncOperationResponse();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        result.setLocation(locationInstance);
                    }
                    
                    JsonNode retryAfterValue = responseDoc.get("retry-after");
                    if (retryAfterValue != null && retryAfterValue instanceof NullNode == false) {
                        String retryAfterInstance;
                        retryAfterInstance = retryAfterValue.getTextValue();
                        result.setRetryAfter(retryAfterInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("location").length > 0) {
                result.setLocation(httpResponse.getFirstHeader("location").getValue());
            }
            if (httpResponse.getHeaders("retry-after").length > 0) {
                result.setRetryAfter(httpResponse.getFirstHeader("retry-after").getValue());
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * You can create a web site by using a POST request that includes the name
    * of the web site and other information in the request body.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166986.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @param parameters Required. Parameters supplied to the Create Web Site
    * operation.
    * @return The Create Web Space operation response.
    */
    @Override
    public Future<WebSiteCreateResponse> createOrUpdateAsync(final String resourceGroupName, final String webSiteName, final String slotName, final WebSiteCreateOrUpdateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<WebSiteCreateResponse>() { 
            @Override
            public WebSiteCreateResponse call() throws Exception {
                return createOrUpdate(resourceGroupName, webSiteName, slotName, parameters);
            }
         });
    }
    
    /**
    * You can create a web site by using a POST request that includes the name
    * of the web site and other information in the request body.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166986.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @param parameters Required. Parameters supplied to the Create Web Site
    * operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The Create Web Space operation response.
    */
    @Override
    public WebSiteCreateResponse createOrUpdate(String resourceGroupName, String webSiteName, String slotName, WebSiteCreateOrUpdateParameters parameters) throws IOException, ServiceException, URISyntaxException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (webSiteName == null) {
            throw new NullPointerException("webSiteName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getWebSite() == null) {
            throw new NullPointerException("parameters.WebSite");
        }
        if (parameters.getWebSite().getLocation() == null) {
            throw new NullPointerException("parameters.WebSite.Location");
        }
        if (parameters.getWebSite().getProperties() != null) {
            if (parameters.getWebSite().getProperties().getServerFarm() == null) {
                throw new NullPointerException("parameters.WebSite.Properties.ServerFarm");
            }
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("webSiteName", webSiteName);
            tracingParameters.put("slotName", slotName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "createOrUpdateAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Web";
        url = url + "/";
        url = url + "sites";
        url = url + "/";
        url = url + URLEncoder.encode(webSiteName, "UTF-8");
        if (slotName != null) {
            url = url + "/slots/" + URLEncoder.encode(slotName, "UTF-8");
        }
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-06-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Serialize Request
        String requestContent = null;
        JsonNode requestDoc = null;
        
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode webSiteCreateOrUpdateParametersValue = objectMapper.createObjectNode();
        requestDoc = webSiteCreateOrUpdateParametersValue;
        
        if (parameters.getWebSite().getProperties() != null) {
            ObjectNode propertiesValue = objectMapper.createObjectNode();
            ((ObjectNode) webSiteCreateOrUpdateParametersValue).put("properties", propertiesValue);
            
            ((ObjectNode) propertiesValue).put("ServerFarm", parameters.getWebSite().getProperties().getServerFarm());
        }
        
        if (parameters.getWebSite().getId() != null) {
            ((ObjectNode) webSiteCreateOrUpdateParametersValue).put("id", parameters.getWebSite().getId());
        }
        
        if (parameters.getWebSite().getName() != null) {
            ((ObjectNode) webSiteCreateOrUpdateParametersValue).put("name", parameters.getWebSite().getName());
        }
        
        ((ObjectNode) webSiteCreateOrUpdateParametersValue).put("location", parameters.getWebSite().getLocation());
        
        if (parameters.getWebSite().getTags() != null) {
            ObjectNode tagsDictionary = objectMapper.createObjectNode();
            for (Map.Entry<String, String> entry : parameters.getWebSite().getTags().entrySet()) {
                String tagsKey = entry.getKey();
                String tagsValue = entry.getValue();
                ((ObjectNode) tagsDictionary).put(tagsKey, tagsValue);
            }
            ((ObjectNode) webSiteCreateOrUpdateParametersValue).put("tags", tagsDictionary);
        }
        
        if (parameters.getWebSite().getType() != null) {
            ((ObjectNode) webSiteCreateOrUpdateParametersValue).put("type", parameters.getWebSite().getType());
        }
        
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue(stringWriter, requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            WebSiteCreateResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new WebSiteCreateResponse();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    WebSite webSiteInstance = new WebSite();
                    result.setWebSite(webSiteInstance);
                    
                    JsonNode propertiesValue2 = responseDoc.get("properties");
                    if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                        WebSiteProperties propertiesInstance = new WebSiteProperties();
                        webSiteInstance.setProperties(propertiesInstance);
                        
                        JsonNode adminEnabledValue = propertiesValue2.get("adminEnabled");
                        if (adminEnabledValue != null && adminEnabledValue instanceof NullNode == false) {
                            boolean adminEnabledInstance;
                            adminEnabledInstance = adminEnabledValue.getBooleanValue();
                            propertiesInstance.setAdminEnabled(adminEnabledInstance);
                        }
                        
                        JsonNode availabilityStateValue = propertiesValue2.get("availabilityState");
                        if (availabilityStateValue != null && availabilityStateValue instanceof NullNode == false) {
                            WebSpaceAvailabilityState availabilityStateInstance;
                            availabilityStateInstance = Enum.valueOf(WebSpaceAvailabilityState.class, availabilityStateValue.getTextValue());
                            propertiesInstance.setAvailabilityState(availabilityStateInstance);
                        }
                        
                        JsonNode enabledValue = propertiesValue2.get("enabled");
                        if (enabledValue != null && enabledValue instanceof NullNode == false) {
                            boolean enabledInstance;
                            enabledInstance = enabledValue.getBooleanValue();
                            propertiesInstance.setEnabled(enabledInstance);
                        }
                        
                        JsonNode enabledHostNamesArray = propertiesValue2.get("enabledHostNames");
                        if (enabledHostNamesArray != null && enabledHostNamesArray instanceof NullNode == false) {
                            for (JsonNode enabledHostNamesValue : ((ArrayNode) enabledHostNamesArray)) {
                                propertiesInstance.getEnabledHostNames().add(enabledHostNamesValue.getTextValue());
                            }
                        }
                        
                        JsonNode hostNameSslStatesArray = propertiesValue2.get("hostNameSslStates");
                        if (hostNameSslStatesArray != null && hostNameSslStatesArray instanceof NullNode == false) {
                            for (JsonNode hostNameSslStatesValue : ((ArrayNode) hostNameSslStatesArray)) {
                                WebSiteProperties.WebSiteHostNameSslState webSiteHostNameSslStateInstance = new WebSiteProperties.WebSiteHostNameSslState();
                                propertiesInstance.getHostNameSslStates().add(webSiteHostNameSslStateInstance);
                                
                                JsonNode nameValue = hostNameSslStatesValue.get("name");
                                if (nameValue != null && nameValue instanceof NullNode == false) {
                                    String nameInstance;
                                    nameInstance = nameValue.getTextValue();
                                    webSiteHostNameSslStateInstance.setName(nameInstance);
                                }
                                
                                JsonNode sslStateValue = hostNameSslStatesValue.get("sslState");
                                if (sslStateValue != null && sslStateValue instanceof NullNode == false) {
                                    WebSiteSslState sslStateInstance;
                                    sslStateInstance = Enum.valueOf(WebSiteSslState.class, sslStateValue.getTextValue());
                                    webSiteHostNameSslStateInstance.setSslState(sslStateInstance);
                                }
                                
                                JsonNode thumbprintValue = hostNameSslStatesValue.get("thumbprint");
                                if (thumbprintValue != null && thumbprintValue instanceof NullNode == false) {
                                    String thumbprintInstance;
                                    thumbprintInstance = thumbprintValue.getTextValue();
                                    webSiteHostNameSslStateInstance.setThumbprint(thumbprintInstance);
                                }
                                
                                JsonNode virtualIPValue = hostNameSslStatesValue.get("virtualIP");
                                if (virtualIPValue != null && virtualIPValue instanceof NullNode == false) {
                                    InetAddress virtualIPInstance;
                                    virtualIPInstance = InetAddress.getByName(virtualIPValue.getTextValue());
                                    webSiteHostNameSslStateInstance.setVirtualIP(virtualIPInstance);
                                }
                                
                                JsonNode ipBasedSslResultValue = hostNameSslStatesValue.get("ipBasedSslResult");
                                if (ipBasedSslResultValue != null && ipBasedSslResultValue instanceof NullNode == false) {
                                    String ipBasedSslResultInstance;
                                    ipBasedSslResultInstance = ipBasedSslResultValue.getTextValue();
                                    webSiteHostNameSslStateInstance.setIpBasedSslResult(ipBasedSslResultInstance);
                                }
                                
                                JsonNode toUpdateValue = hostNameSslStatesValue.get("toUpdate");
                                if (toUpdateValue != null && toUpdateValue instanceof NullNode == false) {
                                    boolean toUpdateInstance;
                                    toUpdateInstance = toUpdateValue.getBooleanValue();
                                    webSiteHostNameSslStateInstance.setToUpdate(toUpdateInstance);
                                }
                                
                                JsonNode toUpdateIpBasedSslValue = hostNameSslStatesValue.get("toUpdateIpBasedSsl");
                                if (toUpdateIpBasedSslValue != null && toUpdateIpBasedSslValue instanceof NullNode == false) {
                                    boolean toUpdateIpBasedSslInstance;
                                    toUpdateIpBasedSslInstance = toUpdateIpBasedSslValue.getBooleanValue();
                                    webSiteHostNameSslStateInstance.setToUpdateIpBasedSsl(toUpdateIpBasedSslInstance);
                                }
                                
                                JsonNode hostTypeValue = hostNameSslStatesValue.get("hostType");
                                if (hostTypeValue != null && hostTypeValue instanceof NullNode == false) {
                                    HostType hostTypeInstance;
                                    hostTypeInstance = Enum.valueOf(HostType.class, hostTypeValue.getTextValue());
                                    webSiteHostNameSslStateInstance.setHostType(hostTypeInstance);
                                }
                            }
                        }
                        
                        JsonNode hostNamesArray = propertiesValue2.get("hostNames");
                        if (hostNamesArray != null && hostNamesArray instanceof NullNode == false) {
                            for (JsonNode hostNamesValue : ((ArrayNode) hostNamesArray)) {
                                propertiesInstance.getHostNames().add(hostNamesValue.getTextValue());
                            }
                        }
                        
                        JsonNode lastModifiedTimeUtcValue = propertiesValue2.get("lastModifiedTimeUtc");
                        if (lastModifiedTimeUtcValue != null && lastModifiedTimeUtcValue instanceof NullNode == false) {
                            Calendar lastModifiedTimeUtcInstance;
                            lastModifiedTimeUtcInstance = DatatypeConverter.parseDateTime(lastModifiedTimeUtcValue.getTextValue());
                            propertiesInstance.setLastModifiedTimeUtc(lastModifiedTimeUtcInstance);
                        }
                        
                        JsonNode repositorySiteNameValue = propertiesValue2.get("repositorySiteName");
                        if (repositorySiteNameValue != null && repositorySiteNameValue instanceof NullNode == false) {
                            String repositorySiteNameInstance;
                            repositorySiteNameInstance = repositorySiteNameValue.getTextValue();
                            propertiesInstance.setRepositorySiteName(repositorySiteNameInstance);
                        }
                        
                        JsonNode runtimeAvailabilityStateValue = propertiesValue2.get("runtimeAvailabilityState");
                        if (runtimeAvailabilityStateValue != null && runtimeAvailabilityStateValue instanceof NullNode == false) {
                            WebSiteRuntimeAvailabilityState runtimeAvailabilityStateInstance;
                            runtimeAvailabilityStateInstance = Enum.valueOf(WebSiteRuntimeAvailabilityState.class, runtimeAvailabilityStateValue.getTextValue());
                            propertiesInstance.setRuntimeAvailabilityState(runtimeAvailabilityStateInstance);
                        }
                        
                        JsonNode trafficManagerHostNamesArray = propertiesValue2.get("trafficManagerHostNames");
                        if (trafficManagerHostNamesArray != null && trafficManagerHostNamesArray instanceof NullNode == false) {
                            for (JsonNode trafficManagerHostNamesValue : ((ArrayNode) trafficManagerHostNamesArray)) {
                                propertiesInstance.getTrafficManagerHostNames().add(trafficManagerHostNamesValue.getTextValue());
                            }
                        }
                        
                        JsonNode selfLinkValue = propertiesValue2.get("selfLink");
                        if (selfLinkValue != null && selfLinkValue instanceof NullNode == false) {
                            URI selfLinkInstance;
                            selfLinkInstance = new URI(selfLinkValue.getTextValue());
                            propertiesInstance.setUri(selfLinkInstance);
                        }
                        
                        JsonNode serverFarmValue = propertiesValue2.get("serverFarm");
                        if (serverFarmValue != null && serverFarmValue instanceof NullNode == false) {
                            String serverFarmInstance;
                            serverFarmInstance = serverFarmValue.getTextValue();
                            propertiesInstance.setServerFarm(serverFarmInstance);
                        }
                        
                        JsonNode serverFarmIdValue = propertiesValue2.get("serverFarmId");
                        if (serverFarmIdValue != null && serverFarmIdValue instanceof NullNode == false) {
                            String serverFarmIdInstance;
                            serverFarmIdInstance = serverFarmIdValue.getTextValue();
                            propertiesInstance.setServerFarmId(serverFarmIdInstance);
                        }
                        
                        JsonNode skuValue = propertiesValue2.get("sku");
                        if (skuValue != null && skuValue instanceof NullNode == false) {
                            SkuOptions skuInstance;
                            skuInstance = Enum.valueOf(SkuOptions.class, skuValue.getTextValue());
                            propertiesInstance.setSku(skuInstance);
                        }
                        
                        JsonNode sitePropertiesValue = propertiesValue2.get("siteProperties");
                        if (sitePropertiesValue != null && sitePropertiesValue instanceof NullNode == false) {
                            WebSiteProperties.SiteProperties sitePropertiesInstance = new WebSiteProperties.SiteProperties();
                            propertiesInstance.setProperties(sitePropertiesInstance);
                            
                            JsonNode appSettingsSequenceElement = ((JsonNode) sitePropertiesValue.get("appSettings"));
                            if (appSettingsSequenceElement != null && appSettingsSequenceElement instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr = appSettingsSequenceElement.getFields();
                                while (itr.hasNext()) {
                                    Map.Entry<String, JsonNode> property = itr.next();
                                    String appSettingsKey = property.getKey();
                                    String appSettingsValue = property.getValue().getTextValue();
                                    sitePropertiesInstance.getAppSettings().put(appSettingsKey, appSettingsValue);
                                }
                            }
                            
                            JsonNode metadataSequenceElement = ((JsonNode) sitePropertiesValue.get("metadata"));
                            if (metadataSequenceElement != null && metadataSequenceElement instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr2 = metadataSequenceElement.getFields();
                                while (itr2.hasNext()) {
                                    Map.Entry<String, JsonNode> property2 = itr2.next();
                                    String metadataKey = property2.getKey();
                                    String metadataValue = property2.getValue().getTextValue();
                                    sitePropertiesInstance.getMetadata().put(metadataKey, metadataValue);
                                }
                            }
                            
                            JsonNode propertiesSequenceElement = ((JsonNode) sitePropertiesValue.get("properties"));
                            if (propertiesSequenceElement != null && propertiesSequenceElement instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr3 = propertiesSequenceElement.getFields();
                                while (itr3.hasNext()) {
                                    Map.Entry<String, JsonNode> property3 = itr3.next();
                                    String propertiesKey = property3.getKey();
                                    String propertiesValue3 = property3.getValue().getTextValue();
                                    sitePropertiesInstance.getProperties().put(propertiesKey, propertiesValue3);
                                }
                            }
                        }
                        
                        JsonNode siteConfigValue = propertiesValue2.get("siteConfig");
                        if (siteConfigValue != null && siteConfigValue instanceof NullNode == false) {
                            WebSiteConfiguration siteConfigInstance = new WebSiteConfiguration();
                            propertiesInstance.setSiteConfig(siteConfigInstance);
                            
                            JsonNode appSettingsSequenceElement2 = ((JsonNode) siteConfigValue.get("appSettings"));
                            if (appSettingsSequenceElement2 != null && appSettingsSequenceElement2 instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr4 = appSettingsSequenceElement2.getFields();
                                while (itr4.hasNext()) {
                                    Map.Entry<String, JsonNode> property4 = itr4.next();
                                    String appSettingsKey2 = property4.getKey();
                                    String appSettingsValue2 = property4.getValue().getTextValue();
                                    siteConfigInstance.getAppSettings().put(appSettingsKey2, appSettingsValue2);
                                }
                            }
                            
                            JsonNode connectionStringsArray = siteConfigValue.get("connectionStrings");
                            if (connectionStringsArray != null && connectionStringsArray instanceof NullNode == false) {
                                for (JsonNode connectionStringsValue : ((ArrayNode) connectionStringsArray)) {
                                    ConnectionStringInfo connStringInfoInstance = new ConnectionStringInfo();
                                    siteConfigInstance.getConnectionStrings().add(connStringInfoInstance);
                                    
                                    JsonNode connectionStringValue = connectionStringsValue.get("connectionString");
                                    if (connectionStringValue != null && connectionStringValue instanceof NullNode == false) {
                                        String connectionStringInstance;
                                        connectionStringInstance = connectionStringValue.getTextValue();
                                        connStringInfoInstance.setConnectionString(connectionStringInstance);
                                    }
                                    
                                    JsonNode nameValue2 = connectionStringsValue.get("name");
                                    if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                                        String nameInstance2;
                                        nameInstance2 = nameValue2.getTextValue();
                                        connStringInfoInstance.setName(nameInstance2);
                                    }
                                    
                                    JsonNode typeValue = connectionStringsValue.get("type");
                                    if (typeValue != null && typeValue instanceof NullNode == false) {
                                        DatabaseServerType typeInstance;
                                        typeInstance = Enum.valueOf(DatabaseServerType.class, typeValue.getTextValue());
                                        connStringInfoInstance.setType(typeInstance);
                                    }
                                }
                            }
                            
                            JsonNode defaultDocumentsArray = siteConfigValue.get("defaultDocuments");
                            if (defaultDocumentsArray != null && defaultDocumentsArray instanceof NullNode == false) {
                                for (JsonNode defaultDocumentsValue : ((ArrayNode) defaultDocumentsArray)) {
                                    siteConfigInstance.getDefaultDocuments().add(defaultDocumentsValue.getTextValue());
                                }
                            }
                            
                            JsonNode detailedErrorLoggingEnabledValue = siteConfigValue.get("detailedErrorLoggingEnabled");
                            if (detailedErrorLoggingEnabledValue != null && detailedErrorLoggingEnabledValue instanceof NullNode == false) {
                                boolean detailedErrorLoggingEnabledInstance;
                                detailedErrorLoggingEnabledInstance = detailedErrorLoggingEnabledValue.getBooleanValue();
                                siteConfigInstance.setDetailedErrorLoggingEnabled(detailedErrorLoggingEnabledInstance);
                            }
                            
                            JsonNode documentRootValue = siteConfigValue.get("documentRoot");
                            if (documentRootValue != null && documentRootValue instanceof NullNode == false) {
                                String documentRootInstance;
                                documentRootInstance = documentRootValue.getTextValue();
                                siteConfigInstance.setDocumentRoot(documentRootInstance);
                            }
                            
                            JsonNode handlerMappingsArray = siteConfigValue.get("handlerMappings");
                            if (handlerMappingsArray != null && handlerMappingsArray instanceof NullNode == false) {
                                for (JsonNode handlerMappingsValue : ((ArrayNode) handlerMappingsArray)) {
                                    WebSiteConfiguration.HandlerMapping handlerMappingInstance = new WebSiteConfiguration.HandlerMapping();
                                    siteConfigInstance.getHandlerMappings().add(handlerMappingInstance);
                                    
                                    JsonNode argumentsValue = handlerMappingsValue.get("arguments");
                                    if (argumentsValue != null && argumentsValue instanceof NullNode == false) {
                                        String argumentsInstance;
                                        argumentsInstance = argumentsValue.getTextValue();
                                        handlerMappingInstance.setArguments(argumentsInstance);
                                    }
                                    
                                    JsonNode extensionValue = handlerMappingsValue.get("extension");
                                    if (extensionValue != null && extensionValue instanceof NullNode == false) {
                                        String extensionInstance;
                                        extensionInstance = extensionValue.getTextValue();
                                        handlerMappingInstance.setExtension(extensionInstance);
                                    }
                                    
                                    JsonNode scriptProcessorValue = handlerMappingsValue.get("scriptProcessor");
                                    if (scriptProcessorValue != null && scriptProcessorValue instanceof NullNode == false) {
                                        String scriptProcessorInstance;
                                        scriptProcessorInstance = scriptProcessorValue.getTextValue();
                                        handlerMappingInstance.setScriptProcessor(scriptProcessorInstance);
                                    }
                                }
                            }
                            
                            JsonNode httpLoggingEnabledValue = siteConfigValue.get("httpLoggingEnabled");
                            if (httpLoggingEnabledValue != null && httpLoggingEnabledValue instanceof NullNode == false) {
                                boolean httpLoggingEnabledInstance;
                                httpLoggingEnabledInstance = httpLoggingEnabledValue.getBooleanValue();
                                siteConfigInstance.setHttpLoggingEnabled(httpLoggingEnabledInstance);
                            }
                            
                            JsonNode logsDirectorySizeLimitValue = siteConfigValue.get("logsDirectorySizeLimit");
                            if (logsDirectorySizeLimitValue != null && logsDirectorySizeLimitValue instanceof NullNode == false) {
                                int logsDirectorySizeLimitInstance;
                                logsDirectorySizeLimitInstance = logsDirectorySizeLimitValue.getIntValue();
                                siteConfigInstance.setLogsDirectorySizeLimit(logsDirectorySizeLimitInstance);
                            }
                            
                            JsonNode managedPipelineModeValue = siteConfigValue.get("managedPipelineMode");
                            if (managedPipelineModeValue != null && managedPipelineModeValue instanceof NullNode == false) {
                                ManagedPipelineMode managedPipelineModeInstance;
                                managedPipelineModeInstance = Enum.valueOf(ManagedPipelineMode.class, managedPipelineModeValue.getTextValue());
                                siteConfigInstance.setManagedPipelineMode(managedPipelineModeInstance);
                            }
                            
                            JsonNode metadataSequenceElement2 = ((JsonNode) siteConfigValue.get("metadata"));
                            if (metadataSequenceElement2 != null && metadataSequenceElement2 instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr5 = metadataSequenceElement2.getFields();
                                while (itr5.hasNext()) {
                                    Map.Entry<String, JsonNode> property5 = itr5.next();
                                    String metadataKey2 = property5.getKey();
                                    String metadataValue2 = property5.getValue().getTextValue();
                                    siteConfigInstance.getMetadata().put(metadataKey2, metadataValue2);
                                }
                            }
                            
                            JsonNode netFrameworkVersionValue = siteConfigValue.get("netFrameworkVersion");
                            if (netFrameworkVersionValue != null && netFrameworkVersionValue instanceof NullNode == false) {
                                String netFrameworkVersionInstance;
                                netFrameworkVersionInstance = netFrameworkVersionValue.getTextValue();
                                siteConfigInstance.setNetFrameworkVersion(netFrameworkVersionInstance);
                            }
                            
                            JsonNode numberOfWorkersValue = siteConfigValue.get("numberOfWorkers");
                            if (numberOfWorkersValue != null && numberOfWorkersValue instanceof NullNode == false) {
                                int numberOfWorkersInstance;
                                numberOfWorkersInstance = numberOfWorkersValue.getIntValue();
                                siteConfigInstance.setNumberOfWorkers(numberOfWorkersInstance);
                            }
                            
                            JsonNode phpVersionValue = siteConfigValue.get("phpVersion");
                            if (phpVersionValue != null && phpVersionValue instanceof NullNode == false) {
                                String phpVersionInstance;
                                phpVersionInstance = phpVersionValue.getTextValue();
                                siteConfigInstance.setPhpVersion(phpVersionInstance);
                            }
                            
                            JsonNode pythonVersionValue = siteConfigValue.get("pythonVersion");
                            if (pythonVersionValue != null && pythonVersionValue instanceof NullNode == false) {
                                String pythonVersionInstance;
                                pythonVersionInstance = pythonVersionValue.getTextValue();
                                siteConfigInstance.setPythonVersion(pythonVersionInstance);
                            }
                            
                            JsonNode publishingPasswordValue = siteConfigValue.get("publishingPassword");
                            if (publishingPasswordValue != null && publishingPasswordValue instanceof NullNode == false) {
                                String publishingPasswordInstance;
                                publishingPasswordInstance = publishingPasswordValue.getTextValue();
                                siteConfigInstance.setPublishingPassword(publishingPasswordInstance);
                            }
                            
                            JsonNode publishingUsernameValue = siteConfigValue.get("publishingUsername");
                            if (publishingUsernameValue != null && publishingUsernameValue instanceof NullNode == false) {
                                String publishingUsernameInstance;
                                publishingUsernameInstance = publishingUsernameValue.getTextValue();
                                siteConfigInstance.setPublishingUserName(publishingUsernameInstance);
                            }
                            
                            JsonNode remoteDebuggingEnabledValue = siteConfigValue.get("RemoteDebuggingEnabled");
                            if (remoteDebuggingEnabledValue != null && remoteDebuggingEnabledValue instanceof NullNode == false) {
                                boolean remoteDebuggingEnabledInstance;
                                remoteDebuggingEnabledInstance = remoteDebuggingEnabledValue.getBooleanValue();
                                siteConfigInstance.setRemoteDebuggingEnabled(remoteDebuggingEnabledInstance);
                            }
                            
                            JsonNode remoteDebuggingVersionValue = siteConfigValue.get("remoteDebuggingVersion");
                            if (remoteDebuggingVersionValue != null && remoteDebuggingVersionValue instanceof NullNode == false) {
                                RemoteDebuggingVersion remoteDebuggingVersionInstance;
                                remoteDebuggingVersionInstance = Enum.valueOf(RemoteDebuggingVersion.class, remoteDebuggingVersionValue.getTextValue());
                                siteConfigInstance.setRemoteDebuggingVersion(remoteDebuggingVersionInstance);
                            }
                            
                            JsonNode requestTracingEnabledValue = siteConfigValue.get("requestTracingEnabled");
                            if (requestTracingEnabledValue != null && requestTracingEnabledValue instanceof NullNode == false) {
                                boolean requestTracingEnabledInstance;
                                requestTracingEnabledInstance = requestTracingEnabledValue.getBooleanValue();
                                siteConfigInstance.setRequestTracingEnabled(requestTracingEnabledInstance);
                            }
                            
                            JsonNode requestTracingExpirationTimeValue = siteConfigValue.get("requestTracingExpirationTime");
                            if (requestTracingExpirationTimeValue != null && requestTracingExpirationTimeValue instanceof NullNode == false) {
                                Calendar requestTracingExpirationTimeInstance;
                                requestTracingExpirationTimeInstance = DatatypeConverter.parseDateTime(requestTracingExpirationTimeValue.getTextValue());
                                siteConfigInstance.setRequestTracingExpirationTime(requestTracingExpirationTimeInstance);
                            }
                            
                            JsonNode scmTypeValue = siteConfigValue.get("scmType");
                            if (scmTypeValue != null && scmTypeValue instanceof NullNode == false) {
                                String scmTypeInstance;
                                scmTypeInstance = scmTypeValue.getTextValue();
                                siteConfigInstance.setScmType(scmTypeInstance);
                            }
                            
                            JsonNode autoSwapSlotNameValue = siteConfigValue.get("autoSwapSlotName");
                            if (autoSwapSlotNameValue != null && autoSwapSlotNameValue instanceof NullNode == false) {
                                String autoSwapSlotNameInstance;
                                autoSwapSlotNameInstance = autoSwapSlotNameValue.getTextValue();
                                siteConfigInstance.setAutoSwapSlotName(autoSwapSlotNameInstance);
                            }
                            
                            JsonNode use32BitWorkerProcessValue = siteConfigValue.get("use32BitWorkerProcess");
                            if (use32BitWorkerProcessValue != null && use32BitWorkerProcessValue instanceof NullNode == false) {
                                boolean use32BitWorkerProcessInstance;
                                use32BitWorkerProcessInstance = use32BitWorkerProcessValue.getBooleanValue();
                                siteConfigInstance.setUse32BitWorkerProcess(use32BitWorkerProcessInstance);
                            }
                            
                            JsonNode webSocketsEnabledValue = siteConfigValue.get("webSocketsEnabled");
                            if (webSocketsEnabledValue != null && webSocketsEnabledValue instanceof NullNode == false) {
                                boolean webSocketsEnabledInstance;
                                webSocketsEnabledInstance = webSocketsEnabledValue.getBooleanValue();
                                siteConfigInstance.setWebSocketsEnabled(webSocketsEnabledInstance);
                            }
                            
                            JsonNode limitsValue = siteConfigValue.get("limits");
                            if (limitsValue != null && limitsValue instanceof NullNode == false) {
                                SiteLimits limitsInstance = new SiteLimits();
                                siteConfigInstance.setLimits(limitsInstance);
                                
                                JsonNode maxPercentageCpuValue = limitsValue.get("maxPercentageCpu");
                                if (maxPercentageCpuValue != null && maxPercentageCpuValue instanceof NullNode == false) {
                                    double maxPercentageCpuInstance;
                                    maxPercentageCpuInstance = maxPercentageCpuValue.getDoubleValue();
                                    limitsInstance.setMaxPercentageCpu(maxPercentageCpuInstance);
                                }
                                
                                JsonNode maxMemoryInMbValue = limitsValue.get("maxMemoryInMb");
                                if (maxMemoryInMbValue != null && maxMemoryInMbValue instanceof NullNode == false) {
                                    long maxMemoryInMbInstance;
                                    maxMemoryInMbInstance = maxMemoryInMbValue.getLongValue();
                                    limitsInstance.setMaxMemoryInMb(maxMemoryInMbInstance);
                                }
                                
                                JsonNode maxDiskSizeInMbValue = limitsValue.get("maxDiskSizeInMb");
                                if (maxDiskSizeInMbValue != null && maxDiskSizeInMbValue instanceof NullNode == false) {
                                    long maxDiskSizeInMbInstance;
                                    maxDiskSizeInMbInstance = maxDiskSizeInMbValue.getLongValue();
                                    limitsInstance.setMaxDiskSizeInMb(maxDiskSizeInMbInstance);
                                }
                            }
                        }
                        
                        JsonNode stateValue = propertiesValue2.get("state");
                        if (stateValue != null && stateValue instanceof NullNode == false) {
                            WebSiteState stateInstance;
                            stateInstance = Enum.valueOf(WebSiteState.class, stateValue.getTextValue());
                            propertiesInstance.setState(stateInstance);
                        }
                        
                        JsonNode usageStateValue = propertiesValue2.get("usageState");
                        if (usageStateValue != null && usageStateValue instanceof NullNode == false) {
                            WebSiteUsageState usageStateInstance;
                            usageStateInstance = Enum.valueOf(WebSiteUsageState.class, usageStateValue.getTextValue());
                            propertiesInstance.setUsageState(usageStateInstance);
                        }
                        
                        JsonNode webSpaceValue = propertiesValue2.get("webSpace");
                        if (webSpaceValue != null && webSpaceValue instanceof NullNode == false) {
                            String webSpaceInstance;
                            webSpaceInstance = webSpaceValue.getTextValue();
                            propertiesInstance.setWebSpace(webSpaceInstance);
                        }
                        
                        JsonNode provisioningStateValue = propertiesValue2.get("provisioningState");
                        if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                            String provisioningStateInstance;
                            provisioningStateInstance = provisioningStateValue.getTextValue();
                            propertiesInstance.setProvisioningState(provisioningStateInstance);
                        }
                    }
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        webSiteInstance.setId(idInstance);
                    }
                    
                    JsonNode nameValue3 = responseDoc.get("name");
                    if (nameValue3 != null && nameValue3 instanceof NullNode == false) {
                        String nameInstance3;
                        nameInstance3 = nameValue3.getTextValue();
                        webSiteInstance.setName(nameInstance3);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        webSiteInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr6 = tagsSequenceElement.getFields();
                        while (itr6.hasNext()) {
                            Map.Entry<String, JsonNode> property6 = itr6.next();
                            String tagsKey2 = property6.getKey();
                            String tagsValue2 = property6.getValue().getTextValue();
                            webSiteInstance.getTags().put(tagsKey2, tagsValue2);
                        }
                    }
                    
                    JsonNode typeValue2 = responseDoc.get("type");
                    if (typeValue2 != null && typeValue2 instanceof NullNode == false) {
                        String typeInstance2;
                        typeInstance2 = typeValue2.getTextValue();
                        webSiteInstance.setType(typeInstance2);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * A web site repository is essentially a GIT repository that you can use to
    * manage your web site content. By using GIT source control tools, you can
    * push or pull version controlled changes to your site. You can create a
    * repository for your web site by issuing an HTTP POST request, or
    * retrieve information about the repository by using HTTP GET.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166967.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> createRepositoryAsync(final String resourceGroupName, final String webSiteName, final String slotName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return createRepository(resourceGroupName, webSiteName, slotName);
            }
         });
    }
    
    /**
    * A web site repository is essentially a GIT repository that you can use to
    * manage your web site content. By using GIT source control tools, you can
    * push or pull version controlled changes to your site. You can create a
    * repository for your web site by issuing an HTTP POST request, or
    * retrieve information about the repository by using HTTP GET.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166967.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse createRepository(String resourceGroupName, String webSiteName, String slotName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (webSiteName == null) {
            throw new NullPointerException("webSiteName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("webSiteName", webSiteName);
            tracingParameters.put("slotName", slotName);
            CloudTracing.enter(invocationId, this, "createRepositoryAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Web";
        url = url + "/";
        url = url + "sites";
        url = url + "/";
        url = url + URLEncoder.encode(webSiteName, "UTF-8");
        if (slotName != null) {
            url = url + "/slots/" + URLEncoder.encode(slotName, "UTF-8");
        }
        url = url + "/repository";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-06-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            // Deserialize Response
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Deletes the web site.
    *
    * @param resourceGroupName Required. The name of the resource group..
    * @param webSiteName Required. The name of the Web Site resource.
    * @param slotName Optional. The name of the slot.
    * @param parameters Required. The parameters to delete a web site.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> deleteAsync(final String resourceGroupName, final String webSiteName, final String slotName, final WebSiteDeleteParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return delete(resourceGroupName, webSiteName, slotName, parameters);
            }
         });
    }
    
    /**
    * Deletes the web site.
    *
    * @param resourceGroupName Required. The name of the resource group..
    * @param webSiteName Required. The name of the Web Site resource.
    * @param slotName Optional. The name of the slot.
    * @param parameters Required. The parameters to delete a web site.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse delete(String resourceGroupName, String webSiteName, String slotName, WebSiteDeleteParameters parameters) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (webSiteName == null) {
            throw new NullPointerException("webSiteName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("webSiteName", webSiteName);
            tracingParameters.put("slotName", slotName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "deleteAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Web";
        url = url + "/";
        url = url + "sites";
        url = url + "/";
        url = url + URLEncoder.encode(webSiteName, "UTF-8");
        if (slotName != null) {
            url = url + "/slots/" + URLEncoder.encode(slotName, "UTF-8");
        }
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-06-01");
        queryParameters.add("deleteEmptyServerFarm=" + URLEncoder.encode(Boolean.toString(parameters.isDeleteEmptyServerFarm()).toLowerCase(), "UTF-8"));
        queryParameters.add("deleteMetrics=" + URLEncoder.encode(Boolean.toString(parameters.isDeleteMetrics()).toLowerCase(), "UTF-8"));
        queryParameters.add("deleteAllSlots=" + URLEncoder.encode(Boolean.toString(parameters.isDeleteAllSlots()).toLowerCase(), "UTF-8"));
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            // Deserialize Response
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * A web site repository is essentially a GIT repository that you can use to
    * manage your web site content. By using GIT source control tools, you can
    * push or pull version controlled changes to your site. You can create a
    * repository for your web site by issuing an HTTP POST request, or
    * retrieve information about the repository by using HTTP GET.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166967.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @return The Delete Web Site Repository operation response.
    */
    @Override
    public Future<WebSiteDeleteRepositoryResponse> deleteRepositoryAsync(final String resourceGroupName, final String webSiteName, final String slotName) {
        return this.getClient().getExecutorService().submit(new Callable<WebSiteDeleteRepositoryResponse>() { 
            @Override
            public WebSiteDeleteRepositoryResponse call() throws Exception {
                return deleteRepository(resourceGroupName, webSiteName, slotName);
            }
         });
    }
    
    /**
    * A web site repository is essentially a GIT repository that you can use to
    * manage your web site content. By using GIT source control tools, you can
    * push or pull version controlled changes to your site. You can create a
    * repository for your web site by issuing an HTTP POST request, or
    * retrieve information about the repository by using HTTP GET.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166967.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The Delete Web Site Repository operation response.
    */
    @Override
    public WebSiteDeleteRepositoryResponse deleteRepository(String resourceGroupName, String webSiteName, String slotName) throws IOException, ServiceException, URISyntaxException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (webSiteName == null) {
            throw new NullPointerException("webSiteName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("webSiteName", webSiteName);
            tracingParameters.put("slotName", slotName);
            CloudTracing.enter(invocationId, this, "deleteRepositoryAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Web";
        url = url + "/";
        url = url + "sites";
        url = url + "/";
        url = url + URLEncoder.encode(webSiteName, "UTF-8");
        if (slotName != null) {
            url = url + "/slots/" + URLEncoder.encode(slotName, "UTF-8");
        }
        url = url + "/repository";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-06-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            WebSiteDeleteRepositoryResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new WebSiteDeleteRepositoryResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode uriValue = responseDoc.get("uri");
                    if (uriValue != null && uriValue instanceof NullNode == false) {
                        URI uriInstance;
                        uriInstance = new URI(uriValue.getTextValue());
                        result.setUri(uriInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Unlink source control from website
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @param repoUrl Required. The repository url.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> deleteSiteSourceControlAsync(final String resourceGroupName, final String webSiteName, final String slotName, final String repoUrl) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return deleteSiteSourceControl(resourceGroupName, webSiteName, slotName, repoUrl);
            }
         });
    }
    
    /**
    * Unlink source control from website
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @param repoUrl Required. The repository url.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse deleteSiteSourceControl(String resourceGroupName, String webSiteName, String slotName, String repoUrl) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (webSiteName == null) {
            throw new NullPointerException("webSiteName");
        }
        if (repoUrl == null) {
            throw new NullPointerException("repoUrl");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("webSiteName", webSiteName);
            tracingParameters.put("slotName", slotName);
            tracingParameters.put("repoUrl", repoUrl);
            CloudTracing.enter(invocationId, this, "deleteSiteSourceControlAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Web";
        url = url + "/";
        url = url + "sites";
        url = url + "/";
        url = url + URLEncoder.encode(webSiteName, "UTF-8");
        if (slotName != null) {
            url = url + "/slots/" + URLEncoder.encode(slotName, "UTF-8");
        }
        url = url + "/sourcecontrols/web";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-06-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            // Deserialize Response
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Scans a backup in a storage account and returns database information etc.
    * Should be called before calling Restore to discover what parameters are
    * needed for the restore operation. KNOWN BUG: This has to be called
    * against an exisingsite, otherwise will hit an error about non-existing
    * resource.
    *
    * @param resourceGroupName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @param restoreRequestEnvelope Required. A restore request.
    * @return The information gathered about a backup storaged in a storage
    * account.
    */
    @Override
    public Future<WebSiteRestoreDiscoverResponse> discoverAsync(final String resourceGroupName, final String webSiteName, final String slotName, final RestoreRequestEnvelope restoreRequestEnvelope) {
        return this.getClient().getExecutorService().submit(new Callable<WebSiteRestoreDiscoverResponse>() { 
            @Override
            public WebSiteRestoreDiscoverResponse call() throws Exception {
                return discover(resourceGroupName, webSiteName, slotName, restoreRequestEnvelope);
            }
         });
    }
    
    /**
    * Scans a backup in a storage account and returns database information etc.
    * Should be called before calling Restore to discover what parameters are
    * needed for the restore operation. KNOWN BUG: This has to be called
    * against an exisingsite, otherwise will hit an error about non-existing
    * resource.
    *
    * @param resourceGroupName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @param restoreRequestEnvelope Required. A restore request.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The information gathered about a backup storaged in a storage
    * account.
    */
    @Override
    public WebSiteRestoreDiscoverResponse discover(String resourceGroupName, String webSiteName, String slotName, RestoreRequestEnvelope restoreRequestEnvelope) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (webSiteName == null) {
            throw new NullPointerException("webSiteName");
        }
        if (restoreRequestEnvelope == null) {
            throw new NullPointerException("restoreRequestEnvelope");
        }
        if (restoreRequestEnvelope.getLocation() == null) {
            throw new NullPointerException("restoreRequestEnvelope.Location");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("webSiteName", webSiteName);
            tracingParameters.put("slotName", slotName);
            tracingParameters.put("restoreRequestEnvelope", restoreRequestEnvelope);
            CloudTracing.enter(invocationId, this, "discoverAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Web";
        url = url + "/";
        url = url + "sites";
        url = url + "/";
        url = url + URLEncoder.encode(webSiteName, "UTF-8");
        if (slotName != null) {
            url = url + "/slots/" + URLEncoder.encode(slotName, "UTF-8");
        }
        url = url + "/restore/discover";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-06-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        httpRequest.setHeader("x-ms-version", "2014-06-01");
        
        // Serialize Request
        String requestContent = null;
        JsonNode requestDoc = null;
        
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode restoreRequestEnvelopeValue = objectMapper.createObjectNode();
        requestDoc = restoreRequestEnvelopeValue;
        
        if (restoreRequestEnvelope.getRequest() != null) {
            ObjectNode propertiesValue = objectMapper.createObjectNode();
            ((ObjectNode) restoreRequestEnvelopeValue).put("properties", propertiesValue);
            
            ((ObjectNode) propertiesValue).put("AdjustConnectionStrings", restoreRequestEnvelope.getRequest().isAdjustConnectionStrings());
            
            if (restoreRequestEnvelope.getRequest().getBlobName() != null) {
                ((ObjectNode) propertiesValue).put("BlobName", restoreRequestEnvelope.getRequest().getBlobName());
            }
            
            if (restoreRequestEnvelope.getRequest().getDatabases() != null) {
                if (restoreRequestEnvelope.getRequest().getDatabases() instanceof LazyCollection == false || ((LazyCollection) restoreRequestEnvelope.getRequest().getDatabases()).isInitialized()) {
                    ArrayNode databasesArray = objectMapper.createArrayNode();
                    for (DatabaseBackupSetting databasesItem : restoreRequestEnvelope.getRequest().getDatabases()) {
                        ObjectNode databaseBackupSettingValue = objectMapper.createObjectNode();
                        databasesArray.add(databaseBackupSettingValue);
                        
                        if (databasesItem.getConnectionString() != null) {
                            ((ObjectNode) databaseBackupSettingValue).put("connectionString", databasesItem.getConnectionString());
                        }
                        
                        if (databasesItem.getConnectionStringName() != null) {
                            ((ObjectNode) databaseBackupSettingValue).put("connectionStringName", databasesItem.getConnectionStringName());
                        }
                        
                        if (databasesItem.getDatabaseType() != null) {
                            ((ObjectNode) databaseBackupSettingValue).put("databaseType", databasesItem.getDatabaseType());
                        }
                        
                        if (databasesItem.getName() != null) {
                            ((ObjectNode) databaseBackupSettingValue).put("name", databasesItem.getName());
                        }
                    }
                    ((ObjectNode) propertiesValue).put("Databases", databasesArray);
                }
            }
            
            ((ObjectNode) propertiesValue).put("IgnoreConflictingHostNames", restoreRequestEnvelope.getRequest().isIgnoreConflictingHostNames());
            
            ((ObjectNode) propertiesValue).put("Overwrite", restoreRequestEnvelope.getRequest().isOverwrite());
            
            if (restoreRequestEnvelope.getRequest().getStorageAccountUrl() != null) {
                ((ObjectNode) propertiesValue).put("StorageAccountUrl", restoreRequestEnvelope.getRequest().getStorageAccountUrl());
            }
        }
        
        if (restoreRequestEnvelope.getId() != null) {
            ((ObjectNode) restoreRequestEnvelopeValue).put("id", restoreRequestEnvelope.getId());
        }
        
        if (restoreRequestEnvelope.getName() != null) {
            ((ObjectNode) restoreRequestEnvelopeValue).put("name", restoreRequestEnvelope.getName());
        }
        
        ((ObjectNode) restoreRequestEnvelopeValue).put("location", restoreRequestEnvelope.getLocation());
        
        if (restoreRequestEnvelope.getTags() != null) {
            ObjectNode tagsDictionary = objectMapper.createObjectNode();
            for (Map.Entry<String, String> entry : restoreRequestEnvelope.getTags().entrySet()) {
                String tagsKey = entry.getKey();
                String tagsValue = entry.getValue();
                ((ObjectNode) tagsDictionary).put(tagsKey, tagsValue);
            }
            ((ObjectNode) restoreRequestEnvelopeValue).put("tags", tagsDictionary);
        }
        
        if (restoreRequestEnvelope.getType() != null) {
            ((ObjectNode) restoreRequestEnvelopeValue).put("type", restoreRequestEnvelope.getType());
        }
        
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue(stringWriter, requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            WebSiteRestoreDiscoverResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new WebSiteRestoreDiscoverResponse();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    WebSiteRestoreDiscover envelopeInstance = new WebSiteRestoreDiscover();
                    result.setEnvelope(envelopeInstance);
                    
                    JsonNode propertiesValue2 = responseDoc.get("properties");
                    if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                        WebSiteRestoreDiscoverProperties propertiesInstance = new WebSiteRestoreDiscoverProperties();
                        envelopeInstance.setProperties(propertiesInstance);
                        
                        JsonNode storageAccountUrlValue = propertiesValue2.get("storageAccountUrl");
                        if (storageAccountUrlValue != null && storageAccountUrlValue instanceof NullNode == false) {
                            String storageAccountUrlInstance;
                            storageAccountUrlInstance = storageAccountUrlValue.getTextValue();
                            propertiesInstance.setStorageAccountUrl(storageAccountUrlInstance);
                        }
                        
                        JsonNode blobNameValue = propertiesValue2.get("blobName");
                        if (blobNameValue != null && blobNameValue instanceof NullNode == false) {
                            String blobNameInstance;
                            blobNameInstance = blobNameValue.getTextValue();
                            propertiesInstance.setBlobName(blobNameInstance);
                        }
                        
                        JsonNode overwriteValue = propertiesValue2.get("overwrite");
                        if (overwriteValue != null && overwriteValue instanceof NullNode == false) {
                            boolean overwriteInstance;
                            overwriteInstance = overwriteValue.getBooleanValue();
                            propertiesInstance.setOverwrite(overwriteInstance);
                        }
                        
                        JsonNode databasesArray2 = propertiesValue2.get("databases");
                        if (databasesArray2 != null && databasesArray2 instanceof NullNode == false) {
                            for (JsonNode databasesValue : ((ArrayNode) databasesArray2)) {
                                DatabaseBackupSetting databaseBackupSettingInstance = new DatabaseBackupSetting();
                                propertiesInstance.getDatabases().add(databaseBackupSettingInstance);
                                
                                JsonNode connectionStringValue = databasesValue.get("connectionString");
                                if (connectionStringValue != null && connectionStringValue instanceof NullNode == false) {
                                    String connectionStringInstance;
                                    connectionStringInstance = connectionStringValue.getTextValue();
                                    databaseBackupSettingInstance.setConnectionString(connectionStringInstance);
                                }
                                
                                JsonNode connectionStringNameValue = databasesValue.get("connectionStringName");
                                if (connectionStringNameValue != null && connectionStringNameValue instanceof NullNode == false) {
                                    String connectionStringNameInstance;
                                    connectionStringNameInstance = connectionStringNameValue.getTextValue();
                                    databaseBackupSettingInstance.setConnectionStringName(connectionStringNameInstance);
                                }
                                
                                JsonNode databaseTypeValue = databasesValue.get("databaseType");
                                if (databaseTypeValue != null && databaseTypeValue instanceof NullNode == false) {
                                    String databaseTypeInstance;
                                    databaseTypeInstance = databaseTypeValue.getTextValue();
                                    databaseBackupSettingInstance.setDatabaseType(databaseTypeInstance);
                                }
                                
                                JsonNode nameValue = databasesValue.get("name");
                                if (nameValue != null && nameValue instanceof NullNode == false) {
                                    String nameInstance;
                                    nameInstance = nameValue.getTextValue();
                                    databaseBackupSettingInstance.setName(nameInstance);
                                }
                            }
                        }
                        
                        JsonNode ignoreConflictingHostNamesValue = propertiesValue2.get("ignoreConflictingHostNames");
                        if (ignoreConflictingHostNamesValue != null && ignoreConflictingHostNamesValue instanceof NullNode == false) {
                            boolean ignoreConflictingHostNamesInstance;
                            ignoreConflictingHostNamesInstance = ignoreConflictingHostNamesValue.getBooleanValue();
                            propertiesInstance.setIgnoreConflictingHostNames(ignoreConflictingHostNamesInstance);
                        }
                        
                        JsonNode adjustConnectionStringsValue = propertiesValue2.get("adjustConnectionStrings");
                        if (adjustConnectionStringsValue != null && adjustConnectionStringsValue instanceof NullNode == false) {
                            boolean adjustConnectionStringsInstance;
                            adjustConnectionStringsInstance = adjustConnectionStringsValue.getBooleanValue();
                            propertiesInstance.setAdjustConnectionStrings(adjustConnectionStringsInstance);
                        }
                    }
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        envelopeInstance.setId(idInstance);
                    }
                    
                    JsonNode nameValue2 = responseDoc.get("name");
                    if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                        String nameInstance2;
                        nameInstance2 = nameValue2.getTextValue();
                        envelopeInstance.setName(nameInstance2);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        envelopeInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry<String, JsonNode> property = itr.next();
                            String tagsKey2 = property.getKey();
                            String tagsValue2 = property.getValue().getTextValue();
                            envelopeInstance.getTags().put(tagsKey2, tagsValue2);
                        }
                    }
                    
                    JsonNode typeValue = responseDoc.get("type");
                    if (typeValue != null && typeValue instanceof NullNode == false) {
                        String typeInstance;
                        typeInstance = typeValue.getTextValue();
                        envelopeInstance.setType(typeInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * You can generate a new random password for publishing a site by issuing
    * an HTTP POST request.  Tip: If you want to verify that the publish
    * password has changed, call HTTP GET on /publishxml before calling
    * /newpassword. In the publish XML, note the hash value in the userPWD
    * attribute. After calling /newpassword, call /publishxml again. You can
    * then compare the new value of userPWD in the Publish XML with the one
    * you noted earlier.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn236428.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> generatePasswordAsync(final String resourceGroupName, final String webSiteName, final String slotName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return generatePassword(resourceGroupName, webSiteName, slotName);
            }
         });
    }
    
    /**
    * You can generate a new random password for publishing a site by issuing
    * an HTTP POST request.  Tip: If you want to verify that the publish
    * password has changed, call HTTP GET on /publishxml before calling
    * /newpassword. In the publish XML, note the hash value in the userPWD
    * attribute. After calling /newpassword, call /publishxml again. You can
    * then compare the new value of userPWD in the Publish XML with the one
    * you noted earlier.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn236428.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse generatePassword(String resourceGroupName, String webSiteName, String slotName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (webSiteName == null) {
            throw new NullPointerException("webSiteName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("webSiteName", webSiteName);
            tracingParameters.put("slotName", slotName);
            CloudTracing.enter(invocationId, this, "generatePasswordAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Web";
        url = url + "/";
        url = url + "sites";
        url = url + "/";
        url = url + URLEncoder.encode(webSiteName, "UTF-8");
        if (slotName != null) {
            url = url + "/slots/" + URLEncoder.encode(slotName, "UTF-8");
        }
        url = url + "/newPassword";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-06-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            // Deserialize Response
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * You can retrieve details for a web site by issuing an HTTP GET request.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/dn167007.aspx
    * for more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @param parameters Optional. Additional parameters.
    * @return The Get Web Site Details operation response.
    */
    @Override
    public Future<WebSiteGetResponse> getAsync(final String resourceGroupName, final String webSiteName, final String slotName, final WebSiteGetParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<WebSiteGetResponse>() { 
            @Override
            public WebSiteGetResponse call() throws Exception {
                return get(resourceGroupName, webSiteName, slotName, parameters);
            }
         });
    }
    
    /**
    * You can retrieve details for a web site by issuing an HTTP GET request.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/dn167007.aspx
    * for more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @param parameters Optional. Additional parameters.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The Get Web Site Details operation response.
    */
    @Override
    public WebSiteGetResponse get(String resourceGroupName, String webSiteName, String slotName, WebSiteGetParameters parameters) throws IOException, ServiceException, URISyntaxException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (webSiteName == null) {
            throw new NullPointerException("webSiteName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("webSiteName", webSiteName);
            tracingParameters.put("slotName", slotName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "getAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Web";
        url = url + "/";
        url = url + "sites";
        url = url + "/";
        url = url + URLEncoder.encode(webSiteName, "UTF-8");
        if (slotName != null) {
            url = url + "/slots/" + URLEncoder.encode(slotName, "UTF-8");
        }
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-06-01");
        if (parameters != null && parameters.getPropertiesToInclude() != null && parameters.getPropertiesToInclude().size() > 0) {
            queryParameters.add("propertiesToInclude=" + URLEncoder.encode(CollectionStringBuilder.join(parameters.getPropertiesToInclude(), ","), "UTF-8"));
        }
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            WebSiteGetResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new WebSiteGetResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    WebSite webSiteInstance = new WebSite();
                    result.setWebSite(webSiteInstance);
                    
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                        WebSiteProperties propertiesInstance = new WebSiteProperties();
                        webSiteInstance.setProperties(propertiesInstance);
                        
                        JsonNode adminEnabledValue = propertiesValue.get("adminEnabled");
                        if (adminEnabledValue != null && adminEnabledValue instanceof NullNode == false) {
                            boolean adminEnabledInstance;
                            adminEnabledInstance = adminEnabledValue.getBooleanValue();
                            propertiesInstance.setAdminEnabled(adminEnabledInstance);
                        }
                        
                        JsonNode availabilityStateValue = propertiesValue.get("availabilityState");
                        if (availabilityStateValue != null && availabilityStateValue instanceof NullNode == false) {
                            WebSpaceAvailabilityState availabilityStateInstance;
                            availabilityStateInstance = Enum.valueOf(WebSpaceAvailabilityState.class, availabilityStateValue.getTextValue());
                            propertiesInstance.setAvailabilityState(availabilityStateInstance);
                        }
                        
                        JsonNode enabledValue = propertiesValue.get("enabled");
                        if (enabledValue != null && enabledValue instanceof NullNode == false) {
                            boolean enabledInstance;
                            enabledInstance = enabledValue.getBooleanValue();
                            propertiesInstance.setEnabled(enabledInstance);
                        }
                        
                        JsonNode enabledHostNamesArray = propertiesValue.get("enabledHostNames");
                        if (enabledHostNamesArray != null && enabledHostNamesArray instanceof NullNode == false) {
                            for (JsonNode enabledHostNamesValue : ((ArrayNode) enabledHostNamesArray)) {
                                propertiesInstance.getEnabledHostNames().add(enabledHostNamesValue.getTextValue());
                            }
                        }
                        
                        JsonNode hostNameSslStatesArray = propertiesValue.get("hostNameSslStates");
                        if (hostNameSslStatesArray != null && hostNameSslStatesArray instanceof NullNode == false) {
                            for (JsonNode hostNameSslStatesValue : ((ArrayNode) hostNameSslStatesArray)) {
                                WebSiteProperties.WebSiteHostNameSslState webSiteHostNameSslStateInstance = new WebSiteProperties.WebSiteHostNameSslState();
                                propertiesInstance.getHostNameSslStates().add(webSiteHostNameSslStateInstance);
                                
                                JsonNode nameValue = hostNameSslStatesValue.get("name");
                                if (nameValue != null && nameValue instanceof NullNode == false) {
                                    String nameInstance;
                                    nameInstance = nameValue.getTextValue();
                                    webSiteHostNameSslStateInstance.setName(nameInstance);
                                }
                                
                                JsonNode sslStateValue = hostNameSslStatesValue.get("sslState");
                                if (sslStateValue != null && sslStateValue instanceof NullNode == false) {
                                    WebSiteSslState sslStateInstance;
                                    sslStateInstance = Enum.valueOf(WebSiteSslState.class, sslStateValue.getTextValue());
                                    webSiteHostNameSslStateInstance.setSslState(sslStateInstance);
                                }
                                
                                JsonNode thumbprintValue = hostNameSslStatesValue.get("thumbprint");
                                if (thumbprintValue != null && thumbprintValue instanceof NullNode == false) {
                                    String thumbprintInstance;
                                    thumbprintInstance = thumbprintValue.getTextValue();
                                    webSiteHostNameSslStateInstance.setThumbprint(thumbprintInstance);
                                }
                                
                                JsonNode virtualIPValue = hostNameSslStatesValue.get("virtualIP");
                                if (virtualIPValue != null && virtualIPValue instanceof NullNode == false) {
                                    InetAddress virtualIPInstance;
                                    virtualIPInstance = InetAddress.getByName(virtualIPValue.getTextValue());
                                    webSiteHostNameSslStateInstance.setVirtualIP(virtualIPInstance);
                                }
                                
                                JsonNode ipBasedSslResultValue = hostNameSslStatesValue.get("ipBasedSslResult");
                                if (ipBasedSslResultValue != null && ipBasedSslResultValue instanceof NullNode == false) {
                                    String ipBasedSslResultInstance;
                                    ipBasedSslResultInstance = ipBasedSslResultValue.getTextValue();
                                    webSiteHostNameSslStateInstance.setIpBasedSslResult(ipBasedSslResultInstance);
                                }
                                
                                JsonNode toUpdateValue = hostNameSslStatesValue.get("toUpdate");
                                if (toUpdateValue != null && toUpdateValue instanceof NullNode == false) {
                                    boolean toUpdateInstance;
                                    toUpdateInstance = toUpdateValue.getBooleanValue();
                                    webSiteHostNameSslStateInstance.setToUpdate(toUpdateInstance);
                                }
                                
                                JsonNode toUpdateIpBasedSslValue = hostNameSslStatesValue.get("toUpdateIpBasedSsl");
                                if (toUpdateIpBasedSslValue != null && toUpdateIpBasedSslValue instanceof NullNode == false) {
                                    boolean toUpdateIpBasedSslInstance;
                                    toUpdateIpBasedSslInstance = toUpdateIpBasedSslValue.getBooleanValue();
                                    webSiteHostNameSslStateInstance.setToUpdateIpBasedSsl(toUpdateIpBasedSslInstance);
                                }
                                
                                JsonNode hostTypeValue = hostNameSslStatesValue.get("hostType");
                                if (hostTypeValue != null && hostTypeValue instanceof NullNode == false) {
                                    HostType hostTypeInstance;
                                    hostTypeInstance = Enum.valueOf(HostType.class, hostTypeValue.getTextValue());
                                    webSiteHostNameSslStateInstance.setHostType(hostTypeInstance);
                                }
                            }
                        }
                        
                        JsonNode hostNamesArray = propertiesValue.get("hostNames");
                        if (hostNamesArray != null && hostNamesArray instanceof NullNode == false) {
                            for (JsonNode hostNamesValue : ((ArrayNode) hostNamesArray)) {
                                propertiesInstance.getHostNames().add(hostNamesValue.getTextValue());
                            }
                        }
                        
                        JsonNode lastModifiedTimeUtcValue = propertiesValue.get("lastModifiedTimeUtc");
                        if (lastModifiedTimeUtcValue != null && lastModifiedTimeUtcValue instanceof NullNode == false) {
                            Calendar lastModifiedTimeUtcInstance;
                            lastModifiedTimeUtcInstance = DatatypeConverter.parseDateTime(lastModifiedTimeUtcValue.getTextValue());
                            propertiesInstance.setLastModifiedTimeUtc(lastModifiedTimeUtcInstance);
                        }
                        
                        JsonNode repositorySiteNameValue = propertiesValue.get("repositorySiteName");
                        if (repositorySiteNameValue != null && repositorySiteNameValue instanceof NullNode == false) {
                            String repositorySiteNameInstance;
                            repositorySiteNameInstance = repositorySiteNameValue.getTextValue();
                            propertiesInstance.setRepositorySiteName(repositorySiteNameInstance);
                        }
                        
                        JsonNode runtimeAvailabilityStateValue = propertiesValue.get("runtimeAvailabilityState");
                        if (runtimeAvailabilityStateValue != null && runtimeAvailabilityStateValue instanceof NullNode == false) {
                            WebSiteRuntimeAvailabilityState runtimeAvailabilityStateInstance;
                            runtimeAvailabilityStateInstance = Enum.valueOf(WebSiteRuntimeAvailabilityState.class, runtimeAvailabilityStateValue.getTextValue());
                            propertiesInstance.setRuntimeAvailabilityState(runtimeAvailabilityStateInstance);
                        }
                        
                        JsonNode trafficManagerHostNamesArray = propertiesValue.get("trafficManagerHostNames");
                        if (trafficManagerHostNamesArray != null && trafficManagerHostNamesArray instanceof NullNode == false) {
                            for (JsonNode trafficManagerHostNamesValue : ((ArrayNode) trafficManagerHostNamesArray)) {
                                propertiesInstance.getTrafficManagerHostNames().add(trafficManagerHostNamesValue.getTextValue());
                            }
                        }
                        
                        JsonNode selfLinkValue = propertiesValue.get("selfLink");
                        if (selfLinkValue != null && selfLinkValue instanceof NullNode == false) {
                            URI selfLinkInstance;
                            selfLinkInstance = new URI(selfLinkValue.getTextValue());
                            propertiesInstance.setUri(selfLinkInstance);
                        }
                        
                        JsonNode serverFarmValue = propertiesValue.get("serverFarm");
                        if (serverFarmValue != null && serverFarmValue instanceof NullNode == false) {
                            String serverFarmInstance;
                            serverFarmInstance = serverFarmValue.getTextValue();
                            propertiesInstance.setServerFarm(serverFarmInstance);
                        }
                        
                        JsonNode serverFarmIdValue = propertiesValue.get("serverFarmId");
                        if (serverFarmIdValue != null && serverFarmIdValue instanceof NullNode == false) {
                            String serverFarmIdInstance;
                            serverFarmIdInstance = serverFarmIdValue.getTextValue();
                            propertiesInstance.setServerFarmId(serverFarmIdInstance);
                        }
                        
                        JsonNode skuValue = propertiesValue.get("sku");
                        if (skuValue != null && skuValue instanceof NullNode == false) {
                            SkuOptions skuInstance;
                            skuInstance = Enum.valueOf(SkuOptions.class, skuValue.getTextValue());
                            propertiesInstance.setSku(skuInstance);
                        }
                        
                        JsonNode sitePropertiesValue = propertiesValue.get("siteProperties");
                        if (sitePropertiesValue != null && sitePropertiesValue instanceof NullNode == false) {
                            WebSiteProperties.SiteProperties sitePropertiesInstance = new WebSiteProperties.SiteProperties();
                            propertiesInstance.setProperties(sitePropertiesInstance);
                            
                            JsonNode appSettingsSequenceElement = ((JsonNode) sitePropertiesValue.get("appSettings"));
                            if (appSettingsSequenceElement != null && appSettingsSequenceElement instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr = appSettingsSequenceElement.getFields();
                                while (itr.hasNext()) {
                                    Map.Entry<String, JsonNode> property = itr.next();
                                    String appSettingsKey = property.getKey();
                                    String appSettingsValue = property.getValue().getTextValue();
                                    sitePropertiesInstance.getAppSettings().put(appSettingsKey, appSettingsValue);
                                }
                            }
                            
                            JsonNode metadataSequenceElement = ((JsonNode) sitePropertiesValue.get("metadata"));
                            if (metadataSequenceElement != null && metadataSequenceElement instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr2 = metadataSequenceElement.getFields();
                                while (itr2.hasNext()) {
                                    Map.Entry<String, JsonNode> property2 = itr2.next();
                                    String metadataKey = property2.getKey();
                                    String metadataValue = property2.getValue().getTextValue();
                                    sitePropertiesInstance.getMetadata().put(metadataKey, metadataValue);
                                }
                            }
                            
                            JsonNode propertiesSequenceElement = ((JsonNode) sitePropertiesValue.get("properties"));
                            if (propertiesSequenceElement != null && propertiesSequenceElement instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr3 = propertiesSequenceElement.getFields();
                                while (itr3.hasNext()) {
                                    Map.Entry<String, JsonNode> property3 = itr3.next();
                                    String propertiesKey = property3.getKey();
                                    String propertiesValue2 = property3.getValue().getTextValue();
                                    sitePropertiesInstance.getProperties().put(propertiesKey, propertiesValue2);
                                }
                            }
                        }
                        
                        JsonNode siteConfigValue = propertiesValue.get("siteConfig");
                        if (siteConfigValue != null && siteConfigValue instanceof NullNode == false) {
                            WebSiteConfiguration siteConfigInstance = new WebSiteConfiguration();
                            propertiesInstance.setSiteConfig(siteConfigInstance);
                            
                            JsonNode appSettingsSequenceElement2 = ((JsonNode) siteConfigValue.get("appSettings"));
                            if (appSettingsSequenceElement2 != null && appSettingsSequenceElement2 instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr4 = appSettingsSequenceElement2.getFields();
                                while (itr4.hasNext()) {
                                    Map.Entry<String, JsonNode> property4 = itr4.next();
                                    String appSettingsKey2 = property4.getKey();
                                    String appSettingsValue2 = property4.getValue().getTextValue();
                                    siteConfigInstance.getAppSettings().put(appSettingsKey2, appSettingsValue2);
                                }
                            }
                            
                            JsonNode connectionStringsArray = siteConfigValue.get("connectionStrings");
                            if (connectionStringsArray != null && connectionStringsArray instanceof NullNode == false) {
                                for (JsonNode connectionStringsValue : ((ArrayNode) connectionStringsArray)) {
                                    ConnectionStringInfo connStringInfoInstance = new ConnectionStringInfo();
                                    siteConfigInstance.getConnectionStrings().add(connStringInfoInstance);
                                    
                                    JsonNode connectionStringValue = connectionStringsValue.get("connectionString");
                                    if (connectionStringValue != null && connectionStringValue instanceof NullNode == false) {
                                        String connectionStringInstance;
                                        connectionStringInstance = connectionStringValue.getTextValue();
                                        connStringInfoInstance.setConnectionString(connectionStringInstance);
                                    }
                                    
                                    JsonNode nameValue2 = connectionStringsValue.get("name");
                                    if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                                        String nameInstance2;
                                        nameInstance2 = nameValue2.getTextValue();
                                        connStringInfoInstance.setName(nameInstance2);
                                    }
                                    
                                    JsonNode typeValue = connectionStringsValue.get("type");
                                    if (typeValue != null && typeValue instanceof NullNode == false) {
                                        DatabaseServerType typeInstance;
                                        typeInstance = Enum.valueOf(DatabaseServerType.class, typeValue.getTextValue());
                                        connStringInfoInstance.setType(typeInstance);
                                    }
                                }
                            }
                            
                            JsonNode defaultDocumentsArray = siteConfigValue.get("defaultDocuments");
                            if (defaultDocumentsArray != null && defaultDocumentsArray instanceof NullNode == false) {
                                for (JsonNode defaultDocumentsValue : ((ArrayNode) defaultDocumentsArray)) {
                                    siteConfigInstance.getDefaultDocuments().add(defaultDocumentsValue.getTextValue());
                                }
                            }
                            
                            JsonNode detailedErrorLoggingEnabledValue = siteConfigValue.get("detailedErrorLoggingEnabled");
                            if (detailedErrorLoggingEnabledValue != null && detailedErrorLoggingEnabledValue instanceof NullNode == false) {
                                boolean detailedErrorLoggingEnabledInstance;
                                detailedErrorLoggingEnabledInstance = detailedErrorLoggingEnabledValue.getBooleanValue();
                                siteConfigInstance.setDetailedErrorLoggingEnabled(detailedErrorLoggingEnabledInstance);
                            }
                            
                            JsonNode documentRootValue = siteConfigValue.get("documentRoot");
                            if (documentRootValue != null && documentRootValue instanceof NullNode == false) {
                                String documentRootInstance;
                                documentRootInstance = documentRootValue.getTextValue();
                                siteConfigInstance.setDocumentRoot(documentRootInstance);
                            }
                            
                            JsonNode handlerMappingsArray = siteConfigValue.get("handlerMappings");
                            if (handlerMappingsArray != null && handlerMappingsArray instanceof NullNode == false) {
                                for (JsonNode handlerMappingsValue : ((ArrayNode) handlerMappingsArray)) {
                                    WebSiteConfiguration.HandlerMapping handlerMappingInstance = new WebSiteConfiguration.HandlerMapping();
                                    siteConfigInstance.getHandlerMappings().add(handlerMappingInstance);
                                    
                                    JsonNode argumentsValue = handlerMappingsValue.get("arguments");
                                    if (argumentsValue != null && argumentsValue instanceof NullNode == false) {
                                        String argumentsInstance;
                                        argumentsInstance = argumentsValue.getTextValue();
                                        handlerMappingInstance.setArguments(argumentsInstance);
                                    }
                                    
                                    JsonNode extensionValue = handlerMappingsValue.get("extension");
                                    if (extensionValue != null && extensionValue instanceof NullNode == false) {
                                        String extensionInstance;
                                        extensionInstance = extensionValue.getTextValue();
                                        handlerMappingInstance.setExtension(extensionInstance);
                                    }
                                    
                                    JsonNode scriptProcessorValue = handlerMappingsValue.get("scriptProcessor");
                                    if (scriptProcessorValue != null && scriptProcessorValue instanceof NullNode == false) {
                                        String scriptProcessorInstance;
                                        scriptProcessorInstance = scriptProcessorValue.getTextValue();
                                        handlerMappingInstance.setScriptProcessor(scriptProcessorInstance);
                                    }
                                }
                            }
                            
                            JsonNode httpLoggingEnabledValue = siteConfigValue.get("httpLoggingEnabled");
                            if (httpLoggingEnabledValue != null && httpLoggingEnabledValue instanceof NullNode == false) {
                                boolean httpLoggingEnabledInstance;
                                httpLoggingEnabledInstance = httpLoggingEnabledValue.getBooleanValue();
                                siteConfigInstance.setHttpLoggingEnabled(httpLoggingEnabledInstance);
                            }
                            
                            JsonNode logsDirectorySizeLimitValue = siteConfigValue.get("logsDirectorySizeLimit");
                            if (logsDirectorySizeLimitValue != null && logsDirectorySizeLimitValue instanceof NullNode == false) {
                                int logsDirectorySizeLimitInstance;
                                logsDirectorySizeLimitInstance = logsDirectorySizeLimitValue.getIntValue();
                                siteConfigInstance.setLogsDirectorySizeLimit(logsDirectorySizeLimitInstance);
                            }
                            
                            JsonNode managedPipelineModeValue = siteConfigValue.get("managedPipelineMode");
                            if (managedPipelineModeValue != null && managedPipelineModeValue instanceof NullNode == false) {
                                ManagedPipelineMode managedPipelineModeInstance;
                                managedPipelineModeInstance = Enum.valueOf(ManagedPipelineMode.class, managedPipelineModeValue.getTextValue());
                                siteConfigInstance.setManagedPipelineMode(managedPipelineModeInstance);
                            }
                            
                            JsonNode metadataSequenceElement2 = ((JsonNode) siteConfigValue.get("metadata"));
                            if (metadataSequenceElement2 != null && metadataSequenceElement2 instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr5 = metadataSequenceElement2.getFields();
                                while (itr5.hasNext()) {
                                    Map.Entry<String, JsonNode> property5 = itr5.next();
                                    String metadataKey2 = property5.getKey();
                                    String metadataValue2 = property5.getValue().getTextValue();
                                    siteConfigInstance.getMetadata().put(metadataKey2, metadataValue2);
                                }
                            }
                            
                            JsonNode netFrameworkVersionValue = siteConfigValue.get("netFrameworkVersion");
                            if (netFrameworkVersionValue != null && netFrameworkVersionValue instanceof NullNode == false) {
                                String netFrameworkVersionInstance;
                                netFrameworkVersionInstance = netFrameworkVersionValue.getTextValue();
                                siteConfigInstance.setNetFrameworkVersion(netFrameworkVersionInstance);
                            }
                            
                            JsonNode numberOfWorkersValue = siteConfigValue.get("numberOfWorkers");
                            if (numberOfWorkersValue != null && numberOfWorkersValue instanceof NullNode == false) {
                                int numberOfWorkersInstance;
                                numberOfWorkersInstance = numberOfWorkersValue.getIntValue();
                                siteConfigInstance.setNumberOfWorkers(numberOfWorkersInstance);
                            }
                            
                            JsonNode phpVersionValue = siteConfigValue.get("phpVersion");
                            if (phpVersionValue != null && phpVersionValue instanceof NullNode == false) {
                                String phpVersionInstance;
                                phpVersionInstance = phpVersionValue.getTextValue();
                                siteConfigInstance.setPhpVersion(phpVersionInstance);
                            }
                            
                            JsonNode pythonVersionValue = siteConfigValue.get("pythonVersion");
                            if (pythonVersionValue != null && pythonVersionValue instanceof NullNode == false) {
                                String pythonVersionInstance;
                                pythonVersionInstance = pythonVersionValue.getTextValue();
                                siteConfigInstance.setPythonVersion(pythonVersionInstance);
                            }
                            
                            JsonNode publishingPasswordValue = siteConfigValue.get("publishingPassword");
                            if (publishingPasswordValue != null && publishingPasswordValue instanceof NullNode == false) {
                                String publishingPasswordInstance;
                                publishingPasswordInstance = publishingPasswordValue.getTextValue();
                                siteConfigInstance.setPublishingPassword(publishingPasswordInstance);
                            }
                            
                            JsonNode publishingUsernameValue = siteConfigValue.get("publishingUsername");
                            if (publishingUsernameValue != null && publishingUsernameValue instanceof NullNode == false) {
                                String publishingUsernameInstance;
                                publishingUsernameInstance = publishingUsernameValue.getTextValue();
                                siteConfigInstance.setPublishingUserName(publishingUsernameInstance);
                            }
                            
                            JsonNode remoteDebuggingEnabledValue = siteConfigValue.get("RemoteDebuggingEnabled");
                            if (remoteDebuggingEnabledValue != null && remoteDebuggingEnabledValue instanceof NullNode == false) {
                                boolean remoteDebuggingEnabledInstance;
                                remoteDebuggingEnabledInstance = remoteDebuggingEnabledValue.getBooleanValue();
                                siteConfigInstance.setRemoteDebuggingEnabled(remoteDebuggingEnabledInstance);
                            }
                            
                            JsonNode remoteDebuggingVersionValue = siteConfigValue.get("remoteDebuggingVersion");
                            if (remoteDebuggingVersionValue != null && remoteDebuggingVersionValue instanceof NullNode == false) {
                                RemoteDebuggingVersion remoteDebuggingVersionInstance;
                                remoteDebuggingVersionInstance = Enum.valueOf(RemoteDebuggingVersion.class, remoteDebuggingVersionValue.getTextValue());
                                siteConfigInstance.setRemoteDebuggingVersion(remoteDebuggingVersionInstance);
                            }
                            
                            JsonNode requestTracingEnabledValue = siteConfigValue.get("requestTracingEnabled");
                            if (requestTracingEnabledValue != null && requestTracingEnabledValue instanceof NullNode == false) {
                                boolean requestTracingEnabledInstance;
                                requestTracingEnabledInstance = requestTracingEnabledValue.getBooleanValue();
                                siteConfigInstance.setRequestTracingEnabled(requestTracingEnabledInstance);
                            }
                            
                            JsonNode requestTracingExpirationTimeValue = siteConfigValue.get("requestTracingExpirationTime");
                            if (requestTracingExpirationTimeValue != null && requestTracingExpirationTimeValue instanceof NullNode == false) {
                                Calendar requestTracingExpirationTimeInstance;
                                requestTracingExpirationTimeInstance = DatatypeConverter.parseDateTime(requestTracingExpirationTimeValue.getTextValue());
                                siteConfigInstance.setRequestTracingExpirationTime(requestTracingExpirationTimeInstance);
                            }
                            
                            JsonNode scmTypeValue = siteConfigValue.get("scmType");
                            if (scmTypeValue != null && scmTypeValue instanceof NullNode == false) {
                                String scmTypeInstance;
                                scmTypeInstance = scmTypeValue.getTextValue();
                                siteConfigInstance.setScmType(scmTypeInstance);
                            }
                            
                            JsonNode autoSwapSlotNameValue = siteConfigValue.get("autoSwapSlotName");
                            if (autoSwapSlotNameValue != null && autoSwapSlotNameValue instanceof NullNode == false) {
                                String autoSwapSlotNameInstance;
                                autoSwapSlotNameInstance = autoSwapSlotNameValue.getTextValue();
                                siteConfigInstance.setAutoSwapSlotName(autoSwapSlotNameInstance);
                            }
                            
                            JsonNode use32BitWorkerProcessValue = siteConfigValue.get("use32BitWorkerProcess");
                            if (use32BitWorkerProcessValue != null && use32BitWorkerProcessValue instanceof NullNode == false) {
                                boolean use32BitWorkerProcessInstance;
                                use32BitWorkerProcessInstance = use32BitWorkerProcessValue.getBooleanValue();
                                siteConfigInstance.setUse32BitWorkerProcess(use32BitWorkerProcessInstance);
                            }
                            
                            JsonNode webSocketsEnabledValue = siteConfigValue.get("webSocketsEnabled");
                            if (webSocketsEnabledValue != null && webSocketsEnabledValue instanceof NullNode == false) {
                                boolean webSocketsEnabledInstance;
                                webSocketsEnabledInstance = webSocketsEnabledValue.getBooleanValue();
                                siteConfigInstance.setWebSocketsEnabled(webSocketsEnabledInstance);
                            }
                            
                            JsonNode limitsValue = siteConfigValue.get("limits");
                            if (limitsValue != null && limitsValue instanceof NullNode == false) {
                                SiteLimits limitsInstance = new SiteLimits();
                                siteConfigInstance.setLimits(limitsInstance);
                                
                                JsonNode maxPercentageCpuValue = limitsValue.get("maxPercentageCpu");
                                if (maxPercentageCpuValue != null && maxPercentageCpuValue instanceof NullNode == false) {
                                    double maxPercentageCpuInstance;
                                    maxPercentageCpuInstance = maxPercentageCpuValue.getDoubleValue();
                                    limitsInstance.setMaxPercentageCpu(maxPercentageCpuInstance);
                                }
                                
                                JsonNode maxMemoryInMbValue = limitsValue.get("maxMemoryInMb");
                                if (maxMemoryInMbValue != null && maxMemoryInMbValue instanceof NullNode == false) {
                                    long maxMemoryInMbInstance;
                                    maxMemoryInMbInstance = maxMemoryInMbValue.getLongValue();
                                    limitsInstance.setMaxMemoryInMb(maxMemoryInMbInstance);
                                }
                                
                                JsonNode maxDiskSizeInMbValue = limitsValue.get("maxDiskSizeInMb");
                                if (maxDiskSizeInMbValue != null && maxDiskSizeInMbValue instanceof NullNode == false) {
                                    long maxDiskSizeInMbInstance;
                                    maxDiskSizeInMbInstance = maxDiskSizeInMbValue.getLongValue();
                                    limitsInstance.setMaxDiskSizeInMb(maxDiskSizeInMbInstance);
                                }
                            }
                        }
                        
                        JsonNode stateValue = propertiesValue.get("state");
                        if (stateValue != null && stateValue instanceof NullNode == false) {
                            WebSiteState stateInstance;
                            stateInstance = Enum.valueOf(WebSiteState.class, stateValue.getTextValue());
                            propertiesInstance.setState(stateInstance);
                        }
                        
                        JsonNode usageStateValue = propertiesValue.get("usageState");
                        if (usageStateValue != null && usageStateValue instanceof NullNode == false) {
                            WebSiteUsageState usageStateInstance;
                            usageStateInstance = Enum.valueOf(WebSiteUsageState.class, usageStateValue.getTextValue());
                            propertiesInstance.setUsageState(usageStateInstance);
                        }
                        
                        JsonNode webSpaceValue = propertiesValue.get("webSpace");
                        if (webSpaceValue != null && webSpaceValue instanceof NullNode == false) {
                            String webSpaceInstance;
                            webSpaceInstance = webSpaceValue.getTextValue();
                            propertiesInstance.setWebSpace(webSpaceInstance);
                        }
                        
                        JsonNode provisioningStateValue = propertiesValue.get("provisioningState");
                        if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                            String provisioningStateInstance;
                            provisioningStateInstance = provisioningStateValue.getTextValue();
                            propertiesInstance.setProvisioningState(provisioningStateInstance);
                        }
                    }
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        webSiteInstance.setId(idInstance);
                    }
                    
                    JsonNode nameValue3 = responseDoc.get("name");
                    if (nameValue3 != null && nameValue3 instanceof NullNode == false) {
                        String nameInstance3;
                        nameInstance3 = nameValue3.getTextValue();
                        webSiteInstance.setName(nameInstance3);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        webSiteInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr6 = tagsSequenceElement.getFields();
                        while (itr6.hasNext()) {
                            Map.Entry<String, JsonNode> property6 = itr6.next();
                            String tagsKey = property6.getKey();
                            String tagsValue = property6.getValue().getTextValue();
                            webSiteInstance.getTags().put(tagsKey, tagsValue);
                        }
                    }
                    
                    JsonNode typeValue2 = responseDoc.get("type");
                    if (typeValue2 != null && typeValue2 instanceof NullNode == false) {
                        String typeInstance2;
                        typeInstance2 = typeValue2.getTextValue();
                        webSiteInstance.setType(typeInstance2);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Restart the web site.
    *
    * @param resourceGroupName Required. The name of the resource group
    * @param webSiteName Required. Name of website
    * @param slotName Optional. The name of the slot of the website
    * @return List of app settings for the website.
    */
    @Override
    public Future<WebSiteAppSettingsResult> getAppSettingsAsync(final String resourceGroupName, final String webSiteName, final String slotName) {
        return this.getClient().getExecutorService().submit(new Callable<WebSiteAppSettingsResult>() { 
            @Override
            public WebSiteAppSettingsResult call() throws Exception {
                return getAppSettings(resourceGroupName, webSiteName, slotName);
            }
         });
    }
    
    /**
    * Restart the web site.
    *
    * @param resourceGroupName Required. The name of the resource group
    * @param webSiteName Required. Name of website
    * @param slotName Optional. The name of the slot of the website
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return List of app settings for the website.
    */
    @Override
    public WebSiteAppSettingsResult getAppSettings(String resourceGroupName, String webSiteName, String slotName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (webSiteName == null) {
            throw new NullPointerException("webSiteName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("webSiteName", webSiteName);
            tracingParameters.put("slotName", slotName);
            CloudTracing.enter(invocationId, this, "getAppSettingsAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Web";
        url = url + "/";
        url = url + "sites";
        url = url + "/";
        url = url + URLEncoder.encode(webSiteName, "UTF-8");
        if (slotName != null) {
            url = url + "/slots/" + URLEncoder.encode(slotName, "UTF-8");
        }
        url = url + "/config/appsettings/list";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-06-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            WebSiteAppSettingsResult result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new WebSiteAppSettingsResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    WebSiteAppSettingsEnvelope resourceInstance = new WebSiteAppSettingsEnvelope();
                    result.setResource(resourceInstance);
                    
                    JsonNode propertiesArray = responseDoc.get("properties");
                    if (propertiesArray != null && propertiesArray instanceof NullNode == false) {
                        for (JsonNode propertiesValue : ((ArrayNode) propertiesArray)) {
                            NameValuePair nameValuePairInstance = new NameValuePair();
                            resourceInstance.getProperties().add(nameValuePairInstance);
                            
                            JsonNode nameValue = propertiesValue.get("name");
                            if (nameValue != null && nameValue instanceof NullNode == false) {
                                String nameInstance;
                                nameInstance = nameValue.getTextValue();
                                nameValuePairInstance.setName(nameInstance);
                            }
                            
                            JsonNode valueValue = propertiesValue.get("value");
                            if (valueValue != null && valueValue instanceof NullNode == false) {
                                String valueInstance;
                                valueInstance = valueValue.getTextValue();
                                nameValuePairInstance.setValue(valueInstance);
                            }
                        }
                    }
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        resourceInstance.setId(idInstance);
                    }
                    
                    JsonNode nameValue2 = responseDoc.get("name");
                    if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                        String nameInstance2;
                        nameInstance2 = nameValue2.getTextValue();
                        resourceInstance.setName(nameInstance2);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        resourceInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry<String, JsonNode> property = itr.next();
                            String tagsKey = property.getKey();
                            String tagsValue = property.getValue().getTextValue();
                            resourceInstance.getTags().put(tagsKey, tagsValue);
                        }
                    }
                    
                    JsonNode typeValue = responseDoc.get("type");
                    if (typeValue != null && typeValue instanceof NullNode == false) {
                        String typeInstance;
                        typeInstance = typeValue.getTextValue();
                        resourceInstance.setType(typeInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Gets a schedule configuration for site backups.
    *
    * @param resourceGroupName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @return Scheduled backup definition.
    */
    @Override
    public Future<WebSiteGetBackupConfigurationResponse> getBackupConfigurationAsync(final String resourceGroupName, final String webSiteName, final String slotName) {
        return this.getClient().getExecutorService().submit(new Callable<WebSiteGetBackupConfigurationResponse>() { 
            @Override
            public WebSiteGetBackupConfigurationResponse call() throws Exception {
                return getBackupConfiguration(resourceGroupName, webSiteName, slotName);
            }
         });
    }
    
    /**
    * Gets a schedule configuration for site backups.
    *
    * @param resourceGroupName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Scheduled backup definition.
    */
    @Override
    public WebSiteGetBackupConfigurationResponse getBackupConfiguration(String resourceGroupName, String webSiteName, String slotName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (webSiteName == null) {
            throw new NullPointerException("webSiteName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("webSiteName", webSiteName);
            tracingParameters.put("slotName", slotName);
            CloudTracing.enter(invocationId, this, "getBackupConfigurationAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Web";
        url = url + "/";
        url = url + "sites";
        url = url + "/";
        url = url + URLEncoder.encode(webSiteName, "UTF-8");
        if (slotName != null) {
            url = url + "/slots/" + URLEncoder.encode(slotName, "UTF-8");
        }
        url = url + "/backup/config";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-06-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("x-ms-version", "2014-06-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            WebSiteGetBackupConfigurationResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new WebSiteGetBackupConfigurationResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    BackupScheduleRequestEnvelope backupScheduleInstance = new BackupScheduleRequestEnvelope();
                    result.setBackupSchedule(backupScheduleInstance);
                    
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                        BackupScheduleRequestResponse propertiesInstance = new BackupScheduleRequestResponse();
                        backupScheduleInstance.setProperties(propertiesInstance);
                        
                        JsonNode enabledValue = propertiesValue.get("enabled");
                        if (enabledValue != null && enabledValue instanceof NullNode == false) {
                            boolean enabledInstance;
                            enabledInstance = enabledValue.getBooleanValue();
                            propertiesInstance.setEnabled(enabledInstance);
                        }
                        
                        JsonNode nameValue = propertiesValue.get("name");
                        if (nameValue != null && nameValue instanceof NullNode == false) {
                            String nameInstance;
                            nameInstance = nameValue.getTextValue();
                            propertiesInstance.setName(nameInstance);
                        }
                        
                        JsonNode storageAccountUrlValue = propertiesValue.get("storageAccountUrl");
                        if (storageAccountUrlValue != null && storageAccountUrlValue instanceof NullNode == false) {
                            String storageAccountUrlInstance;
                            storageAccountUrlInstance = storageAccountUrlValue.getTextValue();
                            propertiesInstance.setStorageAccountUrl(storageAccountUrlInstance);
                        }
                        
                        JsonNode backupScheduleValue = propertiesValue.get("backupSchedule");
                        if (backupScheduleValue != null && backupScheduleValue instanceof NullNode == false) {
                            BackupSchedule backupScheduleInstance2 = new BackupSchedule();
                            propertiesInstance.setBackupSchedule(backupScheduleInstance2);
                            
                            JsonNode frequencyIntervalValue = backupScheduleValue.get("frequencyInterval");
                            if (frequencyIntervalValue != null && frequencyIntervalValue instanceof NullNode == false) {
                                int frequencyIntervalInstance;
                                frequencyIntervalInstance = frequencyIntervalValue.getIntValue();
                                backupScheduleInstance2.setFrequencyInterval(frequencyIntervalInstance);
                            }
                            
                            JsonNode frequencyUnitValue = backupScheduleValue.get("frequencyUnit");
                            if (frequencyUnitValue != null && frequencyUnitValue instanceof NullNode == false) {
                                FrequencyUnit frequencyUnitInstance;
                                frequencyUnitInstance = Enum.valueOf(FrequencyUnit.class, frequencyUnitValue.getTextValue());
                                backupScheduleInstance2.setFrequencyUnit(frequencyUnitInstance);
                            }
                            
                            JsonNode keepAtLeastOneBackupValue = backupScheduleValue.get("keepAtLeastOneBackup");
                            if (keepAtLeastOneBackupValue != null && keepAtLeastOneBackupValue instanceof NullNode == false) {
                                boolean keepAtLeastOneBackupInstance;
                                keepAtLeastOneBackupInstance = keepAtLeastOneBackupValue.getBooleanValue();
                                backupScheduleInstance2.setKeepAtLeastOneBackup(keepAtLeastOneBackupInstance);
                            }
                            
                            JsonNode lastExecutionTimeValue = backupScheduleValue.get("lastExecutionTime");
                            if (lastExecutionTimeValue != null && lastExecutionTimeValue instanceof NullNode == false) {
                                Calendar lastExecutionTimeInstance;
                                lastExecutionTimeInstance = DatatypeConverter.parseDateTime(lastExecutionTimeValue.getTextValue());
                                backupScheduleInstance2.setLastExecutionTime(lastExecutionTimeInstance);
                            }
                            
                            JsonNode retentionPeriodInDaysValue = backupScheduleValue.get("retentionPeriodInDays");
                            if (retentionPeriodInDaysValue != null && retentionPeriodInDaysValue instanceof NullNode == false) {
                                int retentionPeriodInDaysInstance;
                                retentionPeriodInDaysInstance = retentionPeriodInDaysValue.getIntValue();
                                backupScheduleInstance2.setRetentionPeriodInDays(retentionPeriodInDaysInstance);
                            }
                            
                            JsonNode startTimeValue = backupScheduleValue.get("startTime");
                            if (startTimeValue != null && startTimeValue instanceof NullNode == false) {
                                Calendar startTimeInstance;
                                startTimeInstance = DatatypeConverter.parseDateTime(startTimeValue.getTextValue());
                                backupScheduleInstance2.setStartTime(startTimeInstance);
                            }
                        }
                        
                        JsonNode databasesArray = propertiesValue.get("databases");
                        if (databasesArray != null && databasesArray instanceof NullNode == false) {
                            for (JsonNode databasesValue : ((ArrayNode) databasesArray)) {
                                DatabaseBackupSetting databaseBackupSettingInstance = new DatabaseBackupSetting();
                                propertiesInstance.getDatabases().add(databaseBackupSettingInstance);
                                
                                JsonNode connectionStringValue = databasesValue.get("connectionString");
                                if (connectionStringValue != null && connectionStringValue instanceof NullNode == false) {
                                    String connectionStringInstance;
                                    connectionStringInstance = connectionStringValue.getTextValue();
                                    databaseBackupSettingInstance.setConnectionString(connectionStringInstance);
                                }
                                
                                JsonNode connectionStringNameValue = databasesValue.get("connectionStringName");
                                if (connectionStringNameValue != null && connectionStringNameValue instanceof NullNode == false) {
                                    String connectionStringNameInstance;
                                    connectionStringNameInstance = connectionStringNameValue.getTextValue();
                                    databaseBackupSettingInstance.setConnectionStringName(connectionStringNameInstance);
                                }
                                
                                JsonNode databaseTypeValue = databasesValue.get("databaseType");
                                if (databaseTypeValue != null && databaseTypeValue instanceof NullNode == false) {
                                    String databaseTypeInstance;
                                    databaseTypeInstance = databaseTypeValue.getTextValue();
                                    databaseBackupSettingInstance.setDatabaseType(databaseTypeInstance);
                                }
                                
                                JsonNode nameValue2 = databasesValue.get("name");
                                if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                                    String nameInstance2;
                                    nameInstance2 = nameValue2.getTextValue();
                                    databaseBackupSettingInstance.setName(nameInstance2);
                                }
                            }
                        }
                    }
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        backupScheduleInstance.setId(idInstance);
                    }
                    
                    JsonNode nameValue3 = responseDoc.get("name");
                    if (nameValue3 != null && nameValue3 instanceof NullNode == false) {
                        String nameInstance3;
                        nameInstance3 = nameValue3.getTextValue();
                        backupScheduleInstance.setName(nameInstance3);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        backupScheduleInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry<String, JsonNode> property = itr.next();
                            String tagsKey = property.getKey();
                            String tagsValue = property.getValue().getTextValue();
                            backupScheduleInstance.getTags().put(tagsKey, tagsValue);
                        }
                    }
                    
                    JsonNode typeValue = responseDoc.get("type");
                    if (typeValue != null && typeValue instanceof NullNode == false) {
                        String typeInstance;
                        typeInstance = typeValue.getTextValue();
                        backupScheduleInstance.setType(typeInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * You can retrieve the config settings for a web site by issuing an HTTP
    * GET request, or update them by using HTTP PUT with a request body that
    * contains the settings to be updated.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166985.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @param parameters Optional. Additional parameters.
    * @return Config for the website.
    */
    @Override
    public Future<WebSiteGetConfigurationResult> getConfigurationAsync(final String resourceGroupName, final String webSiteName, final String slotName, final WebSiteGetConfigurationParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<WebSiteGetConfigurationResult>() { 
            @Override
            public WebSiteGetConfigurationResult call() throws Exception {
                return getConfiguration(resourceGroupName, webSiteName, slotName, parameters);
            }
         });
    }
    
    /**
    * You can retrieve the config settings for a web site by issuing an HTTP
    * GET request, or update them by using HTTP PUT with a request body that
    * contains the settings to be updated.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166985.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @param parameters Optional. Additional parameters.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Config for the website.
    */
    @Override
    public WebSiteGetConfigurationResult getConfiguration(String resourceGroupName, String webSiteName, String slotName, WebSiteGetConfigurationParameters parameters) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (webSiteName == null) {
            throw new NullPointerException("webSiteName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("webSiteName", webSiteName);
            tracingParameters.put("slotName", slotName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "getConfigurationAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Web";
        url = url + "/";
        url = url + "sites";
        url = url + "/";
        url = url + URLEncoder.encode(webSiteName, "UTF-8");
        if (slotName != null) {
            url = url + "/slots/" + URLEncoder.encode(slotName, "UTF-8");
        }
        url = url + "/config/web";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-06-01");
        if (parameters != null && parameters.getPropertiesToInclude() != null && parameters.getPropertiesToInclude().size() > 0) {
            queryParameters.add("propertiesToInclude=" + URLEncoder.encode(CollectionStringBuilder.join(parameters.getPropertiesToInclude(), ","), "UTF-8"));
        }
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            WebSiteGetConfigurationResult result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new WebSiteGetConfigurationResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    WebSiteConfigurationEnvelope resourceInstance = new WebSiteConfigurationEnvelope();
                    result.setResource(resourceInstance);
                    
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                        WebSiteConfiguration propertiesInstance = new WebSiteConfiguration();
                        resourceInstance.setProperties(propertiesInstance);
                        
                        JsonNode appSettingsSequenceElement = ((JsonNode) propertiesValue.get("appSettings"));
                        if (appSettingsSequenceElement != null && appSettingsSequenceElement instanceof NullNode == false) {
                            Iterator<Map.Entry<String, JsonNode>> itr = appSettingsSequenceElement.getFields();
                            while (itr.hasNext()) {
                                Map.Entry<String, JsonNode> property = itr.next();
                                String appSettingsKey = property.getKey();
                                String appSettingsValue = property.getValue().getTextValue();
                                propertiesInstance.getAppSettings().put(appSettingsKey, appSettingsValue);
                            }
                        }
                        
                        JsonNode connectionStringsArray = propertiesValue.get("connectionStrings");
                        if (connectionStringsArray != null && connectionStringsArray instanceof NullNode == false) {
                            for (JsonNode connectionStringsValue : ((ArrayNode) connectionStringsArray)) {
                                ConnectionStringInfo connStringInfoInstance = new ConnectionStringInfo();
                                propertiesInstance.getConnectionStrings().add(connStringInfoInstance);
                                
                                JsonNode connectionStringValue = connectionStringsValue.get("connectionString");
                                if (connectionStringValue != null && connectionStringValue instanceof NullNode == false) {
                                    String connectionStringInstance;
                                    connectionStringInstance = connectionStringValue.getTextValue();
                                    connStringInfoInstance.setConnectionString(connectionStringInstance);
                                }
                                
                                JsonNode nameValue = connectionStringsValue.get("name");
                                if (nameValue != null && nameValue instanceof NullNode == false) {
                                    String nameInstance;
                                    nameInstance = nameValue.getTextValue();
                                    connStringInfoInstance.setName(nameInstance);
                                }
                                
                                JsonNode typeValue = connectionStringsValue.get("type");
                                if (typeValue != null && typeValue instanceof NullNode == false) {
                                    DatabaseServerType typeInstance;
                                    typeInstance = Enum.valueOf(DatabaseServerType.class, typeValue.getTextValue());
                                    connStringInfoInstance.setType(typeInstance);
                                }
                            }
                        }
                        
                        JsonNode defaultDocumentsArray = propertiesValue.get("defaultDocuments");
                        if (defaultDocumentsArray != null && defaultDocumentsArray instanceof NullNode == false) {
                            for (JsonNode defaultDocumentsValue : ((ArrayNode) defaultDocumentsArray)) {
                                propertiesInstance.getDefaultDocuments().add(defaultDocumentsValue.getTextValue());
                            }
                        }
                        
                        JsonNode detailedErrorLoggingEnabledValue = propertiesValue.get("detailedErrorLoggingEnabled");
                        if (detailedErrorLoggingEnabledValue != null && detailedErrorLoggingEnabledValue instanceof NullNode == false) {
                            boolean detailedErrorLoggingEnabledInstance;
                            detailedErrorLoggingEnabledInstance = detailedErrorLoggingEnabledValue.getBooleanValue();
                            propertiesInstance.setDetailedErrorLoggingEnabled(detailedErrorLoggingEnabledInstance);
                        }
                        
                        JsonNode documentRootValue = propertiesValue.get("documentRoot");
                        if (documentRootValue != null && documentRootValue instanceof NullNode == false) {
                            String documentRootInstance;
                            documentRootInstance = documentRootValue.getTextValue();
                            propertiesInstance.setDocumentRoot(documentRootInstance);
                        }
                        
                        JsonNode handlerMappingsArray = propertiesValue.get("handlerMappings");
                        if (handlerMappingsArray != null && handlerMappingsArray instanceof NullNode == false) {
                            for (JsonNode handlerMappingsValue : ((ArrayNode) handlerMappingsArray)) {
                                WebSiteConfiguration.HandlerMapping handlerMappingInstance = new WebSiteConfiguration.HandlerMapping();
                                propertiesInstance.getHandlerMappings().add(handlerMappingInstance);
                                
                                JsonNode argumentsValue = handlerMappingsValue.get("arguments");
                                if (argumentsValue != null && argumentsValue instanceof NullNode == false) {
                                    String argumentsInstance;
                                    argumentsInstance = argumentsValue.getTextValue();
                                    handlerMappingInstance.setArguments(argumentsInstance);
                                }
                                
                                JsonNode extensionValue = handlerMappingsValue.get("extension");
                                if (extensionValue != null && extensionValue instanceof NullNode == false) {
                                    String extensionInstance;
                                    extensionInstance = extensionValue.getTextValue();
                                    handlerMappingInstance.setExtension(extensionInstance);
                                }
                                
                                JsonNode scriptProcessorValue = handlerMappingsValue.get("scriptProcessor");
                                if (scriptProcessorValue != null && scriptProcessorValue instanceof NullNode == false) {
                                    String scriptProcessorInstance;
                                    scriptProcessorInstance = scriptProcessorValue.getTextValue();
                                    handlerMappingInstance.setScriptProcessor(scriptProcessorInstance);
                                }
                            }
                        }
                        
                        JsonNode httpLoggingEnabledValue = propertiesValue.get("httpLoggingEnabled");
                        if (httpLoggingEnabledValue != null && httpLoggingEnabledValue instanceof NullNode == false) {
                            boolean httpLoggingEnabledInstance;
                            httpLoggingEnabledInstance = httpLoggingEnabledValue.getBooleanValue();
                            propertiesInstance.setHttpLoggingEnabled(httpLoggingEnabledInstance);
                        }
                        
                        JsonNode logsDirectorySizeLimitValue = propertiesValue.get("logsDirectorySizeLimit");
                        if (logsDirectorySizeLimitValue != null && logsDirectorySizeLimitValue instanceof NullNode == false) {
                            int logsDirectorySizeLimitInstance;
                            logsDirectorySizeLimitInstance = logsDirectorySizeLimitValue.getIntValue();
                            propertiesInstance.setLogsDirectorySizeLimit(logsDirectorySizeLimitInstance);
                        }
                        
                        JsonNode managedPipelineModeValue = propertiesValue.get("managedPipelineMode");
                        if (managedPipelineModeValue != null && managedPipelineModeValue instanceof NullNode == false) {
                            ManagedPipelineMode managedPipelineModeInstance;
                            managedPipelineModeInstance = Enum.valueOf(ManagedPipelineMode.class, managedPipelineModeValue.getTextValue());
                            propertiesInstance.setManagedPipelineMode(managedPipelineModeInstance);
                        }
                        
                        JsonNode metadataSequenceElement = ((JsonNode) propertiesValue.get("metadata"));
                        if (metadataSequenceElement != null && metadataSequenceElement instanceof NullNode == false) {
                            Iterator<Map.Entry<String, JsonNode>> itr2 = metadataSequenceElement.getFields();
                            while (itr2.hasNext()) {
                                Map.Entry<String, JsonNode> property2 = itr2.next();
                                String metadataKey = property2.getKey();
                                String metadataValue = property2.getValue().getTextValue();
                                propertiesInstance.getMetadata().put(metadataKey, metadataValue);
                            }
                        }
                        
                        JsonNode netFrameworkVersionValue = propertiesValue.get("netFrameworkVersion");
                        if (netFrameworkVersionValue != null && netFrameworkVersionValue instanceof NullNode == false) {
                            String netFrameworkVersionInstance;
                            netFrameworkVersionInstance = netFrameworkVersionValue.getTextValue();
                            propertiesInstance.setNetFrameworkVersion(netFrameworkVersionInstance);
                        }
                        
                        JsonNode numberOfWorkersValue = propertiesValue.get("numberOfWorkers");
                        if (numberOfWorkersValue != null && numberOfWorkersValue instanceof NullNode == false) {
                            int numberOfWorkersInstance;
                            numberOfWorkersInstance = numberOfWorkersValue.getIntValue();
                            propertiesInstance.setNumberOfWorkers(numberOfWorkersInstance);
                        }
                        
                        JsonNode phpVersionValue = propertiesValue.get("phpVersion");
                        if (phpVersionValue != null && phpVersionValue instanceof NullNode == false) {
                            String phpVersionInstance;
                            phpVersionInstance = phpVersionValue.getTextValue();
                            propertiesInstance.setPhpVersion(phpVersionInstance);
                        }
                        
                        JsonNode pythonVersionValue = propertiesValue.get("pythonVersion");
                        if (pythonVersionValue != null && pythonVersionValue instanceof NullNode == false) {
                            String pythonVersionInstance;
                            pythonVersionInstance = pythonVersionValue.getTextValue();
                            propertiesInstance.setPythonVersion(pythonVersionInstance);
                        }
                        
                        JsonNode publishingPasswordValue = propertiesValue.get("publishingPassword");
                        if (publishingPasswordValue != null && publishingPasswordValue instanceof NullNode == false) {
                            String publishingPasswordInstance;
                            publishingPasswordInstance = publishingPasswordValue.getTextValue();
                            propertiesInstance.setPublishingPassword(publishingPasswordInstance);
                        }
                        
                        JsonNode publishingUsernameValue = propertiesValue.get("publishingUsername");
                        if (publishingUsernameValue != null && publishingUsernameValue instanceof NullNode == false) {
                            String publishingUsernameInstance;
                            publishingUsernameInstance = publishingUsernameValue.getTextValue();
                            propertiesInstance.setPublishingUserName(publishingUsernameInstance);
                        }
                        
                        JsonNode remoteDebuggingEnabledValue = propertiesValue.get("RemoteDebuggingEnabled");
                        if (remoteDebuggingEnabledValue != null && remoteDebuggingEnabledValue instanceof NullNode == false) {
                            boolean remoteDebuggingEnabledInstance;
                            remoteDebuggingEnabledInstance = remoteDebuggingEnabledValue.getBooleanValue();
                            propertiesInstance.setRemoteDebuggingEnabled(remoteDebuggingEnabledInstance);
                        }
                        
                        JsonNode remoteDebuggingVersionValue = propertiesValue.get("remoteDebuggingVersion");
                        if (remoteDebuggingVersionValue != null && remoteDebuggingVersionValue instanceof NullNode == false) {
                            RemoteDebuggingVersion remoteDebuggingVersionInstance;
                            remoteDebuggingVersionInstance = Enum.valueOf(RemoteDebuggingVersion.class, remoteDebuggingVersionValue.getTextValue());
                            propertiesInstance.setRemoteDebuggingVersion(remoteDebuggingVersionInstance);
                        }
                        
                        JsonNode requestTracingEnabledValue = propertiesValue.get("requestTracingEnabled");
                        if (requestTracingEnabledValue != null && requestTracingEnabledValue instanceof NullNode == false) {
                            boolean requestTracingEnabledInstance;
                            requestTracingEnabledInstance = requestTracingEnabledValue.getBooleanValue();
                            propertiesInstance.setRequestTracingEnabled(requestTracingEnabledInstance);
                        }
                        
                        JsonNode requestTracingExpirationTimeValue = propertiesValue.get("requestTracingExpirationTime");
                        if (requestTracingExpirationTimeValue != null && requestTracingExpirationTimeValue instanceof NullNode == false) {
                            Calendar requestTracingExpirationTimeInstance;
                            requestTracingExpirationTimeInstance = DatatypeConverter.parseDateTime(requestTracingExpirationTimeValue.getTextValue());
                            propertiesInstance.setRequestTracingExpirationTime(requestTracingExpirationTimeInstance);
                        }
                        
                        JsonNode scmTypeValue = propertiesValue.get("scmType");
                        if (scmTypeValue != null && scmTypeValue instanceof NullNode == false) {
                            String scmTypeInstance;
                            scmTypeInstance = scmTypeValue.getTextValue();
                            propertiesInstance.setScmType(scmTypeInstance);
                        }
                        
                        JsonNode autoSwapSlotNameValue = propertiesValue.get("autoSwapSlotName");
                        if (autoSwapSlotNameValue != null && autoSwapSlotNameValue instanceof NullNode == false) {
                            String autoSwapSlotNameInstance;
                            autoSwapSlotNameInstance = autoSwapSlotNameValue.getTextValue();
                            propertiesInstance.setAutoSwapSlotName(autoSwapSlotNameInstance);
                        }
                        
                        JsonNode use32BitWorkerProcessValue = propertiesValue.get("use32BitWorkerProcess");
                        if (use32BitWorkerProcessValue != null && use32BitWorkerProcessValue instanceof NullNode == false) {
                            boolean use32BitWorkerProcessInstance;
                            use32BitWorkerProcessInstance = use32BitWorkerProcessValue.getBooleanValue();
                            propertiesInstance.setUse32BitWorkerProcess(use32BitWorkerProcessInstance);
                        }
                        
                        JsonNode webSocketsEnabledValue = propertiesValue.get("webSocketsEnabled");
                        if (webSocketsEnabledValue != null && webSocketsEnabledValue instanceof NullNode == false) {
                            boolean webSocketsEnabledInstance;
                            webSocketsEnabledInstance = webSocketsEnabledValue.getBooleanValue();
                            propertiesInstance.setWebSocketsEnabled(webSocketsEnabledInstance);
                        }
                        
                        JsonNode limitsValue = propertiesValue.get("limits");
                        if (limitsValue != null && limitsValue instanceof NullNode == false) {
                            SiteLimits limitsInstance = new SiteLimits();
                            propertiesInstance.setLimits(limitsInstance);
                            
                            JsonNode maxPercentageCpuValue = limitsValue.get("maxPercentageCpu");
                            if (maxPercentageCpuValue != null && maxPercentageCpuValue instanceof NullNode == false) {
                                double maxPercentageCpuInstance;
                                maxPercentageCpuInstance = maxPercentageCpuValue.getDoubleValue();
                                limitsInstance.setMaxPercentageCpu(maxPercentageCpuInstance);
                            }
                            
                            JsonNode maxMemoryInMbValue = limitsValue.get("maxMemoryInMb");
                            if (maxMemoryInMbValue != null && maxMemoryInMbValue instanceof NullNode == false) {
                                long maxMemoryInMbInstance;
                                maxMemoryInMbInstance = maxMemoryInMbValue.getLongValue();
                                limitsInstance.setMaxMemoryInMb(maxMemoryInMbInstance);
                            }
                            
                            JsonNode maxDiskSizeInMbValue = limitsValue.get("maxDiskSizeInMb");
                            if (maxDiskSizeInMbValue != null && maxDiskSizeInMbValue instanceof NullNode == false) {
                                long maxDiskSizeInMbInstance;
                                maxDiskSizeInMbInstance = maxDiskSizeInMbValue.getLongValue();
                                limitsInstance.setMaxDiskSizeInMb(maxDiskSizeInMbInstance);
                            }
                        }
                    }
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        resourceInstance.setId(idInstance);
                    }
                    
                    JsonNode nameValue2 = responseDoc.get("name");
                    if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                        String nameInstance2;
                        nameInstance2 = nameValue2.getTextValue();
                        resourceInstance.setName(nameInstance2);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        resourceInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr3 = tagsSequenceElement.getFields();
                        while (itr3.hasNext()) {
                            Map.Entry<String, JsonNode> property3 = itr3.next();
                            String tagsKey = property3.getKey();
                            String tagsValue = property3.getValue().getTextValue();
                            resourceInstance.getTags().put(tagsKey, tagsValue);
                        }
                    }
                    
                    JsonNode typeValue2 = responseDoc.get("type");
                    if (typeValue2 != null && typeValue2 instanceof NullNode == false) {
                        String typeInstance2;
                        typeInstance2 = typeValue2.getTextValue();
                        resourceInstance.setType(typeInstance2);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Restart the web site.
    *
    * @param resourceGroupName Required. The name of the resource group
    * @param webSiteName Required. Name of website
    * @param slotName Optional. The name of the slot of the web site
    * @return List of connection strings for the website.
    */
    @Override
    public Future<WebSiteConnectionStringsResult> getConnectionStringsAsync(final String resourceGroupName, final String webSiteName, final String slotName) {
        return this.getClient().getExecutorService().submit(new Callable<WebSiteConnectionStringsResult>() { 
            @Override
            public WebSiteConnectionStringsResult call() throws Exception {
                return getConnectionStrings(resourceGroupName, webSiteName, slotName);
            }
         });
    }
    
    /**
    * Restart the web site.
    *
    * @param resourceGroupName Required. The name of the resource group
    * @param webSiteName Required. Name of website
    * @param slotName Optional. The name of the slot of the web site
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return List of connection strings for the website.
    */
    @Override
    public WebSiteConnectionStringsResult getConnectionStrings(String resourceGroupName, String webSiteName, String slotName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (webSiteName == null) {
            throw new NullPointerException("webSiteName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("webSiteName", webSiteName);
            tracingParameters.put("slotName", slotName);
            CloudTracing.enter(invocationId, this, "getConnectionStringsAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Web";
        url = url + "/";
        url = url + "sites";
        url = url + "/";
        url = url + URLEncoder.encode(webSiteName, "UTF-8");
        if (slotName != null) {
            url = url + "/slots/" + URLEncoder.encode(slotName, "UTF-8");
        }
        url = url + "/config/connectionstrings/list";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-06-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            WebSiteConnectionStringsResult result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new WebSiteConnectionStringsResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    WebSiteConnectionStringsEnvelope resourceInstance = new WebSiteConnectionStringsEnvelope();
                    result.setResource(resourceInstance);
                    
                    JsonNode propertiesArray = responseDoc.get("properties");
                    if (propertiesArray != null && propertiesArray instanceof NullNode == false) {
                        for (JsonNode propertiesValue : ((ArrayNode) propertiesArray)) {
                            ConnectionStringInfo connStringInfoInstance = new ConnectionStringInfo();
                            resourceInstance.getProperties().add(connStringInfoInstance);
                            
                            JsonNode connectionStringValue = propertiesValue.get("connectionString");
                            if (connectionStringValue != null && connectionStringValue instanceof NullNode == false) {
                                String connectionStringInstance;
                                connectionStringInstance = connectionStringValue.getTextValue();
                                connStringInfoInstance.setConnectionString(connectionStringInstance);
                            }
                            
                            JsonNode nameValue = propertiesValue.get("name");
                            if (nameValue != null && nameValue instanceof NullNode == false) {
                                String nameInstance;
                                nameInstance = nameValue.getTextValue();
                                connStringInfoInstance.setName(nameInstance);
                            }
                            
                            JsonNode typeValue = propertiesValue.get("type");
                            if (typeValue != null && typeValue instanceof NullNode == false) {
                                DatabaseServerType typeInstance;
                                typeInstance = Enum.valueOf(DatabaseServerType.class, typeValue.getTextValue());
                                connStringInfoInstance.setType(typeInstance);
                            }
                        }
                    }
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        resourceInstance.setId(idInstance);
                    }
                    
                    JsonNode nameValue2 = responseDoc.get("name");
                    if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                        String nameInstance2;
                        nameInstance2 = nameValue2.getTextValue();
                        resourceInstance.setName(nameInstance2);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        resourceInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry<String, JsonNode> property = itr.next();
                            String tagsKey = property.getKey();
                            String tagsValue = property.getValue().getTextValue();
                            resourceInstance.getTags().put(tagsKey, tagsValue);
                        }
                    }
                    
                    JsonNode typeValue2 = responseDoc.get("type");
                    if (typeValue2 != null && typeValue2 instanceof NullNode == false) {
                        String typeInstance2;
                        typeInstance2 = typeValue2.getTextValue();
                        resourceInstance.setType(typeInstance2);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * You can retrieve historical usage metrics for a site by issuing an HTTP
    * GET request.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166964.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @param parameters Required. The Get Web Site Historical Usage Metrics
    * parameters.
    * @return The Get Web Site Historical Usage Metrics operation response.
    */
    @Override
    public Future<WebSiteGetHistoricalUsageMetricsResponse> getHistoricalUsageMetricsAsync(final String resourceGroupName, final String webSiteName, final String slotName, final WebSiteGetHistoricalUsageMetricsParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<WebSiteGetHistoricalUsageMetricsResponse>() { 
            @Override
            public WebSiteGetHistoricalUsageMetricsResponse call() throws Exception {
                return getHistoricalUsageMetrics(resourceGroupName, webSiteName, slotName, parameters);
            }
         });
    }
    
    /**
    * You can retrieve historical usage metrics for a site by issuing an HTTP
    * GET request.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166964.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @param parameters Required. The Get Web Site Historical Usage Metrics
    * parameters.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The Get Web Site Historical Usage Metrics operation response.
    */
    @Override
    public WebSiteGetHistoricalUsageMetricsResponse getHistoricalUsageMetrics(String resourceGroupName, String webSiteName, String slotName, WebSiteGetHistoricalUsageMetricsParameters parameters) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (webSiteName == null) {
            throw new NullPointerException("webSiteName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("webSiteName", webSiteName);
            tracingParameters.put("slotName", slotName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "getHistoricalUsageMetricsAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Web";
        url = url + "/";
        url = url + "sites";
        url = url + "/";
        url = url + URLEncoder.encode(webSiteName, "UTF-8");
        if (slotName != null) {
            url = url + "/slots/" + URLEncoder.encode(slotName, "UTF-8");
        }
        url = url + "/metrics";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-06-01");
        if (parameters.getMetricNames() != null && parameters.getMetricNames().size() > 0) {
            queryParameters.add("names=" + URLEncoder.encode(CollectionStringBuilder.join(parameters.getMetricNames(), ","), "UTF-8"));
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        if (parameters.getStartTime() != null) {
            queryParameters.add("StartTime=" + URLEncoder.encode(simpleDateFormat.format(parameters.getStartTime().getTime()), "UTF-8"));
        }
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
        simpleDateFormat2.setTimeZone(TimeZone.getTimeZone("UTC"));
        if (parameters.getEndTime() != null) {
            queryParameters.add("EndTime=" + URLEncoder.encode(simpleDateFormat2.format(parameters.getEndTime().getTime()), "UTF-8"));
        }
        if (parameters.getTimeGrain() != null) {
            queryParameters.add("timeGrain=" + URLEncoder.encode(parameters.getTimeGrain(), "UTF-8"));
        }
        queryParameters.add("details=" + URLEncoder.encode(Boolean.toString(parameters.isIncludeInstanceBreakdown()).toLowerCase(), "UTF-8"));
        queryParameters.add("slotView=" + URLEncoder.encode(Boolean.toString(parameters.isSlotView()).toLowerCase(), "UTF-8"));
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            WebSiteGetHistoricalUsageMetricsResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new WebSiteGetHistoricalUsageMetricsResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode propertiesArray = responseDoc.get("properties");
                    if (propertiesArray != null && propertiesArray instanceof NullNode == false) {
                        for (JsonNode propertiesValue : ((ArrayNode) propertiesArray)) {
                            HistoricalUsageMetric historicalUsageMetricInstance = new HistoricalUsageMetric();
                            result.getUsageMetrics().add(historicalUsageMetricInstance);
                            
                            JsonNode codeValue = propertiesValue.get("code");
                            if (codeValue != null && codeValue instanceof NullNode == false) {
                                String codeInstance;
                                codeInstance = codeValue.getTextValue();
                                historicalUsageMetricInstance.setCode(codeInstance);
                            }
                            
                            JsonNode dataValue = propertiesValue.get("data");
                            if (dataValue != null && dataValue instanceof NullNode == false) {
                                HistoricalUsageMetricData dataInstance = new HistoricalUsageMetricData();
                                historicalUsageMetricInstance.setData(dataInstance);
                                
                                JsonNode displayNameValue = dataValue.get("displayName");
                                if (displayNameValue != null && displayNameValue instanceof NullNode == false) {
                                    String displayNameInstance;
                                    displayNameInstance = displayNameValue.getTextValue();
                                    dataInstance.setDisplayName(displayNameInstance);
                                }
                                
                                JsonNode endTimeValue = dataValue.get("EndTime");
                                if (endTimeValue != null && endTimeValue instanceof NullNode == false) {
                                    Calendar endTimeInstance;
                                    endTimeInstance = DatatypeConverter.parseDateTime(endTimeValue.getTextValue());
                                    dataInstance.setEndTime(endTimeInstance);
                                }
                                
                                JsonNode nameValue = dataValue.get("name");
                                if (nameValue != null && nameValue instanceof NullNode == false) {
                                    String nameInstance;
                                    nameInstance = nameValue.getTextValue();
                                    dataInstance.setName(nameInstance);
                                }
                                
                                JsonNode primaryAggregationTypeValue = dataValue.get("primaryAggregationType");
                                if (primaryAggregationTypeValue != null && primaryAggregationTypeValue instanceof NullNode == false) {
                                    String primaryAggregationTypeInstance;
                                    primaryAggregationTypeInstance = primaryAggregationTypeValue.getTextValue();
                                    dataInstance.setPrimaryAggregationType(primaryAggregationTypeInstance);
                                }
                                
                                JsonNode startTimeValue = dataValue.get("startTime");
                                if (startTimeValue != null && startTimeValue instanceof NullNode == false) {
                                    Calendar startTimeInstance;
                                    startTimeInstance = DatatypeConverter.parseDateTime(startTimeValue.getTextValue());
                                    dataInstance.setStartTime(startTimeInstance);
                                }
                                
                                JsonNode timeGrainValue = dataValue.get("timeGrain");
                                if (timeGrainValue != null && timeGrainValue instanceof NullNode == false) {
                                    String timeGrainInstance;
                                    timeGrainInstance = timeGrainValue.getTextValue();
                                    dataInstance.setTimeGrain(timeGrainInstance);
                                }
                                
                                JsonNode unitValue = dataValue.get("unit");
                                if (unitValue != null && unitValue instanceof NullNode == false) {
                                    String unitInstance;
                                    unitInstance = unitValue.getTextValue();
                                    dataInstance.setUnit(unitInstance);
                                }
                                
                                JsonNode valuesArray = dataValue.get("values");
                                if (valuesArray != null && valuesArray instanceof NullNode == false) {
                                    for (JsonNode valuesValue : ((ArrayNode) valuesArray)) {
                                        HistoricalUsageMetricSample metricSampleInstance = new HistoricalUsageMetricSample();
                                        dataInstance.getValues().add(metricSampleInstance);
                                        
                                        JsonNode countValue = valuesValue.get("count");
                                        if (countValue != null && countValue instanceof NullNode == false) {
                                            int countInstance;
                                            countInstance = countValue.getIntValue();
                                            metricSampleInstance.setCount(countInstance);
                                        }
                                        
                                        JsonNode maximumValue = valuesValue.get("maximum");
                                        if (maximumValue != null && maximumValue instanceof NullNode == false) {
                                            String maximumInstance;
                                            maximumInstance = maximumValue.getTextValue();
                                            metricSampleInstance.setMaximum(maximumInstance);
                                        }
                                        
                                        JsonNode minimumValue = valuesValue.get("minimum");
                                        if (minimumValue != null && minimumValue instanceof NullNode == false) {
                                            String minimumInstance;
                                            minimumInstance = minimumValue.getTextValue();
                                            metricSampleInstance.setMinimum(minimumInstance);
                                        }
                                        
                                        JsonNode timeCreatedValue = valuesValue.get("timeCreated");
                                        if (timeCreatedValue != null && timeCreatedValue instanceof NullNode == false) {
                                            Calendar timeCreatedInstance;
                                            timeCreatedInstance = DatatypeConverter.parseDateTime(timeCreatedValue.getTextValue());
                                            metricSampleInstance.setTimeCreated(timeCreatedInstance);
                                        }
                                        
                                        JsonNode totalValue = valuesValue.get("total");
                                        if (totalValue != null && totalValue instanceof NullNode == false) {
                                            String totalInstance;
                                            totalInstance = totalValue.getTextValue();
                                            metricSampleInstance.setTotal(totalInstance);
                                        }
                                        
                                        JsonNode instanceNameValue = valuesValue.get("instanceName");
                                        if (instanceNameValue != null && instanceNameValue instanceof NullNode == false) {
                                            String instanceNameInstance;
                                            instanceNameInstance = instanceNameValue.getTextValue();
                                            metricSampleInstance.setInstanceName(instanceNameInstance);
                                        }
                                    }
                                }
                            }
                            
                            JsonNode messageValue = propertiesValue.get("message");
                            if (messageValue != null && messageValue instanceof NullNode == false) {
                                String messageInstance;
                                messageInstance = messageValue.getTextValue();
                                historicalUsageMetricInstance.setMessage(messageInstance);
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Restart the web site.
    *
    * @param resourceGroupName Required. The name of the resource group
    * @param webSiteName Required. Name of website
    * @param slotName Optional. The name of the slot of the web site
    * @return List of metadata for the website.
    */
    @Override
    public Future<WebSiteMetadataResult> getMetadataAsync(final String resourceGroupName, final String webSiteName, final String slotName) {
        return this.getClient().getExecutorService().submit(new Callable<WebSiteMetadataResult>() { 
            @Override
            public WebSiteMetadataResult call() throws Exception {
                return getMetadata(resourceGroupName, webSiteName, slotName);
            }
         });
    }
    
    /**
    * Restart the web site.
    *
    * @param resourceGroupName Required. The name of the resource group
    * @param webSiteName Required. Name of website
    * @param slotName Optional. The name of the slot of the web site
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return List of metadata for the website.
    */
    @Override
    public WebSiteMetadataResult getMetadata(String resourceGroupName, String webSiteName, String slotName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (webSiteName == null) {
            throw new NullPointerException("webSiteName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("webSiteName", webSiteName);
            tracingParameters.put("slotName", slotName);
            CloudTracing.enter(invocationId, this, "getMetadataAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Web";
        url = url + "/";
        url = url + "sites";
        url = url + "/";
        url = url + URLEncoder.encode(webSiteName, "UTF-8");
        if (slotName != null) {
            url = url + "/slots/" + URLEncoder.encode(slotName, "UTF-8");
        }
        url = url + "/config/metadata/list";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-06-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            WebSiteMetadataResult result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new WebSiteMetadataResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    WebSiteMetadataEnvelope resourceInstance = new WebSiteMetadataEnvelope();
                    result.setResource(resourceInstance);
                    
                    JsonNode propertiesArray = responseDoc.get("properties");
                    if (propertiesArray != null && propertiesArray instanceof NullNode == false) {
                        for (JsonNode propertiesValue : ((ArrayNode) propertiesArray)) {
                            NameValuePair nameValuePairInstance = new NameValuePair();
                            resourceInstance.getProperties().add(nameValuePairInstance);
                            
                            JsonNode nameValue = propertiesValue.get("name");
                            if (nameValue != null && nameValue instanceof NullNode == false) {
                                String nameInstance;
                                nameInstance = nameValue.getTextValue();
                                nameValuePairInstance.setName(nameInstance);
                            }
                            
                            JsonNode valueValue = propertiesValue.get("value");
                            if (valueValue != null && valueValue instanceof NullNode == false) {
                                String valueInstance;
                                valueInstance = valueValue.getTextValue();
                                nameValuePairInstance.setValue(valueInstance);
                            }
                        }
                    }
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        resourceInstance.setId(idInstance);
                    }
                    
                    JsonNode nameValue2 = responseDoc.get("name");
                    if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                        String nameInstance2;
                        nameInstance2 = nameValue2.getTextValue();
                        resourceInstance.setName(nameInstance2);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        resourceInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry<String, JsonNode> property = itr.next();
                            String tagsKey = property.getKey();
                            String tagsValue = property.getValue().getTextValue();
                            resourceInstance.getTags().put(tagsKey, tagsValue);
                        }
                    }
                    
                    JsonNode typeValue = responseDoc.get("type");
                    if (typeValue != null && typeValue instanceof NullNode == false) {
                        String typeInstance;
                        typeInstance = typeValue.getTextValue();
                        resourceInstance.setType(typeInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * You can retrieve details for a web site by issuing an HTTP GET request.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/dn167007.aspx
    * for more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @param operationId Required. Additional parameters.
    * @return The website operation response.
    */
    @Override
    public Future<WebSiteAsyncOperationResponse> getOperationAsync(final String resourceGroupName, final String webSiteName, final String slotName, final String operationId) {
        return this.getClient().getExecutorService().submit(new Callable<WebSiteAsyncOperationResponse>() { 
            @Override
            public WebSiteAsyncOperationResponse call() throws Exception {
                return getOperation(resourceGroupName, webSiteName, slotName, operationId);
            }
         });
    }
    
    /**
    * You can retrieve details for a web site by issuing an HTTP GET request.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/dn167007.aspx
    * for more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @param operationId Required. Additional parameters.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The website operation response.
    */
    @Override
    public WebSiteAsyncOperationResponse getOperation(String resourceGroupName, String webSiteName, String slotName, String operationId) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (webSiteName == null) {
            throw new NullPointerException("webSiteName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("webSiteName", webSiteName);
            tracingParameters.put("slotName", slotName);
            tracingParameters.put("operationId", operationId);
            CloudTracing.enter(invocationId, this, "getOperationAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Web";
        url = url + "/";
        url = url + "sites";
        url = url + "/";
        url = url + URLEncoder.encode(webSiteName, "UTF-8");
        if (slotName != null) {
            url = url + "/slots/" + URLEncoder.encode(slotName, "UTF-8");
        }
        url = url + "/operations/";
        if (operationId != null) {
            url = url + URLEncoder.encode(operationId, "UTF-8");
        }
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-06-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_CREATED && statusCode != HttpStatus.SC_ACCEPTED) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            WebSiteAsyncOperationResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK || statusCode == HttpStatus.SC_CREATED || statusCode == HttpStatus.SC_ACCEPTED) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new WebSiteAsyncOperationResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        result.setLocation(locationInstance);
                    }
                    
                    JsonNode retryAfterValue = responseDoc.get("retry-after");
                    if (retryAfterValue != null && retryAfterValue instanceof NullNode == false) {
                        String retryAfterInstance;
                        retryAfterInstance = retryAfterValue.getTextValue();
                        result.setRetryAfter(retryAfterInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("location").length > 0) {
                result.setLocation(httpResponse.getFirstHeader("location").getValue());
            }
            if (httpResponse.getHeaders("retry-after").length > 0) {
                result.setRetryAfter(httpResponse.getFirstHeader("retry-after").getValue());
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Get publishing credentials for the web site.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. Name of website
    * @param slotName Optional. The name of the slot of the web site.
    * @return Publishing credentials for the website.
    */
    @Override
    public Future<WebSitePublishingCredentialsResult> getPublishingCredentialsAsync(final String resourceGroupName, final String webSiteName, final String slotName) {
        return this.getClient().getExecutorService().submit(new Callable<WebSitePublishingCredentialsResult>() { 
            @Override
            public WebSitePublishingCredentialsResult call() throws Exception {
                return getPublishingCredentials(resourceGroupName, webSiteName, slotName);
            }
         });
    }
    
    /**
    * Get publishing credentials for the web site.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. Name of website
    * @param slotName Optional. The name of the slot of the web site.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Publishing credentials for the website.
    */
    @Override
    public WebSitePublishingCredentialsResult getPublishingCredentials(String resourceGroupName, String webSiteName, String slotName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (webSiteName == null) {
            throw new NullPointerException("webSiteName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("webSiteName", webSiteName);
            tracingParameters.put("slotName", slotName);
            CloudTracing.enter(invocationId, this, "getPublishingCredentialsAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Web";
        url = url + "/";
        url = url + "sites";
        url = url + "/";
        url = url + URLEncoder.encode(webSiteName, "UTF-8");
        if (slotName != null) {
            url = url + "/slots/" + URLEncoder.encode(slotName, "UTF-8");
        }
        url = url + "/config/publishingcredentials/list";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-06-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            WebSitePublishingCredentialsResult result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new WebSitePublishingCredentialsResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    WebSitePublishingCredentialsEnvelope resourceInstance = new WebSitePublishingCredentialsEnvelope();
                    result.setResource(resourceInstance);
                    
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                        PublishingCredentials propertiesInstance = new PublishingCredentials();
                        resourceInstance.setProperties(propertiesInstance);
                        
                        JsonNode publishingPasswordValue = propertiesValue.get("publishingPassword");
                        if (publishingPasswordValue != null && publishingPasswordValue instanceof NullNode == false) {
                            String publishingPasswordInstance;
                            publishingPasswordInstance = publishingPasswordValue.getTextValue();
                            propertiesInstance.setPublishingPassword(publishingPasswordInstance);
                        }
                        
                        JsonNode publishingUserNameValue = propertiesValue.get("publishingUserName");
                        if (publishingUserNameValue != null && publishingUserNameValue instanceof NullNode == false) {
                            String publishingUserNameInstance;
                            publishingUserNameInstance = publishingUserNameValue.getTextValue();
                            propertiesInstance.setPublishingUserName(publishingUserNameInstance);
                        }
                    }
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        resourceInstance.setId(idInstance);
                    }
                    
                    JsonNode nameValue = responseDoc.get("name");
                    if (nameValue != null && nameValue instanceof NullNode == false) {
                        String nameInstance;
                        nameInstance = nameValue.getTextValue();
                        resourceInstance.setName(nameInstance);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        resourceInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry<String, JsonNode> property = itr.next();
                            String tagsKey = property.getKey();
                            String tagsValue = property.getValue().getTextValue();
                            resourceInstance.getTags().put(tagsKey, tagsValue);
                        }
                    }
                    
                    JsonNode typeValue = responseDoc.get("type");
                    if (typeValue != null && typeValue instanceof NullNode == false) {
                        String typeInstance;
                        typeInstance = typeValue.getTextValue();
                        resourceInstance.setType(typeInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Retrieve the publish settings information for a web site.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166996.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @return The Get Web Site Publish Profile operation response.
    */
    @Override
    public Future<WebSiteGetPublishProfileResponse> getPublishProfileAsync(final String resourceGroupName, final String webSiteName, final String slotName) {
        return this.getClient().getExecutorService().submit(new Callable<WebSiteGetPublishProfileResponse>() { 
            @Override
            public WebSiteGetPublishProfileResponse call() throws Exception {
                return getPublishProfile(resourceGroupName, webSiteName, slotName);
            }
         });
    }
    
    /**
    * Retrieve the publish settings information for a web site.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166996.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The Get Web Site Publish Profile operation response.
    */
    @Override
    public WebSiteGetPublishProfileResponse getPublishProfile(String resourceGroupName, String webSiteName, String slotName) throws IOException, ServiceException, ParserConfigurationException, SAXException, URISyntaxException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (webSiteName == null) {
            throw new NullPointerException("webSiteName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("webSiteName", webSiteName);
            tracingParameters.put("slotName", slotName);
            CloudTracing.enter(invocationId, this, "getPublishProfileAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Web";
        url = url + "/";
        url = url + "sites";
        url = url + "/";
        url = url + URLEncoder.encode(webSiteName, "UTF-8");
        if (slotName != null) {
            url = url + "/slots/" + URLEncoder.encode(slotName, "UTF-8");
        }
        url = url + "/publishxml";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-06-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/xml");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            WebSiteGetPublishProfileResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new WebSiteGetPublishProfileResponse();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document responseDoc = documentBuilder.parse(new BOMInputStream(responseContent));
                
                Element publishDataSequenceElement = XmlUtility.getElementByTagNameNS(responseDoc, "", "publishData");
                if (publishDataSequenceElement != null) {
                    for (int i1 = 0; i1 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(publishDataSequenceElement, "", "publishProfile").size(); i1 = i1 + 1) {
                        org.w3c.dom.Element publishDataElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(publishDataSequenceElement, "", "publishProfile").get(i1));
                        WebSiteGetPublishProfileResponse.PublishProfile publishProfileInstance = new WebSiteGetPublishProfileResponse.PublishProfile();
                        result.getPublishProfiles().add(publishProfileInstance);
                        
                        Attr profileNameAttribute = publishDataElement.getAttributeNodeNS("", "profileName");
                        if (profileNameAttribute != null) {
                            publishProfileInstance.setProfileName(profileNameAttribute.getValue());
                        }
                        
                        Attr publishMethodAttribute = publishDataElement.getAttributeNodeNS("", "publishMethod");
                        if (publishMethodAttribute != null) {
                            publishProfileInstance.setPublishMethod(publishMethodAttribute.getValue());
                        }
                        
                        Attr publishUrlAttribute = publishDataElement.getAttributeNodeNS("", "publishUrl");
                        if (publishUrlAttribute != null) {
                            publishProfileInstance.setPublishUrl(publishUrlAttribute.getValue());
                        }
                        
                        Attr msdeploySiteAttribute = publishDataElement.getAttributeNodeNS("", "msdeploySite");
                        if (msdeploySiteAttribute != null) {
                            publishProfileInstance.setMSDeploySite(msdeploySiteAttribute.getValue());
                        }
                        
                        Attr ftpPassiveModeAttribute = publishDataElement.getAttributeNodeNS("", "ftpPassiveMode");
                        if (ftpPassiveModeAttribute != null) {
                            publishProfileInstance.setFtpPassiveMode(DatatypeConverter.parseBoolean(ftpPassiveModeAttribute.getValue().toLowerCase()));
                        }
                        
                        Attr userNameAttribute = publishDataElement.getAttributeNodeNS("", "userName");
                        if (userNameAttribute != null) {
                            publishProfileInstance.setUserName(userNameAttribute.getValue());
                        }
                        
                        Attr userPWDAttribute = publishDataElement.getAttributeNodeNS("", "userPWD");
                        if (userPWDAttribute != null) {
                            publishProfileInstance.setUserPassword(userPWDAttribute.getValue());
                        }
                        
                        Attr destinationAppUrlAttribute = publishDataElement.getAttributeNodeNS("", "destinationAppUrl");
                        if (destinationAppUrlAttribute != null) {
                            publishProfileInstance.setDestinationAppUri(new URI(destinationAppUrlAttribute.getValue()));
                        }
                        
                        Attr sQLServerDBConnectionStringAttribute = publishDataElement.getAttributeNodeNS("", "SQLServerDBConnectionString");
                        if (sQLServerDBConnectionStringAttribute != null) {
                            publishProfileInstance.setSqlServerConnectionString(sQLServerDBConnectionStringAttribute.getValue());
                        }
                        
                        Attr mySQLDBConnectionStringAttribute = publishDataElement.getAttributeNodeNS("", "mySQLDBConnectionString");
                        if (mySQLDBConnectionStringAttribute != null) {
                            publishProfileInstance.setMySqlConnectionString(mySQLDBConnectionStringAttribute.getValue());
                        }
                        
                        Attr hostingProviderForumLinkAttribute = publishDataElement.getAttributeNodeNS("", "hostingProviderForumLink");
                        if (hostingProviderForumLinkAttribute != null) {
                            publishProfileInstance.setHostingProviderForumUri(new URI(hostingProviderForumLinkAttribute.getValue()));
                        }
                        
                        Attr controlPanelLinkAttribute = publishDataElement.getAttributeNodeNS("", "controlPanelLink");
                        if (controlPanelLinkAttribute != null) {
                            publishProfileInstance.setControlPanelUri(new URI(controlPanelLinkAttribute.getValue()));
                        }
                        
                        Element databasesSequenceElement = XmlUtility.getElementByTagNameNS(publishDataElement, "", "databases");
                        if (databasesSequenceElement != null) {
                            for (int i2 = 0; i2 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(databasesSequenceElement, "", "add").size(); i2 = i2 + 1) {
                                org.w3c.dom.Element databasesElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(databasesSequenceElement, "", "add").get(i2));
                                WebSiteGetPublishProfileResponse.Database addInstance = new WebSiteGetPublishProfileResponse.Database();
                                publishProfileInstance.getDatabases().add(addInstance);
                                
                                Attr nameAttribute = databasesElement.getAttributeNodeNS("", "name");
                                if (nameAttribute != null) {
                                    addInstance.setName(nameAttribute.getValue());
                                }
                                
                                Attr connectionStringAttribute = databasesElement.getAttributeNodeNS("", "connectionString");
                                if (connectionStringAttribute != null) {
                                    addInstance.setConnectionString(connectionStringAttribute.getValue());
                                }
                                
                                Attr providerNameAttribute = databasesElement.getAttributeNodeNS("", "providerName");
                                if (providerNameAttribute != null) {
                                    addInstance.setProviderName(providerNameAttribute.getValue());
                                }
                                
                                Attr typeAttribute = databasesElement.getAttributeNodeNS("", "type");
                                if (typeAttribute != null) {
                                    addInstance.setType(typeAttribute.getValue());
                                }
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * A web site repository is essentially a GIT repository that you can use to
    * manage your web site content. By using GIT source control tools, you can
    * push or pull version controlled changes to your site. You can create a
    * repository for your web site by issuing an HTTP POST request, or
    * retrieve information about the repository by using HTTP GET.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166967.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @return The Get Web Site Repository operation response.
    */
    @Override
    public Future<WebSiteGetRepositoryResponse> getRepositoryAsync(final String resourceGroupName, final String webSiteName, final String slotName) {
        return this.getClient().getExecutorService().submit(new Callable<WebSiteGetRepositoryResponse>() { 
            @Override
            public WebSiteGetRepositoryResponse call() throws Exception {
                return getRepository(resourceGroupName, webSiteName, slotName);
            }
         });
    }
    
    /**
    * A web site repository is essentially a GIT repository that you can use to
    * manage your web site content. By using GIT source control tools, you can
    * push or pull version controlled changes to your site. You can create a
    * repository for your web site by issuing an HTTP POST request, or
    * retrieve information about the repository by using HTTP GET.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166967.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The Get Web Site Repository operation response.
    */
    @Override
    public WebSiteGetRepositoryResponse getRepository(String resourceGroupName, String webSiteName, String slotName) throws IOException, ServiceException, URISyntaxException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (webSiteName == null) {
            throw new NullPointerException("webSiteName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("webSiteName", webSiteName);
            tracingParameters.put("slotName", slotName);
            CloudTracing.enter(invocationId, this, "getRepositoryAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Web";
        url = url + "/";
        url = url + "sites";
        url = url + "/";
        url = url + URLEncoder.encode(webSiteName, "UTF-8");
        if (slotName != null) {
            url = url + "/slots/" + URLEncoder.encode(slotName, "UTF-8");
        }
        url = url + "/repository";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-06-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            WebSiteGetRepositoryResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new WebSiteGetRepositoryResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode uriValue = responseDoc.get("uri");
                    if (uriValue != null && uriValue instanceof NullNode == false) {
                        URI uriInstance;
                        uriInstance = new URI(uriValue.getTextValue());
                        result.setUri(uriInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Update list of app settings and connection strings which to be slot
    * specific. E.g. settings in staging slots remain in staging after swap
    * with production.
    *
    * @param resourceGroupName Required. The name of the resource group
    * @param webSiteName Required. The name of the website
    * @return List of slot specific settings.
    */
    @Override
    public Future<SlotConfigNamesResult> getSlotConfigNamesAsync(final String resourceGroupName, final String webSiteName) {
        return this.getClient().getExecutorService().submit(new Callable<SlotConfigNamesResult>() { 
            @Override
            public SlotConfigNamesResult call() throws Exception {
                return getSlotConfigNames(resourceGroupName, webSiteName);
            }
         });
    }
    
    /**
    * Update list of app settings and connection strings which to be slot
    * specific. E.g. settings in staging slots remain in staging after swap
    * with production.
    *
    * @param resourceGroupName Required. The name of the resource group
    * @param webSiteName Required. The name of the website
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return List of slot specific settings.
    */
    @Override
    public SlotConfigNamesResult getSlotConfigNames(String resourceGroupName, String webSiteName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (webSiteName == null) {
            throw new NullPointerException("webSiteName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("webSiteName", webSiteName);
            CloudTracing.enter(invocationId, this, "getSlotConfigNamesAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Web";
        url = url + "/";
        url = url + "sites";
        url = url + "/";
        url = url + URLEncoder.encode(webSiteName, "UTF-8");
        url = url + "/config/slotConfigNames";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-06-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("accept", "application/json");
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            SlotConfigNamesResult result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new SlotConfigNamesResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    SlotConfigNamesEnvelope resourceInstance = new SlotConfigNamesEnvelope();
                    result.setResource(resourceInstance);
                    
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                        SlotConfigNames propertiesInstance = new SlotConfigNames();
                        resourceInstance.setProperties(propertiesInstance);
                        
                        JsonNode connectionStringNamesArray = propertiesValue.get("connectionStringNames");
                        if (connectionStringNamesArray != null && connectionStringNamesArray instanceof NullNode == false) {
                            for (JsonNode connectionStringNamesValue : ((ArrayNode) connectionStringNamesArray)) {
                                propertiesInstance.getConnectionStringNames().add(connectionStringNamesValue.getTextValue());
                            }
                        }
                        
                        JsonNode appSettingNamesArray = propertiesValue.get("appSettingNames");
                        if (appSettingNamesArray != null && appSettingNamesArray instanceof NullNode == false) {
                            for (JsonNode appSettingNamesValue : ((ArrayNode) appSettingNamesArray)) {
                                propertiesInstance.getAppSettingNames().add(appSettingNamesValue.getTextValue());
                            }
                        }
                    }
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        resourceInstance.setId(idInstance);
                    }
                    
                    JsonNode nameValue = responseDoc.get("name");
                    if (nameValue != null && nameValue instanceof NullNode == false) {
                        String nameInstance;
                        nameInstance = nameValue.getTextValue();
                        resourceInstance.setName(nameInstance);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        resourceInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry<String, JsonNode> property = itr.next();
                            String tagsKey = property.getKey();
                            String tagsValue = property.getValue().getTextValue();
                            resourceInstance.getTags().put(tagsKey, tagsValue);
                        }
                    }
                    
                    JsonNode typeValue = responseDoc.get("type");
                    if (typeValue != null && typeValue instanceof NullNode == false) {
                        String typeInstance;
                        typeInstance = typeValue.getTextValue();
                        resourceInstance.setType(typeInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Get a web site's current usage metrics. The metrics returned include CPU
    * Time, Data In, Data Out, Local bytes read, Local bytes written, Network
    * bytes read, Network bytes written, WP stop requests, Memory Usage, CPU
    * Time - Minute Limit, and File System Storage.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166991.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @return The Get Web Site Usage Metrics operation response.
    */
    @Override
    public Future<WebSiteGetUsageMetricsResponse> getUsageMetricsAsync(final String resourceGroupName, final String webSiteName, final String slotName) {
        return this.getClient().getExecutorService().submit(new Callable<WebSiteGetUsageMetricsResponse>() { 
            @Override
            public WebSiteGetUsageMetricsResponse call() throws Exception {
                return getUsageMetrics(resourceGroupName, webSiteName, slotName);
            }
         });
    }
    
    /**
    * Get a web site's current usage metrics. The metrics returned include CPU
    * Time, Data In, Data Out, Local bytes read, Local bytes written, Network
    * bytes read, Network bytes written, WP stop requests, Memory Usage, CPU
    * Time - Minute Limit, and File System Storage.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166991.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The Get Web Site Usage Metrics operation response.
    */
    @Override
    public WebSiteGetUsageMetricsResponse getUsageMetrics(String resourceGroupName, String webSiteName, String slotName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (webSiteName == null) {
            throw new NullPointerException("webSiteName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("webSiteName", webSiteName);
            tracingParameters.put("slotName", slotName);
            CloudTracing.enter(invocationId, this, "getUsageMetricsAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Web";
        url = url + "/";
        url = url + "sites";
        url = url + "/";
        url = url + URLEncoder.encode(webSiteName, "UTF-8");
        if (slotName != null) {
            url = url + "/slots/" + URLEncoder.encode(slotName, "UTF-8");
        }
        url = url + "/usages";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-06-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            WebSiteGetUsageMetricsResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new WebSiteGetUsageMetricsResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                JsonNode usagesValue = responseDoc.get("usages");
                if (usagesValue != null && usagesValue instanceof NullNode == false) {
                    WebSiteGetUsageMetricsResponse usagesInstance = new WebSiteGetUsageMetricsResponse();
                    
                    JsonNode usageMetricsArray = usagesValue;
                    if (usageMetricsArray != null && usageMetricsArray instanceof NullNode == false) {
                        for (JsonNode usageMetricsValue : ((ArrayNode) usageMetricsArray)) {
                            WebSiteGetUsageMetricsResponse.UsageMetric usageInstance = new WebSiteGetUsageMetricsResponse.UsageMetric();
                            usagesInstance.getUsageMetrics().add(usageInstance);
                            
                            JsonNode currentValueValue = usageMetricsValue.get("currentValue");
                            if (currentValueValue != null && currentValueValue instanceof NullNode == false) {
                                String currentValueInstance;
                                currentValueInstance = currentValueValue.getTextValue();
                                usageInstance.setCurrentValue(currentValueInstance);
                            }
                            
                            JsonNode displayNameValue = usageMetricsValue.get("displayName");
                            if (displayNameValue != null && displayNameValue instanceof NullNode == false) {
                                String displayNameInstance;
                                displayNameInstance = displayNameValue.getTextValue();
                                usageInstance.setDisplayName(displayNameInstance);
                            }
                            
                            JsonNode limitValue = usageMetricsValue.get("limit");
                            if (limitValue != null && limitValue instanceof NullNode == false) {
                                String limitInstance;
                                limitInstance = limitValue.getTextValue();
                                usageInstance.setLimit(limitInstance);
                            }
                            
                            JsonNode nameValue = usageMetricsValue.get("name");
                            if (nameValue != null && nameValue instanceof NullNode == false) {
                                String nameInstance;
                                nameInstance = nameValue.getTextValue();
                                usageInstance.setName(nameInstance);
                            }
                            
                            JsonNode nextResetTimeValue = usageMetricsValue.get("nextResetTime");
                            if (nextResetTimeValue != null && nextResetTimeValue instanceof NullNode == false) {
                                Calendar nextResetTimeInstance;
                                nextResetTimeInstance = DatatypeConverter.parseDateTime(nextResetTimeValue.getTextValue());
                                usageInstance.setNextResetTime(nextResetTimeInstance);
                            }
                            
                            JsonNode resourceNameValue = usageMetricsValue.get("resourceName");
                            if (resourceNameValue != null && resourceNameValue instanceof NullNode == false) {
                                String resourceNameInstance;
                                resourceNameInstance = resourceNameValue.getTextValue();
                                usageInstance.setResourceName(resourceNameInstance);
                            }
                            
                            JsonNode unitValue = usageMetricsValue.get("unit");
                            if (unitValue != null && unitValue instanceof NullNode == false) {
                                String unitInstance;
                                unitInstance = unitValue.getTextValue();
                                usageInstance.setUnit(unitInstance);
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * List the Web Sites in a resource group.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Optional. The name of the web site.
    * @param parameters Optional. Additional parameters.
    * @return The List Web Sites operation response.
    */
    @Override
    public Future<WebSiteListResponse> listAsync(final String resourceGroupName, final String webSiteName, final WebSiteListParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<WebSiteListResponse>() { 
            @Override
            public WebSiteListResponse call() throws Exception {
                return list(resourceGroupName, webSiteName, parameters);
            }
         });
    }
    
    /**
    * List the Web Sites in a resource group.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Optional. The name of the web site.
    * @param parameters Optional. Additional parameters.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The List Web Sites operation response.
    */
    @Override
    public WebSiteListResponse list(String resourceGroupName, String webSiteName, WebSiteListParameters parameters) throws IOException, ServiceException, URISyntaxException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("webSiteName", webSiteName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "listAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Web";
        url = url + "/";
        url = url + "sites";
        if (webSiteName != null) {
            url = url + "/" + URLEncoder.encode(webSiteName, "UTF-8") + "/slots/";
        }
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-06-01");
        if (parameters != null && parameters.getPropertiesToInclude() != null && parameters.getPropertiesToInclude().size() > 0) {
            queryParameters.add("propertiesToInclude=" + URLEncoder.encode(CollectionStringBuilder.join(parameters.getPropertiesToInclude(), ","), "UTF-8"));
        }
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            WebSiteListResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new WebSiteListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && valueArray instanceof NullNode == false) {
                        for (JsonNode valueValue : ((ArrayNode) valueArray)) {
                            WebSite webSiteInstance = new WebSite();
                            result.getWebSites().add(webSiteInstance);
                            
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                                WebSiteProperties propertiesInstance = new WebSiteProperties();
                                webSiteInstance.setProperties(propertiesInstance);
                                
                                JsonNode adminEnabledValue = propertiesValue.get("adminEnabled");
                                if (adminEnabledValue != null && adminEnabledValue instanceof NullNode == false) {
                                    boolean adminEnabledInstance;
                                    adminEnabledInstance = adminEnabledValue.getBooleanValue();
                                    propertiesInstance.setAdminEnabled(adminEnabledInstance);
                                }
                                
                                JsonNode availabilityStateValue = propertiesValue.get("availabilityState");
                                if (availabilityStateValue != null && availabilityStateValue instanceof NullNode == false) {
                                    WebSpaceAvailabilityState availabilityStateInstance;
                                    availabilityStateInstance = Enum.valueOf(WebSpaceAvailabilityState.class, availabilityStateValue.getTextValue());
                                    propertiesInstance.setAvailabilityState(availabilityStateInstance);
                                }
                                
                                JsonNode enabledValue = propertiesValue.get("enabled");
                                if (enabledValue != null && enabledValue instanceof NullNode == false) {
                                    boolean enabledInstance;
                                    enabledInstance = enabledValue.getBooleanValue();
                                    propertiesInstance.setEnabled(enabledInstance);
                                }
                                
                                JsonNode enabledHostNamesArray = propertiesValue.get("enabledHostNames");
                                if (enabledHostNamesArray != null && enabledHostNamesArray instanceof NullNode == false) {
                                    for (JsonNode enabledHostNamesValue : ((ArrayNode) enabledHostNamesArray)) {
                                        propertiesInstance.getEnabledHostNames().add(enabledHostNamesValue.getTextValue());
                                    }
                                }
                                
                                JsonNode hostNameSslStatesArray = propertiesValue.get("hostNameSslStates");
                                if (hostNameSslStatesArray != null && hostNameSslStatesArray instanceof NullNode == false) {
                                    for (JsonNode hostNameSslStatesValue : ((ArrayNode) hostNameSslStatesArray)) {
                                        WebSiteProperties.WebSiteHostNameSslState webSiteHostNameSslStateInstance = new WebSiteProperties.WebSiteHostNameSslState();
                                        propertiesInstance.getHostNameSslStates().add(webSiteHostNameSslStateInstance);
                                        
                                        JsonNode nameValue = hostNameSslStatesValue.get("name");
                                        if (nameValue != null && nameValue instanceof NullNode == false) {
                                            String nameInstance;
                                            nameInstance = nameValue.getTextValue();
                                            webSiteHostNameSslStateInstance.setName(nameInstance);
                                        }
                                        
                                        JsonNode sslStateValue = hostNameSslStatesValue.get("sslState");
                                        if (sslStateValue != null && sslStateValue instanceof NullNode == false) {
                                            WebSiteSslState sslStateInstance;
                                            sslStateInstance = Enum.valueOf(WebSiteSslState.class, sslStateValue.getTextValue());
                                            webSiteHostNameSslStateInstance.setSslState(sslStateInstance);
                                        }
                                        
                                        JsonNode thumbprintValue = hostNameSslStatesValue.get("thumbprint");
                                        if (thumbprintValue != null && thumbprintValue instanceof NullNode == false) {
                                            String thumbprintInstance;
                                            thumbprintInstance = thumbprintValue.getTextValue();
                                            webSiteHostNameSslStateInstance.setThumbprint(thumbprintInstance);
                                        }
                                        
                                        JsonNode virtualIPValue = hostNameSslStatesValue.get("virtualIP");
                                        if (virtualIPValue != null && virtualIPValue instanceof NullNode == false) {
                                            InetAddress virtualIPInstance;
                                            virtualIPInstance = InetAddress.getByName(virtualIPValue.getTextValue());
                                            webSiteHostNameSslStateInstance.setVirtualIP(virtualIPInstance);
                                        }
                                        
                                        JsonNode ipBasedSslResultValue = hostNameSslStatesValue.get("ipBasedSslResult");
                                        if (ipBasedSslResultValue != null && ipBasedSslResultValue instanceof NullNode == false) {
                                            String ipBasedSslResultInstance;
                                            ipBasedSslResultInstance = ipBasedSslResultValue.getTextValue();
                                            webSiteHostNameSslStateInstance.setIpBasedSslResult(ipBasedSslResultInstance);
                                        }
                                        
                                        JsonNode toUpdateValue = hostNameSslStatesValue.get("toUpdate");
                                        if (toUpdateValue != null && toUpdateValue instanceof NullNode == false) {
                                            boolean toUpdateInstance;
                                            toUpdateInstance = toUpdateValue.getBooleanValue();
                                            webSiteHostNameSslStateInstance.setToUpdate(toUpdateInstance);
                                        }
                                        
                                        JsonNode toUpdateIpBasedSslValue = hostNameSslStatesValue.get("toUpdateIpBasedSsl");
                                        if (toUpdateIpBasedSslValue != null && toUpdateIpBasedSslValue instanceof NullNode == false) {
                                            boolean toUpdateIpBasedSslInstance;
                                            toUpdateIpBasedSslInstance = toUpdateIpBasedSslValue.getBooleanValue();
                                            webSiteHostNameSslStateInstance.setToUpdateIpBasedSsl(toUpdateIpBasedSslInstance);
                                        }
                                        
                                        JsonNode hostTypeValue = hostNameSslStatesValue.get("hostType");
                                        if (hostTypeValue != null && hostTypeValue instanceof NullNode == false) {
                                            HostType hostTypeInstance;
                                            hostTypeInstance = Enum.valueOf(HostType.class, hostTypeValue.getTextValue());
                                            webSiteHostNameSslStateInstance.setHostType(hostTypeInstance);
                                        }
                                    }
                                }
                                
                                JsonNode hostNamesArray = propertiesValue.get("hostNames");
                                if (hostNamesArray != null && hostNamesArray instanceof NullNode == false) {
                                    for (JsonNode hostNamesValue : ((ArrayNode) hostNamesArray)) {
                                        propertiesInstance.getHostNames().add(hostNamesValue.getTextValue());
                                    }
                                }
                                
                                JsonNode lastModifiedTimeUtcValue = propertiesValue.get("lastModifiedTimeUtc");
                                if (lastModifiedTimeUtcValue != null && lastModifiedTimeUtcValue instanceof NullNode == false) {
                                    Calendar lastModifiedTimeUtcInstance;
                                    lastModifiedTimeUtcInstance = DatatypeConverter.parseDateTime(lastModifiedTimeUtcValue.getTextValue());
                                    propertiesInstance.setLastModifiedTimeUtc(lastModifiedTimeUtcInstance);
                                }
                                
                                JsonNode repositorySiteNameValue = propertiesValue.get("repositorySiteName");
                                if (repositorySiteNameValue != null && repositorySiteNameValue instanceof NullNode == false) {
                                    String repositorySiteNameInstance;
                                    repositorySiteNameInstance = repositorySiteNameValue.getTextValue();
                                    propertiesInstance.setRepositorySiteName(repositorySiteNameInstance);
                                }
                                
                                JsonNode runtimeAvailabilityStateValue = propertiesValue.get("runtimeAvailabilityState");
                                if (runtimeAvailabilityStateValue != null && runtimeAvailabilityStateValue instanceof NullNode == false) {
                                    WebSiteRuntimeAvailabilityState runtimeAvailabilityStateInstance;
                                    runtimeAvailabilityStateInstance = Enum.valueOf(WebSiteRuntimeAvailabilityState.class, runtimeAvailabilityStateValue.getTextValue());
                                    propertiesInstance.setRuntimeAvailabilityState(runtimeAvailabilityStateInstance);
                                }
                                
                                JsonNode trafficManagerHostNamesArray = propertiesValue.get("trafficManagerHostNames");
                                if (trafficManagerHostNamesArray != null && trafficManagerHostNamesArray instanceof NullNode == false) {
                                    for (JsonNode trafficManagerHostNamesValue : ((ArrayNode) trafficManagerHostNamesArray)) {
                                        propertiesInstance.getTrafficManagerHostNames().add(trafficManagerHostNamesValue.getTextValue());
                                    }
                                }
                                
                                JsonNode selfLinkValue = propertiesValue.get("selfLink");
                                if (selfLinkValue != null && selfLinkValue instanceof NullNode == false) {
                                    URI selfLinkInstance;
                                    selfLinkInstance = new URI(selfLinkValue.getTextValue());
                                    propertiesInstance.setUri(selfLinkInstance);
                                }
                                
                                JsonNode serverFarmValue = propertiesValue.get("serverFarm");
                                if (serverFarmValue != null && serverFarmValue instanceof NullNode == false) {
                                    String serverFarmInstance;
                                    serverFarmInstance = serverFarmValue.getTextValue();
                                    propertiesInstance.setServerFarm(serverFarmInstance);
                                }
                                
                                JsonNode serverFarmIdValue = propertiesValue.get("serverFarmId");
                                if (serverFarmIdValue != null && serverFarmIdValue instanceof NullNode == false) {
                                    String serverFarmIdInstance;
                                    serverFarmIdInstance = serverFarmIdValue.getTextValue();
                                    propertiesInstance.setServerFarmId(serverFarmIdInstance);
                                }
                                
                                JsonNode skuValue = propertiesValue.get("sku");
                                if (skuValue != null && skuValue instanceof NullNode == false) {
                                    SkuOptions skuInstance;
                                    skuInstance = Enum.valueOf(SkuOptions.class, skuValue.getTextValue());
                                    propertiesInstance.setSku(skuInstance);
                                }
                                
                                JsonNode sitePropertiesValue = propertiesValue.get("siteProperties");
                                if (sitePropertiesValue != null && sitePropertiesValue instanceof NullNode == false) {
                                    WebSiteProperties.SiteProperties sitePropertiesInstance = new WebSiteProperties.SiteProperties();
                                    propertiesInstance.setProperties(sitePropertiesInstance);
                                    
                                    JsonNode appSettingsSequenceElement = ((JsonNode) sitePropertiesValue.get("appSettings"));
                                    if (appSettingsSequenceElement != null && appSettingsSequenceElement instanceof NullNode == false) {
                                        Iterator<Map.Entry<String, JsonNode>> itr = appSettingsSequenceElement.getFields();
                                        while (itr.hasNext()) {
                                            Map.Entry<String, JsonNode> property = itr.next();
                                            String appSettingsKey = property.getKey();
                                            String appSettingsValue = property.getValue().getTextValue();
                                            sitePropertiesInstance.getAppSettings().put(appSettingsKey, appSettingsValue);
                                        }
                                    }
                                    
                                    JsonNode metadataSequenceElement = ((JsonNode) sitePropertiesValue.get("metadata"));
                                    if (metadataSequenceElement != null && metadataSequenceElement instanceof NullNode == false) {
                                        Iterator<Map.Entry<String, JsonNode>> itr2 = metadataSequenceElement.getFields();
                                        while (itr2.hasNext()) {
                                            Map.Entry<String, JsonNode> property2 = itr2.next();
                                            String metadataKey = property2.getKey();
                                            String metadataValue = property2.getValue().getTextValue();
                                            sitePropertiesInstance.getMetadata().put(metadataKey, metadataValue);
                                        }
                                    }
                                    
                                    JsonNode propertiesSequenceElement = ((JsonNode) sitePropertiesValue.get("properties"));
                                    if (propertiesSequenceElement != null && propertiesSequenceElement instanceof NullNode == false) {
                                        Iterator<Map.Entry<String, JsonNode>> itr3 = propertiesSequenceElement.getFields();
                                        while (itr3.hasNext()) {
                                            Map.Entry<String, JsonNode> property3 = itr3.next();
                                            String propertiesKey = property3.getKey();
                                            String propertiesValue2 = property3.getValue().getTextValue();
                                            sitePropertiesInstance.getProperties().put(propertiesKey, propertiesValue2);
                                        }
                                    }
                                }
                                
                                JsonNode siteConfigValue = propertiesValue.get("siteConfig");
                                if (siteConfigValue != null && siteConfigValue instanceof NullNode == false) {
                                    WebSiteConfiguration siteConfigInstance = new WebSiteConfiguration();
                                    propertiesInstance.setSiteConfig(siteConfigInstance);
                                    
                                    JsonNode appSettingsSequenceElement2 = ((JsonNode) siteConfigValue.get("appSettings"));
                                    if (appSettingsSequenceElement2 != null && appSettingsSequenceElement2 instanceof NullNode == false) {
                                        Iterator<Map.Entry<String, JsonNode>> itr4 = appSettingsSequenceElement2.getFields();
                                        while (itr4.hasNext()) {
                                            Map.Entry<String, JsonNode> property4 = itr4.next();
                                            String appSettingsKey2 = property4.getKey();
                                            String appSettingsValue2 = property4.getValue().getTextValue();
                                            siteConfigInstance.getAppSettings().put(appSettingsKey2, appSettingsValue2);
                                        }
                                    }
                                    
                                    JsonNode connectionStringsArray = siteConfigValue.get("connectionStrings");
                                    if (connectionStringsArray != null && connectionStringsArray instanceof NullNode == false) {
                                        for (JsonNode connectionStringsValue : ((ArrayNode) connectionStringsArray)) {
                                            ConnectionStringInfo connStringInfoInstance = new ConnectionStringInfo();
                                            siteConfigInstance.getConnectionStrings().add(connStringInfoInstance);
                                            
                                            JsonNode connectionStringValue = connectionStringsValue.get("connectionString");
                                            if (connectionStringValue != null && connectionStringValue instanceof NullNode == false) {
                                                String connectionStringInstance;
                                                connectionStringInstance = connectionStringValue.getTextValue();
                                                connStringInfoInstance.setConnectionString(connectionStringInstance);
                                            }
                                            
                                            JsonNode nameValue2 = connectionStringsValue.get("name");
                                            if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                                                String nameInstance2;
                                                nameInstance2 = nameValue2.getTextValue();
                                                connStringInfoInstance.setName(nameInstance2);
                                            }
                                            
                                            JsonNode typeValue = connectionStringsValue.get("type");
                                            if (typeValue != null && typeValue instanceof NullNode == false) {
                                                DatabaseServerType typeInstance;
                                                typeInstance = Enum.valueOf(DatabaseServerType.class, typeValue.getTextValue());
                                                connStringInfoInstance.setType(typeInstance);
                                            }
                                        }
                                    }
                                    
                                    JsonNode defaultDocumentsArray = siteConfigValue.get("defaultDocuments");
                                    if (defaultDocumentsArray != null && defaultDocumentsArray instanceof NullNode == false) {
                                        for (JsonNode defaultDocumentsValue : ((ArrayNode) defaultDocumentsArray)) {
                                            siteConfigInstance.getDefaultDocuments().add(defaultDocumentsValue.getTextValue());
                                        }
                                    }
                                    
                                    JsonNode detailedErrorLoggingEnabledValue = siteConfigValue.get("detailedErrorLoggingEnabled");
                                    if (detailedErrorLoggingEnabledValue != null && detailedErrorLoggingEnabledValue instanceof NullNode == false) {
                                        boolean detailedErrorLoggingEnabledInstance;
                                        detailedErrorLoggingEnabledInstance = detailedErrorLoggingEnabledValue.getBooleanValue();
                                        siteConfigInstance.setDetailedErrorLoggingEnabled(detailedErrorLoggingEnabledInstance);
                                    }
                                    
                                    JsonNode documentRootValue = siteConfigValue.get("documentRoot");
                                    if (documentRootValue != null && documentRootValue instanceof NullNode == false) {
                                        String documentRootInstance;
                                        documentRootInstance = documentRootValue.getTextValue();
                                        siteConfigInstance.setDocumentRoot(documentRootInstance);
                                    }
                                    
                                    JsonNode handlerMappingsArray = siteConfigValue.get("handlerMappings");
                                    if (handlerMappingsArray != null && handlerMappingsArray instanceof NullNode == false) {
                                        for (JsonNode handlerMappingsValue : ((ArrayNode) handlerMappingsArray)) {
                                            WebSiteConfiguration.HandlerMapping handlerMappingInstance = new WebSiteConfiguration.HandlerMapping();
                                            siteConfigInstance.getHandlerMappings().add(handlerMappingInstance);
                                            
                                            JsonNode argumentsValue = handlerMappingsValue.get("arguments");
                                            if (argumentsValue != null && argumentsValue instanceof NullNode == false) {
                                                String argumentsInstance;
                                                argumentsInstance = argumentsValue.getTextValue();
                                                handlerMappingInstance.setArguments(argumentsInstance);
                                            }
                                            
                                            JsonNode extensionValue = handlerMappingsValue.get("extension");
                                            if (extensionValue != null && extensionValue instanceof NullNode == false) {
                                                String extensionInstance;
                                                extensionInstance = extensionValue.getTextValue();
                                                handlerMappingInstance.setExtension(extensionInstance);
                                            }
                                            
                                            JsonNode scriptProcessorValue = handlerMappingsValue.get("scriptProcessor");
                                            if (scriptProcessorValue != null && scriptProcessorValue instanceof NullNode == false) {
                                                String scriptProcessorInstance;
                                                scriptProcessorInstance = scriptProcessorValue.getTextValue();
                                                handlerMappingInstance.setScriptProcessor(scriptProcessorInstance);
                                            }
                                        }
                                    }
                                    
                                    JsonNode httpLoggingEnabledValue = siteConfigValue.get("httpLoggingEnabled");
                                    if (httpLoggingEnabledValue != null && httpLoggingEnabledValue instanceof NullNode == false) {
                                        boolean httpLoggingEnabledInstance;
                                        httpLoggingEnabledInstance = httpLoggingEnabledValue.getBooleanValue();
                                        siteConfigInstance.setHttpLoggingEnabled(httpLoggingEnabledInstance);
                                    }
                                    
                                    JsonNode logsDirectorySizeLimitValue = siteConfigValue.get("logsDirectorySizeLimit");
                                    if (logsDirectorySizeLimitValue != null && logsDirectorySizeLimitValue instanceof NullNode == false) {
                                        int logsDirectorySizeLimitInstance;
                                        logsDirectorySizeLimitInstance = logsDirectorySizeLimitValue.getIntValue();
                                        siteConfigInstance.setLogsDirectorySizeLimit(logsDirectorySizeLimitInstance);
                                    }
                                    
                                    JsonNode managedPipelineModeValue = siteConfigValue.get("managedPipelineMode");
                                    if (managedPipelineModeValue != null && managedPipelineModeValue instanceof NullNode == false) {
                                        ManagedPipelineMode managedPipelineModeInstance;
                                        managedPipelineModeInstance = Enum.valueOf(ManagedPipelineMode.class, managedPipelineModeValue.getTextValue());
                                        siteConfigInstance.setManagedPipelineMode(managedPipelineModeInstance);
                                    }
                                    
                                    JsonNode metadataSequenceElement2 = ((JsonNode) siteConfigValue.get("metadata"));
                                    if (metadataSequenceElement2 != null && metadataSequenceElement2 instanceof NullNode == false) {
                                        Iterator<Map.Entry<String, JsonNode>> itr5 = metadataSequenceElement2.getFields();
                                        while (itr5.hasNext()) {
                                            Map.Entry<String, JsonNode> property5 = itr5.next();
                                            String metadataKey2 = property5.getKey();
                                            String metadataValue2 = property5.getValue().getTextValue();
                                            siteConfigInstance.getMetadata().put(metadataKey2, metadataValue2);
                                        }
                                    }
                                    
                                    JsonNode netFrameworkVersionValue = siteConfigValue.get("netFrameworkVersion");
                                    if (netFrameworkVersionValue != null && netFrameworkVersionValue instanceof NullNode == false) {
                                        String netFrameworkVersionInstance;
                                        netFrameworkVersionInstance = netFrameworkVersionValue.getTextValue();
                                        siteConfigInstance.setNetFrameworkVersion(netFrameworkVersionInstance);
                                    }
                                    
                                    JsonNode numberOfWorkersValue = siteConfigValue.get("numberOfWorkers");
                                    if (numberOfWorkersValue != null && numberOfWorkersValue instanceof NullNode == false) {
                                        int numberOfWorkersInstance;
                                        numberOfWorkersInstance = numberOfWorkersValue.getIntValue();
                                        siteConfigInstance.setNumberOfWorkers(numberOfWorkersInstance);
                                    }
                                    
                                    JsonNode phpVersionValue = siteConfigValue.get("phpVersion");
                                    if (phpVersionValue != null && phpVersionValue instanceof NullNode == false) {
                                        String phpVersionInstance;
                                        phpVersionInstance = phpVersionValue.getTextValue();
                                        siteConfigInstance.setPhpVersion(phpVersionInstance);
                                    }
                                    
                                    JsonNode pythonVersionValue = siteConfigValue.get("pythonVersion");
                                    if (pythonVersionValue != null && pythonVersionValue instanceof NullNode == false) {
                                        String pythonVersionInstance;
                                        pythonVersionInstance = pythonVersionValue.getTextValue();
                                        siteConfigInstance.setPythonVersion(pythonVersionInstance);
                                    }
                                    
                                    JsonNode publishingPasswordValue = siteConfigValue.get("publishingPassword");
                                    if (publishingPasswordValue != null && publishingPasswordValue instanceof NullNode == false) {
                                        String publishingPasswordInstance;
                                        publishingPasswordInstance = publishingPasswordValue.getTextValue();
                                        siteConfigInstance.setPublishingPassword(publishingPasswordInstance);
                                    }
                                    
                                    JsonNode publishingUsernameValue = siteConfigValue.get("publishingUsername");
                                    if (publishingUsernameValue != null && publishingUsernameValue instanceof NullNode == false) {
                                        String publishingUsernameInstance;
                                        publishingUsernameInstance = publishingUsernameValue.getTextValue();
                                        siteConfigInstance.setPublishingUserName(publishingUsernameInstance);
                                    }
                                    
                                    JsonNode remoteDebuggingEnabledValue = siteConfigValue.get("RemoteDebuggingEnabled");
                                    if (remoteDebuggingEnabledValue != null && remoteDebuggingEnabledValue instanceof NullNode == false) {
                                        boolean remoteDebuggingEnabledInstance;
                                        remoteDebuggingEnabledInstance = remoteDebuggingEnabledValue.getBooleanValue();
                                        siteConfigInstance.setRemoteDebuggingEnabled(remoteDebuggingEnabledInstance);
                                    }
                                    
                                    JsonNode remoteDebuggingVersionValue = siteConfigValue.get("remoteDebuggingVersion");
                                    if (remoteDebuggingVersionValue != null && remoteDebuggingVersionValue instanceof NullNode == false) {
                                        RemoteDebuggingVersion remoteDebuggingVersionInstance;
                                        remoteDebuggingVersionInstance = Enum.valueOf(RemoteDebuggingVersion.class, remoteDebuggingVersionValue.getTextValue());
                                        siteConfigInstance.setRemoteDebuggingVersion(remoteDebuggingVersionInstance);
                                    }
                                    
                                    JsonNode requestTracingEnabledValue = siteConfigValue.get("requestTracingEnabled");
                                    if (requestTracingEnabledValue != null && requestTracingEnabledValue instanceof NullNode == false) {
                                        boolean requestTracingEnabledInstance;
                                        requestTracingEnabledInstance = requestTracingEnabledValue.getBooleanValue();
                                        siteConfigInstance.setRequestTracingEnabled(requestTracingEnabledInstance);
                                    }
                                    
                                    JsonNode requestTracingExpirationTimeValue = siteConfigValue.get("requestTracingExpirationTime");
                                    if (requestTracingExpirationTimeValue != null && requestTracingExpirationTimeValue instanceof NullNode == false) {
                                        Calendar requestTracingExpirationTimeInstance;
                                        requestTracingExpirationTimeInstance = DatatypeConverter.parseDateTime(requestTracingExpirationTimeValue.getTextValue());
                                        siteConfigInstance.setRequestTracingExpirationTime(requestTracingExpirationTimeInstance);
                                    }
                                    
                                    JsonNode scmTypeValue = siteConfigValue.get("scmType");
                                    if (scmTypeValue != null && scmTypeValue instanceof NullNode == false) {
                                        String scmTypeInstance;
                                        scmTypeInstance = scmTypeValue.getTextValue();
                                        siteConfigInstance.setScmType(scmTypeInstance);
                                    }
                                    
                                    JsonNode autoSwapSlotNameValue = siteConfigValue.get("autoSwapSlotName");
                                    if (autoSwapSlotNameValue != null && autoSwapSlotNameValue instanceof NullNode == false) {
                                        String autoSwapSlotNameInstance;
                                        autoSwapSlotNameInstance = autoSwapSlotNameValue.getTextValue();
                                        siteConfigInstance.setAutoSwapSlotName(autoSwapSlotNameInstance);
                                    }
                                    
                                    JsonNode use32BitWorkerProcessValue = siteConfigValue.get("use32BitWorkerProcess");
                                    if (use32BitWorkerProcessValue != null && use32BitWorkerProcessValue instanceof NullNode == false) {
                                        boolean use32BitWorkerProcessInstance;
                                        use32BitWorkerProcessInstance = use32BitWorkerProcessValue.getBooleanValue();
                                        siteConfigInstance.setUse32BitWorkerProcess(use32BitWorkerProcessInstance);
                                    }
                                    
                                    JsonNode webSocketsEnabledValue = siteConfigValue.get("webSocketsEnabled");
                                    if (webSocketsEnabledValue != null && webSocketsEnabledValue instanceof NullNode == false) {
                                        boolean webSocketsEnabledInstance;
                                        webSocketsEnabledInstance = webSocketsEnabledValue.getBooleanValue();
                                        siteConfigInstance.setWebSocketsEnabled(webSocketsEnabledInstance);
                                    }
                                    
                                    JsonNode limitsValue = siteConfigValue.get("limits");
                                    if (limitsValue != null && limitsValue instanceof NullNode == false) {
                                        SiteLimits limitsInstance = new SiteLimits();
                                        siteConfigInstance.setLimits(limitsInstance);
                                        
                                        JsonNode maxPercentageCpuValue = limitsValue.get("maxPercentageCpu");
                                        if (maxPercentageCpuValue != null && maxPercentageCpuValue instanceof NullNode == false) {
                                            double maxPercentageCpuInstance;
                                            maxPercentageCpuInstance = maxPercentageCpuValue.getDoubleValue();
                                            limitsInstance.setMaxPercentageCpu(maxPercentageCpuInstance);
                                        }
                                        
                                        JsonNode maxMemoryInMbValue = limitsValue.get("maxMemoryInMb");
                                        if (maxMemoryInMbValue != null && maxMemoryInMbValue instanceof NullNode == false) {
                                            long maxMemoryInMbInstance;
                                            maxMemoryInMbInstance = maxMemoryInMbValue.getLongValue();
                                            limitsInstance.setMaxMemoryInMb(maxMemoryInMbInstance);
                                        }
                                        
                                        JsonNode maxDiskSizeInMbValue = limitsValue.get("maxDiskSizeInMb");
                                        if (maxDiskSizeInMbValue != null && maxDiskSizeInMbValue instanceof NullNode == false) {
                                            long maxDiskSizeInMbInstance;
                                            maxDiskSizeInMbInstance = maxDiskSizeInMbValue.getLongValue();
                                            limitsInstance.setMaxDiskSizeInMb(maxDiskSizeInMbInstance);
                                        }
                                    }
                                }
                                
                                JsonNode stateValue = propertiesValue.get("state");
                                if (stateValue != null && stateValue instanceof NullNode == false) {
                                    WebSiteState stateInstance;
                                    stateInstance = Enum.valueOf(WebSiteState.class, stateValue.getTextValue());
                                    propertiesInstance.setState(stateInstance);
                                }
                                
                                JsonNode usageStateValue = propertiesValue.get("usageState");
                                if (usageStateValue != null && usageStateValue instanceof NullNode == false) {
                                    WebSiteUsageState usageStateInstance;
                                    usageStateInstance = Enum.valueOf(WebSiteUsageState.class, usageStateValue.getTextValue());
                                    propertiesInstance.setUsageState(usageStateInstance);
                                }
                                
                                JsonNode webSpaceValue = propertiesValue.get("webSpace");
                                if (webSpaceValue != null && webSpaceValue instanceof NullNode == false) {
                                    String webSpaceInstance;
                                    webSpaceInstance = webSpaceValue.getTextValue();
                                    propertiesInstance.setWebSpace(webSpaceInstance);
                                }
                                
                                JsonNode provisioningStateValue = propertiesValue.get("provisioningState");
                                if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                                    String provisioningStateInstance;
                                    provisioningStateInstance = provisioningStateValue.getTextValue();
                                    propertiesInstance.setProvisioningState(provisioningStateInstance);
                                }
                            }
                            
                            JsonNode idValue = valueValue.get("id");
                            if (idValue != null && idValue instanceof NullNode == false) {
                                String idInstance;
                                idInstance = idValue.getTextValue();
                                webSiteInstance.setId(idInstance);
                            }
                            
                            JsonNode nameValue3 = valueValue.get("name");
                            if (nameValue3 != null && nameValue3 instanceof NullNode == false) {
                                String nameInstance3;
                                nameInstance3 = nameValue3.getTextValue();
                                webSiteInstance.setName(nameInstance3);
                            }
                            
                            JsonNode locationValue = valueValue.get("location");
                            if (locationValue != null && locationValue instanceof NullNode == false) {
                                String locationInstance;
                                locationInstance = locationValue.getTextValue();
                                webSiteInstance.setLocation(locationInstance);
                            }
                            
                            JsonNode tagsSequenceElement = ((JsonNode) valueValue.get("tags"));
                            if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr6 = tagsSequenceElement.getFields();
                                while (itr6.hasNext()) {
                                    Map.Entry<String, JsonNode> property6 = itr6.next();
                                    String tagsKey = property6.getKey();
                                    String tagsValue = property6.getValue().getTextValue();
                                    webSiteInstance.getTags().put(tagsKey, tagsValue);
                                }
                            }
                            
                            JsonNode typeValue2 = valueValue.get("type");
                            if (typeValue2 != null && typeValue2 instanceof NullNode == false) {
                                String typeInstance2;
                                typeInstance2 = typeValue2.getTextValue();
                                webSiteInstance.setType(typeInstance2);
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Returns list of all backups which are tracked by the system.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @return List of backups for the website.
    */
    @Override
    public Future<WebSiteGetBackupsResponse> listBackupsAsync(final String resourceGroupName, final String webSiteName, final String slotName) {
        return this.getClient().getExecutorService().submit(new Callable<WebSiteGetBackupsResponse>() { 
            @Override
            public WebSiteGetBackupsResponse call() throws Exception {
                return listBackups(resourceGroupName, webSiteName, slotName);
            }
         });
    }
    
    /**
    * Returns list of all backups which are tracked by the system.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return List of backups for the website.
    */
    @Override
    public WebSiteGetBackupsResponse listBackups(String resourceGroupName, String webSiteName, String slotName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (webSiteName == null) {
            throw new NullPointerException("webSiteName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("webSiteName", webSiteName);
            tracingParameters.put("slotName", slotName);
            CloudTracing.enter(invocationId, this, "listBackupsAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Web";
        url = url + "/";
        url = url + "sites";
        url = url + "/";
        url = url + URLEncoder.encode(webSiteName, "UTF-8");
        if (slotName != null) {
            url = url + "/slots/" + URLEncoder.encode(slotName, "UTF-8");
        }
        url = url + "/restore";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-06-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("x-ms-version", "2014-06-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            WebSiteGetBackupsResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new WebSiteGetBackupsResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    BackupItemsEnvelope backupListInstance = new BackupItemsEnvelope();
                    result.setBackupList(backupListInstance);
                    
                    JsonNode propertiesArray = responseDoc.get("properties");
                    if (propertiesArray != null && propertiesArray instanceof NullNode == false) {
                        for (JsonNode propertiesValue : ((ArrayNode) propertiesArray)) {
                            BackupItem backupItemInstance = new BackupItem();
                            backupListInstance.getProperties().add(backupItemInstance);
                            
                            JsonNode storageAccountUrlValue = propertiesValue.get("storageAccountUrl");
                            if (storageAccountUrlValue != null && storageAccountUrlValue instanceof NullNode == false) {
                                String storageAccountUrlInstance;
                                storageAccountUrlInstance = storageAccountUrlValue.getTextValue();
                                backupItemInstance.setStorageAccountUrl(storageAccountUrlInstance);
                            }
                            
                            JsonNode blobNameValue = propertiesValue.get("blobName");
                            if (blobNameValue != null && blobNameValue instanceof NullNode == false) {
                                String blobNameInstance;
                                blobNameInstance = blobNameValue.getTextValue();
                                backupItemInstance.setBlobName(blobNameInstance);
                            }
                            
                            JsonNode nameValue = propertiesValue.get("name");
                            if (nameValue != null && nameValue instanceof NullNode == false) {
                                String nameInstance;
                                nameInstance = nameValue.getTextValue();
                                backupItemInstance.setName(nameInstance);
                            }
                            
                            JsonNode statusValue = propertiesValue.get("status");
                            if (statusValue != null && statusValue instanceof NullNode == false) {
                                BackupItemStatus statusInstance;
                                statusInstance = Enum.valueOf(BackupItemStatus.class, statusValue.getTextValue());
                                backupItemInstance.setStatus(statusInstance);
                            }
                            
                            JsonNode sizeInBytesValue = propertiesValue.get("sizeInBytes");
                            if (sizeInBytesValue != null && sizeInBytesValue instanceof NullNode == false) {
                                long sizeInBytesInstance;
                                sizeInBytesInstance = sizeInBytesValue.getLongValue();
                                backupItemInstance.setSizeInBytes(sizeInBytesInstance);
                            }
                            
                            JsonNode createdValue = propertiesValue.get("created");
                            if (createdValue != null && createdValue instanceof NullNode == false) {
                                Calendar createdInstance;
                                createdInstance = DatatypeConverter.parseDateTime(createdValue.getTextValue());
                                backupItemInstance.setCreated(createdInstance);
                            }
                            
                            JsonNode logValue = propertiesValue.get("log");
                            if (logValue != null && logValue instanceof NullNode == false) {
                                String logInstance;
                                logInstance = logValue.getTextValue();
                                backupItemInstance.setLog(logInstance);
                            }
                            
                            JsonNode databasesArray = propertiesValue.get("databases");
                            if (databasesArray != null && databasesArray instanceof NullNode == false) {
                                for (JsonNode databasesValue : ((ArrayNode) databasesArray)) {
                                    DatabaseBackupSetting databaseBackupSettingInstance = new DatabaseBackupSetting();
                                    backupItemInstance.getDatabases().add(databaseBackupSettingInstance);
                                    
                                    JsonNode connectionStringValue = databasesValue.get("connectionString");
                                    if (connectionStringValue != null && connectionStringValue instanceof NullNode == false) {
                                        String connectionStringInstance;
                                        connectionStringInstance = connectionStringValue.getTextValue();
                                        databaseBackupSettingInstance.setConnectionString(connectionStringInstance);
                                    }
                                    
                                    JsonNode connectionStringNameValue = databasesValue.get("connectionStringName");
                                    if (connectionStringNameValue != null && connectionStringNameValue instanceof NullNode == false) {
                                        String connectionStringNameInstance;
                                        connectionStringNameInstance = connectionStringNameValue.getTextValue();
                                        databaseBackupSettingInstance.setConnectionStringName(connectionStringNameInstance);
                                    }
                                    
                                    JsonNode databaseTypeValue = databasesValue.get("databaseType");
                                    if (databaseTypeValue != null && databaseTypeValue instanceof NullNode == false) {
                                        String databaseTypeInstance;
                                        databaseTypeInstance = databaseTypeValue.getTextValue();
                                        databaseBackupSettingInstance.setDatabaseType(databaseTypeInstance);
                                    }
                                    
                                    JsonNode nameValue2 = databasesValue.get("name");
                                    if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                                        String nameInstance2;
                                        nameInstance2 = nameValue2.getTextValue();
                                        databaseBackupSettingInstance.setName(nameInstance2);
                                    }
                                }
                            }
                            
                            JsonNode scheduledValue = propertiesValue.get("scheduled");
                            if (scheduledValue != null && scheduledValue instanceof NullNode == false) {
                                boolean scheduledInstance;
                                scheduledInstance = scheduledValue.getBooleanValue();
                                backupItemInstance.setScheduled(scheduledInstance);
                            }
                            
                            JsonNode lastRestoreTimeStampValue = propertiesValue.get("lastRestoreTimeStamp");
                            if (lastRestoreTimeStampValue != null && lastRestoreTimeStampValue instanceof NullNode == false) {
                                Calendar lastRestoreTimeStampInstance;
                                lastRestoreTimeStampInstance = DatatypeConverter.parseDateTime(lastRestoreTimeStampValue.getTextValue());
                                backupItemInstance.setLastRestoreTimeStamp(lastRestoreTimeStampInstance);
                            }
                            
                            JsonNode finishedTimeStampValue = propertiesValue.get("finishedTimeStamp");
                            if (finishedTimeStampValue != null && finishedTimeStampValue instanceof NullNode == false) {
                                Calendar finishedTimeStampInstance;
                                finishedTimeStampInstance = DatatypeConverter.parseDateTime(finishedTimeStampValue.getTextValue());
                                backupItemInstance.setFinishedTimeStamp(finishedTimeStampInstance);
                            }
                            
                            JsonNode correlationIdValue = propertiesValue.get("correlationId");
                            if (correlationIdValue != null && correlationIdValue instanceof NullNode == false) {
                                String correlationIdInstance;
                                correlationIdInstance = correlationIdValue.getTextValue();
                                backupItemInstance.setCorrelationId(correlationIdInstance);
                            }
                        }
                    }
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        backupListInstance.setId(idInstance);
                    }
                    
                    JsonNode nameValue3 = responseDoc.get("name");
                    if (nameValue3 != null && nameValue3 instanceof NullNode == false) {
                        String nameInstance3;
                        nameInstance3 = nameValue3.getTextValue();
                        backupListInstance.setName(nameInstance3);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        backupListInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry<String, JsonNode> property = itr.next();
                            String tagsKey = property.getKey();
                            String tagsValue = property.getValue().getTextValue();
                            backupListInstance.getTags().put(tagsKey, tagsValue);
                        }
                    }
                    
                    JsonNode typeValue = responseDoc.get("type");
                    if (typeValue != null && typeValue instanceof NullNode == false) {
                        String typeInstance;
                        typeInstance = typeValue.getTextValue();
                        backupListInstance.setType(typeInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Restart the web site.
    *
    * @param resourceGroupName Required. The name of the resource group
    * @param webSiteName Required. Name of website
    * @param slotName Optional. The name of the slot.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> restartAsync(final String resourceGroupName, final String webSiteName, final String slotName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return restart(resourceGroupName, webSiteName, slotName);
            }
         });
    }
    
    /**
    * Restart the web site.
    *
    * @param resourceGroupName Required. The name of the resource group
    * @param webSiteName Required. Name of website
    * @param slotName Optional. The name of the slot.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse restart(String resourceGroupName, String webSiteName, String slotName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (webSiteName == null) {
            throw new NullPointerException("webSiteName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("webSiteName", webSiteName);
            tracingParameters.put("slotName", slotName);
            CloudTracing.enter(invocationId, this, "restartAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Web";
        url = url + "/";
        url = url + "sites";
        url = url + "/";
        url = url + URLEncoder.encode(webSiteName, "UTF-8");
        if (slotName != null) {
            url = url + "/slots/" + URLEncoder.encode(slotName, "UTF-8");
        }
        url = url + "/restart";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-06-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            // Deserialize Response
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Restores a site to either a new site or existing site (Overwrite flag has
    * to be set to true for that).
    *
    * @param resourceGroupName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @param restoreRequestEnvelope Required. A restore request.
    * @return Restore operation information.
    */
    @Override
    public Future<WebSiteRestoreResponse> restoreAsync(final String resourceGroupName, final String webSiteName, final String slotName, final RestoreRequestEnvelope restoreRequestEnvelope) {
        return this.getClient().getExecutorService().submit(new Callable<WebSiteRestoreResponse>() { 
            @Override
            public WebSiteRestoreResponse call() throws Exception {
                return restore(resourceGroupName, webSiteName, slotName, restoreRequestEnvelope);
            }
         });
    }
    
    /**
    * Restores a site to either a new site or existing site (Overwrite flag has
    * to be set to true for that).
    *
    * @param resourceGroupName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @param restoreRequestEnvelope Required. A restore request.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Restore operation information.
    */
    @Override
    public WebSiteRestoreResponse restore(String resourceGroupName, String webSiteName, String slotName, RestoreRequestEnvelope restoreRequestEnvelope) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (webSiteName == null) {
            throw new NullPointerException("webSiteName");
        }
        if (restoreRequestEnvelope == null) {
            throw new NullPointerException("restoreRequestEnvelope");
        }
        if (restoreRequestEnvelope.getLocation() == null) {
            throw new NullPointerException("restoreRequestEnvelope.Location");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("webSiteName", webSiteName);
            tracingParameters.put("slotName", slotName);
            tracingParameters.put("restoreRequestEnvelope", restoreRequestEnvelope);
            CloudTracing.enter(invocationId, this, "restoreAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Web";
        url = url + "/";
        url = url + "sites";
        url = url + "/";
        url = url + URLEncoder.encode(webSiteName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-06-01");
        queryParameters.add("operation=restore");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        httpRequest.setHeader("x-ms-version", "2014-06-01");
        
        // Serialize Request
        String requestContent = null;
        JsonNode requestDoc = null;
        
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode restoreRequestEnvelopeValue = objectMapper.createObjectNode();
        requestDoc = restoreRequestEnvelopeValue;
        
        if (restoreRequestEnvelope.getRequest() != null) {
            ObjectNode propertiesValue = objectMapper.createObjectNode();
            ((ObjectNode) restoreRequestEnvelopeValue).put("properties", propertiesValue);
            
            ((ObjectNode) propertiesValue).put("AdjustConnectionStrings", restoreRequestEnvelope.getRequest().isAdjustConnectionStrings());
            
            if (restoreRequestEnvelope.getRequest().getBlobName() != null) {
                ((ObjectNode) propertiesValue).put("BlobName", restoreRequestEnvelope.getRequest().getBlobName());
            }
            
            if (restoreRequestEnvelope.getRequest().getDatabases() != null) {
                if (restoreRequestEnvelope.getRequest().getDatabases() instanceof LazyCollection == false || ((LazyCollection) restoreRequestEnvelope.getRequest().getDatabases()).isInitialized()) {
                    ArrayNode databasesArray = objectMapper.createArrayNode();
                    for (DatabaseBackupSetting databasesItem : restoreRequestEnvelope.getRequest().getDatabases()) {
                        ObjectNode databaseBackupSettingValue = objectMapper.createObjectNode();
                        databasesArray.add(databaseBackupSettingValue);
                        
                        if (databasesItem.getConnectionString() != null) {
                            ((ObjectNode) databaseBackupSettingValue).put("connectionString", databasesItem.getConnectionString());
                        }
                        
                        if (databasesItem.getConnectionStringName() != null) {
                            ((ObjectNode) databaseBackupSettingValue).put("connectionStringName", databasesItem.getConnectionStringName());
                        }
                        
                        if (databasesItem.getDatabaseType() != null) {
                            ((ObjectNode) databaseBackupSettingValue).put("databaseType", databasesItem.getDatabaseType());
                        }
                        
                        if (databasesItem.getName() != null) {
                            ((ObjectNode) databaseBackupSettingValue).put("name", databasesItem.getName());
                        }
                    }
                    ((ObjectNode) propertiesValue).put("Databases", databasesArray);
                }
            }
            
            ((ObjectNode) propertiesValue).put("IgnoreConflictingHostNames", restoreRequestEnvelope.getRequest().isIgnoreConflictingHostNames());
            
            ((ObjectNode) propertiesValue).put("Overwrite", restoreRequestEnvelope.getRequest().isOverwrite());
            
            if (restoreRequestEnvelope.getRequest().getStorageAccountUrl() != null) {
                ((ObjectNode) propertiesValue).put("StorageAccountUrl", restoreRequestEnvelope.getRequest().getStorageAccountUrl());
            }
        }
        
        if (restoreRequestEnvelope.getId() != null) {
            ((ObjectNode) restoreRequestEnvelopeValue).put("id", restoreRequestEnvelope.getId());
        }
        
        if (restoreRequestEnvelope.getName() != null) {
            ((ObjectNode) restoreRequestEnvelopeValue).put("name", restoreRequestEnvelope.getName());
        }
        
        ((ObjectNode) restoreRequestEnvelopeValue).put("location", restoreRequestEnvelope.getLocation());
        
        if (restoreRequestEnvelope.getTags() != null) {
            ObjectNode tagsDictionary = objectMapper.createObjectNode();
            for (Map.Entry<String, String> entry : restoreRequestEnvelope.getTags().entrySet()) {
                String tagsKey = entry.getKey();
                String tagsValue = entry.getValue();
                ((ObjectNode) tagsDictionary).put(tagsKey, tagsValue);
            }
            ((ObjectNode) restoreRequestEnvelopeValue).put("tags", tagsDictionary);
        }
        
        if (restoreRequestEnvelope.getType() != null) {
            ((ObjectNode) restoreRequestEnvelopeValue).put("type", restoreRequestEnvelope.getType());
        }
        
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue(stringWriter, requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            WebSiteRestoreResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new WebSiteRestoreResponse();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                JsonNode restoreResponseValue = responseDoc.get("RestoreResponse");
                if (restoreResponseValue != null && restoreResponseValue instanceof NullNode == false) {
                    WebSiteRestoreResponse restoreResponseInstance = new WebSiteRestoreResponse();
                    
                    JsonNode operationIdValue = restoreResponseValue.get("operationId");
                    if (operationIdValue != null && operationIdValue instanceof NullNode == false) {
                        String operationIdInstance;
                        operationIdInstance = operationIdValue.getTextValue();
                        restoreResponseInstance.setOperationId(operationIdInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Restart the web site.
    *
    * @param resourceGroupName Required. The name of the resource group
    * @param webSiteName Required. Name of website
    * @param slotName Optional. The name of the slot of the website
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> startAsync(final String resourceGroupName, final String webSiteName, final String slotName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return start(resourceGroupName, webSiteName, slotName);
            }
         });
    }
    
    /**
    * Restart the web site.
    *
    * @param resourceGroupName Required. The name of the resource group
    * @param webSiteName Required. Name of website
    * @param slotName Optional. The name of the slot of the website
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse start(String resourceGroupName, String webSiteName, String slotName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (webSiteName == null) {
            throw new NullPointerException("webSiteName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("webSiteName", webSiteName);
            tracingParameters.put("slotName", slotName);
            CloudTracing.enter(invocationId, this, "startAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Web";
        url = url + "/";
        url = url + "sites";
        url = url + "/";
        url = url + URLEncoder.encode(webSiteName, "UTF-8");
        if (slotName != null) {
            url = url + "/slots/" + URLEncoder.encode(slotName, "UTF-8");
        }
        url = url + "/start";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-06-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            // Deserialize Response
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Restart the web site.
    *
    * @param resourceGroupName Required. The name of the resource group
    * @param webSiteName Required. Name of website
    * @param slotName Optional. The name of the slot of the web site
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> stopAsync(final String resourceGroupName, final String webSiteName, final String slotName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return stop(resourceGroupName, webSiteName, slotName);
            }
         });
    }
    
    /**
    * Restart the web site.
    *
    * @param resourceGroupName Required. The name of the resource group
    * @param webSiteName Required. Name of website
    * @param slotName Optional. The name of the slot of the web site
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse stop(String resourceGroupName, String webSiteName, String slotName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (webSiteName == null) {
            throw new NullPointerException("webSiteName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("webSiteName", webSiteName);
            tracingParameters.put("slotName", slotName);
            CloudTracing.enter(invocationId, this, "stopAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Web";
        url = url + "/";
        url = url + "sites";
        url = url + "/";
        url = url + URLEncoder.encode(webSiteName, "UTF-8");
        if (slotName != null) {
            url = url + "/slots/" + URLEncoder.encode(slotName, "UTF-8");
        }
        url = url + "/stop";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-06-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            // Deserialize Response
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * You can retrieve the application settings for a web site by issuing an
    * HTTP GET request, or update them by using HTTP PUT with a request body
    * that contains the settings to be updated.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166985.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group
    * @param webSiteName Required. The name of the web site
    * @param slotName Optional. The name of the slot of the website
    * @param parameters Required. The Update Web Site app settings parameters
    * @return List of app settings for the website.
    */
    @Override
    public Future<WebSiteAppSettingsResult> updateAppSettingsAsync(final String resourceGroupName, final String webSiteName, final String slotName, final WebSiteNameValueParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<WebSiteAppSettingsResult>() { 
            @Override
            public WebSiteAppSettingsResult call() throws Exception {
                return updateAppSettings(resourceGroupName, webSiteName, slotName, parameters);
            }
         });
    }
    
    /**
    * You can retrieve the application settings for a web site by issuing an
    * HTTP GET request, or update them by using HTTP PUT with a request body
    * that contains the settings to be updated.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166985.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group
    * @param webSiteName Required. The name of the web site
    * @param slotName Optional. The name of the slot of the website
    * @param parameters Required. The Update Web Site app settings parameters
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return List of app settings for the website.
    */
    @Override
    public WebSiteAppSettingsResult updateAppSettings(String resourceGroupName, String webSiteName, String slotName, WebSiteNameValueParameters parameters) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (webSiteName == null) {
            throw new NullPointerException("webSiteName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getLocation() == null) {
            throw new NullPointerException("parameters.Location");
        }
        if (parameters.getProperties() == null) {
            throw new NullPointerException("parameters.Properties");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("webSiteName", webSiteName);
            tracingParameters.put("slotName", slotName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "updateAppSettingsAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Web";
        url = url + "/";
        url = url + "sites";
        url = url + "/";
        url = url + URLEncoder.encode(webSiteName, "UTF-8");
        if (slotName != null) {
            url = url + "/slots/" + URLEncoder.encode(slotName, "UTF-8");
        }
        url = url + "/config/appsettings";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-06-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Serialize Request
        String requestContent = null;
        JsonNode requestDoc = null;
        
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode webSiteNameValueParametersValue = objectMapper.createObjectNode();
        requestDoc = webSiteNameValueParametersValue;
        
        if (parameters.getProperties() != null) {
            if (parameters.getProperties() instanceof LazyCollection == false || ((LazyCollection) parameters.getProperties()).isInitialized()) {
                ArrayNode propertiesArray = objectMapper.createArrayNode();
                for (NameValuePair propertiesItem : parameters.getProperties()) {
                    ObjectNode nameValuePairValue = objectMapper.createObjectNode();
                    propertiesArray.add(nameValuePairValue);
                    
                    if (propertiesItem.getName() != null) {
                        ((ObjectNode) nameValuePairValue).put("name", propertiesItem.getName());
                    }
                    
                    if (propertiesItem.getValue() != null) {
                        ((ObjectNode) nameValuePairValue).put("value", propertiesItem.getValue());
                    }
                }
                ((ObjectNode) webSiteNameValueParametersValue).put("properties", propertiesArray);
            }
        }
        
        if (parameters.getId() != null) {
            ((ObjectNode) webSiteNameValueParametersValue).put("id", parameters.getId());
        }
        
        if (parameters.getName() != null) {
            ((ObjectNode) webSiteNameValueParametersValue).put("name", parameters.getName());
        }
        
        ((ObjectNode) webSiteNameValueParametersValue).put("location", parameters.getLocation());
        
        if (parameters.getTags() != null) {
            ObjectNode tagsDictionary = objectMapper.createObjectNode();
            for (Map.Entry<String, String> entry : parameters.getTags().entrySet()) {
                String tagsKey = entry.getKey();
                String tagsValue = entry.getValue();
                ((ObjectNode) tagsDictionary).put(tagsKey, tagsValue);
            }
            ((ObjectNode) webSiteNameValueParametersValue).put("tags", tagsDictionary);
        }
        
        if (parameters.getType() != null) {
            ((ObjectNode) webSiteNameValueParametersValue).put("type", parameters.getType());
        }
        
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue(stringWriter, requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            WebSiteAppSettingsResult result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new WebSiteAppSettingsResult();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    WebSiteAppSettingsEnvelope resourceInstance = new WebSiteAppSettingsEnvelope();
                    result.setResource(resourceInstance);
                    
                    JsonNode propertiesArray2 = responseDoc.get("properties");
                    if (propertiesArray2 != null && propertiesArray2 instanceof NullNode == false) {
                        for (JsonNode propertiesValue : ((ArrayNode) propertiesArray2)) {
                            NameValuePair nameValuePairInstance = new NameValuePair();
                            resourceInstance.getProperties().add(nameValuePairInstance);
                            
                            JsonNode nameValue = propertiesValue.get("name");
                            if (nameValue != null && nameValue instanceof NullNode == false) {
                                String nameInstance;
                                nameInstance = nameValue.getTextValue();
                                nameValuePairInstance.setName(nameInstance);
                            }
                            
                            JsonNode valueValue = propertiesValue.get("value");
                            if (valueValue != null && valueValue instanceof NullNode == false) {
                                String valueInstance;
                                valueInstance = valueValue.getTextValue();
                                nameValuePairInstance.setValue(valueInstance);
                            }
                        }
                    }
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        resourceInstance.setId(idInstance);
                    }
                    
                    JsonNode nameValue2 = responseDoc.get("name");
                    if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                        String nameInstance2;
                        nameInstance2 = nameValue2.getTextValue();
                        resourceInstance.setName(nameInstance2);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        resourceInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry<String, JsonNode> property = itr.next();
                            String tagsKey2 = property.getKey();
                            String tagsValue2 = property.getValue().getTextValue();
                            resourceInstance.getTags().put(tagsKey2, tagsValue2);
                        }
                    }
                    
                    JsonNode typeValue = responseDoc.get("type");
                    if (typeValue != null && typeValue instanceof NullNode == false) {
                        String typeInstance;
                        typeInstance = typeValue.getTextValue();
                        resourceInstance.setType(typeInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Updates a backup schedule for a site.
    *
    * @param resourceGroupName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @param backupRequestEnvelope Required. A backup schedule specification.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> updateBackupConfigurationAsync(final String resourceGroupName, final String webSiteName, final String slotName, final BackupRequestEnvelope backupRequestEnvelope) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return updateBackupConfiguration(resourceGroupName, webSiteName, slotName, backupRequestEnvelope);
            }
         });
    }
    
    /**
    * Updates a backup schedule for a site.
    *
    * @param resourceGroupName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @param backupRequestEnvelope Required. A backup schedule specification.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse updateBackupConfiguration(String resourceGroupName, String webSiteName, String slotName, BackupRequestEnvelope backupRequestEnvelope) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (webSiteName == null) {
            throw new NullPointerException("webSiteName");
        }
        if (backupRequestEnvelope == null) {
            throw new NullPointerException("backupRequestEnvelope");
        }
        if (backupRequestEnvelope.getLocation() == null) {
            throw new NullPointerException("backupRequestEnvelope.Location");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("webSiteName", webSiteName);
            tracingParameters.put("slotName", slotName);
            tracingParameters.put("backupRequestEnvelope", backupRequestEnvelope);
            CloudTracing.enter(invocationId, this, "updateBackupConfigurationAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Web";
        url = url + "/";
        url = url + "sites";
        url = url + "/";
        url = url + URLEncoder.encode(webSiteName, "UTF-8");
        if (slotName != null) {
            url = url + "/slots/" + URLEncoder.encode(slotName, "UTF-8");
        }
        url = url + "/backup/config";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-06-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        httpRequest.setHeader("x-ms-version", "2014-06-01");
        
        // Serialize Request
        String requestContent = null;
        JsonNode requestDoc = null;
        
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode backupRequestEnvelopeValue = objectMapper.createObjectNode();
        requestDoc = backupRequestEnvelopeValue;
        
        if (backupRequestEnvelope.getRequest() != null) {
            ObjectNode propertiesValue = objectMapper.createObjectNode();
            ((ObjectNode) backupRequestEnvelopeValue).put("properties", propertiesValue);
            
            if (backupRequestEnvelope.getRequest().getBackupSchedule() != null) {
                ObjectNode backupScheduleValue = objectMapper.createObjectNode();
                ((ObjectNode) propertiesValue).put("backupSchedule", backupScheduleValue);
                
                ((ObjectNode) backupScheduleValue).put("frequencyInterval", backupRequestEnvelope.getRequest().getBackupSchedule().getFrequencyInterval());
                
                if (backupRequestEnvelope.getRequest().getBackupSchedule().getFrequencyUnit() != null) {
                    ((ObjectNode) backupScheduleValue).put("frequencyUnit", backupRequestEnvelope.getRequest().getBackupSchedule().getFrequencyUnit().toString());
                }
                
                ((ObjectNode) backupScheduleValue).put("keepAtLeastOneBackup", backupRequestEnvelope.getRequest().getBackupSchedule().isKeepAtLeastOneBackup());
                
                if (backupRequestEnvelope.getRequest().getBackupSchedule().getLastExecutionTime() != null) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                    simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                    ((ObjectNode) backupScheduleValue).put("lastExecutionTime", simpleDateFormat.format(backupRequestEnvelope.getRequest().getBackupSchedule().getLastExecutionTime().getTime()));
                }
                
                ((ObjectNode) backupScheduleValue).put("retentionPeriodInDays", backupRequestEnvelope.getRequest().getBackupSchedule().getRetentionPeriodInDays());
                
                if (backupRequestEnvelope.getRequest().getBackupSchedule().getStartTime() != null) {
                    SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                    simpleDateFormat2.setTimeZone(TimeZone.getTimeZone("UTC"));
                    ((ObjectNode) backupScheduleValue).put("startTime", simpleDateFormat2.format(backupRequestEnvelope.getRequest().getBackupSchedule().getStartTime().getTime()));
                }
            }
            
            if (backupRequestEnvelope.getRequest().getDatabases() != null) {
                if (backupRequestEnvelope.getRequest().getDatabases() instanceof LazyCollection == false || ((LazyCollection) backupRequestEnvelope.getRequest().getDatabases()).isInitialized()) {
                    ArrayNode databasesArray = objectMapper.createArrayNode();
                    for (DatabaseBackupSetting databasesItem : backupRequestEnvelope.getRequest().getDatabases()) {
                        ObjectNode databaseBackupSettingValue = objectMapper.createObjectNode();
                        databasesArray.add(databaseBackupSettingValue);
                        
                        if (databasesItem.getConnectionString() != null) {
                            ((ObjectNode) databaseBackupSettingValue).put("connectionString", databasesItem.getConnectionString());
                        }
                        
                        if (databasesItem.getConnectionStringName() != null) {
                            ((ObjectNode) databaseBackupSettingValue).put("connectionStringName", databasesItem.getConnectionStringName());
                        }
                        
                        if (databasesItem.getDatabaseType() != null) {
                            ((ObjectNode) databaseBackupSettingValue).put("databaseType", databasesItem.getDatabaseType());
                        }
                        
                        if (databasesItem.getName() != null) {
                            ((ObjectNode) databaseBackupSettingValue).put("name", databasesItem.getName());
                        }
                    }
                    ((ObjectNode) propertiesValue).put("databases", databasesArray);
                }
            }
            
            if (backupRequestEnvelope.getRequest().isEnabled() != null) {
                ((ObjectNode) propertiesValue).put("enabled", backupRequestEnvelope.getRequest().isEnabled());
            }
            
            if (backupRequestEnvelope.getRequest().getName() != null) {
                ((ObjectNode) propertiesValue).put("name", backupRequestEnvelope.getRequest().getName());
            }
            
            if (backupRequestEnvelope.getRequest().getStorageAccountUrl() != null) {
                ((ObjectNode) propertiesValue).put("storageAccountUrl", backupRequestEnvelope.getRequest().getStorageAccountUrl());
            }
        }
        
        if (backupRequestEnvelope.getId() != null) {
            ((ObjectNode) backupRequestEnvelopeValue).put("id", backupRequestEnvelope.getId());
        }
        
        if (backupRequestEnvelope.getName() != null) {
            ((ObjectNode) backupRequestEnvelopeValue).put("name", backupRequestEnvelope.getName());
        }
        
        ((ObjectNode) backupRequestEnvelopeValue).put("location", backupRequestEnvelope.getLocation());
        
        if (backupRequestEnvelope.getTags() != null) {
            ObjectNode tagsDictionary = objectMapper.createObjectNode();
            for (Map.Entry<String, String> entry : backupRequestEnvelope.getTags().entrySet()) {
                String tagsKey = entry.getKey();
                String tagsValue = entry.getValue();
                ((ObjectNode) tagsDictionary).put(tagsKey, tagsValue);
            }
            ((ObjectNode) backupRequestEnvelopeValue).put("tags", tagsDictionary);
        }
        
        if (backupRequestEnvelope.getType() != null) {
            ((ObjectNode) backupRequestEnvelopeValue).put("type", backupRequestEnvelope.getType());
        }
        
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue(stringWriter, requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            // Deserialize Response
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * You can retrieve the config settings for a web site by issuing an HTTP
    * GET request, or update them by using HTTP PUT with a request body that
    * contains the settings to be updated.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166985.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @param parameters Required. The Update Web Site Configuration parameters.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> updateConfigurationAsync(final String resourceGroupName, final String webSiteName, final String slotName, final WebSiteUpdateConfigurationParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return updateConfiguration(resourceGroupName, webSiteName, slotName, parameters);
            }
         });
    }
    
    /**
    * You can retrieve the config settings for a web site by issuing an HTTP
    * GET request, or update them by using HTTP PUT with a request body that
    * contains the settings to be updated.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166985.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param webSiteName Required. The name of the web site.
    * @param slotName Optional. The name of the slot.
    * @param parameters Required. The Update Web Site Configuration parameters.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse updateConfiguration(String resourceGroupName, String webSiteName, String slotName, WebSiteUpdateConfigurationParameters parameters) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (webSiteName == null) {
            throw new NullPointerException("webSiteName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getLocation() == null) {
            throw new NullPointerException("parameters.Location");
        }
        if (parameters.getProperties() == null) {
            throw new NullPointerException("parameters.Properties");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("webSiteName", webSiteName);
            tracingParameters.put("slotName", slotName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "updateConfigurationAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Web";
        url = url + "/";
        url = url + "sites";
        url = url + "/";
        url = url + URLEncoder.encode(webSiteName, "UTF-8");
        if (slotName != null) {
            url = url + "/slots/" + URLEncoder.encode(slotName, "UTF-8");
        }
        url = url + "/config/web";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-06-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Serialize Request
        String requestContent = null;
        JsonNode requestDoc = null;
        
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode webSiteUpdateConfigurationParametersValue = objectMapper.createObjectNode();
        requestDoc = webSiteUpdateConfigurationParametersValue;
        
        ObjectNode propertiesValue = objectMapper.createObjectNode();
        ((ObjectNode) webSiteUpdateConfigurationParametersValue).put("properties", propertiesValue);
        
        if (parameters.getProperties().getAppSettings() != null) {
            if (parameters.getProperties().getAppSettings() instanceof LazyCollection == false || ((LazyCollection) parameters.getProperties().getAppSettings()).isInitialized()) {
                ObjectNode appSettingsDictionary = objectMapper.createObjectNode();
                for (Map.Entry<String, String> entry : parameters.getProperties().getAppSettings().entrySet()) {
                    String appSettingsKey = entry.getKey();
                    String appSettingsValue = entry.getValue();
                    ((ObjectNode) appSettingsDictionary).put(appSettingsKey, appSettingsValue);
                }
                ((ObjectNode) propertiesValue).put("appSettings", appSettingsDictionary);
            }
        }
        
        if (parameters.getProperties().getConnectionStrings() != null) {
            if (parameters.getProperties().getConnectionStrings() instanceof LazyCollection == false || ((LazyCollection) parameters.getProperties().getConnectionStrings()).isInitialized()) {
                ArrayNode connectionStringsArray = objectMapper.createArrayNode();
                for (ConnectionStringInfo connectionStringsItem : parameters.getProperties().getConnectionStrings()) {
                    ObjectNode connStringInfoValue = objectMapper.createObjectNode();
                    connectionStringsArray.add(connStringInfoValue);
                    
                    if (connectionStringsItem.getConnectionString() != null) {
                        ((ObjectNode) connStringInfoValue).put("connectionString", connectionStringsItem.getConnectionString());
                    }
                    
                    if (connectionStringsItem.getName() != null) {
                        ((ObjectNode) connStringInfoValue).put("name", connectionStringsItem.getName());
                    }
                    
                    if (connectionStringsItem.getType() != null) {
                        ((ObjectNode) connStringInfoValue).put("type", connectionStringsItem.getType().toString());
                    }
                }
                ((ObjectNode) propertiesValue).put("connectionStrings", connectionStringsArray);
            }
        }
        
        if (parameters.getProperties().getDefaultDocuments() != null) {
            if (parameters.getProperties().getDefaultDocuments() instanceof LazyCollection == false || ((LazyCollection) parameters.getProperties().getDefaultDocuments()).isInitialized()) {
                ArrayNode defaultDocumentsArray = objectMapper.createArrayNode();
                for (String defaultDocumentsItem : parameters.getProperties().getDefaultDocuments()) {
                    defaultDocumentsArray.add(defaultDocumentsItem);
                }
                ((ObjectNode) propertiesValue).put("defaultDocuments", defaultDocumentsArray);
            }
        }
        
        if (parameters.getProperties().isDetailedErrorLoggingEnabled() != null) {
            ((ObjectNode) propertiesValue).put("detailedErrorLoggingEnabled", parameters.getProperties().isDetailedErrorLoggingEnabled());
        }
        
        if (parameters.getProperties().getDocumentRoot() != null) {
            ((ObjectNode) propertiesValue).put("documentRoot", parameters.getProperties().getDocumentRoot());
        }
        
        if (parameters.getProperties().getHandlerMappings() != null) {
            if (parameters.getProperties().getHandlerMappings() instanceof LazyCollection == false || ((LazyCollection) parameters.getProperties().getHandlerMappings()).isInitialized()) {
                ArrayNode handlerMappingsArray = objectMapper.createArrayNode();
                for (WebSiteUpdateConfigurationDetails.HandlerMapping handlerMappingsItem : parameters.getProperties().getHandlerMappings()) {
                    ObjectNode handlerMappingValue = objectMapper.createObjectNode();
                    handlerMappingsArray.add(handlerMappingValue);
                    
                    if (handlerMappingsItem.getArguments() != null) {
                        ((ObjectNode) handlerMappingValue).put("arguments", handlerMappingsItem.getArguments());
                    }
                    
                    if (handlerMappingsItem.getExtension() != null) {
                        ((ObjectNode) handlerMappingValue).put("extension", handlerMappingsItem.getExtension());
                    }
                    
                    if (handlerMappingsItem.getScriptProcessor() != null) {
                        ((ObjectNode) handlerMappingValue).put("scriptProcessor", handlerMappingsItem.getScriptProcessor());
                    }
                }
                ((ObjectNode) propertiesValue).put("handlerMappings", handlerMappingsArray);
            }
        }
        
        if (parameters.getProperties().isHttpLoggingEnabled() != null) {
            ((ObjectNode) propertiesValue).put("httpLoggingEnabled", parameters.getProperties().isHttpLoggingEnabled());
        }
        
        if (parameters.getProperties().getLogsDirectorySizeLimit() != null) {
            ((ObjectNode) propertiesValue).put("logsDirectorySizeLimit", parameters.getProperties().getLogsDirectorySizeLimit());
        }
        
        if (parameters.getProperties().getManagedPipelineMode() != null) {
            ((ObjectNode) propertiesValue).put("managedPipelineMode", parameters.getProperties().getManagedPipelineMode().toString());
        }
        
        if (parameters.getProperties().getMetadata() != null) {
            if (parameters.getProperties().getMetadata() instanceof LazyCollection == false || ((LazyCollection) parameters.getProperties().getMetadata()).isInitialized()) {
                ObjectNode metadataDictionary = objectMapper.createObjectNode();
                for (Map.Entry<String, String> entry2 : parameters.getProperties().getMetadata().entrySet()) {
                    String metadataKey = entry2.getKey();
                    String metadataValue = entry2.getValue();
                    ((ObjectNode) metadataDictionary).put(metadataKey, metadataValue);
                }
                ((ObjectNode) propertiesValue).put("metadata", metadataDictionary);
            }
        }
        
        if (parameters.getProperties().getNetFrameworkVersion() != null) {
            ((ObjectNode) propertiesValue).put("netFrameworkVersion", parameters.getProperties().getNetFrameworkVersion());
        }
        
        if (parameters.getProperties().getNumberOfWorkers() != null) {
            ((ObjectNode) propertiesValue).put("numberOfWorkers", parameters.getProperties().getNumberOfWorkers());
        }
        
        if (parameters.getProperties().getPhpVersion() != null) {
            ((ObjectNode) propertiesValue).put("phpVersion", parameters.getProperties().getPhpVersion());
        }
        
        if (parameters.getProperties().getPythonVersion() != null) {
            ((ObjectNode) propertiesValue).put("pythonVersion", parameters.getProperties().getPythonVersion());
        }
        
        if (parameters.getProperties().isRemoteDebuggingEnabled() != null) {
            ((ObjectNode) propertiesValue).put("remoteDebuggingEnabled", parameters.getProperties().isRemoteDebuggingEnabled());
        }
        
        if (parameters.getProperties().getRemoteDebuggingVersion() != null) {
            ((ObjectNode) propertiesValue).put("remoteDebuggingVersion", parameters.getProperties().getRemoteDebuggingVersion().toString());
        }
        
        if (parameters.getProperties().isRequestTracingEnabled() != null) {
            ((ObjectNode) propertiesValue).put("requestTracingEnabled", parameters.getProperties().isRequestTracingEnabled());
        }
        
        if (parameters.getProperties().getRequestTracingExpirationTime() != null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            ((ObjectNode) propertiesValue).put("requestTracingExpirationTime", simpleDateFormat.format(parameters.getProperties().getRequestTracingExpirationTime().getTime()));
        }
        
        if (parameters.getProperties().getScmType() != null) {
            ((ObjectNode) propertiesValue).put("scmType", parameters.getProperties().getScmType());
        }
        
        if (parameters.getProperties().isUse32BitWorkerProcess() != null) {
            ((ObjectNode) propertiesValue).put("use32BitWorkerProcess", parameters.getProperties().isUse32BitWorkerProcess());
        }
        
        if (parameters.getProperties().isWebSocketsEnabled() != null) {
            ((ObjectNode) propertiesValue).put("webSocketsEnabled", parameters.getProperties().isWebSocketsEnabled());
        }
        
        if (parameters.getProperties().isAlwaysOn() != null) {
            ((ObjectNode) propertiesValue).put("alwaysOn", parameters.getProperties().isAlwaysOn());
        }
        
        if (parameters.getProperties().getAutoSwapSlotName() != null) {
            ((ObjectNode) propertiesValue).put("autoSwapSlotName", parameters.getProperties().getAutoSwapSlotName());
        }
        
        if (parameters.getProperties().getLimits() != null) {
            ObjectNode limitsValue = objectMapper.createObjectNode();
            ((ObjectNode) propertiesValue).put("limits", limitsValue);
            
            if (parameters.getProperties().getLimits().getMaxPercentageCpu() != null) {
                ((ObjectNode) limitsValue).put("maxPercentageCpu", parameters.getProperties().getLimits().getMaxPercentageCpu());
            }
            
            if (parameters.getProperties().getLimits().getMaxMemoryInMb() != null) {
                ((ObjectNode) limitsValue).put("maxMemoryInMb", parameters.getProperties().getLimits().getMaxMemoryInMb());
            }
            
            if (parameters.getProperties().getLimits().getMaxDiskSizeInMb() != null) {
                ((ObjectNode) limitsValue).put("maxDiskSizeInMb", parameters.getProperties().getLimits().getMaxDiskSizeInMb());
            }
        }
        
        if (parameters.getId() != null) {
            ((ObjectNode) webSiteUpdateConfigurationParametersValue).put("id", parameters.getId());
        }
        
        if (parameters.getName() != null) {
            ((ObjectNode) webSiteUpdateConfigurationParametersValue).put("name", parameters.getName());
        }
        
        ((ObjectNode) webSiteUpdateConfigurationParametersValue).put("location", parameters.getLocation());
        
        if (parameters.getTags() != null) {
            ObjectNode tagsDictionary = objectMapper.createObjectNode();
            for (Map.Entry<String, String> entry3 : parameters.getTags().entrySet()) {
                String tagsKey = entry3.getKey();
                String tagsValue = entry3.getValue();
                ((ObjectNode) tagsDictionary).put(tagsKey, tagsValue);
            }
            ((ObjectNode) webSiteUpdateConfigurationParametersValue).put("tags", tagsDictionary);
        }
        
        if (parameters.getType() != null) {
            ((ObjectNode) webSiteUpdateConfigurationParametersValue).put("type", parameters.getType());
        }
        
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue(stringWriter, requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            // Deserialize Response
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * You can retrieve the connection strings for a web site by issuing an HTTP
    * GET request, or update them by using HTTP PUT with a request body that
    * contains the settings to be updated.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166985.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group
    * @param webSiteName Required. The name of the website
    * @param slotName Optional. The name of the slot of the website
    * @param parameters Required. The Update Web Site connection strings
    * parameters
    * @return List of connection strings for the website.
    */
    @Override
    public Future<WebSiteConnectionStringsResult> updateConnectionStringsAsync(final String resourceGroupName, final String webSiteName, final String slotName, final WebSiteUpdateConnectionStringsParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<WebSiteConnectionStringsResult>() { 
            @Override
            public WebSiteConnectionStringsResult call() throws Exception {
                return updateConnectionStrings(resourceGroupName, webSiteName, slotName, parameters);
            }
         });
    }
    
    /**
    * You can retrieve the connection strings for a web site by issuing an HTTP
    * GET request, or update them by using HTTP PUT with a request body that
    * contains the settings to be updated.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166985.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group
    * @param webSiteName Required. The name of the website
    * @param slotName Optional. The name of the slot of the website
    * @param parameters Required. The Update Web Site connection strings
    * parameters
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return List of connection strings for the website.
    */
    @Override
    public WebSiteConnectionStringsResult updateConnectionStrings(String resourceGroupName, String webSiteName, String slotName, WebSiteUpdateConnectionStringsParameters parameters) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (webSiteName == null) {
            throw new NullPointerException("webSiteName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getLocation() == null) {
            throw new NullPointerException("parameters.Location");
        }
        if (parameters.getProperties() == null) {
            throw new NullPointerException("parameters.Properties");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("webSiteName", webSiteName);
            tracingParameters.put("slotName", slotName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "updateConnectionStringsAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Web";
        url = url + "/";
        url = url + "sites";
        url = url + "/";
        url = url + URLEncoder.encode(webSiteName, "UTF-8");
        if (slotName != null) {
            url = url + "/slots/" + URLEncoder.encode(slotName, "UTF-8");
        }
        url = url + "/config/connectionstrings";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-06-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Serialize Request
        String requestContent = null;
        JsonNode requestDoc = null;
        
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode webSiteUpdateConnectionStringsParametersValue = objectMapper.createObjectNode();
        requestDoc = webSiteUpdateConnectionStringsParametersValue;
        
        if (parameters.getProperties() != null) {
            if (parameters.getProperties() instanceof LazyCollection == false || ((LazyCollection) parameters.getProperties()).isInitialized()) {
                ArrayNode propertiesArray = objectMapper.createArrayNode();
                for (ConnectionStringInfo propertiesItem : parameters.getProperties()) {
                    ObjectNode connStringInfoValue = objectMapper.createObjectNode();
                    propertiesArray.add(connStringInfoValue);
                    
                    if (propertiesItem.getConnectionString() != null) {
                        ((ObjectNode) connStringInfoValue).put("connectionString", propertiesItem.getConnectionString());
                    }
                    
                    if (propertiesItem.getName() != null) {
                        ((ObjectNode) connStringInfoValue).put("name", propertiesItem.getName());
                    }
                    
                    if (propertiesItem.getType() != null) {
                        ((ObjectNode) connStringInfoValue).put("type", propertiesItem.getType().toString());
                    }
                }
                ((ObjectNode) webSiteUpdateConnectionStringsParametersValue).put("properties", propertiesArray);
            }
        }
        
        if (parameters.getId() != null) {
            ((ObjectNode) webSiteUpdateConnectionStringsParametersValue).put("id", parameters.getId());
        }
        
        if (parameters.getName() != null) {
            ((ObjectNode) webSiteUpdateConnectionStringsParametersValue).put("name", parameters.getName());
        }
        
        ((ObjectNode) webSiteUpdateConnectionStringsParametersValue).put("location", parameters.getLocation());
        
        if (parameters.getTags() != null) {
            ObjectNode tagsDictionary = objectMapper.createObjectNode();
            for (Map.Entry<String, String> entry : parameters.getTags().entrySet()) {
                String tagsKey = entry.getKey();
                String tagsValue = entry.getValue();
                ((ObjectNode) tagsDictionary).put(tagsKey, tagsValue);
            }
            ((ObjectNode) webSiteUpdateConnectionStringsParametersValue).put("tags", tagsDictionary);
        }
        
        if (parameters.getType() != null) {
            ((ObjectNode) webSiteUpdateConnectionStringsParametersValue).put("type", parameters.getType());
        }
        
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue(stringWriter, requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            WebSiteConnectionStringsResult result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new WebSiteConnectionStringsResult();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    WebSiteConnectionStringsEnvelope resourceInstance = new WebSiteConnectionStringsEnvelope();
                    result.setResource(resourceInstance);
                    
                    JsonNode propertiesArray2 = responseDoc.get("properties");
                    if (propertiesArray2 != null && propertiesArray2 instanceof NullNode == false) {
                        for (JsonNode propertiesValue : ((ArrayNode) propertiesArray2)) {
                            ConnectionStringInfo connStringInfoInstance = new ConnectionStringInfo();
                            resourceInstance.getProperties().add(connStringInfoInstance);
                            
                            JsonNode connectionStringValue = propertiesValue.get("connectionString");
                            if (connectionStringValue != null && connectionStringValue instanceof NullNode == false) {
                                String connectionStringInstance;
                                connectionStringInstance = connectionStringValue.getTextValue();
                                connStringInfoInstance.setConnectionString(connectionStringInstance);
                            }
                            
                            JsonNode nameValue = propertiesValue.get("name");
                            if (nameValue != null && nameValue instanceof NullNode == false) {
                                String nameInstance;
                                nameInstance = nameValue.getTextValue();
                                connStringInfoInstance.setName(nameInstance);
                            }
                            
                            JsonNode typeValue = propertiesValue.get("type");
                            if (typeValue != null && typeValue instanceof NullNode == false) {
                                DatabaseServerType typeInstance;
                                typeInstance = Enum.valueOf(DatabaseServerType.class, typeValue.getTextValue());
                                connStringInfoInstance.setType(typeInstance);
                            }
                        }
                    }
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        resourceInstance.setId(idInstance);
                    }
                    
                    JsonNode nameValue2 = responseDoc.get("name");
                    if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                        String nameInstance2;
                        nameInstance2 = nameValue2.getTextValue();
                        resourceInstance.setName(nameInstance2);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        resourceInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry<String, JsonNode> property = itr.next();
                            String tagsKey2 = property.getKey();
                            String tagsValue2 = property.getValue().getTextValue();
                            resourceInstance.getTags().put(tagsKey2, tagsValue2);
                        }
                    }
                    
                    JsonNode typeValue2 = responseDoc.get("type");
                    if (typeValue2 != null && typeValue2 instanceof NullNode == false) {
                        String typeInstance2;
                        typeInstance2 = typeValue2.getTextValue();
                        resourceInstance.setType(typeInstance2);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * You can retrieve the metadata for a web site by issuing an HTTP GET
    * request, or update them by using HTTP PUT with a request body that
    * contains the settings to be updated.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166985.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group
    * @param webSiteName Required. The name of the website
    * @param slotName Optional. The name of the slot of the website
    * @param parameters Required. The Update Web Site metadata parameters
    * @return List of metadata for the website.
    */
    @Override
    public Future<WebSiteMetadataResult> updateMetadataAsync(final String resourceGroupName, final String webSiteName, final String slotName, final WebSiteNameValueParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<WebSiteMetadataResult>() { 
            @Override
            public WebSiteMetadataResult call() throws Exception {
                return updateMetadata(resourceGroupName, webSiteName, slotName, parameters);
            }
         });
    }
    
    /**
    * You can retrieve the metadata for a web site by issuing an HTTP GET
    * request, or update them by using HTTP PUT with a request body that
    * contains the settings to be updated.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166985.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group
    * @param webSiteName Required. The name of the website
    * @param slotName Optional. The name of the slot of the website
    * @param parameters Required. The Update Web Site metadata parameters
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return List of metadata for the website.
    */
    @Override
    public WebSiteMetadataResult updateMetadata(String resourceGroupName, String webSiteName, String slotName, WebSiteNameValueParameters parameters) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (webSiteName == null) {
            throw new NullPointerException("webSiteName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getLocation() == null) {
            throw new NullPointerException("parameters.Location");
        }
        if (parameters.getProperties() == null) {
            throw new NullPointerException("parameters.Properties");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("webSiteName", webSiteName);
            tracingParameters.put("slotName", slotName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "updateMetadataAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Web";
        url = url + "/";
        url = url + "sites";
        url = url + "/";
        url = url + URLEncoder.encode(webSiteName, "UTF-8");
        if (slotName != null) {
            url = url + "/slots/" + URLEncoder.encode(slotName, "UTF-8");
        }
        url = url + "/config/metadata";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-06-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Serialize Request
        String requestContent = null;
        JsonNode requestDoc = null;
        
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode webSiteNameValueParametersValue = objectMapper.createObjectNode();
        requestDoc = webSiteNameValueParametersValue;
        
        if (parameters.getProperties() != null) {
            if (parameters.getProperties() instanceof LazyCollection == false || ((LazyCollection) parameters.getProperties()).isInitialized()) {
                ArrayNode propertiesArray = objectMapper.createArrayNode();
                for (NameValuePair propertiesItem : parameters.getProperties()) {
                    ObjectNode nameValuePairValue = objectMapper.createObjectNode();
                    propertiesArray.add(nameValuePairValue);
                    
                    if (propertiesItem.getName() != null) {
                        ((ObjectNode) nameValuePairValue).put("name", propertiesItem.getName());
                    }
                    
                    if (propertiesItem.getValue() != null) {
                        ((ObjectNode) nameValuePairValue).put("value", propertiesItem.getValue());
                    }
                }
                ((ObjectNode) webSiteNameValueParametersValue).put("properties", propertiesArray);
            }
        }
        
        if (parameters.getId() != null) {
            ((ObjectNode) webSiteNameValueParametersValue).put("id", parameters.getId());
        }
        
        if (parameters.getName() != null) {
            ((ObjectNode) webSiteNameValueParametersValue).put("name", parameters.getName());
        }
        
        ((ObjectNode) webSiteNameValueParametersValue).put("location", parameters.getLocation());
        
        if (parameters.getTags() != null) {
            ObjectNode tagsDictionary = objectMapper.createObjectNode();
            for (Map.Entry<String, String> entry : parameters.getTags().entrySet()) {
                String tagsKey = entry.getKey();
                String tagsValue = entry.getValue();
                ((ObjectNode) tagsDictionary).put(tagsKey, tagsValue);
            }
            ((ObjectNode) webSiteNameValueParametersValue).put("tags", tagsDictionary);
        }
        
        if (parameters.getType() != null) {
            ((ObjectNode) webSiteNameValueParametersValue).put("type", parameters.getType());
        }
        
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue(stringWriter, requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            WebSiteMetadataResult result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new WebSiteMetadataResult();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    WebSiteMetadataEnvelope resourceInstance = new WebSiteMetadataEnvelope();
                    result.setResource(resourceInstance);
                    
                    JsonNode propertiesArray2 = responseDoc.get("properties");
                    if (propertiesArray2 != null && propertiesArray2 instanceof NullNode == false) {
                        for (JsonNode propertiesValue : ((ArrayNode) propertiesArray2)) {
                            NameValuePair nameValuePairInstance = new NameValuePair();
                            resourceInstance.getProperties().add(nameValuePairInstance);
                            
                            JsonNode nameValue = propertiesValue.get("name");
                            if (nameValue != null && nameValue instanceof NullNode == false) {
                                String nameInstance;
                                nameInstance = nameValue.getTextValue();
                                nameValuePairInstance.setName(nameInstance);
                            }
                            
                            JsonNode valueValue = propertiesValue.get("value");
                            if (valueValue != null && valueValue instanceof NullNode == false) {
                                String valueInstance;
                                valueInstance = valueValue.getTextValue();
                                nameValuePairInstance.setValue(valueInstance);
                            }
                        }
                    }
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        resourceInstance.setId(idInstance);
                    }
                    
                    JsonNode nameValue2 = responseDoc.get("name");
                    if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                        String nameInstance2;
                        nameInstance2 = nameValue2.getTextValue();
                        resourceInstance.setName(nameInstance2);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        resourceInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry<String, JsonNode> property = itr.next();
                            String tagsKey2 = property.getKey();
                            String tagsValue2 = property.getValue().getTextValue();
                            resourceInstance.getTags().put(tagsKey2, tagsValue2);
                        }
                    }
                    
                    JsonNode typeValue = responseDoc.get("type");
                    if (typeValue != null && typeValue instanceof NullNode == false) {
                        String typeInstance;
                        typeInstance = typeValue.getTextValue();
                        resourceInstance.setType(typeInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Link source control to website (do not forget to setup the token, and if
    * needed token secret, for the specific source control type used).
    *
    * @param resourceGroupName Required. The name of the resource group
    * @param webSiteName Required. The name of the web site
    * @param slotName Optional. The name of the slot of the website
    * @param parameters Required. The update site source control parameters.
    * @return The link site to source control operation response.
    */
    @Override
    public Future<SiteSourceControlUpdateResponse> updateSiteSourceControlAsync(final String resourceGroupName, final String webSiteName, final String slotName, final SiteSourceControlUpdateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<SiteSourceControlUpdateResponse>() { 
            @Override
            public SiteSourceControlUpdateResponse call() throws Exception {
                return updateSiteSourceControl(resourceGroupName, webSiteName, slotName, parameters);
            }
         });
    }
    
    /**
    * Link source control to website (do not forget to setup the token, and if
    * needed token secret, for the specific source control type used).
    *
    * @param resourceGroupName Required. The name of the resource group
    * @param webSiteName Required. The name of the web site
    * @param slotName Optional. The name of the slot of the website
    * @param parameters Required. The update site source control parameters.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The link site to source control operation response.
    */
    @Override
    public SiteSourceControlUpdateResponse updateSiteSourceControl(String resourceGroupName, String webSiteName, String slotName, SiteSourceControlUpdateParameters parameters) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (webSiteName == null) {
            throw new NullPointerException("webSiteName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getProperties() == null) {
            throw new NullPointerException("parameters.Properties");
        }
        if (parameters.getProperties().getRepoUrl() == null) {
            throw new NullPointerException("parameters.Properties.RepoUrl");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("webSiteName", webSiteName);
            tracingParameters.put("slotName", slotName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "updateSiteSourceControlAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Web";
        url = url + "/";
        url = url + "sites";
        url = url + "/";
        url = url + URLEncoder.encode(webSiteName, "UTF-8");
        if (slotName != null) {
            url = url + "/slots/" + URLEncoder.encode(slotName, "UTF-8");
        }
        url = url + "/sourcecontrols/web";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-06-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Serialize Request
        String requestContent = null;
        JsonNode requestDoc = null;
        
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode siteSourceControlUpdateParametersValue = objectMapper.createObjectNode();
        requestDoc = siteSourceControlUpdateParametersValue;
        
        ObjectNode propertiesValue = objectMapper.createObjectNode();
        ((ObjectNode) siteSourceControlUpdateParametersValue).put("properties", propertiesValue);
        
        ((ObjectNode) propertiesValue).put("repoUrl", parameters.getProperties().getRepoUrl());
        
        if (parameters.getProperties().getBranch() != null) {
            ((ObjectNode) propertiesValue).put("branch", parameters.getProperties().getBranch());
        }
        
        ((ObjectNode) propertiesValue).put("isManualIntegration", parameters.getProperties().isManualIntegration());
        
        ((ObjectNode) propertiesValue).put("deploymentRollbackEnabled", parameters.getProperties().isDeploymentRollbackEnabled());
        
        ((ObjectNode) propertiesValue).put("isMercurial", parameters.getProperties().isMercurial());
        
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue(stringWriter, requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            SiteSourceControlUpdateResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new SiteSourceControlUpdateResponse();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    SiteSourceControl siteSourceControlInstance = new SiteSourceControl();
                    result.setSiteSourceControl(siteSourceControlInstance);
                    
                    JsonNode propertiesValue2 = responseDoc.get("properties");
                    if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                        SiteSourceControlProperties propertiesInstance = new SiteSourceControlProperties();
                        siteSourceControlInstance.setProperties(propertiesInstance);
                        
                        JsonNode repoUrlValue = propertiesValue2.get("repoUrl");
                        if (repoUrlValue != null && repoUrlValue instanceof NullNode == false) {
                            String repoUrlInstance;
                            repoUrlInstance = repoUrlValue.getTextValue();
                            propertiesInstance.setRepoUrl(repoUrlInstance);
                        }
                        
                        JsonNode branchValue = propertiesValue2.get("branch");
                        if (branchValue != null && branchValue instanceof NullNode == false) {
                            String branchInstance;
                            branchInstance = branchValue.getTextValue();
                            propertiesInstance.setBranch(branchInstance);
                        }
                        
                        JsonNode isManualIntegrationValue = propertiesValue2.get("isManualIntegration");
                        if (isManualIntegrationValue != null && isManualIntegrationValue instanceof NullNode == false) {
                            boolean isManualIntegrationInstance;
                            isManualIntegrationInstance = isManualIntegrationValue.getBooleanValue();
                            propertiesInstance.setIsManualIntegration(isManualIntegrationInstance);
                        }
                        
                        JsonNode deploymentRollbackEnabledValue = propertiesValue2.get("deploymentRollbackEnabled");
                        if (deploymentRollbackEnabledValue != null && deploymentRollbackEnabledValue instanceof NullNode == false) {
                            boolean deploymentRollbackEnabledInstance;
                            deploymentRollbackEnabledInstance = deploymentRollbackEnabledValue.getBooleanValue();
                            propertiesInstance.setDeploymentRollbackEnabled(deploymentRollbackEnabledInstance);
                        }
                        
                        JsonNode isMercurialValue = propertiesValue2.get("isMercurial");
                        if (isMercurialValue != null && isMercurialValue instanceof NullNode == false) {
                            boolean isMercurialInstance;
                            isMercurialInstance = isMercurialValue.getBooleanValue();
                            propertiesInstance.setIsMercurial(isMercurialInstance);
                        }
                    }
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        siteSourceControlInstance.setId(idInstance);
                    }
                    
                    JsonNode nameValue = responseDoc.get("name");
                    if (nameValue != null && nameValue instanceof NullNode == false) {
                        String nameInstance;
                        nameInstance = nameValue.getTextValue();
                        siteSourceControlInstance.setName(nameInstance);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        siteSourceControlInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry<String, JsonNode> property = itr.next();
                            String tagsKey = property.getKey();
                            String tagsValue = property.getValue().getTextValue();
                            siteSourceControlInstance.getTags().put(tagsKey, tagsValue);
                        }
                    }
                    
                    JsonNode typeValue = responseDoc.get("type");
                    if (typeValue != null && typeValue instanceof NullNode == false) {
                        String typeInstance;
                        typeInstance = typeValue.getTextValue();
                        siteSourceControlInstance.setType(typeInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Update list of app settings and connection strings which to be slot
    * specific. E.g. settings in staging slots remain in staging after swap
    * with production.
    *
    * @param resourceGroupName Required. The name of the resource group
    * @param webSiteName Required. The name of the website
    * @param parameters Required. The Update slot configs parameters
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> updateSlotConfigNamesAsync(final String resourceGroupName, final String webSiteName, final SlotConfigNamesUpdateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return updateSlotConfigNames(resourceGroupName, webSiteName, parameters);
            }
         });
    }
    
    /**
    * Update list of app settings and connection strings which to be slot
    * specific. E.g. settings in staging slots remain in staging after swap
    * with production.
    *
    * @param resourceGroupName Required. The name of the resource group
    * @param webSiteName Required. The name of the website
    * @param parameters Required. The Update slot configs parameters
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse updateSlotConfigNames(String resourceGroupName, String webSiteName, SlotConfigNamesUpdateParameters parameters) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (webSiteName == null) {
            throw new NullPointerException("webSiteName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getLocation() == null) {
            throw new NullPointerException("parameters.Location");
        }
        if (parameters.getProperties() == null) {
            throw new NullPointerException("parameters.Properties");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("webSiteName", webSiteName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "updateSlotConfigNamesAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Web";
        url = url + "/";
        url = url + "sites";
        url = url + "/";
        url = url + URLEncoder.encode(webSiteName, "UTF-8");
        url = url + "/config/slotConfigNames";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-06-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("accept", "application/json");
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Serialize Request
        String requestContent = null;
        JsonNode requestDoc = null;
        
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode slotConfigNamesUpdateParametersValue = objectMapper.createObjectNode();
        requestDoc = slotConfigNamesUpdateParametersValue;
        
        ObjectNode propertiesValue = objectMapper.createObjectNode();
        ((ObjectNode) slotConfigNamesUpdateParametersValue).put("properties", propertiesValue);
        
        if (parameters.getProperties().getConnectionStringNames() != null) {
            if (parameters.getProperties().getConnectionStringNames() instanceof LazyCollection == false || ((LazyCollection) parameters.getProperties().getConnectionStringNames()).isInitialized()) {
                ArrayNode connectionStringNamesArray = objectMapper.createArrayNode();
                for (String connectionStringNamesItem : parameters.getProperties().getConnectionStringNames()) {
                    connectionStringNamesArray.add(connectionStringNamesItem);
                }
                ((ObjectNode) propertiesValue).put("connectionStringNames", connectionStringNamesArray);
            }
        }
        
        if (parameters.getProperties().getAppSettingNames() != null) {
            if (parameters.getProperties().getAppSettingNames() instanceof LazyCollection == false || ((LazyCollection) parameters.getProperties().getAppSettingNames()).isInitialized()) {
                ArrayNode appSettingNamesArray = objectMapper.createArrayNode();
                for (String appSettingNamesItem : parameters.getProperties().getAppSettingNames()) {
                    appSettingNamesArray.add(appSettingNamesItem);
                }
                ((ObjectNode) propertiesValue).put("appSettingNames", appSettingNamesArray);
            }
        }
        
        if (parameters.getId() != null) {
            ((ObjectNode) slotConfigNamesUpdateParametersValue).put("id", parameters.getId());
        }
        
        if (parameters.getName() != null) {
            ((ObjectNode) slotConfigNamesUpdateParametersValue).put("name", parameters.getName());
        }
        
        ((ObjectNode) slotConfigNamesUpdateParametersValue).put("location", parameters.getLocation());
        
        if (parameters.getTags() != null) {
            ObjectNode tagsDictionary = objectMapper.createObjectNode();
            for (Map.Entry<String, String> entry : parameters.getTags().entrySet()) {
                String tagsKey = entry.getKey();
                String tagsValue = entry.getValue();
                ((ObjectNode) tagsDictionary).put(tagsKey, tagsValue);
            }
            ((ObjectNode) slotConfigNamesUpdateParametersValue).put("tags", tagsDictionary);
        }
        
        if (parameters.getType() != null) {
            ((ObjectNode) slotConfigNamesUpdateParametersValue).put("type", parameters.getType());
        }
        
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue(stringWriter, requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            // Deserialize Response
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}
