/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.websites.models;

import com.microsoft.windowsazure.core.LazyArrayList;

import java.util.ArrayList;
import java.util.Calendar;

/**
* Historical metric snapshot data for the web site.
*/
public class HistoricalUsageMetricData {
    private String displayName;
    
    /**
    * Optional. The display name of the metric, including spaces.
    * @return The DisplayName value.
    */
    public String getDisplayName() {
        return this.displayName;
    }
    
    /**
    * Optional. The display name of the metric, including spaces.
    * @param displayNameValue The DisplayName value.
    */
    public void setDisplayName(final String displayNameValue) {
        this.displayName = displayNameValue;
    }
    
    private Calendar endTime;
    
    /**
    * Optional. The end time of the data reported.
    * @return The EndTime value.
    */
    public Calendar getEndTime() {
        return this.endTime;
    }
    
    /**
    * Optional. The end time of the data reported.
    * @param endTimeValue The EndTime value.
    */
    public void setEndTime(final Calendar endTimeValue) {
        this.endTime = endTimeValue;
    }
    
    private String name;
    
    /**
    * Optional. The name of the metric.
    * @return The Name value.
    */
    public String getName() {
        return this.name;
    }
    
    /**
    * Optional. The name of the metric.
    * @param nameValue The Name value.
    */
    public void setName(final String nameValue) {
        this.name = nameValue;
    }
    
    private String primaryAggregationType;
    
    /**
    * Optional. The primary data aggregation type. This value is usually Total.
    * @return The PrimaryAggregationType value.
    */
    public String getPrimaryAggregationType() {
        return this.primaryAggregationType;
    }
    
    /**
    * Optional. The primary data aggregation type. This value is usually Total.
    * @param primaryAggregationTypeValue The PrimaryAggregationType value.
    */
    public void setPrimaryAggregationType(final String primaryAggregationTypeValue) {
        this.primaryAggregationType = primaryAggregationTypeValue;
    }
    
    private Calendar startTime;
    
    /**
    * Optional. The start time of the data reported.
    * @return The StartTime value.
    */
    public Calendar getStartTime() {
        return this.startTime;
    }
    
    /**
    * Optional. The start time of the data reported.
    * @param startTimeValue The StartTime value.
    */
    public void setStartTime(final Calendar startTimeValue) {
        this.startTime = startTimeValue;
    }
    
    private String timeGrain;
    
    /**
    * Optional. Length of time (rollup) during which the information was
    * gathered. For more information, see Supported Rollups.
    * @return The TimeGrain value.
    */
    public String getTimeGrain() {
        return this.timeGrain;
    }
    
    /**
    * Optional. Length of time (rollup) during which the information was
    * gathered. For more information, see Supported Rollups.
    * @param timeGrainValue The TimeGrain value.
    */
    public void setTimeGrain(final String timeGrainValue) {
        this.timeGrain = timeGrainValue;
    }
    
    private String unit;
    
    /**
    * Optional. The unit of measurement for the metric (for example,
    * milliseconds, bytes, or count).
    * @return The Unit value.
    */
    public String getUnit() {
        return this.unit;
    }
    
    /**
    * Optional. The unit of measurement for the metric (for example,
    * milliseconds, bytes, or count).
    * @param unitValue The Unit value.
    */
    public void setUnit(final String unitValue) {
        this.unit = unitValue;
    }
    
    private ArrayList<HistoricalUsageMetricSample> values;
    
    /**
    * Optional. One or more MetricSample elements.
    * @return The Values value.
    */
    public ArrayList<HistoricalUsageMetricSample> getValues() {
        return this.values;
    }
    
    /**
    * Optional. One or more MetricSample elements.
    * @param valuesValue The Values value.
    */
    public void setValues(final ArrayList<HistoricalUsageMetricSample> valuesValue) {
        this.values = valuesValue;
    }
    
    /**
    * Initializes a new instance of the HistoricalUsageMetricData class.
    *
    */
    public HistoricalUsageMetricData() {
        this.setValues(new LazyArrayList<HistoricalUsageMetricSample>());
    }
}
