/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.websites.models;

/**
* Publishing Credentials  for the website.
*/
public class PublishingCredentials {
    private String publishingPassword;
    
    /**
    * Required. Hash value of the password used for publishing the web site.
    * @return The PublishingPassword value.
    */
    public String getPublishingPassword() {
        return this.publishingPassword;
    }
    
    /**
    * Required. Hash value of the password used for publishing the web site.
    * @param publishingPasswordValue The PublishingPassword value.
    */
    public void setPublishingPassword(final String publishingPasswordValue) {
        this.publishingPassword = publishingPasswordValue;
    }
    
    private String publishingUserName;
    
    /**
    * Required. The username used for publishing the web site. This is normally
    * a dollar sign prepended to the web site name (for example, "$contoso").
    * @return The PublishingUserName value.
    */
    public String getPublishingUserName() {
        return this.publishingUserName;
    }
    
    /**
    * Required. The username used for publishing the web site. This is normally
    * a dollar sign prepended to the web site name (for example, "$contoso").
    * @param publishingUserNameValue The PublishingUserName value.
    */
    public void setPublishingUserName(final String publishingUserNameValue) {
        this.publishingUserName = publishingUserNameValue;
    }
    
    /**
    * Initializes a new instance of the PublishingCredentials class.
    *
    */
    public PublishingCredentials() {
    }
    
    /**
    * Initializes a new instance of the PublishingCredentials class with
    * required arguments.
    *
    * @param publishingPassword Hash value of the password used for publishing
    * the web site.
    * @param publishingUserName The username used for publishing the web site.
    * This is normally a dollar sign prepended to the web site name (for
    * example, "$contoso").
    */
    public PublishingCredentials(String publishingPassword, String publishingUserName) {
        if (publishingPassword == null) {
            throw new NullPointerException("publishingPassword");
        }
        if (publishingUserName == null) {
            throw new NullPointerException("publishingUserName");
        }
        this.setPublishingPassword(publishingPassword);
        this.setPublishingUserName(publishingUserName);
    }
}
