/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.websites.models;

/**
* Represents the properties of the site's source control.
*/
public class SiteSourceControlProperties {
    private String branch;
    
    /**
    * Optional. Gets or sets the branch (if required, will be master by
    * default).
    * @return The Branch value.
    */
    public String getBranch() {
        return this.branch;
    }
    
    /**
    * Optional. Gets or sets the branch (if required, will be master by
    * default).
    * @param branchValue The Branch value.
    */
    public void setBranch(final String branchValue) {
        this.branch = branchValue;
    }
    
    private boolean deploymentRollbackEnabled;
    
    /**
    * Optional. Gets or sets true to keep a repository for non-repository
    * source control provider (like Dropbox) or false (by default) otherwise.
    * @return The DeploymentRollbackEnabled value.
    */
    public boolean isDeploymentRollbackEnabled() {
        return this.deploymentRollbackEnabled;
    }
    
    /**
    * Optional. Gets or sets true to keep a repository for non-repository
    * source control provider (like Dropbox) or false (by default) otherwise.
    * @param deploymentRollbackEnabledValue The DeploymentRollbackEnabled value.
    */
    public void setDeploymentRollbackEnabled(final boolean deploymentRollbackEnabledValue) {
        this.deploymentRollbackEnabled = deploymentRollbackEnabledValue;
    }
    
    private boolean isManualIntegration;
    
    /**
    * Optional. Gets or sets true for repository that requires to be manually
    * synced or false (by default) otherwise.
    * @return The IsManualIntegration value.
    */
    public boolean isManualIntegration() {
        return this.isManualIntegration;
    }
    
    /**
    * Optional. Gets or sets true for repository that requires to be manually
    * synced or false (by default) otherwise.
    * @param isManualIntegrationValue The IsManualIntegration value.
    */
    public void setIsManualIntegration(final boolean isManualIntegrationValue) {
        this.isManualIntegration = isManualIntegrationValue;
    }
    
    private boolean isMercurial;
    
    /**
    * Optional. Gets or sets true if repository is Mercurial or false (by
    * default) otherwise.
    * @return The IsMercurial value.
    */
    public boolean isMercurial() {
        return this.isMercurial;
    }
    
    /**
    * Optional. Gets or sets true if repository is Mercurial or false (by
    * default) otherwise.
    * @param isMercurialValue The IsMercurial value.
    */
    public void setIsMercurial(final boolean isMercurialValue) {
        this.isMercurial = isMercurialValue;
    }
    
    private String repoUrl;
    
    /**
    * Required. Gets or sets the repository url.
    * @return The RepoUrl value.
    */
    public String getRepoUrl() {
        return this.repoUrl;
    }
    
    /**
    * Required. Gets or sets the repository url.
    * @param repoUrlValue The RepoUrl value.
    */
    public void setRepoUrl(final String repoUrlValue) {
        this.repoUrl = repoUrlValue;
    }
    
    /**
    * Initializes a new instance of the SiteSourceControlProperties class.
    *
    */
    public SiteSourceControlProperties() {
    }
    
    /**
    * Initializes a new instance of the SiteSourceControlProperties class with
    * required arguments.
    *
    * @param repoUrl Gets or sets the repository url.
    */
    public SiteSourceControlProperties(String repoUrl) {
        if (repoUrl == null) {
            throw new NullPointerException("repoUrl");
        }
        this.setRepoUrl(repoUrl);
    }
}
