/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.websites.models;

import com.microsoft.windowsazure.core.LazyArrayList;
import com.microsoft.windowsazure.core.OperationResponse;

import java.util.ArrayList;
import java.util.Iterator;

/**
* The list source controls operation response.
*/
public class SourceControlListResponse extends OperationResponse implements Iterable<SourceControl> {
    private ArrayList<SourceControl> sourceControls;
    
    /**
    * Optional. Gets or sets the source controls list.
    * @return The SourceControls value.
    */
    public ArrayList<SourceControl> getSourceControls() {
        return this.sourceControls;
    }
    
    /**
    * Optional. Gets or sets the source controls list.
    * @param sourceControlsValue The SourceControls value.
    */
    public void setSourceControls(final ArrayList<SourceControl> sourceControlsValue) {
        this.sourceControls = sourceControlsValue;
    }
    
    /**
    * Initializes a new instance of the SourceControlListResponse class.
    *
    */
    public SourceControlListResponse() {
        super();
        this.setSourceControls(new LazyArrayList<SourceControl>());
    }
    
    /**
    * Gets the sequence of SourceControls.
    *
    */
    public Iterator<SourceControl> iterator() {
        return this.getSourceControls().iterator();
    }
}
