/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.websites.models;

/**
* Create or update Web Hosting Plan parameters.
*/
public class WebHostingPlanCreateOrUpdateParameters {
    private WebHostingPlan webHostingPlan;
    
    /**
    * Required. Gets or sets information about a Web Hosting Plan being created
    * of updated.
    * @return The WebHostingPlan value.
    */
    public WebHostingPlan getWebHostingPlan() {
        return this.webHostingPlan;
    }
    
    /**
    * Required. Gets or sets information about a Web Hosting Plan being created
    * of updated.
    * @param webHostingPlanValue The WebHostingPlan value.
    */
    public void setWebHostingPlan(final WebHostingPlan webHostingPlanValue) {
        this.webHostingPlan = webHostingPlanValue;
    }
    
    /**
    * Initializes a new instance of the WebHostingPlanCreateOrUpdateParameters
    * class.
    *
    */
    public WebHostingPlanCreateOrUpdateParameters() {
    }
    
    /**
    * Initializes a new instance of the WebHostingPlanCreateOrUpdateParameters
    * class with required arguments.
    *
    * @param webHostingPlan Gets or sets information about a Web Hosting Plan
    * being created of updated.
    */
    public WebHostingPlanCreateOrUpdateParameters(WebHostingPlan webHostingPlan) {
        if (webHostingPlan == null) {
            throw new NullPointerException("webHostingPlan");
        }
        this.setWebHostingPlan(webHostingPlan);
    }
}
