/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.websites.models;

import com.microsoft.windowsazure.core.LazyArrayList;
import com.microsoft.windowsazure.core.OperationResponse;

import java.util.ArrayList;
import java.util.Iterator;

/**
* The Get Historical Usage Metrics Web hosting plan operation response.
*/
public class WebHostingPlanGetHistoricalUsageMetricsResponse extends OperationResponse implements Iterable<HistoricalUsageMetric> {
    private ArrayList<HistoricalUsageMetric> usageMetrics;
    
    /**
    * Optional. Historical metric snapshots for the web site.
    * @return The UsageMetrics value.
    */
    public ArrayList<HistoricalUsageMetric> getUsageMetrics() {
        return this.usageMetrics;
    }
    
    /**
    * Optional. Historical metric snapshots for the web site.
    * @param usageMetricsValue The UsageMetrics value.
    */
    public void setUsageMetrics(final ArrayList<HistoricalUsageMetric> usageMetricsValue) {
        this.usageMetrics = usageMetricsValue;
    }
    
    /**
    * Initializes a new instance of the
    * WebHostingPlanGetHistoricalUsageMetricsResponse class.
    *
    */
    public WebHostingPlanGetHistoricalUsageMetricsResponse() {
        super();
        this.setUsageMetrics(new LazyArrayList<HistoricalUsageMetric>());
    }
    
    /**
    * Gets the sequence of UsageMetrics.
    *
    */
    public Iterator<HistoricalUsageMetric> iterator() {
        return this.getUsageMetrics().iterator();
    }
}
