/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.websites.models;

import com.microsoft.windowsazure.core.LazyArrayList;

import java.util.ArrayList;

/**
* List of backups for the website.
*/
public class WebSiteConnectionStringsEnvelope extends ResourceBase {
    private ArrayList<ConnectionStringInfo> properties;
    
    /**
    * Optional. Connection strings configuration for a web site.
    * @return The Properties value.
    */
    public ArrayList<ConnectionStringInfo> getProperties() {
        return this.properties;
    }
    
    /**
    * Optional. Connection strings configuration for a web site.
    * @param propertiesValue The Properties value.
    */
    public void setProperties(final ArrayList<ConnectionStringInfo> propertiesValue) {
        this.properties = propertiesValue;
    }
    
    /**
    * Initializes a new instance of the WebSiteConnectionStringsEnvelope class.
    *
    */
    public WebSiteConnectionStringsEnvelope() {
        super();
        this.setProperties(new LazyArrayList<ConnectionStringInfo>());
    }
    
    /**
    * Initializes a new instance of the WebSiteConnectionStringsEnvelope class
    * with required arguments.
    *
    * @param location Gets or sets the location of the resource.
    */
    public WebSiteConnectionStringsEnvelope(String location) {
        this();
        if (location == null) {
            throw new NullPointerException("location");
        }
        this.setLocation(location);
    }
}
