/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.websites.models;

import com.microsoft.windowsazure.core.LazyArrayList;
import com.microsoft.windowsazure.core.OperationResponse;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;

/**
* The Get Web Site Usage Metrics operation response.
*/
public class WebSiteGetUsageMetricsResponse extends OperationResponse implements Iterable<WebSiteGetUsageMetricsResponse.UsageMetric> {
    private ArrayList<WebSiteGetUsageMetricsResponse.UsageMetric> usageMetrics;
    
    /**
    * Optional. The usage metrics for the web site.
    * @return The UsageMetrics value.
    */
    public ArrayList<WebSiteGetUsageMetricsResponse.UsageMetric> getUsageMetrics() {
        return this.usageMetrics;
    }
    
    /**
    * Optional. The usage metrics for the web site.
    * @param usageMetricsValue The UsageMetrics value.
    */
    public void setUsageMetrics(final ArrayList<WebSiteGetUsageMetricsResponse.UsageMetric> usageMetricsValue) {
        this.usageMetrics = usageMetricsValue;
    }
    
    /**
    * Initializes a new instance of the WebSiteGetUsageMetricsResponse class.
    *
    */
    public WebSiteGetUsageMetricsResponse() {
        super();
        this.setUsageMetrics(new LazyArrayList<WebSiteGetUsageMetricsResponse.UsageMetric>());
    }
    
    /**
    * Gets the sequence of UsageMetrics.
    *
    */
    public Iterator<WebSiteGetUsageMetricsResponse.UsageMetric> iterator() {
        return this.getUsageMetrics().iterator();
    }
    
    /**
    * A specific usage metric.
    */
    public static class UsageMetric {
        private String currentValue;
        
        /**
        * Optional. The current value of the metric specified, expressed in
        * terms of the measurement specified by the Unit element.
        * @return The CurrentValue value.
        */
        public String getCurrentValue() {
            return this.currentValue;
        }
        
        /**
        * Optional. The current value of the metric specified, expressed in
        * terms of the measurement specified by the Unit element.
        * @param currentValueValue The CurrentValue value.
        */
        public void setCurrentValue(final String currentValueValue) {
            this.currentValue = currentValueValue;
        }
        
        private String displayName;
        
        /**
        * Optional. The display name of the metric (includes spaces).
        * @return The DisplayName value.
        */
        public String getDisplayName() {
            return this.displayName;
        }
        
        /**
        * Optional. The display name of the metric (includes spaces).
        * @param displayNameValue The DisplayName value.
        */
        public void setDisplayName(final String displayNameValue) {
            this.displayName = displayNameValue;
        }
        
        private String limit;
        
        /**
        * Optional. The maximum point that the given metric can reach. The
        * limit resets at the time specified by the NextResetTime element. If
        * the limit is reached before the reset time, the site will be
        * stopped. A value of -1 means unlimited. Resources with limits
        * typically include CPU Time, Memory Usage, and File System Storage.
        * Important: Site level Limits information is only meaningful for
        * Shared and Standard web sites. For free web sites, limits are
        * enforced at the webspace level.
        * @return The Limit value.
        */
        public String getLimit() {
            return this.limit;
        }
        
        /**
        * Optional. The maximum point that the given metric can reach. The
        * limit resets at the time specified by the NextResetTime element. If
        * the limit is reached before the reset time, the site will be
        * stopped. A value of -1 means unlimited. Resources with limits
        * typically include CPU Time, Memory Usage, and File System Storage.
        * Important: Site level Limits information is only meaningful for
        * Shared and Standard web sites. For free web sites, limits are
        * enforced at the webspace level.
        * @param limitValue The Limit value.
        */
        public void setLimit(final String limitValue) {
            this.limit = limitValue;
        }
        
        private String name;
        
        /**
        * Optional. The name of the metric, without spaces. The value is
        * usually the same as that of the ResourceName element.
        * @return The Name value.
        */
        public String getName() {
            return this.name;
        }
        
        /**
        * Optional. The name of the metric, without spaces. The value is
        * usually the same as that of the ResourceName element.
        * @param nameValue The Name value.
        */
        public void setName(final String nameValue) {
            this.name = nameValue;
        }
        
        private Calendar nextResetTime;
        
        /**
        * Optional. The time at which the metric will be reset.
        * @return The NextResetTime value.
        */
        public Calendar getNextResetTime() {
            return this.nextResetTime;
        }
        
        /**
        * Optional. The time at which the metric will be reset.
        * @param nextResetTimeValue The NextResetTime value.
        */
        public void setNextResetTime(final Calendar nextResetTimeValue) {
            this.nextResetTime = nextResetTimeValue;
        }
        
        private String resourceName;
        
        /**
        * Optional. The name of the resource being measured.
        * @return The ResourceName value.
        */
        public String getResourceName() {
            return this.resourceName;
        }
        
        /**
        * Optional. The name of the resource being measured.
        * @param resourceNameValue The ResourceName value.
        */
        public void setResourceName(final String resourceNameValue) {
            this.resourceName = resourceNameValue;
        }
        
        private String unit;
        
        /**
        * Optional. The unit of measure for the given metric.
        * @return The Unit value.
        */
        public String getUnit() {
            return this.unit;
        }
        
        /**
        * Optional. The unit of measure for the given metric.
        * @param unitValue The Unit value.
        */
        public void setUnit(final String unitValue) {
            this.unit = unitValue;
        }
    }
}
