/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.websites.models;

import com.microsoft.windowsazure.core.LazyArrayList;
import com.microsoft.windowsazure.core.OperationResponse;

import java.util.ArrayList;
import java.util.Iterator;

/**
* The List Web Sites operation response.
*/
public class WebSiteListResponse extends OperationResponse implements Iterable<WebSite> {
    private ArrayList<WebSite> webSites;
    
    /**
    * Optional. The list of websites.
    * @return The WebSites value.
    */
    public ArrayList<WebSite> getWebSites() {
        return this.webSites;
    }
    
    /**
    * Optional. The list of websites.
    * @param webSitesValue The WebSites value.
    */
    public void setWebSites(final ArrayList<WebSite> webSitesValue) {
        this.webSites = webSitesValue;
    }
    
    /**
    * Initializes a new instance of the WebSiteListResponse class.
    *
    */
    public WebSiteListResponse() {
        super();
        this.setWebSites(new LazyArrayList<WebSite>());
    }
    
    /**
    * Gets the sequence of WebSites.
    *
    */
    public Iterator<WebSite> iterator() {
        return this.getWebSites().iterator();
    }
}
