/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.compute;

import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.OperationStatusResponse;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.compute.models.ExtensionImageRegisterParameters;
import com.microsoft.windowsazure.management.compute.models.ExtensionImageUpdateParameters;
import org.xml.sax.SAXException;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/**
* The Service Management API includes operations for managing the service and
* virtual machine extension images in your publisher subscription.
*/
public interface ExtensionImageOperations {
    /**
    * Register a new extension. An extension is identified by the combination
    * of its ProviderNamespace and Type (case-sensitive string). It is not
    * allowed to register an extension with the same identity (i.e.
    * combination of ProviderNamespace and Type) of an already-registered
    * extension. To register new version of an existing extension, the Update
    * Extension API should be used.
    *
    * @param parameters Required. Parameters supplied to the Register Virtual
    * Machine Extension Image operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse beginRegistering(ExtensionImageRegisterParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * Register a new extension. An extension is identified by the combination
    * of its ProviderNamespace and Type (case-sensitive string). It is not
    * allowed to register an extension with the same identity (i.e.
    * combination of ProviderNamespace and Type) of an already-registered
    * extension. To register new version of an existing extension, the Update
    * Extension API should be used.
    *
    * @param parameters Required. Parameters supplied to the Register Virtual
    * Machine Extension Image operation.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> beginRegisteringAsync(ExtensionImageRegisterParameters parameters);
    
    /**
    * Unregister a version of an extension that was previously registered using
    * either the Register Extension or Update Extension APIs. An extension
    * version is identified by the combination of its ProviderNamespace, Type
    * and Version which are specified when registering the extension.
    * Unregistering is only allowed for internal extensions, that is, the
    * extensions for which the IsInternalExtension field is set to 'true'
    * during registration or during an update. There is a quota (15) on the
    * number of extensions that can be registered per subscription. If your
    * subscription runs out of quota, you will wither need to unregister some
    * of the internal extensions or contact Azure (same email used to become a
    * publisher)  to increase the quota.
    *
    * @param providerNamespace Required. The provider namespace of the
    * extension image to unregister.
    * @param type Required. The type of the extension image to unregister.
    * @param version Required. The version of the extension image to unregister.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse beginUnregistering(String providerNamespace, String type, String version) throws IOException, ServiceException;
    
    /**
    * Unregister a version of an extension that was previously registered using
    * either the Register Extension or Update Extension APIs. An extension
    * version is identified by the combination of its ProviderNamespace, Type
    * and Version which are specified when registering the extension.
    * Unregistering is only allowed for internal extensions, that is, the
    * extensions for which the IsInternalExtension field is set to 'true'
    * during registration or during an update. There is a quota (15) on the
    * number of extensions that can be registered per subscription. If your
    * subscription runs out of quota, you will wither need to unregister some
    * of the internal extensions or contact Azure (same email used to become a
    * publisher)  to increase the quota.
    *
    * @param providerNamespace Required. The provider namespace of the
    * extension image to unregister.
    * @param type Required. The type of the extension image to unregister.
    * @param version Required. The version of the extension image to unregister.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> beginUnregisteringAsync(String providerNamespace, String type, String version);
    
    /**
    * Update a new extension. It is allowed to update an extension which had
    * already been registered with the same identity (i.e. combination of
    * ProviderNamespace and Type) but with different version. It will fail if
    * the extension to update has an identity that has not been registered
    * before, or there is already an extension with the same identity and same
    * version.
    *
    * @param parameters Required. Parameters supplied to the Update Virtual
    * Machine Extension Image operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse beginUpdating(ExtensionImageUpdateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * Update a new extension. It is allowed to update an extension which had
    * already been registered with the same identity (i.e. combination of
    * ProviderNamespace and Type) but with different version. It will fail if
    * the extension to update has an identity that has not been registered
    * before, or there is already an extension with the same identity and same
    * version.
    *
    * @param parameters Required. Parameters supplied to the Update Virtual
    * Machine Extension Image operation.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> beginUpdatingAsync(ExtensionImageUpdateParameters parameters);
    
    /**
    * Register a new extension. An extension is identified by the combination
    * of its ProviderNamespace and Type (case-sensitive string). It is not
    * allowed to register an extension with the same identity (i.e.
    * combination of ProviderNamespace and Type) of an already-registered
    * extension. To register new version of an existing extension, the Update
    * Extension API should be used.
    *
    * @param parameters Required. Parameters supplied to the Register Virtual
    * Machine Extension Image operation.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    OperationStatusResponse register(ExtensionImageRegisterParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException;
    
    /**
    * Register a new extension. An extension is identified by the combination
    * of its ProviderNamespace and Type (case-sensitive string). It is not
    * allowed to register an extension with the same identity (i.e.
    * combination of ProviderNamespace and Type) of an already-registered
    * extension. To register new version of an existing extension, the Update
    * Extension API should be used.
    *
    * @param parameters Required. Parameters supplied to the Register Virtual
    * Machine Extension Image operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    Future<OperationStatusResponse> registerAsync(ExtensionImageRegisterParameters parameters);
    
    /**
    * Unregister a version of an extension that was previously registered using
    * either the Register Extension or Update Extension APIs. An extension
    * version is identified by the combination of its ProviderNamespace, Type
    * and Version which are specified when registering the extension.
    * Unregistering is only allowed for internal extensions, that is, the
    * extensions for which the IsInternalExtension field is set to 'true'
    * during registration or during an update. There is a quota (15) on the
    * number of extensions that can be registered per subscription. If your
    * subscription runs out of quota, you will wither need to unregister some
    * of the internal extensions or contact Azure (same email used to become a
    * publisher)  to increase the quota.
    *
    * @param providerNamespace Required. The provider namespace of the
    * extension image to unregister.
    * @param type Required. The type of the extension image to unregister.
    * @param version Required. The version of the extension image to unregister.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    OperationStatusResponse unregister(String providerNamespace, String type, String version) throws InterruptedException, ExecutionException, ServiceException, IOException;
    
    /**
    * Unregister a version of an extension that was previously registered using
    * either the Register Extension or Update Extension APIs. An extension
    * version is identified by the combination of its ProviderNamespace, Type
    * and Version which are specified when registering the extension.
    * Unregistering is only allowed for internal extensions, that is, the
    * extensions for which the IsInternalExtension field is set to 'true'
    * during registration or during an update. There is a quota (15) on the
    * number of extensions that can be registered per subscription. If your
    * subscription runs out of quota, you will wither need to unregister some
    * of the internal extensions or contact Azure (same email used to become a
    * publisher)  to increase the quota.
    *
    * @param providerNamespace Required. The provider namespace of the
    * extension image to unregister.
    * @param type Required. The type of the extension image to unregister.
    * @param version Required. The version of the extension image to unregister.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    Future<OperationStatusResponse> unregisterAsync(String providerNamespace, String type, String version);
    
    /**
    * Update a new extension. It is allowed to update an extension which had
    * already been registered with the same identity (i.e. combination of
    * ProviderNamespace and Type) but with different version. It will fail if
    * the extension to update has an identity that has not been registered
    * before, or there is already an extension with the same identity and same
    * version.
    *
    * @param parameters Required. Parameters supplied to the Update Virtual
    * Machine Extension Image operation.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    OperationStatusResponse update(ExtensionImageUpdateParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException, ParserConfigurationException, SAXException, TransformerException, URISyntaxException;
    
    /**
    * Update a new extension. It is allowed to update an extension which had
    * already been registered with the same identity (i.e. combination of
    * ProviderNamespace and Type) but with different version. It will fail if
    * the extension to update has an identity that has not been registered
    * before, or there is already an extension with the same identity and same
    * version.
    *
    * @param parameters Required. Parameters supplied to the Update Virtual
    * Machine Extension Image operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    Future<OperationStatusResponse> updateAsync(ExtensionImageUpdateParameters parameters);
}
