/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.compute;

import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.compute.models.OperatingSystemListFamiliesResponse;
import com.microsoft.windowsazure.management.compute.models.OperatingSystemListResponse;
import org.xml.sax.SAXException;

import javax.xml.parsers.ParserConfigurationException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.concurrent.Future;

/**
* Operations for determining the version of the Azure Guest Operating System on
* which your service is running.  (see
* http://msdn.microsoft.com/en-us/library/windowsazure/ff684169.aspx for more
* information)
*/
public interface OperatingSystemOperations {
    /**
    * The List Operating Systems operation lists the versions of the guest
    * operating system that are currently available in Windows Azure. The
    * 2010-10-28 version of List Operating Systems also indicates what family
    * an operating system version belongs to. Currently Azure supports two
    * operating system families: the Azure guest operating system that is
    * substantially compatible with Windows Server 2008 SP2, and the Azure
    * guest operating system that is substantially compatible with Windows
    * Server 2008 R2.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/ff684168.aspx for
    * more information)
    *
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The List Operating Systems operation response.
    */
    OperatingSystemListResponse list() throws IOException, ServiceException, ParserConfigurationException, SAXException, URISyntaxException;
    
    /**
    * The List Operating Systems operation lists the versions of the guest
    * operating system that are currently available in Windows Azure. The
    * 2010-10-28 version of List Operating Systems also indicates what family
    * an operating system version belongs to. Currently Azure supports two
    * operating system families: the Azure guest operating system that is
    * substantially compatible with Windows Server 2008 SP2, and the Azure
    * guest operating system that is substantially compatible with Windows
    * Server 2008 R2.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/ff684168.aspx for
    * more information)
    *
    * @return The List Operating Systems operation response.
    */
    Future<OperatingSystemListResponse> listAsync();
    
    /**
    * The List OS Families operation lists the guest operating system families
    * available in Azure, and also lists the operating system versions
    * available for each family. Currently Azure supports two operating system
    * families: the Azure guest operating system that is substantially
    * compatible with Windows Server 2008 SP2, and the Azure guest operating
    * system that is substantially compatible with Windows Server 2008 R2.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/gg441291.aspx
    * for more information)
    *
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return The List Operating System Families operation response.
    */
    OperatingSystemListFamiliesResponse listFamilies() throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * The List OS Families operation lists the guest operating system families
    * available in Azure, and also lists the operating system versions
    * available for each family. Currently Azure supports two operating system
    * families: the Azure guest operating system that is substantially
    * compatible with Windows Server 2008 SP2, and the Azure guest operating
    * system that is substantially compatible with Windows Server 2008 R2.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/gg441291.aspx
    * for more information)
    *
    * @return The List Operating System Families operation response.
    */
    Future<OperatingSystemListFamiliesResponse> listFamiliesAsync();
}
