/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.compute;

import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.OperationStatusResponse;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineOSImageCreateParameters;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineOSImageCreateResponse;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineOSImageGetDetailsResponse;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineOSImageGetResponse;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineOSImageListResponse;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineOSImageReplicateParameters;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineOSImageReplicateResponse;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineOSImageUpdateParameters;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineOSImageUpdateResponse;
import org.xml.sax.SAXException;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/**
* The Service Management API includes operations for managing the OS images in
* your subscription.  (see
* http://msdn.microsoft.com/en-us/library/windowsazure/jj157175.aspx for more
* information)
*/
public interface VirtualMachineOSImageOperations {
    /**
    * Share an already replicated OS image. This operation is only for
    * publishers. You have to be registered as image publisher with Windows
    * Azure to be able to call this.
    *
    * @param imageName Required. The name of the virtual machine image to share.
    * @param permission Required. The sharing permission: public, msdn, or
    * private.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse beginSharing(String imageName, String permission) throws IOException, ServiceException;
    
    /**
    * Share an already replicated OS image. This operation is only for
    * publishers. You have to be registered as image publisher with Windows
    * Azure to be able to call this.
    *
    * @param imageName Required. The name of the virtual machine image to share.
    * @param permission Required. The sharing permission: public, msdn, or
    * private.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> beginSharingAsync(String imageName, String permission);
    
    /**
    * Unreplicate an OS image to multiple target locations. This operation is
    * only for publishers. You have to be registered as image publisher with
    * Windows Azure to be able to call this. Note: The operation removes the
    * published copies of the user OS Image. It does not remove the actual
    * user OS Image. To remove the actual user OS Image, the publisher will
    * have to call Delete OS Image.
    *
    * @param imageName Required. The name of the virtual machine image to
    * replicate. Note: The OS Image Name should be the user OS Image, not the
    * published name of the OS Image.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse beginUnreplicating(String imageName) throws IOException, ServiceException;
    
    /**
    * Unreplicate an OS image to multiple target locations. This operation is
    * only for publishers. You have to be registered as image publisher with
    * Windows Azure to be able to call this. Note: The operation removes the
    * published copies of the user OS Image. It does not remove the actual
    * user OS Image. To remove the actual user OS Image, the publisher will
    * have to call Delete OS Image.
    *
    * @param imageName Required. The name of the virtual machine image to
    * replicate. Note: The OS Image Name should be the user OS Image, not the
    * published name of the OS Image.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> beginUnreplicatingAsync(String imageName);
    
    /**
    * The Create OS Image operation adds an operating system image that is
    * stored in a storage account and is available from the image repository.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/jj157192.aspx
    * for more information)
    *
    * @param parameters Required. Parameters supplied to the Create Virtual
    * Machine Image operation.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return Parameters returned from the Create Virtual Machine Image
    * operation.
    */
    VirtualMachineOSImageCreateResponse create(VirtualMachineOSImageCreateParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException, ParserConfigurationException, SAXException, TransformerException, URISyntaxException;
    
    /**
    * The Create OS Image operation adds an operating system image that is
    * stored in a storage account and is available from the image repository.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/jj157192.aspx
    * for more information)
    *
    * @param parameters Required. Parameters supplied to the Create Virtual
    * Machine Image operation.
    * @return Parameters returned from the Create Virtual Machine Image
    * operation.
    */
    Future<VirtualMachineOSImageCreateResponse> createAsync(VirtualMachineOSImageCreateParameters parameters);
    
    /**
    * The Delete OS Image operation deletes the specified OS image from your
    * image repository.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157203.aspx for
    * more information)
    *
    * @param imageName Required. The name of the image to delete.
    * @param deleteFromStorage Required. Specifies that the source blob for the
    * image should also be deleted from storage.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse delete(String imageName, boolean deleteFromStorage) throws IOException, ServiceException, InterruptedException, ExecutionException;
    
    /**
    * The Delete OS Image operation deletes the specified OS image from your
    * image repository.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157203.aspx for
    * more information)
    *
    * @param imageName Required. The name of the image to delete.
    * @param deleteFromStorage Required. Specifies that the source blob for the
    * image should also be deleted from storage.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> deleteAsync(String imageName, boolean deleteFromStorage);
    
    /**
    * The Get OS Image operation retrieves the details for an operating system
    * image from the image repository.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157191.aspx for
    * more information)
    *
    * @param imageName Required. The name of the OS image to retrieve.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return A virtual machine image associated with your subscription.
    */
    VirtualMachineOSImageGetResponse get(String imageName) throws IOException, ServiceException, ParserConfigurationException, SAXException, URISyntaxException;
    
    /**
    * The Get OS Image operation retrieves the details for an operating system
    * image from the image repository.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157191.aspx for
    * more information)
    *
    * @param imageName Required. The name of the OS image to retrieve.
    * @return A virtual machine image associated with your subscription.
    */
    Future<VirtualMachineOSImageGetResponse> getAsync(String imageName);
    
    /**
    * Gets OS Image's properties and its replication details. This operation is
    * only for publishers. You have to be registered as image publisher with
    * Windows Azure to be able to call this.
    *
    * @param imageName Required. The name of the virtual machine image to
    * replicate.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The Get Details OS Images operation response.
    */
    VirtualMachineOSImageGetDetailsResponse getDetails(String imageName) throws IOException, ServiceException, ParserConfigurationException, SAXException, URISyntaxException;
    
    /**
    * Gets OS Image's properties and its replication details. This operation is
    * only for publishers. You have to be registered as image publisher with
    * Windows Azure to be able to call this.
    *
    * @param imageName Required. The name of the virtual machine image to
    * replicate.
    * @return The Get Details OS Images operation response.
    */
    Future<VirtualMachineOSImageGetDetailsResponse> getDetailsAsync(String imageName);
    
    /**
    * The List OS Images operation retrieves a list of the operating system
    * images from the image repository.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157191.aspx for
    * more information)
    *
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The List OS Images operation response.
    */
    VirtualMachineOSImageListResponse list() throws IOException, ServiceException, ParserConfigurationException, SAXException, URISyntaxException;
    
    /**
    * The List OS Images operation retrieves a list of the operating system
    * images from the image repository.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157191.aspx for
    * more information)
    *
    * @return The List OS Images operation response.
    */
    Future<VirtualMachineOSImageListResponse> listAsync();
    
    /**
    * Replicate an OS image to multiple target locations. This operation is
    * only for publishers. You have to be registered as image publisher with
    * Windows Azure to be able to call this.
    *
    * @param imageName Required. The name of the virtual machine OS image to
    * replicate.
    * @param parameters Required. Parameters supplied to the Replicate Virtual
    * Machine Image operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The response body contains the published name of the image.
    */
    VirtualMachineOSImageReplicateResponse replicate(String imageName, VirtualMachineOSImageReplicateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * Replicate an OS image to multiple target locations. This operation is
    * only for publishers. You have to be registered as image publisher with
    * Windows Azure to be able to call this.
    *
    * @param imageName Required. The name of the virtual machine OS image to
    * replicate.
    * @param parameters Required. Parameters supplied to the Replicate Virtual
    * Machine Image operation.
    * @return The response body contains the published name of the image.
    */
    Future<VirtualMachineOSImageReplicateResponse> replicateAsync(String imageName, VirtualMachineOSImageReplicateParameters parameters);
    
    /**
    * Share an already replicated OS image. This operation is only for
    * publishers. You have to be registered as image publisher with Windows
    * Azure to be able to call this.
    *
    * @param imageName Required. The name of the virtual machine image to share.
    * @param permission Required. The sharing permission: public, msdn, or
    * private.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    OperationStatusResponse share(String imageName, String permission) throws InterruptedException, ExecutionException, ServiceException, IOException;
    
    /**
    * Share an already replicated OS image. This operation is only for
    * publishers. You have to be registered as image publisher with Windows
    * Azure to be able to call this.
    *
    * @param imageName Required. The name of the virtual machine image to share.
    * @param permission Required. The sharing permission: public, msdn, or
    * private.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    Future<OperationStatusResponse> shareAsync(String imageName, String permission);
    
    /**
    * Unreplicate an OS image to multiple target locations. This operation is
    * only for publishers. You have to be registered as image publisher with
    * Windows Azure to be able to call this. Note: The operation removes the
    * published copies of the user OS Image. It does not remove the actual
    * user OS Image. To remove the actual user OS Image, the publisher will
    * have to call Delete OS Image.
    *
    * @param imageName Required. The name of the virtual machine image to
    * replicate. Note: The OS Image Name should be the user OS Image, not the
    * published name of the OS Image.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    OperationStatusResponse unreplicate(String imageName) throws InterruptedException, ExecutionException, ServiceException, IOException;
    
    /**
    * Unreplicate an OS image to multiple target locations. This operation is
    * only for publishers. You have to be registered as image publisher with
    * Windows Azure to be able to call this. Note: The operation removes the
    * published copies of the user OS Image. It does not remove the actual
    * user OS Image. To remove the actual user OS Image, the publisher will
    * have to call Delete OS Image.
    *
    * @param imageName Required. The name of the virtual machine image to
    * replicate. Note: The OS Image Name should be the user OS Image, not the
    * published name of the OS Image.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    Future<OperationStatusResponse> unreplicateAsync(String imageName);
    
    /**
    * The Update OS Image operation updates an OS image that in your image
    * repository.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157198.aspx for
    * more information)
    *
    * @param imageName Required. The name of the virtual machine image to be
    * updated.
    * @param parameters Required. Parameters supplied to the Update Virtual
    * Machine Image operation.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return Parameters returned from the Create Virtual Machine Image
    * operation.
    */
    VirtualMachineOSImageUpdateResponse update(String imageName, VirtualMachineOSImageUpdateParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException, ParserConfigurationException, SAXException, TransformerException, URISyntaxException;
    
    /**
    * The Update OS Image operation updates an OS image that in your image
    * repository.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157198.aspx for
    * more information)
    *
    * @param imageName Required. The name of the virtual machine image to be
    * updated.
    * @param parameters Required. Parameters supplied to the Update Virtual
    * Machine Image operation.
    * @return Parameters returned from the Create Virtual Machine Image
    * operation.
    */
    Future<VirtualMachineOSImageUpdateResponse> updateAsync(String imageName, VirtualMachineOSImageUpdateParameters parameters);
}
