/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.compute;

import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.OperationStatusResponse;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineCaptureOSImageParameters;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineCaptureVMImageParameters;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineCreateDeploymentParameters;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineCreateParameters;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineGetRemoteDesktopFileResponse;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineGetResponse;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineShutdownParameters;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineShutdownRolesParameters;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineStartRolesParameters;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineUpdateLoadBalancedSetParameters;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineUpdateParameters;
import org.xml.sax.SAXException;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/**
* The Service Management API includes operations for managing the virtual
* machines in your subscription.  (see
* http://msdn.microsoft.com/en-us/library/windowsazure/jj157206.aspx for more
* information)
*/
public interface VirtualMachineOperations {
    /**
    * The Begin Capturing Role operation creates a copy of the operating system
    * virtual hard disk (VHD) that is deployed in the virtual machine, saves
    * the VHD copy in the same storage location as the operating system VHD,
    * and registers the copy as an image in your image gallery. From the
    * captured image, you can create additional customized virtual machines.
    * For more information about images and disks, see Manage Disks and Images
    * at http://msdn.microsoft.com/en-us/library/windowsazure/jj672979.aspx.
    * For more information about capturing images, see How to Capture an Image
    * of a Virtual Machine Running Windows Server 2008 R2 at
    * http://www.windowsazure.com/en-us/documentation/articles/virtual-machines-capture-image-windows-server/
    * or How to Capture an Image of a Virtual Machine Running Linux at
    * http://www.windowsazure.com/en-us/documentation/articles/virtual-machines-linux-capture-image/.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/jj157201.aspx
    * for more information)
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of your deployment.
    * @param virtualMachineName Required. The name of the virtual machine to
    * restart.
    * @param parameters Required. Parameters supplied to the Begin Capturing
    * Virtual Machine operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse beginCapturingOSImage(String serviceName, String deploymentName, String virtualMachineName, VirtualMachineCaptureOSImageParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * The Begin Capturing Role operation creates a copy of the operating system
    * virtual hard disk (VHD) that is deployed in the virtual machine, saves
    * the VHD copy in the same storage location as the operating system VHD,
    * and registers the copy as an image in your image gallery. From the
    * captured image, you can create additional customized virtual machines.
    * For more information about images and disks, see Manage Disks and Images
    * at http://msdn.microsoft.com/en-us/library/windowsazure/jj672979.aspx.
    * For more information about capturing images, see How to Capture an Image
    * of a Virtual Machine Running Windows Server 2008 R2 at
    * http://www.windowsazure.com/en-us/documentation/articles/virtual-machines-capture-image-windows-server/
    * or How to Capture an Image of a Virtual Machine Running Linux at
    * http://www.windowsazure.com/en-us/documentation/articles/virtual-machines-linux-capture-image/.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/jj157201.aspx
    * for more information)
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of your deployment.
    * @param virtualMachineName Required. The name of the virtual machine to
    * restart.
    * @param parameters Required. Parameters supplied to the Begin Capturing
    * Virtual Machine operation.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> beginCapturingOSImageAsync(String serviceName, String deploymentName, String virtualMachineName, VirtualMachineCaptureOSImageParameters parameters);
    
    /**
    * Begin capturing role as VM template.
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of your deployment.
    * @param virtualMachineName Required. The name of the virtual machine to
    * restart.
    * @param parameters Required. Parameters supplied to the Capture Virtual
    * Machine operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse beginCapturingVMImage(String serviceName, String deploymentName, String virtualMachineName, VirtualMachineCaptureVMImageParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * Begin capturing role as VM template.
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of your deployment.
    * @param virtualMachineName Required. The name of the virtual machine to
    * restart.
    * @param parameters Required. Parameters supplied to the Capture Virtual
    * Machine operation.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> beginCapturingVMImageAsync(String serviceName, String deploymentName, String virtualMachineName, VirtualMachineCaptureVMImageParameters parameters);
    
    /**
    * The Begin Creating Role operation adds a virtual machine to an existing
    * deployment. You can refer to the OSDisk in the Add Role operation in the
    * following ways: Platform/User Image - Set the SourceImageName to a
    * platform or user image. You can optionally specify the DiskName and
    * MediaLink values as part the operation to control the name and location
    * of target disk. When DiskName and MediaLink are specified in this mode,
    * they must not already exist in the system, otherwise a conflict fault is
    * returned; UserDisk - Set DiskName to a user supplied image in image
    * repository. SourceImageName must be set to NULL. All other properties
    * are ignored; or Blob in a Storage Account - Set MediaLink to a blob
    * containing the image. SourceImageName and DiskName are set to NULL.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/jj157186.aspx
    * for more information)
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of your deployment.
    * @param parameters Required. Parameters supplied to the Begin Creating
    * Virtual Machine operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse beginCreating(String serviceName, String deploymentName, VirtualMachineCreateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * The Begin Creating Role operation adds a virtual machine to an existing
    * deployment. You can refer to the OSDisk in the Add Role operation in the
    * following ways: Platform/User Image - Set the SourceImageName to a
    * platform or user image. You can optionally specify the DiskName and
    * MediaLink values as part the operation to control the name and location
    * of target disk. When DiskName and MediaLink are specified in this mode,
    * they must not already exist in the system, otherwise a conflict fault is
    * returned; UserDisk - Set DiskName to a user supplied image in image
    * repository. SourceImageName must be set to NULL. All other properties
    * are ignored; or Blob in a Storage Account - Set MediaLink to a blob
    * containing the image. SourceImageName and DiskName are set to NULL.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/jj157186.aspx
    * for more information)
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of your deployment.
    * @param parameters Required. Parameters supplied to the Begin Creating
    * Virtual Machine operation.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> beginCreatingAsync(String serviceName, String deploymentName, VirtualMachineCreateParameters parameters);
    
    /**
    * The Begin Creating Virtual Machine Deployment operation provisions a
    * virtual machine based on the supplied configuration. When you create a
    * deployment of a virtual machine, you should make sure that the cloud
    * service and the disk or image that you use are located in the same
    * region. For example, if the cloud service was created in the West US
    * region, the disk or image that you use should also be located in a
    * storage account in the West US region.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157194.aspx for
    * more information)
    *
    * @param serviceName Required. The name of your service.
    * @param parameters Required. Parameters supplied to the Begin Creating
    * Virtual Machine Deployment operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse beginCreatingDeployment(String serviceName, VirtualMachineCreateDeploymentParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * The Begin Creating Virtual Machine Deployment operation provisions a
    * virtual machine based on the supplied configuration. When you create a
    * deployment of a virtual machine, you should make sure that the cloud
    * service and the disk or image that you use are located in the same
    * region. For example, if the cloud service was created in the West US
    * region, the disk or image that you use should also be located in a
    * storage account in the West US region.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157194.aspx for
    * more information)
    *
    * @param serviceName Required. The name of your service.
    * @param parameters Required. Parameters supplied to the Begin Creating
    * Virtual Machine Deployment operation.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> beginCreatingDeploymentAsync(String serviceName, VirtualMachineCreateDeploymentParameters parameters);
    
    /**
    * The Begin Deleting Role operation deletes the specified virtual machine.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/jj157184.aspx
    * for more information)
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of your deployment.
    * @param virtualMachineName Required. The name of the virtual machine to
    * delete.
    * @param deleteFromStorage Required. Specifies that the source blob(s) for
    * the virtual machine should also be deleted from storage.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse beginDeleting(String serviceName, String deploymentName, String virtualMachineName, boolean deleteFromStorage) throws IOException, ServiceException;
    
    /**
    * The Begin Deleting Role operation deletes the specified virtual machine.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/jj157184.aspx
    * for more information)
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of your deployment.
    * @param virtualMachineName Required. The name of the virtual machine to
    * delete.
    * @param deleteFromStorage Required. Specifies that the source blob(s) for
    * the virtual machine should also be deleted from storage.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> beginDeletingAsync(String serviceName, String deploymentName, String virtualMachineName, boolean deleteFromStorage);
    
    /**
    * The Begin Restarting role operation restarts the specified virtual
    * machine.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157197.aspx for
    * more information)
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of your deployment.
    * @param virtualMachineName Required. The name of the virtual machine to
    * restart.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse beginRestarting(String serviceName, String deploymentName, String virtualMachineName) throws IOException, ServiceException;
    
    /**
    * The Begin Restarting role operation restarts the specified virtual
    * machine.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157197.aspx for
    * more information)
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of your deployment.
    * @param virtualMachineName Required. The name of the virtual machine to
    * restart.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> beginRestartingAsync(String serviceName, String deploymentName, String virtualMachineName);
    
    /**
    * The Shutdown Role operation shuts down the specified virtual machine.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/jj157195.aspx
    * for more information)
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of your deployment.
    * @param virtualMachineName Required. The name of the virtual machine to
    * shutdown.
    * @param parameters Required. The parameters for the shutdown vm operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse beginShutdown(String serviceName, String deploymentName, String virtualMachineName, VirtualMachineShutdownParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * The Shutdown Role operation shuts down the specified virtual machine.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/jj157195.aspx
    * for more information)
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of your deployment.
    * @param virtualMachineName Required. The name of the virtual machine to
    * shutdown.
    * @param parameters Required. The parameters for the shutdown vm operation.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> beginShutdownAsync(String serviceName, String deploymentName, String virtualMachineName, VirtualMachineShutdownParameters parameters);
    
    /**
    * The Begin Shutting Down Roles operation stops the specified set of
    * virtual machines.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn469421.aspx for
    * more information)
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of your deployment.
    * @param parameters Required. Parameters to pass to the Begin Shutting Down
    * Roles operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse beginShuttingDownRoles(String serviceName, String deploymentName, VirtualMachineShutdownRolesParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * The Begin Shutting Down Roles operation stops the specified set of
    * virtual machines.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn469421.aspx for
    * more information)
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of your deployment.
    * @param parameters Required. Parameters to pass to the Begin Shutting Down
    * Roles operation.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> beginShuttingDownRolesAsync(String serviceName, String deploymentName, VirtualMachineShutdownRolesParameters parameters);
    
    /**
    * The Begin Starting Role operation starts the specified virtual machine.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/jj157189.aspx
    * for more information)
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of your deployment.
    * @param virtualMachineName Required. The name of the virtual machine to
    * start.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse beginStarting(String serviceName, String deploymentName, String virtualMachineName) throws IOException, ServiceException;
    
    /**
    * The Begin Starting Role operation starts the specified virtual machine.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/jj157189.aspx
    * for more information)
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of your deployment.
    * @param virtualMachineName Required. The name of the virtual machine to
    * start.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> beginStartingAsync(String serviceName, String deploymentName, String virtualMachineName);
    
    /**
    * The Begin Starting Roles operation starts the specified set of virtual
    * machines.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn469419.aspx for
    * more information)
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of your deployment.
    * @param parameters Required. Parameters to pass to the Begin Starting
    * Roles operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse beginStartingRoles(String serviceName, String deploymentName, VirtualMachineStartRolesParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * The Begin Starting Roles operation starts the specified set of virtual
    * machines.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn469419.aspx for
    * more information)
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of your deployment.
    * @param parameters Required. Parameters to pass to the Begin Starting
    * Roles operation.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> beginStartingRolesAsync(String serviceName, String deploymentName, VirtualMachineStartRolesParameters parameters);
    
    /**
    * The Begin Updating Role operation adds a virtual machine to an existing
    * deployment.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157187.aspx for
    * more information)
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of your deployment.
    * @param virtualMachineName Required. The name of your virtual machine.
    * @param parameters Required. Parameters supplied to the Begin Updating
    * Virtual Machine operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse beginUpdating(String serviceName, String deploymentName, String virtualMachineName, VirtualMachineUpdateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * The Begin Updating Role operation adds a virtual machine to an existing
    * deployment.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157187.aspx for
    * more information)
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of your deployment.
    * @param virtualMachineName Required. The name of your virtual machine.
    * @param parameters Required. Parameters supplied to the Begin Updating
    * Virtual Machine operation.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> beginUpdatingAsync(String serviceName, String deploymentName, String virtualMachineName, VirtualMachineUpdateParameters parameters);
    
    /**
    * The Begin Updating Load Balanced Endpoint Set operation changes the
    * specified load-balanced InputEndpoints on all the roles of an
    * Infrastructure as a Service deployment. Non-load-balanced endpoints must
    * be changed using UpdateRole.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn469417.aspx for
    * more information)
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of your deployment.
    * @param parameters Required. Parameters supplied to the Begin Updating
    * Load Balanced Endpoint Set operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse beginUpdatingLoadBalancedEndpointSet(String serviceName, String deploymentName, VirtualMachineUpdateLoadBalancedSetParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * The Begin Updating Load Balanced Endpoint Set operation changes the
    * specified load-balanced InputEndpoints on all the roles of an
    * Infrastructure as a Service deployment. Non-load-balanced endpoints must
    * be changed using UpdateRole.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn469417.aspx for
    * more information)
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of your deployment.
    * @param parameters Required. Parameters supplied to the Begin Updating
    * Load Balanced Endpoint Set operation.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> beginUpdatingLoadBalancedEndpointSetAsync(String serviceName, String deploymentName, VirtualMachineUpdateLoadBalancedSetParameters parameters);
    
    /**
    * The Capture Role operation creates a copy of the operating system virtual
    * hard disk (VHD) that is deployed in the virtual machine, saves the VHD
    * copy in the same storage location as the operating system VHD, and
    * registers the copy as an image in your image gallery. From the captured
    * image, you can create additional customized virtual machines. For more
    * information about images and disks, see Manage Disks and Images at
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj672979.aspx. For
    * more information about capturing images, see How to Capture an Image of
    * a Virtual Machine Running Windows Server 2008 R2 at
    * http://www.windowsazure.com/en-us/documentation/articles/virtual-machines-capture-image-windows-server/
    * or How to Capture an Image of a Virtual Machine Running Linux at
    * http://www.windowsazure.com/en-us/documentation/articles/virtual-machines-linux-capture-image/.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/jj157201.aspx
    * for more information)
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of your deployment.
    * @param virtualMachineName Required. The name of the virtual machine to
    * restart.
    * @param parameters Required. Parameters supplied to the Capture Virtual
    * Machine operation.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    OperationStatusResponse captureOSImage(String serviceName, String deploymentName, String virtualMachineName, VirtualMachineCaptureOSImageParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException;
    
    /**
    * The Capture Role operation creates a copy of the operating system virtual
    * hard disk (VHD) that is deployed in the virtual machine, saves the VHD
    * copy in the same storage location as the operating system VHD, and
    * registers the copy as an image in your image gallery. From the captured
    * image, you can create additional customized virtual machines. For more
    * information about images and disks, see Manage Disks and Images at
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj672979.aspx. For
    * more information about capturing images, see How to Capture an Image of
    * a Virtual Machine Running Windows Server 2008 R2 at
    * http://www.windowsazure.com/en-us/documentation/articles/virtual-machines-capture-image-windows-server/
    * or How to Capture an Image of a Virtual Machine Running Linux at
    * http://www.windowsazure.com/en-us/documentation/articles/virtual-machines-linux-capture-image/.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/jj157201.aspx
    * for more information)
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of your deployment.
    * @param virtualMachineName Required. The name of the virtual machine to
    * restart.
    * @param parameters Required. Parameters supplied to the Capture Virtual
    * Machine operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    Future<OperationStatusResponse> captureOSImageAsync(String serviceName, String deploymentName, String virtualMachineName, VirtualMachineCaptureOSImageParameters parameters);
    
    /**
    * Capture role as VM template.
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of your deployment.
    * @param virtualMachineName Required. The name of the virtual machine to
    * restart.
    * @param parameters Required. Parameters supplied to the Capture Virtual
    * Machine operation.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    OperationStatusResponse captureVMImage(String serviceName, String deploymentName, String virtualMachineName, VirtualMachineCaptureVMImageParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException;
    
    /**
    * Capture role as VM template.
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of your deployment.
    * @param virtualMachineName Required. The name of the virtual machine to
    * restart.
    * @param parameters Required. Parameters supplied to the Capture Virtual
    * Machine operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    Future<OperationStatusResponse> captureVMImageAsync(String serviceName, String deploymentName, String virtualMachineName, VirtualMachineCaptureVMImageParameters parameters);
    
    /**
    * The Create Role operation adds a virtual machine to an existing
    * deployment. You can refer to the OSDisk in the Add Role operation in the
    * following ways: Platform/User Image - Set the SourceImageName to a
    * platform or user image. You can optionally specify the DiskName and
    * MediaLink values as part the operation to control the name and location
    * of target disk. When DiskName and MediaLink are specified in this mode,
    * they must not already exist in the system, otherwise a conflict fault is
    * returned; UserDisk - Set DiskName to a user supplied image in image
    * repository. SourceImageName must be set to NULL. All other properties
    * are ignored; or Blob in a Storage Account - Set MediaLink to a blob
    * containing the image. SourceImageName and DiskName are set to NULL.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/jj157186.aspx
    * for more information)
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of your deployment.
    * @param parameters Required. Parameters supplied to the Create Virtual
    * Machine operation.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    OperationStatusResponse create(String serviceName, String deploymentName, VirtualMachineCreateParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException, ParserConfigurationException, SAXException, TransformerException, URISyntaxException;
    
    /**
    * The Create Role operation adds a virtual machine to an existing
    * deployment. You can refer to the OSDisk in the Add Role operation in the
    * following ways: Platform/User Image - Set the SourceImageName to a
    * platform or user image. You can optionally specify the DiskName and
    * MediaLink values as part the operation to control the name and location
    * of target disk. When DiskName and MediaLink are specified in this mode,
    * they must not already exist in the system, otherwise a conflict fault is
    * returned; UserDisk - Set DiskName to a user supplied image in image
    * repository. SourceImageName must be set to NULL. All other properties
    * are ignored; or Blob in a Storage Account - Set MediaLink to a blob
    * containing the image. SourceImageName and DiskName are set to NULL.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/jj157186.aspx
    * for more information)
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of your deployment.
    * @param parameters Required. Parameters supplied to the Create Virtual
    * Machine operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    Future<OperationStatusResponse> createAsync(String serviceName, String deploymentName, VirtualMachineCreateParameters parameters);
    
    /**
    * The Create Virtual Machine Deployment operation provisions a virtual
    * machine based on the supplied configuration. When you create a
    * deployment of a virtual machine, you should make sure that the cloud
    * service and the disk or image that you use are located in the same
    * region. For example, if the cloud service was created in the West US
    * region, the disk or image that you use should also be located in a
    * storage account in the West US region.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157194.aspx for
    * more information)
    *
    * @param serviceName Required. The name of your service.
    * @param parameters Required. Parameters supplied to the Create Virtual
    * Machine Deployment operation.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    OperationStatusResponse createDeployment(String serviceName, VirtualMachineCreateDeploymentParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException;
    
    /**
    * The Create Virtual Machine Deployment operation provisions a virtual
    * machine based on the supplied configuration. When you create a
    * deployment of a virtual machine, you should make sure that the cloud
    * service and the disk or image that you use are located in the same
    * region. For example, if the cloud service was created in the West US
    * region, the disk or image that you use should also be located in a
    * storage account in the West US region.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157194.aspx for
    * more information)
    *
    * @param serviceName Required. The name of your service.
    * @param parameters Required. Parameters supplied to the Create Virtual
    * Machine Deployment operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    Future<OperationStatusResponse> createDeploymentAsync(String serviceName, VirtualMachineCreateDeploymentParameters parameters);
    
    /**
    * The Delete Role operation deletes the specified virtual machine.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157184.aspx for
    * more information)
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of your deployment.
    * @param virtualMachineName Required. The name of the virtual machine to
    * delete.
    * @param deleteFromStorage Required. Specifies that the source blob(s) for
    * the virtual machine should also be deleted from storage.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    OperationStatusResponse delete(String serviceName, String deploymentName, String virtualMachineName, boolean deleteFromStorage) throws IOException, ServiceException, InterruptedException, ExecutionException;
    
    /**
    * The Delete Role operation deletes the specified virtual machine.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157184.aspx for
    * more information)
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of your deployment.
    * @param virtualMachineName Required. The name of the virtual machine to
    * delete.
    * @param deleteFromStorage Required. Specifies that the source blob(s) for
    * the virtual machine should also be deleted from storage.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    Future<OperationStatusResponse> deleteAsync(String serviceName, String deploymentName, String virtualMachineName, boolean deleteFromStorage);
    
    /**
    * The Get Role operation retrieves information about the specified virtual
    * machine.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157193.aspx for
    * more information)
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of your deployment.
    * @param virtualMachineName Required. The name of the virtual machine.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The Get Virtual Machine operation response.
    */
    VirtualMachineGetResponse get(String serviceName, String deploymentName, String virtualMachineName) throws IOException, ServiceException, ParserConfigurationException, SAXException, URISyntaxException;
    
    /**
    * The Get Role operation retrieves information about the specified virtual
    * machine.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157193.aspx for
    * more information)
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of your deployment.
    * @param virtualMachineName Required. The name of the virtual machine.
    * @return The Get Virtual Machine operation response.
    */
    Future<VirtualMachineGetResponse> getAsync(String serviceName, String deploymentName, String virtualMachineName);
    
    /**
    * The Download RDP file operation retrieves the Remote Desktop Protocol
    * configuration file from the specified virtual machine.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157183.aspx for
    * more information)
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of your deployment.
    * @param virtualMachineName Required. The name of the virtual machine.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The Download RDP file operation response.
    */
    VirtualMachineGetRemoteDesktopFileResponse getRemoteDesktopFile(String serviceName, String deploymentName, String virtualMachineName) throws IOException, ServiceException;
    
    /**
    * The Download RDP file operation retrieves the Remote Desktop Protocol
    * configuration file from the specified virtual machine.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157183.aspx for
    * more information)
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of your deployment.
    * @param virtualMachineName Required. The name of the virtual machine.
    * @return The Download RDP file operation response.
    */
    Future<VirtualMachineGetRemoteDesktopFileResponse> getRemoteDesktopFileAsync(String serviceName, String deploymentName, String virtualMachineName);
    
    /**
    * The Restart role operation restarts the specified virtual machine.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157197.aspx for
    * more information)
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of your deployment.
    * @param virtualMachineName Required. The name of the virtual machine to
    * restart.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    OperationStatusResponse restart(String serviceName, String deploymentName, String virtualMachineName) throws InterruptedException, ExecutionException, ServiceException, IOException;
    
    /**
    * The Restart role operation restarts the specified virtual machine.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157197.aspx for
    * more information)
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of your deployment.
    * @param virtualMachineName Required. The name of the virtual machine to
    * restart.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    Future<OperationStatusResponse> restartAsync(String serviceName, String deploymentName, String virtualMachineName);
    
    /**
    * The Shutdown Role operation shuts down the specified virtual machine.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/jj157195.aspx
    * for more information)
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of your deployment.
    * @param virtualMachineName Required. The name of the virtual machine to
    * shutdown.
    * @param parameters Required. The parameters for the shutdown virtual
    * machine operation.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    OperationStatusResponse shutdown(String serviceName, String deploymentName, String virtualMachineName, VirtualMachineShutdownParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException;
    
    /**
    * The Shutdown Role operation shuts down the specified virtual machine.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/jj157195.aspx
    * for more information)
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of your deployment.
    * @param virtualMachineName Required. The name of the virtual machine to
    * shutdown.
    * @param parameters Required. The parameters for the shutdown virtual
    * machine operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    Future<OperationStatusResponse> shutdownAsync(String serviceName, String deploymentName, String virtualMachineName, VirtualMachineShutdownParameters parameters);
    
    /**
    * The Shutdown Roles operation stops the specified set of virtual machines.
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of your deployment.
    * @param parameters Required. Parameters to pass to the Shutdown Roles
    * operation.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    OperationStatusResponse shutdownRoles(String serviceName, String deploymentName, VirtualMachineShutdownRolesParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException;
    
    /**
    * The Shutdown Roles operation stops the specified set of virtual machines.
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of your deployment.
    * @param parameters Required. Parameters to pass to the Shutdown Roles
    * operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    Future<OperationStatusResponse> shutdownRolesAsync(String serviceName, String deploymentName, VirtualMachineShutdownRolesParameters parameters);
    
    /**
    * The Start Role operation starts the specified virtual machine.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157189.aspx for
    * more information)
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of your deployment.
    * @param virtualMachineName Required. The name of the virtual machine to
    * start.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    OperationStatusResponse start(String serviceName, String deploymentName, String virtualMachineName) throws InterruptedException, ExecutionException, ServiceException, IOException;
    
    /**
    * The Start Role operation starts the specified virtual machine.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157189.aspx for
    * more information)
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of your deployment.
    * @param virtualMachineName Required. The name of the virtual machine to
    * start.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    Future<OperationStatusResponse> startAsync(String serviceName, String deploymentName, String virtualMachineName);
    
    /**
    * The Start Roles operation starts the specified set of virtual machines.
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of your deployment.
    * @param parameters Required. Parameters to pass to the Start Roles
    * operation.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    OperationStatusResponse startRoles(String serviceName, String deploymentName, VirtualMachineStartRolesParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException;
    
    /**
    * The Start Roles operation starts the specified set of virtual machines.
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of your deployment.
    * @param parameters Required. Parameters to pass to the Start Roles
    * operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    Future<OperationStatusResponse> startRolesAsync(String serviceName, String deploymentName, VirtualMachineStartRolesParameters parameters);
    
    /**
    * The Update Role operation adds a virtual machine to an existing
    * deployment.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157187.aspx for
    * more information)
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of your deployment.
    * @param virtualMachineName Required. The name of your virtual machine.
    * @param parameters Required. Parameters supplied to the Update Virtual
    * Machine operation.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    OperationStatusResponse update(String serviceName, String deploymentName, String virtualMachineName, VirtualMachineUpdateParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException, ParserConfigurationException, SAXException, TransformerException, URISyntaxException;
    
    /**
    * The Update Role operation adds a virtual machine to an existing
    * deployment.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157187.aspx for
    * more information)
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of your deployment.
    * @param virtualMachineName Required. The name of your virtual machine.
    * @param parameters Required. Parameters supplied to the Update Virtual
    * Machine operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    Future<OperationStatusResponse> updateAsync(String serviceName, String deploymentName, String virtualMachineName, VirtualMachineUpdateParameters parameters);
    
    /**
    * The Update Load Balanced Endpoint Set operation changes the specified
    * load-balanced InputEndpoints on all the roles of an Infrastructure as a
    * Service deployment. Non-load-balanced endpoints must be changed using
    * UpdateRole.
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of your deployment.
    * @param parameters Required. Parameters supplied to the Update Load
    * Balanced Endpoint Set operation.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    OperationStatusResponse updateLoadBalancedEndpointSet(String serviceName, String deploymentName, VirtualMachineUpdateLoadBalancedSetParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException;
    
    /**
    * The Update Load Balanced Endpoint Set operation changes the specified
    * load-balanced InputEndpoints on all the roles of an Infrastructure as a
    * Service deployment. Non-load-balanced endpoints must be changed using
    * UpdateRole.
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of your deployment.
    * @param parameters Required. Parameters supplied to the Update Load
    * Balanced Endpoint Set operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    Future<OperationStatusResponse> updateLoadBalancedEndpointSetAsync(String serviceName, String deploymentName, VirtualMachineUpdateLoadBalancedSetParameters parameters);
}
