/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.compute.models;

/**
* Contains the name and content of component.
*/
public class ComponentSetting {
    private String content;
    
    /**
    * Optional. Specifies the base-64 encoded XML formatted content that is
    * added to the unattend.xml file for the specified path and component. The
    * XML must be less that 4 KB and must include the root element for the
    * setting or feature that is being inserted.
    * @return The Content value.
    */
    public String getContent() {
        return this.content;
    }
    
    /**
    * Optional. Specifies the base-64 encoded XML formatted content that is
    * added to the unattend.xml file for the specified path and component. The
    * XML must be less that 4 KB and must include the root element for the
    * setting or feature that is being inserted.
    * @param contentValue The Content value.
    */
    public void setContent(final String contentValue) {
        this.content = contentValue;
    }
    
    private String settingName;
    
    /**
    * Required. Specifies the name of the setting to which the content applies.
    * @return The SettingName value.
    */
    public String getSettingName() {
        return this.settingName;
    }
    
    /**
    * Required. Specifies the name of the setting to which the content applies.
    * @param settingNameValue The SettingName value.
    */
    public void setSettingName(final String settingNameValue) {
        this.settingName = settingNameValue;
    }
    
    /**
    * Initializes a new instance of the ComponentSetting class.
    *
    */
    public ComponentSetting() {
    }
    
    /**
    * Initializes a new instance of the ComponentSetting class with required
    * arguments.
    *
    * @param settingName Specifies the name of the setting to which the content
    * applies.
    */
    public ComponentSetting(String settingName) {
        if (settingName == null) {
            throw new NullPointerException("settingName");
        }
        this.setSettingName(settingName);
    }
}
