/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.compute.models;

import com.microsoft.windowsazure.core.LazyArrayList;

import java.util.ArrayList;

/**
* Objects that provide system or application data.
*/
public class ConfigurationSet {
    private AdditionalUnattendContentSettings additionalUnattendContent;
    
    /**
    * Optional. Specifies additional base-64 encoded XML formatted information
    * that can be included in the Unattend.xml file, which is used by Windows
    * Setup.
    * @return The AdditionalUnattendContent value.
    */
    public AdditionalUnattendContentSettings getAdditionalUnattendContent() {
        return this.additionalUnattendContent;
    }
    
    /**
    * Optional. Specifies additional base-64 encoded XML formatted information
    * that can be included in the Unattend.xml file, which is used by Windows
    * Setup.
    * @param additionalUnattendContentValue The AdditionalUnattendContent value.
    */
    public void setAdditionalUnattendContent(final AdditionalUnattendContentSettings additionalUnattendContentValue) {
        this.additionalUnattendContent = additionalUnattendContentValue;
    }
    
    private String adminPassword;
    
    /**
    * Optional. Specifies the string representing the administrator password to
    * use for the virtual machine. If the VM will be created from a
    * 'Specialized' VM image, the password is not required.
    * @return The AdminPassword value.
    */
    public String getAdminPassword() {
        return this.adminPassword;
    }
    
    /**
    * Optional. Specifies the string representing the administrator password to
    * use for the virtual machine. If the VM will be created from a
    * 'Specialized' VM image, the password is not required.
    * @param adminPasswordValue The AdminPassword value.
    */
    public void setAdminPassword(final String adminPasswordValue) {
        this.adminPassword = adminPasswordValue;
    }
    
    private String adminUserName;
    
    /**
    * Optional. Specifies the name that is used to rename the default
    * administrator account. If the VM will be created from a 'Specialized' VM
    * image, the user name is not required.
    * @return The AdminUserName value.
    */
    public String getAdminUserName() {
        return this.adminUserName;
    }
    
    /**
    * Optional. Specifies the name that is used to rename the default
    * administrator account. If the VM will be created from a 'Specialized' VM
    * image, the user name is not required.
    * @param adminUserNameValue The AdminUserName value.
    */
    public void setAdminUserName(final String adminUserNameValue) {
        this.adminUserName = adminUserNameValue;
    }
    
    private String computerName;
    
    /**
    * Optional. Specifies the computer name for the virtual machine. If the
    * computer name is not specified, a name is created based on the name of
    * the role. Computer names must be 1 to 15 characters in length. This
    * element is only used with the WindowsProvisioningConfiguration set.
    * @return The ComputerName value.
    */
    public String getComputerName() {
        return this.computerName;
    }
    
    /**
    * Optional. Specifies the computer name for the virtual machine. If the
    * computer name is not specified, a name is created based on the name of
    * the role. Computer names must be 1 to 15 characters in length. This
    * element is only used with the WindowsProvisioningConfiguration set.
    * @param computerNameValue The ComputerName value.
    */
    public void setComputerName(final String computerNameValue) {
        this.computerName = computerNameValue;
    }
    
    private String configurationSetType;
    
    /**
    * Optional. Specifies the configuration type for the configuration set.
    * @return The ConfigurationSetType value.
    */
    public String getConfigurationSetType() {
        return this.configurationSetType;
    }
    
    /**
    * Optional. Specifies the configuration type for the configuration set.
    * @param configurationSetTypeValue The ConfigurationSetType value.
    */
    public void setConfigurationSetType(final String configurationSetTypeValue) {
        this.configurationSetType = configurationSetTypeValue;
    }
    
    private String customData;
    
    /**
    * Optional. Optional. Provides base64 encoded custom data to be passed to
    * VM.
    * @return The CustomData value.
    */
    public String getCustomData() {
        return this.customData;
    }
    
    /**
    * Optional. Optional. Provides base64 encoded custom data to be passed to
    * VM.
    * @param customDataValue The CustomData value.
    */
    public void setCustomData(final String customDataValue) {
        this.customData = customDataValue;
    }
    
    private Boolean disableSshPasswordAuthentication;
    
    /**
    * Optional. Specifies whether or not SSH authentication is disabled for the
    * password. This element is only used with the
    * LinuxProvisioningConfiguration set. By default this value is set to true.
    * @return The DisableSshPasswordAuthentication value.
    */
    public Boolean isDisableSshPasswordAuthentication() {
        return this.disableSshPasswordAuthentication;
    }
    
    /**
    * Optional. Specifies whether or not SSH authentication is disabled for the
    * password. This element is only used with the
    * LinuxProvisioningConfiguration set. By default this value is set to true.
    * @param disableSshPasswordAuthenticationValue The
    * DisableSshPasswordAuthentication value.
    */
    public void setDisableSshPasswordAuthentication(final Boolean disableSshPasswordAuthenticationValue) {
        this.disableSshPasswordAuthentication = disableSshPasswordAuthenticationValue;
    }
    
    private DomainJoinSettings domainJoin;
    
    /**
    * Optional. Contains properties that specify a domain to which the virtual
    * machine will be joined. This element is only used with the
    * WindowsProvisioningConfiguration set.
    * @return The DomainJoin value.
    */
    public DomainJoinSettings getDomainJoin() {
        return this.domainJoin;
    }
    
    /**
    * Optional. Contains properties that specify a domain to which the virtual
    * machine will be joined. This element is only used with the
    * WindowsProvisioningConfiguration set.
    * @param domainJoinValue The DomainJoin value.
    */
    public void setDomainJoin(final DomainJoinSettings domainJoinValue) {
        this.domainJoin = domainJoinValue;
    }
    
    private Boolean enableAutomaticUpdates;
    
    /**
    * Optional. Specifies whether automatic updates are enabled for the virtual
    * machine. This element is only used with the
    * WindowsProvisioningConfiguration set. The default value is false.
    * @return The EnableAutomaticUpdates value.
    */
    public Boolean isEnableAutomaticUpdates() {
        return this.enableAutomaticUpdates;
    }
    
    /**
    * Optional. Specifies whether automatic updates are enabled for the virtual
    * machine. This element is only used with the
    * WindowsProvisioningConfiguration set. The default value is false.
    * @param enableAutomaticUpdatesValue The EnableAutomaticUpdates value.
    */
    public void setEnableAutomaticUpdates(final Boolean enableAutomaticUpdatesValue) {
        this.enableAutomaticUpdates = enableAutomaticUpdatesValue;
    }
    
    private String hostName;
    
    /**
    * Optional. Specifies the host name for the VM. Host names are ASCII
    * character strings 1 to 64 characters in length. This element is only
    * used with the LinuxProvisioningConfiguration set.
    * @return The HostName value.
    */
    public String getHostName() {
        return this.hostName;
    }
    
    /**
    * Optional. Specifies the host name for the VM. Host names are ASCII
    * character strings 1 to 64 characters in length. This element is only
    * used with the LinuxProvisioningConfiguration set.
    * @param hostNameValue The HostName value.
    */
    public void setHostName(final String hostNameValue) {
        this.hostName = hostNameValue;
    }
    
    private ArrayList<InputEndpoint> inputEndpoints;
    
    /**
    * Optional. Contains a collection of external endpoints for the virtual
    * machine. This element is only used with the NetworkConfigurationSet type.
    * @return The InputEndpoints value.
    */
    public ArrayList<InputEndpoint> getInputEndpoints() {
        return this.inputEndpoints;
    }
    
    /**
    * Optional. Contains a collection of external endpoints for the virtual
    * machine. This element is only used with the NetworkConfigurationSet type.
    * @param inputEndpointsValue The InputEndpoints value.
    */
    public void setInputEndpoints(final ArrayList<InputEndpoint> inputEndpointsValue) {
        this.inputEndpoints = inputEndpointsValue;
    }
    
    private String iPForwarding;
    
    /**
    * Optional. Gets or sets the IP Forwarding status for this role. Optional
    * @return The IPForwarding value.
    */
    public String getIPForwarding() {
        return this.iPForwarding;
    }
    
    /**
    * Optional. Gets or sets the IP Forwarding status for this role. Optional
    * @param iPForwardingValue The IPForwarding value.
    */
    public void setIPForwarding(final String iPForwardingValue) {
        this.iPForwarding = iPForwardingValue;
    }
    
    private ArrayList<NetworkInterface> networkInterfaces;
    
    /**
    * Optional.
    * @return The NetworkInterfaces value.
    */
    public ArrayList<NetworkInterface> getNetworkInterfaces() {
        return this.networkInterfaces;
    }
    
    /**
    * Optional.
    * @param networkInterfacesValue The NetworkInterfaces value.
    */
    public void setNetworkInterfaces(final ArrayList<NetworkInterface> networkInterfacesValue) {
        this.networkInterfaces = networkInterfacesValue;
    }
    
    private String networkSecurityGroup;
    
    /**
    * Optional. Gets or sets the Network Security Group associated with this
    * role. Optional
    * @return The NetworkSecurityGroup value.
    */
    public String getNetworkSecurityGroup() {
        return this.networkSecurityGroup;
    }
    
    /**
    * Optional. Gets or sets the Network Security Group associated with this
    * role. Optional
    * @param networkSecurityGroupValue The NetworkSecurityGroup value.
    */
    public void setNetworkSecurityGroup(final String networkSecurityGroupValue) {
        this.networkSecurityGroup = networkSecurityGroupValue;
    }
    
    private ArrayList<ConfigurationSet.PublicIP> publicIPs;
    
    /**
    * Optional. Optional. A set of public IPs. Currently, only one additional
    * public IP per role is supported in an IaaS deployment. The IP address is
    * in addition to the default VIP for the deployment.
    * @return The PublicIPs value.
    */
    public ArrayList<ConfigurationSet.PublicIP> getPublicIPs() {
        return this.publicIPs;
    }
    
    /**
    * Optional. Optional. A set of public IPs. Currently, only one additional
    * public IP per role is supported in an IaaS deployment. The IP address is
    * in addition to the default VIP for the deployment.
    * @param publicIPsValue The PublicIPs value.
    */
    public void setPublicIPs(final ArrayList<ConfigurationSet.PublicIP> publicIPsValue) {
        this.publicIPs = publicIPsValue;
    }
    
    private Boolean resetPasswordOnFirstLogon;
    
    /**
    * Optional. Specifies whether password should be reset the first time the
    * administrator logs in.
    * @return The ResetPasswordOnFirstLogon value.
    */
    public Boolean isResetPasswordOnFirstLogon() {
        return this.resetPasswordOnFirstLogon;
    }
    
    /**
    * Optional. Specifies whether password should be reset the first time the
    * administrator logs in.
    * @param resetPasswordOnFirstLogonValue The ResetPasswordOnFirstLogon value.
    */
    public void setResetPasswordOnFirstLogon(final Boolean resetPasswordOnFirstLogonValue) {
        this.resetPasswordOnFirstLogon = resetPasswordOnFirstLogonValue;
    }
    
    private SshSettings sshSettings;
    
    /**
    * Optional. Specifies the SSH public keys and key pairs to populate in the
    * image during provisioning. This element is only used with the
    * LinuxProvisioningConfiguration set.
    * @return The SshSettings value.
    */
    public SshSettings getSshSettings() {
        return this.sshSettings;
    }
    
    /**
    * Optional. Specifies the SSH public keys and key pairs to populate in the
    * image during provisioning. This element is only used with the
    * LinuxProvisioningConfiguration set.
    * @param sshSettingsValue The SshSettings value.
    */
    public void setSshSettings(final SshSettings sshSettingsValue) {
        this.sshSettings = sshSettingsValue;
    }
    
    private String staticVirtualNetworkIPAddress;
    
    /**
    * Optional. Specifies a Customer Address, i.e. an IP address assigned to a
    * VM in a VNet's SubNet. For example: 10.0.0.4.
    * @return The StaticVirtualNetworkIPAddress value.
    */
    public String getStaticVirtualNetworkIPAddress() {
        return this.staticVirtualNetworkIPAddress;
    }
    
    /**
    * Optional. Specifies a Customer Address, i.e. an IP address assigned to a
    * VM in a VNet's SubNet. For example: 10.0.0.4.
    * @param staticVirtualNetworkIPAddressValue The
    * StaticVirtualNetworkIPAddress value.
    */
    public void setStaticVirtualNetworkIPAddress(final String staticVirtualNetworkIPAddressValue) {
        this.staticVirtualNetworkIPAddress = staticVirtualNetworkIPAddressValue;
    }
    
    private ArrayList<StoredCertificateSettings> storedCertificateSettings;
    
    /**
    * Optional. Contains a list of service certificates with which to provision
    * to the new role. This element is only used with the
    * WindowsProvisioningConfiguration set.
    * @return The StoredCertificateSettings value.
    */
    public ArrayList<StoredCertificateSettings> getStoredCertificateSettings() {
        return this.storedCertificateSettings;
    }
    
    /**
    * Optional. Contains a list of service certificates with which to provision
    * to the new role. This element is only used with the
    * WindowsProvisioningConfiguration set.
    * @param storedCertificateSettingsValue The StoredCertificateSettings value.
    */
    public void setStoredCertificateSettings(final ArrayList<StoredCertificateSettings> storedCertificateSettingsValue) {
        this.storedCertificateSettings = storedCertificateSettingsValue;
    }
    
    private ArrayList<String> subnetNames;
    
    /**
    * Optional. The list of Virtual Network subnet names that the deployment
    * belongs to. This element is only used with the NetworkConfigurationSet
    * type.
    * @return The SubnetNames value.
    */
    public ArrayList<String> getSubnetNames() {
        return this.subnetNames;
    }
    
    /**
    * Optional. The list of Virtual Network subnet names that the deployment
    * belongs to. This element is only used with the NetworkConfigurationSet
    * type.
    * @param subnetNamesValue The SubnetNames value.
    */
    public void setSubnetNames(final ArrayList<String> subnetNamesValue) {
        this.subnetNames = subnetNamesValue;
    }
    
    private String timeZone;
    
    /**
    * Optional. Specifies the time zone for the virtual machine. This element
    * is only used with the WindowsProvisioningConfiguration set. For a
    * complete list of supported time zone entries, you can refer to the
    * values listed in the registry entry
    * HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows
    * NT\\CurrentVersion\\Time Zones on a computer running Windows 7, Windows
    * Server 2008, and Windows Server 2008 R2 or you can use the tzutil
    * command-line tool to list the valid time. The tzutil tool is installed
    * by default on Windows 7, Windows Server 2008, and Windows Server 2008 R2.
    * @return The TimeZone value.
    */
    public String getTimeZone() {
        return this.timeZone;
    }
    
    /**
    * Optional. Specifies the time zone for the virtual machine. This element
    * is only used with the WindowsProvisioningConfiguration set. For a
    * complete list of supported time zone entries, you can refer to the
    * values listed in the registry entry
    * HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows
    * NT\\CurrentVersion\\Time Zones on a computer running Windows 7, Windows
    * Server 2008, and Windows Server 2008 R2 or you can use the tzutil
    * command-line tool to list the valid time. The tzutil tool is installed
    * by default on Windows 7, Windows Server 2008, and Windows Server 2008 R2.
    * @param timeZoneValue The TimeZone value.
    */
    public void setTimeZone(final String timeZoneValue) {
        this.timeZone = timeZoneValue;
    }
    
    private String userName;
    
    /**
    * Optional. Specifies the name of a user to be created in the sudoer group
    * of the virtual machine. User names are ASCII character strings 1 to 32
    * characters in length. This element is only used with the
    * LinuxProvisioningConfiguration set.
    * @return The UserName value.
    */
    public String getUserName() {
        return this.userName;
    }
    
    /**
    * Optional. Specifies the name of a user to be created in the sudoer group
    * of the virtual machine. User names are ASCII character strings 1 to 32
    * characters in length. This element is only used with the
    * LinuxProvisioningConfiguration set.
    * @param userNameValue The UserName value.
    */
    public void setUserName(final String userNameValue) {
        this.userName = userNameValue;
    }
    
    private String userPassword;
    
    /**
    * Optional. Specifies the password for user name. Passwords are ASCII
    * character strings 6 to 72 characters in length. This element is only
    * used with the LinuxProvisioningConfiguration set.
    * @return The UserPassword value.
    */
    public String getUserPassword() {
        return this.userPassword;
    }
    
    /**
    * Optional. Specifies the password for user name. Passwords are ASCII
    * character strings 6 to 72 characters in length. This element is only
    * used with the LinuxProvisioningConfiguration set.
    * @param userPasswordValue The UserPassword value.
    */
    public void setUserPassword(final String userPasswordValue) {
        this.userPassword = userPasswordValue;
    }
    
    private WindowsRemoteManagementSettings windowsRemoteManagement;
    
    /**
    * Optional. Configures the Windows Remote Management service on the virtual
    * machine, which enables remote Windows PowerShell.
    * @return The WindowsRemoteManagement value.
    */
    public WindowsRemoteManagementSettings getWindowsRemoteManagement() {
        return this.windowsRemoteManagement;
    }
    
    /**
    * Optional. Configures the Windows Remote Management service on the virtual
    * machine, which enables remote Windows PowerShell.
    * @param windowsRemoteManagementValue The WindowsRemoteManagement value.
    */
    public void setWindowsRemoteManagement(final WindowsRemoteManagementSettings windowsRemoteManagementValue) {
        this.windowsRemoteManagement = windowsRemoteManagementValue;
    }
    
    /**
    * Initializes a new instance of the ConfigurationSet class.
    *
    */
    public ConfigurationSet() {
        this.setInputEndpoints(new LazyArrayList<InputEndpoint>());
        this.setNetworkInterfaces(new LazyArrayList<NetworkInterface>());
        this.setPublicIPs(new LazyArrayList<ConfigurationSet.PublicIP>());
        this.setStoredCertificateSettings(new LazyArrayList<StoredCertificateSettings>());
        this.setSubnetNames(new LazyArrayList<String>());
    }
    
    /**
    * An additional public IP that will be created for the role. The public IP
    * will be an additional IP for the role. The role continues to be
    * addressable via the default deployment VIP.
    */
    public static class PublicIP {
        private String domainNameLabel;
        
        /**
        * Optional. The DNS name of the public IP.
        * @return The DomainNameLabel value.
        */
        public String getDomainNameLabel() {
            return this.domainNameLabel;
        }
        
        /**
        * Optional. The DNS name of the public IP.
        * @param domainNameLabelValue The DomainNameLabel value.
        */
        public void setDomainNameLabel(final String domainNameLabelValue) {
            this.domainNameLabel = domainNameLabelValue;
        }
        
        private Integer idleTimeoutInMinutes;
        
        /**
        * Optional. The idle timeout in minutes for this Public IP.
        * @return The IdleTimeoutInMinutes value.
        */
        public Integer getIdleTimeoutInMinutes() {
            return this.idleTimeoutInMinutes;
        }
        
        /**
        * Optional. The idle timeout in minutes for this Public IP.
        * @param idleTimeoutInMinutesValue The IdleTimeoutInMinutes value.
        */
        public void setIdleTimeoutInMinutes(final Integer idleTimeoutInMinutesValue) {
            this.idleTimeoutInMinutes = idleTimeoutInMinutesValue;
        }
        
        private String name;
        
        /**
        * Optional. The name of the public IP.
        * @return The Name value.
        */
        public String getName() {
            return this.name;
        }
        
        /**
        * Optional. The name of the public IP.
        * @param nameValue The Name value.
        */
        public void setName(final String nameValue) {
            this.name = nameValue;
        }
    }
}
