/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.compute.models;

import java.net.URI;

/**
* Objects that are used to create a data disk for a virtual machine.
*/
public class DataVirtualHardDisk {
    private String hostCaching;
    
    /**
    * Optional. Specifies the platform caching behavior of the data disk blob
    * for read/write efficiency. The default value is ReadOnly.
    * @return The HostCaching value.
    */
    public String getHostCaching() {
        return this.hostCaching;
    }
    
    /**
    * Optional. Specifies the platform caching behavior of the data disk blob
    * for read/write efficiency. The default value is ReadOnly.
    * @param hostCachingValue The HostCaching value.
    */
    public void setHostCaching(final String hostCachingValue) {
        this.hostCaching = hostCachingValue;
    }
    
    private String iOType;
    
    /**
    * Optional. Gets or sets the IO type.
    * @return The IOType value.
    */
    public String getIOType() {
        return this.iOType;
    }
    
    /**
    * Optional. Gets or sets the IO type.
    * @param iOTypeValue The IOType value.
    */
    public void setIOType(final String iOTypeValue) {
        this.iOType = iOTypeValue;
    }
    
    private String label;
    
    /**
    * Optional. Specifies the friendly name of the VHD used to create the data
    * disk for the virtual machine.
    * @return The Label value.
    */
    public String getLabel() {
        return this.label;
    }
    
    /**
    * Optional. Specifies the friendly name of the VHD used to create the data
    * disk for the virtual machine.
    * @param labelValue The Label value.
    */
    public void setLabel(final String labelValue) {
        this.label = labelValue;
    }
    
    private Integer logicalDiskSizeInGB;
    
    /**
    * Optional. Specifies the size, in GB, of an empty VHD to be attached to
    * the virtual machine. The VHD can be created as part of an attached disk
    * or created as a virtual machine call by specifying the value for this
    * property. Azure creates the empty VHD based on the size preference and
    * attaches the newly created VHD to the virtual machine.
    * @return The LogicalDiskSizeInGB value.
    */
    public Integer getLogicalDiskSizeInGB() {
        return this.logicalDiskSizeInGB;
    }
    
    /**
    * Optional. Specifies the size, in GB, of an empty VHD to be attached to
    * the virtual machine. The VHD can be created as part of an attached disk
    * or created as a virtual machine call by specifying the value for this
    * property. Azure creates the empty VHD based on the size preference and
    * attaches the newly created VHD to the virtual machine.
    * @param logicalDiskSizeInGBValue The LogicalDiskSizeInGB value.
    */
    public void setLogicalDiskSizeInGB(final Integer logicalDiskSizeInGBValue) {
        this.logicalDiskSizeInGB = logicalDiskSizeInGBValue;
    }
    
    private Integer logicalUnitNumber;
    
    /**
    * Optional. Specifies the Logical Unit Number (LUN) for the data disk. The
    * LUN specifies the slot in which the data drive appears when mounted for
    * usage by the virtual machine. This element is only listed when more than
    * one data disk is attached to a virtual machine.
    * @return The LogicalUnitNumber value.
    */
    public Integer getLogicalUnitNumber() {
        return this.logicalUnitNumber;
    }
    
    /**
    * Optional. Specifies the Logical Unit Number (LUN) for the data disk. The
    * LUN specifies the slot in which the data drive appears when mounted for
    * usage by the virtual machine. This element is only listed when more than
    * one data disk is attached to a virtual machine.
    * @param logicalUnitNumberValue The LogicalUnitNumber value.
    */
    public void setLogicalUnitNumber(final Integer logicalUnitNumberValue) {
        this.logicalUnitNumber = logicalUnitNumberValue;
    }
    
    private URI mediaLink;
    
    /**
    * Optional. Optional. If the disk that is being added is already registered
    * in the subscription or the VHD for the disk already exists in blob
    * storage, this element is ignored. If a VHD file does not exist in blob
    * storage, this element defines the location of the new VHD that is
    * created when the new disk is added.Example:
    * http://example.blob.core.windows.net/disks/mydatadisk.vhd
    * @return The MediaLink value.
    */
    public URI getMediaLink() {
        return this.mediaLink;
    }
    
    /**
    * Optional. Optional. If the disk that is being added is already registered
    * in the subscription or the VHD for the disk already exists in blob
    * storage, this element is ignored. If a VHD file does not exist in blob
    * storage, this element defines the location of the new VHD that is
    * created when the new disk is added.Example:
    * http://example.blob.core.windows.net/disks/mydatadisk.vhd
    * @param mediaLinkValue The MediaLink value.
    */
    public void setMediaLink(final URI mediaLinkValue) {
        this.mediaLink = mediaLinkValue;
    }
    
    private String name;
    
    /**
    * Optional. Specifies the name of the VHD used to create the data disk for
    * the virtual machine.
    * @return The Name value.
    */
    public String getName() {
        return this.name;
    }
    
    /**
    * Optional. Specifies the name of the VHD used to create the data disk for
    * the virtual machine.
    * @param nameValue The Name value.
    */
    public void setName(final String nameValue) {
        this.name = nameValue;
    }
    
    private URI sourceMediaLink;
    
    /**
    * Optional. Optional. If the disk that is being added is already registered
    * in the subscription or the VHD for the disk does not exist in blob
    * storage, this element is ignored. If the VHD file exists in blob
    * storage, this element defines the path to the VHD and a disk is
    * registered from it and attached to the virtual machine.
    * @return The SourceMediaLink value.
    */
    public URI getSourceMediaLink() {
        return this.sourceMediaLink;
    }
    
    /**
    * Optional. Optional. If the disk that is being added is already registered
    * in the subscription or the VHD for the disk does not exist in blob
    * storage, this element is ignored. If the VHD file exists in blob
    * storage, this element defines the path to the VHD and a disk is
    * registered from it and attached to the virtual machine.
    * @param sourceMediaLinkValue The SourceMediaLink value.
    */
    public void setSourceMediaLink(final URI sourceMediaLinkValue) {
        this.sourceMediaLink = sourceMediaLinkValue;
    }
}
