/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.compute.models;

import com.microsoft.windowsazure.core.LazyHashMap;

import java.util.HashMap;

/**
* Parameters supplied to the Change Configuration Deployment operation.
*/
public class DeploymentChangeConfigurationParameters {
    private String configuration;
    
    /**
    * Required. The encoded service configuration file for the deployment.
    * @return The Configuration value.
    */
    public String getConfiguration() {
        return this.configuration;
    }
    
    /**
    * Required. The encoded service configuration file for the deployment.
    * @param configurationValue The Configuration value.
    */
    public void setConfiguration(final String configurationValue) {
        this.configuration = configurationValue;
    }
    
    private HashMap<String, String> extendedProperties;
    
    /**
    * Optional. Represents the name of an extended deployment property. Each
    * extended property must have a defined name and a value. You can have a
    * maximum of 25 extended property name/value pairs. The maximum length of
    * the name element is 64 characters, only alphanumeric characters and
    * underscores are valid in the name, and the name must start with a
    * letter. Attempting to use other characters, starting the name with a
    * non-letter character, or entering a name that is identical to that of
    * another extended property owned by the same hosted service will result
    * in a status code 400 (Bad Request) error.
    * @return The ExtendedProperties value.
    */
    public HashMap<String, String> getExtendedProperties() {
        return this.extendedProperties;
    }
    
    /**
    * Optional. Represents the name of an extended deployment property. Each
    * extended property must have a defined name and a value. You can have a
    * maximum of 25 extended property name/value pairs. The maximum length of
    * the name element is 64 characters, only alphanumeric characters and
    * underscores are valid in the name, and the name must start with a
    * letter. Attempting to use other characters, starting the name with a
    * non-letter character, or entering a name that is identical to that of
    * another extended property owned by the same hosted service will result
    * in a status code 400 (Bad Request) error.
    * @param extendedPropertiesValue The ExtendedProperties value.
    */
    public void setExtendedProperties(final HashMap<String, String> extendedPropertiesValue) {
        this.extendedProperties = extendedPropertiesValue;
    }
    
    private ExtensionConfiguration extensionConfiguration;
    
    /**
    * Optional. Represents an extension that is added to the cloud service. In
    * Azure, a process can run as an extension of a cloud service. For
    * example, Remote Desktop Access or the Azure Diagnostics Agent can run as
    * extensions to the cloud service. You must add an extension to the cloud
    * service by using Add Extension before it can be added to the deployment.
    * @return The ExtensionConfiguration value.
    */
    public ExtensionConfiguration getExtensionConfiguration() {
        return this.extensionConfiguration;
    }
    
    /**
    * Optional. Represents an extension that is added to the cloud service. In
    * Azure, a process can run as an extension of a cloud service. For
    * example, Remote Desktop Access or the Azure Diagnostics Agent can run as
    * extensions to the cloud service. You must add an extension to the cloud
    * service by using Add Extension before it can be added to the deployment.
    * @param extensionConfigurationValue The ExtensionConfiguration value.
    */
    public void setExtensionConfiguration(final ExtensionConfiguration extensionConfigurationValue) {
        this.extensionConfiguration = extensionConfigurationValue;
    }
    
    private DeploymentChangeConfigurationMode mode;
    
    /**
    * Optional. The Change Configuration Deployment mode. Possible values are:
    * Auto and Manual. If not specified, the default value is Auto. If set to
    * Manual, WalkUpgradeDomain must be called to apply the update. If set to
    * Auto, the update is automatically applied to each update domain for the
    * service.
    * @return The Mode value.
    */
    public DeploymentChangeConfigurationMode getMode() {
        return this.mode;
    }
    
    /**
    * Optional. The Change Configuration Deployment mode. Possible values are:
    * Auto and Manual. If not specified, the default value is Auto. If set to
    * Manual, WalkUpgradeDomain must be called to apply the update. If set to
    * Auto, the update is automatically applied to each update domain for the
    * service.
    * @param modeValue The Mode value.
    */
    public void setMode(final DeploymentChangeConfigurationMode modeValue) {
        this.mode = modeValue;
    }
    
    private Boolean treatWarningsAsError;
    
    /**
    * Optional. Indicates whether to treat package validation warnings as
    * errors. The default value is false. If set to true, the Created
    * Deployment operation fails if there are validation warnings on the
    * service package.
    * @return The TreatWarningsAsError value.
    */
    public Boolean isTreatWarningsAsError() {
        return this.treatWarningsAsError;
    }
    
    /**
    * Optional. Indicates whether to treat package validation warnings as
    * errors. The default value is false. If set to true, the Created
    * Deployment operation fails if there are validation warnings on the
    * service package.
    * @param treatWarningsAsErrorValue The TreatWarningsAsError value.
    */
    public void setTreatWarningsAsError(final Boolean treatWarningsAsErrorValue) {
        this.treatWarningsAsError = treatWarningsAsErrorValue;
    }
    
    /**
    * Initializes a new instance of the DeploymentChangeConfigurationParameters
    * class.
    *
    */
    public DeploymentChangeConfigurationParameters() {
        this.setExtendedProperties(new LazyHashMap<String, String>());
    }
    
    /**
    * Initializes a new instance of the DeploymentChangeConfigurationParameters
    * class with required arguments.
    *
    * @param configuration The encoded service configuration file for the
    * deployment.
    */
    public DeploymentChangeConfigurationParameters(String configuration) {
        this();
        if (configuration == null) {
            throw new NullPointerException("configuration");
        }
        this.setConfiguration(configuration);
    }
}
