/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.compute.models;

import com.microsoft.windowsazure.core.LazyHashMap;

import java.util.HashMap;

/**
* Parameters supplied to the Create Hosted Service operation.
*/
public class HostedServiceCreateParameters {
    private String affinityGroup;
    
    /**
    * Optional. The name of an existing affinity group associated with this
    * subscription. Required if Location is not specified. This name is a GUID
    * and can be retrieved by examining the name element of the response body
    * returned by the List Affinity Groups operation. Specify either Location
    * or AffinityGroup, but not both. To list available affinity groups, use
    * the List Affinity Groups operation.
    * @return The AffinityGroup value.
    */
    public String getAffinityGroup() {
        return this.affinityGroup;
    }
    
    /**
    * Optional. The name of an existing affinity group associated with this
    * subscription. Required if Location is not specified. This name is a GUID
    * and can be retrieved by examining the name element of the response body
    * returned by the List Affinity Groups operation. Specify either Location
    * or AffinityGroup, but not both. To list available affinity groups, use
    * the List Affinity Groups operation.
    * @param affinityGroupValue The AffinityGroup value.
    */
    public void setAffinityGroup(final String affinityGroupValue) {
        this.affinityGroup = affinityGroupValue;
    }
    
    private String description;
    
    /**
    * Optional. A description for the cloud service. The description can be up
    * to 1024 characters in length.
    * @return The Description value.
    */
    public String getDescription() {
        return this.description;
    }
    
    /**
    * Optional. A description for the cloud service. The description can be up
    * to 1024 characters in length.
    * @param descriptionValue The Description value.
    */
    public void setDescription(final String descriptionValue) {
        this.description = descriptionValue;
    }
    
    private HashMap<String, String> extendedProperties;
    
    /**
    * Optional. Represents the name of an extended cloud service property. Each
    * extended property must have a defined name and a value. You can have a
    * maximum of 50 extended property name and value pairs. The maximum length
    * of the name element is 64 characters, only alphanumeric characters and
    * underscores are valid in the name, and it must start with a letter.
    * Attempting to use other characters, starting with a non-letter
    * character, or entering a name that is identical to that of another
    * extended property owned by the same service will result in a status code
    * 400 (Bad Request) error. Each extended property value has a maximum
    * length of 255 characters.
    * @return The ExtendedProperties value.
    */
    public HashMap<String, String> getExtendedProperties() {
        return this.extendedProperties;
    }
    
    /**
    * Optional. Represents the name of an extended cloud service property. Each
    * extended property must have a defined name and a value. You can have a
    * maximum of 50 extended property name and value pairs. The maximum length
    * of the name element is 64 characters, only alphanumeric characters and
    * underscores are valid in the name, and it must start with a letter.
    * Attempting to use other characters, starting with a non-letter
    * character, or entering a name that is identical to that of another
    * extended property owned by the same service will result in a status code
    * 400 (Bad Request) error. Each extended property value has a maximum
    * length of 255 characters.
    * @param extendedPropertiesValue The ExtendedProperties value.
    */
    public void setExtendedProperties(final HashMap<String, String> extendedPropertiesValue) {
        this.extendedProperties = extendedPropertiesValue;
    }
    
    private String label;
    
    /**
    * Required. A name for the cloud service. The name can be up to 100
    * characters in length. The name can be used to identify the storage
    * account for your tracking purposes.
    * @return The Label value.
    */
    public String getLabel() {
        if (this.label == null) {
            return this.getServiceName();
        } else {
            return this.label;
        }
    }
    
    /**
    * Required. A name for the cloud service. The name can be up to 100
    * characters in length. The name can be used to identify the storage
    * account for your tracking purposes.
    * @param labelValue The Label value.
    */
    public void setLabel(final String labelValue) {
        this.label = labelValue;
    }
    
    private String location;
    
    /**
    * Optional. The location where the cloud service will be created. Required
    * if AffinityGroup is not specified. Specify either Location or
    * AffinityGroup, but not both. To list available locations, use the List
    * Locations operation.
    * @return The Location value.
    */
    public String getLocation() {
        return this.location;
    }
    
    /**
    * Optional. The location where the cloud service will be created. Required
    * if AffinityGroup is not specified. Specify either Location or
    * AffinityGroup, but not both. To list available locations, use the List
    * Locations operation.
    * @param locationValue The Location value.
    */
    public void setLocation(final String locationValue) {
        this.location = locationValue;
    }
    
    private String reverseDnsFqdn;
    
    /**
    * Optional. Dns address to which the cloud service's IP address resolves
    * when queried using a reverse Dns query.
    * @return The ReverseDnsFqdn value.
    */
    public String getReverseDnsFqdn() {
        return this.reverseDnsFqdn;
    }
    
    /**
    * Optional. Dns address to which the cloud service's IP address resolves
    * when queried using a reverse Dns query.
    * @param reverseDnsFqdnValue The ReverseDnsFqdn value.
    */
    public void setReverseDnsFqdn(final String reverseDnsFqdnValue) {
        this.reverseDnsFqdn = reverseDnsFqdnValue;
    }
    
    private String serviceName;
    
    /**
    * Required. A name for the cloud service that is unique within Azure. This
    * name is the DNS prefix name and can be used to access the service.
    * @return The ServiceName value.
    */
    public String getServiceName() {
        return this.serviceName;
    }
    
    /**
    * Required. A name for the cloud service that is unique within Azure. This
    * name is the DNS prefix name and can be used to access the service.
    * @param serviceNameValue The ServiceName value.
    */
    public void setServiceName(final String serviceNameValue) {
        this.serviceName = serviceNameValue;
    }
    
    /**
    * Initializes a new instance of the HostedServiceCreateParameters class.
    *
    */
    public HostedServiceCreateParameters() {
        this.setExtendedProperties(new LazyHashMap<String, String>());
    }
    
    /**
    * Initializes a new instance of the HostedServiceCreateParameters class
    * with required arguments.
    *
    * @param serviceName A name for the cloud service that is unique within
    * Azure. This name is the DNS prefix name and can be used to access the
    * service.
    * @param label A name for the cloud service. The name can be up to 100
    * characters in length. The name can be used to identify the storage
    * account for your tracking purposes.
    */
    public HostedServiceCreateParameters(String serviceName, String label) {
        this();
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (label == null) {
            throw new NullPointerException("label");
        }
        this.setServiceName(serviceName);
        this.setLabel(label);
    }
}
