/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.compute.models;

import com.microsoft.windowsazure.core.LazyHashMap;

import java.util.Calendar;
import java.util.HashMap;

/**
* The properties that are assigned to the cloud service.
*/
public class HostedServiceProperties {
    private String affinityGroup;
    
    /**
    * Optional. The affinity group with which this cloud service is associated,
    * if any. If the service is associated with an affinity group, the
    * Location element is not returned.
    * @return The AffinityGroup value.
    */
    public String getAffinityGroup() {
        return this.affinityGroup;
    }
    
    /**
    * Optional. The affinity group with which this cloud service is associated,
    * if any. If the service is associated with an affinity group, the
    * Location element is not returned.
    * @param affinityGroupValue The AffinityGroup value.
    */
    public void setAffinityGroup(final String affinityGroupValue) {
        this.affinityGroup = affinityGroupValue;
    }
    
    private Calendar dateCreated;
    
    /**
    * Optional. The date that the cloud service was created, in
    * [4DigitYear]-[2DigitMonth]-[2DigitDay]T[2DigitHour]:[2DigitMinute]:[2DigitSecond]Z
    * format. The date 2011-05-11T16:15:26Z is an example that could be
    * returned by the DateCreated or DateLastModified elements.
    * @return The DateCreated value.
    */
    public Calendar getDateCreated() {
        return this.dateCreated;
    }
    
    /**
    * Optional. The date that the cloud service was created, in
    * [4DigitYear]-[2DigitMonth]-[2DigitDay]T[2DigitHour]:[2DigitMinute]:[2DigitSecond]Z
    * format. The date 2011-05-11T16:15:26Z is an example that could be
    * returned by the DateCreated or DateLastModified elements.
    * @param dateCreatedValue The DateCreated value.
    */
    public void setDateCreated(final Calendar dateCreatedValue) {
        this.dateCreated = dateCreatedValue;
    }
    
    private Calendar dateLastModified;
    
    /**
    * Optional. The date that the cloud service was last updated, in
    * [4DigitYear]-[2DigitMonth]-[2DigitDay]T[2DigitHour]:[2DigitMinute]:[2DigitSecond]Z
    * format. The date 2011-05-11T16:15:26Z is an example that could be
    * returned by the DateCreated or DateLastModified elements.
    * @return The DateLastModified value.
    */
    public Calendar getDateLastModified() {
        return this.dateLastModified;
    }
    
    /**
    * Optional. The date that the cloud service was last updated, in
    * [4DigitYear]-[2DigitMonth]-[2DigitDay]T[2DigitHour]:[2DigitMinute]:[2DigitSecond]Z
    * format. The date 2011-05-11T16:15:26Z is an example that could be
    * returned by the DateCreated or DateLastModified elements.
    * @param dateLastModifiedValue The DateLastModified value.
    */
    public void setDateLastModified(final Calendar dateLastModifiedValue) {
        this.dateLastModified = dateLastModifiedValue;
    }
    
    private String description;
    
    /**
    * Optional. The description for the cloud service.
    * @return The Description value.
    */
    public String getDescription() {
        return this.description;
    }
    
    /**
    * Optional. The description for the cloud service.
    * @param descriptionValue The Description value.
    */
    public void setDescription(final String descriptionValue) {
        this.description = descriptionValue;
    }
    
    private HashMap<String, String> extendedProperties;
    
    /**
    * Optional. Represents the name of an extended cloud service property. Each
    * extended property must have a defined name and a value. You can have a
    * maximum of 50 extended property name and value pairs. The maximum length
    * of the name element is 64 characters, only alphanumeric characters and
    * underscores are valid in the name, and it must start with a letter.
    * Attempting to use other characters, starting with a non-letter
    * character, or entering a name that is identical to that of another
    * extended property owned by the same service will result in a status code
    * 400 (Bad Request) error. Each extended property value has a maximum
    * length of 255 characters.
    * @return The ExtendedProperties value.
    */
    public HashMap<String, String> getExtendedProperties() {
        return this.extendedProperties;
    }
    
    /**
    * Optional. Represents the name of an extended cloud service property. Each
    * extended property must have a defined name and a value. You can have a
    * maximum of 50 extended property name and value pairs. The maximum length
    * of the name element is 64 characters, only alphanumeric characters and
    * underscores are valid in the name, and it must start with a letter.
    * Attempting to use other characters, starting with a non-letter
    * character, or entering a name that is identical to that of another
    * extended property owned by the same service will result in a status code
    * 400 (Bad Request) error. Each extended property value has a maximum
    * length of 255 characters.
    * @param extendedPropertiesValue The ExtendedProperties value.
    */
    public void setExtendedProperties(final HashMap<String, String> extendedPropertiesValue) {
        this.extendedProperties = extendedPropertiesValue;
    }
    
    private String label;
    
    /**
    * Optional. The user-supplied name of the cloud service. This name can be
    * used identify the service for your tracking purposes.
    * @return The Label value.
    */
    public String getLabel() {
        return this.label;
    }
    
    /**
    * Optional. The user-supplied name of the cloud service. This name can be
    * used identify the service for your tracking purposes.
    * @param labelValue The Label value.
    */
    public void setLabel(final String labelValue) {
        this.label = labelValue;
    }
    
    private String location;
    
    /**
    * Optional. The geo-location of the cloud service in Windows Azure, if the
    * service is not associated with an affinity group. If a location has been
    * specified, the AffinityGroup element is not returned.
    * @return The Location value.
    */
    public String getLocation() {
        return this.location;
    }
    
    /**
    * Optional. The geo-location of the cloud service in Windows Azure, if the
    * service is not associated with an affinity group. If a location has been
    * specified, the AffinityGroup element is not returned.
    * @param locationValue The Location value.
    */
    public void setLocation(final String locationValue) {
        this.location = locationValue;
    }
    
    private String reverseDnsFqdn;
    
    /**
    * Optional. Dns address to which the cloud service's IP address resolves
    * when queried using a reverse Dns query.
    * @return The ReverseDnsFqdn value.
    */
    public String getReverseDnsFqdn() {
        return this.reverseDnsFqdn;
    }
    
    /**
    * Optional. Dns address to which the cloud service's IP address resolves
    * when queried using a reverse Dns query.
    * @param reverseDnsFqdnValue The ReverseDnsFqdn value.
    */
    public void setReverseDnsFqdn(final String reverseDnsFqdnValue) {
        this.reverseDnsFqdn = reverseDnsFqdnValue;
    }
    
    private HostedServiceStatus status;
    
    /**
    * Optional. The status of the cloud service.
    * @return The Status value.
    */
    public HostedServiceStatus getStatus() {
        return this.status;
    }
    
    /**
    * Optional. The status of the cloud service.
    * @param statusValue The Status value.
    */
    public void setStatus(final HostedServiceStatus statusValue) {
        this.status = statusValue;
    }
    
    /**
    * Initializes a new instance of the HostedServiceProperties class.
    *
    */
    public HostedServiceProperties() {
        this.setExtendedProperties(new LazyHashMap<String, String>());
    }
}
