/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.compute.models;

/**
* The market place image attributes.
*/
public class MarketplaceImageAttributes {
    private Plan plan;
    
    /**
    * Required. Gets or sets the purchase context of any 3rd party artifact.
    * @return The Plan value.
    */
    public Plan getPlan() {
        return this.plan;
    }
    
    /**
    * Required. Gets or sets the purchase context of any 3rd party artifact.
    * @param planValue The Plan value.
    */
    public void setPlan(final Plan planValue) {
        this.plan = planValue;
    }
    
    private String publisherId;
    
    /**
    * Required. Gets or sets the publisher Id. This is the Microsoft.Compute
    * Provider publisher name to use for image.
    * @return The PublisherId value.
    */
    public String getPublisherId() {
        return this.publisherId;
    }
    
    /**
    * Required. Gets or sets the publisher Id. This is the Microsoft.Compute
    * Provider publisher name to use for image.
    * @param publisherIdValue The PublisherId value.
    */
    public void setPublisherId(final String publisherIdValue) {
        this.publisherId = publisherIdValue;
    }
    
    /**
    * Initializes a new instance of the MarketplaceImageAttributes class.
    *
    */
    public MarketplaceImageAttributes() {
    }
    
    /**
    * Initializes a new instance of the MarketplaceImageAttributes class with
    * required arguments.
    *
    * @param publisherId Gets or sets the publisher Id. This is the
    * Microsoft.Compute Provider publisher name to use for image.
    * @param plan Gets or sets the purchase context of any 3rd party artifact.
    */
    public MarketplaceImageAttributes(String publisherId, Plan plan) {
        if (publisherId == null) {
            throw new NullPointerException("publisherId");
        }
        if (plan == null) {
            throw new NullPointerException("plan");
        }
        this.setPublisherId(publisherId);
        this.setPlan(plan);
    }
}
