/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.compute.models;

import java.net.URI;

/**
* The OS disk configuration.
*/
public class OSDiskConfigurationCreateParameters {
    private String hostCaching;
    
    /**
    * Optional. Gets or sets the platform caching behavior of the operating
    * system disk blob for read/write efficiency.
    * @return The HostCaching value.
    */
    public String getHostCaching() {
        return this.hostCaching;
    }
    
    /**
    * Optional. Gets or sets the platform caching behavior of the operating
    * system disk blob for read/write efficiency.
    * @param hostCachingValue The HostCaching value.
    */
    public void setHostCaching(final String hostCachingValue) {
        this.hostCaching = hostCachingValue;
    }
    
    private URI mediaLink;
    
    /**
    * Required. Gets or sets the location of the blob in Windows Azure storage.
    * The blob location belongs to a storage account in the subscription
    * specified by the <subscription-id> value in the operation call.
    * @return The MediaLink value.
    */
    public URI getMediaLink() {
        return this.mediaLink;
    }
    
    /**
    * Required. Gets or sets the location of the blob in Windows Azure storage.
    * The blob location belongs to a storage account in the subscription
    * specified by the <subscription-id> value in the operation call.
    * @param mediaLinkValue The MediaLink value.
    */
    public void setMediaLink(final URI mediaLinkValue) {
        this.mediaLink = mediaLinkValue;
    }
    
    private String os;
    
    /**
    * Required. Gets or sets the operating system in the image.
    * @return The OS value.
    */
    public String getOS() {
        return this.os;
    }
    
    /**
    * Required. Gets or sets the operating system in the image.
    * @param oSValue The OS value.
    */
    public void setOS(final String oSValue) {
        this.os = oSValue;
    }
    
    private String oSState;
    
    /**
    * Required. Gets or sets the state of the operating system in the image.
    * @return The OSState value.
    */
    public String getOSState() {
        return this.oSState;
    }
    
    /**
    * Required. Gets or sets the state of the operating system in the image.
    * @param oSStateValue The OSState value.
    */
    public void setOSState(final String oSStateValue) {
        this.oSState = oSStateValue;
    }
    
    /**
    * Initializes a new instance of the OSDiskConfigurationCreateParameters
    * class.
    *
    */
    public OSDiskConfigurationCreateParameters() {
    }
    
    /**
    * Initializes a new instance of the OSDiskConfigurationCreateParameters
    * class with required arguments.
    *
    * @param oSState Gets or sets the state of the operating system in the
    * image.
    * @param os Gets or sets the operating system in the image.
    * @param mediaLink Gets or sets the location of the blob in Windows Azure
    * storage. The blob location belongs to a storage account in the
    * subscription specified by the <subscription-id> value in the operation
    * call.
    */
    public OSDiskConfigurationCreateParameters(String oSState, String os, URI mediaLink) {
        if (oSState == null) {
            throw new NullPointerException("oSState");
        }
        if (os == null) {
            throw new NullPointerException("os");
        }
        if (mediaLink == null) {
            throw new NullPointerException("mediaLink");
        }
        this.setOSState(oSState);
        this.setOS(os);
        this.setMediaLink(mediaLink);
    }
}
