/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.compute.models;

import com.microsoft.windowsazure.core.LazyArrayList;
import com.microsoft.windowsazure.core.OperationResponse;

import java.util.ArrayList;
import java.util.Iterator;

/**
* The List Operating System Families operation response.
*/
public class OperatingSystemListFamiliesResponse extends OperationResponse implements Iterable<OperatingSystemListFamiliesResponse.OperatingSystemFamily> {
    private ArrayList<OperatingSystemListFamiliesResponse.OperatingSystemFamily> operatingSystemFamilies;
    
    /**
    * Optional. The operating system families that are valid for your
    * subscription.
    * @return The OperatingSystemFamilies value.
    */
    public ArrayList<OperatingSystemListFamiliesResponse.OperatingSystemFamily> getOperatingSystemFamilies() {
        return this.operatingSystemFamilies;
    }
    
    /**
    * Optional. The operating system families that are valid for your
    * subscription.
    * @param operatingSystemFamiliesValue The OperatingSystemFamilies value.
    */
    public void setOperatingSystemFamilies(final ArrayList<OperatingSystemListFamiliesResponse.OperatingSystemFamily> operatingSystemFamiliesValue) {
        this.operatingSystemFamilies = operatingSystemFamiliesValue;
    }
    
    /**
    * Initializes a new instance of the OperatingSystemListFamiliesResponse
    * class.
    *
    */
    public OperatingSystemListFamiliesResponse() {
        super();
        this.setOperatingSystemFamilies(new LazyArrayList<OperatingSystemListFamiliesResponse.OperatingSystemFamily>());
    }
    
    /**
    * Gets the sequence of OperatingSystemFamilies.
    *
    */
    public Iterator<OperatingSystemListFamiliesResponse.OperatingSystemFamily> iterator() {
        return this.getOperatingSystemFamilies().iterator();
    }
    
    /**
    * An operating system that is valid for your subscription.
    */
    public static class OperatingSystem {
        private boolean isActive;
        
        /**
        * Optional. Indicates whether this operating system version is
        * currently active for running a service. If an operating system
        * version is active, you can manually configure your service to run on
        * that version. An operating system version may be inactive for one of
        * two reasons: 1. It is not yet active as it is in the process of
        * being rolled out to Azure data centers. If your service is
        * configured to use auto-upgrade, it will be upgraded to the new
        * operating system version during the rollout. If you are manually
        * configuring your operating system version, you can upgrade to the
        * latest version once it becomes active. 2. It is no longer supported
        * for running a service. In this case you will either need to manually
        * configure your service to run on a newer version, or configure your
        * service to use auto-upgrade to manage operating system upgrades.
        * @return The IsActive value.
        */
        public boolean isActive() {
            return this.isActive;
        }
        
        /**
        * Optional. Indicates whether this operating system version is
        * currently active for running a service. If an operating system
        * version is active, you can manually configure your service to run on
        * that version. An operating system version may be inactive for one of
        * two reasons: 1. It is not yet active as it is in the process of
        * being rolled out to Azure data centers. If your service is
        * configured to use auto-upgrade, it will be upgraded to the new
        * operating system version during the rollout. If you are manually
        * configuring your operating system version, you can upgrade to the
        * latest version once it becomes active. 2. It is no longer supported
        * for running a service. In this case you will either need to manually
        * configure your service to run on a newer version, or configure your
        * service to use auto-upgrade to manage operating system upgrades.
        * @param isActiveValue The IsActive value.
        */
        public void setIsActive(final boolean isActiveValue) {
            this.isActive = isActiveValue;
        }
        
        private boolean isDefault;
        
        /**
        * Optional. Indicates whether this operating system version is the
        * default version for a service that has not otherwise specified a
        * particular version. The default operating system version is applied
        * to services that are configured for auto-upgrade. An operating
        * system family has exactly one default operating system version at
        * any given time, for which the IsDefault element is set to true; for
        * all other versions, IsDefault is set to false.
        * @return The IsDefault value.
        */
        public boolean isDefault() {
            return this.isDefault;
        }
        
        /**
        * Optional. Indicates whether this operating system version is the
        * default version for a service that has not otherwise specified a
        * particular version. The default operating system version is applied
        * to services that are configured for auto-upgrade. An operating
        * system family has exactly one default operating system version at
        * any given time, for which the IsDefault element is set to true; for
        * all other versions, IsDefault is set to false.
        * @param isDefaultValue The IsDefault value.
        */
        public void setIsDefault(final boolean isDefaultValue) {
            this.isDefault = isDefaultValue;
        }
        
        private String label;
        
        /**
        * Optional. The label of the operating system version.
        * @return The Label value.
        */
        public String getLabel() {
            return this.label;
        }
        
        /**
        * Optional. The label of the operating system version.
        * @param labelValue The Label value.
        */
        public void setLabel(final String labelValue) {
            this.label = labelValue;
        }
        
        private String version;
        
        /**
        * Optional. The operating system version. This value corresponds to the
        * configuration value for specifying that your service is to run on a
        * particular version of the Azure guest operating system. See
        * Configuring Settings for the Windows Azure Guest OS for additional
        * details.
        * @return The Version value.
        */
        public String getVersion() {
            return this.version;
        }
        
        /**
        * Optional. The operating system version. This value corresponds to the
        * configuration value for specifying that your service is to run on a
        * particular version of the Azure guest operating system. See
        * Configuring Settings for the Windows Azure Guest OS for additional
        * details.
        * @param versionValue The Version value.
        */
        public void setVersion(final String versionValue) {
            this.version = versionValue;
        }
    }
    
    /**
    * An operating system family that is valid for your subscription.
    */
    public static class OperatingSystemFamily {
        private String label;
        
        /**
        * Optional. The label of the operating system family.
        * @return The Label value.
        */
        public String getLabel() {
            return this.label;
        }
        
        /**
        * Optional. The label of the operating system family.
        * @param labelValue The Label value.
        */
        public void setLabel(final String labelValue) {
            this.label = labelValue;
        }
        
        private int name;
        
        /**
        * Optional. Indicates which operating system family this version
        * belongs to. A value of 1 corresponds to the Azure guest operating
        * system that is substantially compatible with Windows Server 2008
        * SP2. A value of 2 corresponds to the Azure guest operating system
        * that is substantially compatible with Windows Server 2008 R2.
        * @return The Name value.
        */
        public int getName() {
            return this.name;
        }
        
        /**
        * Optional. Indicates which operating system family this version
        * belongs to. A value of 1 corresponds to the Azure guest operating
        * system that is substantially compatible with Windows Server 2008
        * SP2. A value of 2 corresponds to the Azure guest operating system
        * that is substantially compatible with Windows Server 2008 R2.
        * @param nameValue The Name value.
        */
        public void setName(final int nameValue) {
            this.name = nameValue;
        }
        
        private ArrayList<OperatingSystemListFamiliesResponse.OperatingSystem> operatingSystems;
        
        /**
        * Optional. The available operating systems in your subscription
        * belonging to this family.
        * @return The OperatingSystems value.
        */
        public ArrayList<OperatingSystemListFamiliesResponse.OperatingSystem> getOperatingSystems() {
            return this.operatingSystems;
        }
        
        /**
        * Optional. The available operating systems in your subscription
        * belonging to this family.
        * @param operatingSystemsValue The OperatingSystems value.
        */
        public void setOperatingSystems(final ArrayList<OperatingSystemListFamiliesResponse.OperatingSystem> operatingSystemsValue) {
            this.operatingSystems = operatingSystemsValue;
        }
        
        /**
        * Initializes a new instance of the OperatingSystemFamily class.
        *
        */
        public OperatingSystemFamily() {
            this.setOperatingSystems(new LazyArrayList<OperatingSystemListFamiliesResponse.OperatingSystem>());
        }
    }
}
