/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.compute.models;

/**
* Parameters supplied to the Create Service Certificate operation.
*/
public class ServiceCertificateCreateParameters {
    private CertificateFormat certificateFormat;
    
    /**
    * Required. The service certificate format. Azure supports the pfx and cer
    * file formats.
    * @return The CertificateFormat value.
    */
    public CertificateFormat getCertificateFormat() {
        return this.certificateFormat;
    }
    
    /**
    * Required. The service certificate format. Azure supports the pfx and cer
    * file formats.
    * @param certificateFormatValue The CertificateFormat value.
    */
    public void setCertificateFormat(final CertificateFormat certificateFormatValue) {
        this.certificateFormat = certificateFormatValue;
    }
    
    private byte[] data;
    
    /**
    * Required. The pfx or cer file.
    * @return The Data value.
    */
    public byte[] getData() {
        return this.data;
    }
    
    /**
    * Required. The pfx or cer file.
    * @param dataValue The Data value.
    */
    public void setData(final byte[] dataValue) {
        this.data = dataValue;
    }
    
    private String password;
    
    /**
    * Optional. The password for a pfx certificate. A cer certificate does not
    * require a password.
    * @return The Password value.
    */
    public String getPassword() {
        return this.password;
    }
    
    /**
    * Optional. The password for a pfx certificate. A cer certificate does not
    * require a password.
    * @param passwordValue The Password value.
    */
    public void setPassword(final String passwordValue) {
        this.password = passwordValue;
    }
    
    /**
    * Initializes a new instance of the ServiceCertificateCreateParameters
    * class.
    *
    */
    public ServiceCertificateCreateParameters() {
    }
    
    /**
    * Initializes a new instance of the ServiceCertificateCreateParameters
    * class with required arguments.
    *
    * @param data The pfx or cer file.
    * @param certificateFormat The service certificate format. Azure supports
    * the pfx and cer file formats.
    */
    public ServiceCertificateCreateParameters(byte[] data, CertificateFormat certificateFormat) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        if (certificateFormat == null) {
            throw new NullPointerException("certificateFormat");
        }
        this.setData(data);
        this.setCertificateFormat(certificateFormat);
    }
}
