/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.compute.models;

import com.microsoft.windowsazure.core.LazyArrayList;

import java.util.ArrayList;

/**
* Contains the unattend component.
*/
public class UnattendComponent {
    private String componentName;
    
    /**
    * Required. Specifies the name of the component to configure with the added
    * content.
    * @return The ComponentName value.
    */
    public String getComponentName() {
        return this.componentName;
    }
    
    /**
    * Required. Specifies the name of the component to configure with the added
    * content.
    * @param componentNameValue The ComponentName value.
    */
    public void setComponentName(final String componentNameValue) {
        this.componentName = componentNameValue;
    }
    
    private ArrayList<ComponentSetting> unattendComponentSettings;
    
    /**
    * Optional. Specifies component settings.
    * @return The UnattendComponentSettings value.
    */
    public ArrayList<ComponentSetting> getUnattendComponentSettings() {
        return this.unattendComponentSettings;
    }
    
    /**
    * Optional. Specifies component settings.
    * @param unattendComponentSettingsValue The UnattendComponentSettings value.
    */
    public void setUnattendComponentSettings(final ArrayList<ComponentSetting> unattendComponentSettingsValue) {
        this.unattendComponentSettings = unattendComponentSettingsValue;
    }
    
    /**
    * Initializes a new instance of the UnattendComponent class.
    *
    */
    public UnattendComponent() {
        this.setUnattendComponentSettings(new LazyArrayList<ComponentSetting>());
    }
    
    /**
    * Initializes a new instance of the UnattendComponent class with required
    * arguments.
    *
    * @param componentName Specifies the name of the component to configure
    * with the added content.
    */
    public UnattendComponent(String componentName) {
        this();
        if (componentName == null) {
            throw new NullPointerException("componentName");
        }
        this.setComponentName(componentName);
    }
}
