/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.compute.models;

import com.microsoft.windowsazure.core.LazyArrayList;

import java.util.ArrayList;

/**
* Contains unattend pass.
*/
public class UnattendPassSettings {
    private String passName;
    
    /**
    * Required. Specifies the name of the pass that the content applies to.
    * @return The PassName value.
    */
    public String getPassName() {
        return this.passName;
    }
    
    /**
    * Required. Specifies the name of the pass that the content applies to.
    * @param passNameValue The PassName value.
    */
    public void setPassName(final String passNameValue) {
        this.passName = passNameValue;
    }
    
    private ArrayList<UnattendComponent> unattendComponents;
    
    /**
    * Optional. Specifies unattend components.
    * @return The UnattendComponents value.
    */
    public ArrayList<UnattendComponent> getUnattendComponents() {
        return this.unattendComponents;
    }
    
    /**
    * Optional. Specifies unattend components.
    * @param unattendComponentsValue The UnattendComponents value.
    */
    public void setUnattendComponents(final ArrayList<UnattendComponent> unattendComponentsValue) {
        this.unattendComponents = unattendComponentsValue;
    }
    
    /**
    * Initializes a new instance of the UnattendPassSettings class.
    *
    */
    public UnattendPassSettings() {
        this.setUnattendComponents(new LazyArrayList<UnattendComponent>());
    }
    
    /**
    * Initializes a new instance of the UnattendPassSettings class with
    * required arguments.
    *
    * @param passName Specifies the name of the pass that the content applies
    * to.
    */
    public UnattendPassSettings(String passName) {
        this();
        if (passName == null) {
            throw new NullPointerException("passName");
        }
        this.setPassName(passName);
    }
}
