/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.compute.models;

/**
* Contains upgrade details of the deployment.
*/
public class UpgradeStatus {
    private int currentUpgradeDomain;
    
    /**
    * Optional. An integer value that identifies the current upgrade domain.
    * Upgrade domains are identified with a zero-based index: the first
    * upgrade domain has an ID of 0, the second has an ID of 1, and so on.
    * @return The CurrentUpgradeDomain value.
    */
    public int getCurrentUpgradeDomain() {
        return this.currentUpgradeDomain;
    }
    
    /**
    * Optional. An integer value that identifies the current upgrade domain.
    * Upgrade domains are identified with a zero-based index: the first
    * upgrade domain has an ID of 0, the second has an ID of 1, and so on.
    * @param currentUpgradeDomainValue The CurrentUpgradeDomain value.
    */
    public void setCurrentUpgradeDomain(final int currentUpgradeDomainValue) {
        this.currentUpgradeDomain = currentUpgradeDomainValue;
    }
    
    private UpgradeDomainState currentUpgradeDomainState;
    
    /**
    * Optional. The current state of the upgrade. Possible values are Before
    * and During
    * @return The CurrentUpgradeDomainState value.
    */
    public UpgradeDomainState getCurrentUpgradeDomainState() {
        return this.currentUpgradeDomainState;
    }
    
    /**
    * Optional. The current state of the upgrade. Possible values are Before
    * and During
    * @param currentUpgradeDomainStateValue The CurrentUpgradeDomainState value.
    */
    public void setCurrentUpgradeDomainState(final UpgradeDomainState currentUpgradeDomainStateValue) {
        this.currentUpgradeDomainState = currentUpgradeDomainStateValue;
    }
    
    private DeploymentUpgradeType upgradeType;
    
    /**
    * Optional. The type of the upgrade. Possible values are Auto and Manual.
    * @return The UpgradeType value.
    */
    public DeploymentUpgradeType getUpgradeType() {
        return this.upgradeType;
    }
    
    /**
    * Optional. The type of the upgrade. Possible values are Auto and Manual.
    * @param upgradeTypeValue The UpgradeType value.
    */
    public void setUpgradeType(final DeploymentUpgradeType upgradeTypeValue) {
        this.upgradeType = upgradeTypeValue;
    }
}
