/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.compute.models;

import com.microsoft.windowsazure.core.LazyArrayList;

import java.util.ArrayList;

/**
* Parameters supplied to the Create Virtual Machine Deployment operation.
*/
public class VirtualMachineCreateDeploymentParameters {
    private DeploymentSlot deploymentSlot;
    
    /**
    * Required. Specifies the environment in which to deploy the virtual
    * machine. Possible values are: Staging or Production.
    * @return The DeploymentSlot value.
    */
    public DeploymentSlot getDeploymentSlot() {
        return this.deploymentSlot;
    }
    
    /**
    * Required. Specifies the environment in which to deploy the virtual
    * machine. Possible values are: Staging or Production.
    * @param deploymentSlotValue The DeploymentSlot value.
    */
    public void setDeploymentSlot(final DeploymentSlot deploymentSlotValue) {
        this.deploymentSlot = deploymentSlotValue;
    }
    
    private DnsSettings dnsSettings;
    
    /**
    * Optional. Contains a list of DNS servers to associate with the machine.
    * @return The DnsSettings value.
    */
    public DnsSettings getDnsSettings() {
        return this.dnsSettings;
    }
    
    /**
    * Optional. Contains a list of DNS servers to associate with the machine.
    * @param dnsSettingsValue The DnsSettings value.
    */
    public void setDnsSettings(final DnsSettings dnsSettingsValue) {
        this.dnsSettings = dnsSettingsValue;
    }
    
    private String label;
    
    /**
    * Required. A name for the hosted service. The name can be up to 100
    * characters in length. It is recommended that the label be unique within
    * the subscription. The name can be used identify the hosted service for
    * tracking purposes.
    * @return The Label value.
    */
    public String getLabel() {
        return this.label;
    }
    
    /**
    * Required. A name for the hosted service. The name can be up to 100
    * characters in length. It is recommended that the label be unique within
    * the subscription. The name can be used identify the hosted service for
    * tracking purposes.
    * @param labelValue The Label value.
    */
    public void setLabel(final String labelValue) {
        this.label = labelValue;
    }
    
    private ArrayList<LoadBalancer> loadBalancers;
    
    /**
    * Optional. A list of internal load balancers that each provide load
    * balancing on a private VIP.
    * @return The LoadBalancers value.
    */
    public ArrayList<LoadBalancer> getLoadBalancers() {
        return this.loadBalancers;
    }
    
    /**
    * Optional. A list of internal load balancers that each provide load
    * balancing on a private VIP.
    * @param loadBalancersValue The LoadBalancers value.
    */
    public void setLoadBalancers(final ArrayList<LoadBalancer> loadBalancersValue) {
        this.loadBalancers = loadBalancersValue;
    }
    
    private String name;
    
    /**
    * Required. A name for the deployment. The deployment name must be unique
    * among other deployments for the hosted service.
    * @return The Name value.
    */
    public String getName() {
        return this.name;
    }
    
    /**
    * Required. A name for the deployment. The deployment name must be unique
    * among other deployments for the hosted service.
    * @param nameValue The Name value.
    */
    public void setName(final String nameValue) {
        this.name = nameValue;
    }
    
    private String reservedIPName;
    
    /**
    * Optional. Optional. Specifies the name of an existing reserved IP to
    * which the deployment will belong. Reserved IPs are created by calling
    * the Create Reserved IP operation.
    * @return The ReservedIPName value.
    */
    public String getReservedIPName() {
        return this.reservedIPName;
    }
    
    /**
    * Optional. Optional. Specifies the name of an existing reserved IP to
    * which the deployment will belong. Reserved IPs are created by calling
    * the Create Reserved IP operation.
    * @param reservedIPNameValue The ReservedIPName value.
    */
    public void setReservedIPName(final String reservedIPNameValue) {
        this.reservedIPName = reservedIPNameValue;
    }
    
    private ArrayList<Role> roles;
    
    /**
    * Required. Contains the provisioning details for the new virtual machine
    * deployment.
    * @return The Roles value.
    */
    public ArrayList<Role> getRoles() {
        return this.roles;
    }
    
    /**
    * Required. Contains the provisioning details for the new virtual machine
    * deployment.
    * @param rolesValue The Roles value.
    */
    public void setRoles(final ArrayList<Role> rolesValue) {
        this.roles = rolesValue;
    }
    
    private String virtualNetworkName;
    
    /**
    * Optional. Specifies the name of an existing virtual network to which the
    * deployment will belong. Virtual networks are created by calling the Set
    * Network Configuration operation.
    * @return The VirtualNetworkName value.
    */
    public String getVirtualNetworkName() {
        return this.virtualNetworkName;
    }
    
    /**
    * Optional. Specifies the name of an existing virtual network to which the
    * deployment will belong. Virtual networks are created by calling the Set
    * Network Configuration operation.
    * @param virtualNetworkNameValue The VirtualNetworkName value.
    */
    public void setVirtualNetworkName(final String virtualNetworkNameValue) {
        this.virtualNetworkName = virtualNetworkNameValue;
    }
    
    /**
    * Initializes a new instance of the
    * VirtualMachineCreateDeploymentParameters class.
    *
    */
    public VirtualMachineCreateDeploymentParameters() {
        this.setLoadBalancers(new LazyArrayList<LoadBalancer>());
        this.setRoles(new LazyArrayList<Role>());
    }
}
