/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.compute.models;

import com.microsoft.windowsazure.core.OperationResponse;

import java.net.URI;

/**
* A virtual machine disk associated with your subscription.
*/
public class VirtualMachineDiskUpdateResponse extends OperationResponse {
    private String affinityGroup;
    
    /**
    * Optional. The affinity group in which the disk is located. The
    * AffinityGroup value is derived from storage account that contains the
    * blob in which the media is located. If the storage account does not
    * belong to an affinity group the value is NULL.
    * @return The AffinityGroup value.
    */
    public String getAffinityGroup() {
        return this.affinityGroup;
    }
    
    /**
    * Optional. The affinity group in which the disk is located. The
    * AffinityGroup value is derived from storage account that contains the
    * blob in which the media is located. If the storage account does not
    * belong to an affinity group the value is NULL.
    * @param affinityGroupValue The AffinityGroup value.
    */
    public void setAffinityGroup(final String affinityGroupValue) {
        this.affinityGroup = affinityGroupValue;
    }
    
    private String iOType;
    
    /**
    * Optional. Gets or sets the IO type.
    * @return The IOType value.
    */
    public String getIOType() {
        return this.iOType;
    }
    
    /**
    * Optional. Gets or sets the IO type.
    * @param iOTypeValue The IOType value.
    */
    public void setIOType(final String iOTypeValue) {
        this.iOType = iOTypeValue;
    }
    
    private Boolean isPremium;
    
    /**
    * Optional. Specifies whether the contained image is a premium image.
    * @return The IsPremium value.
    */
    public Boolean isPremium() {
        return this.isPremium;
    }
    
    /**
    * Optional. Specifies whether the contained image is a premium image.
    * @param isPremiumValue The IsPremium value.
    */
    public void setIsPremium(final Boolean isPremiumValue) {
        this.isPremium = isPremiumValue;
    }
    
    private String label;
    
    /**
    * Optional. The friendly name of the disk
    * @return The Label value.
    */
    public String getLabel() {
        return this.label;
    }
    
    /**
    * Optional. The friendly name of the disk
    * @param labelValue The Label value.
    */
    public void setLabel(final String labelValue) {
        this.label = labelValue;
    }
    
    private String location;
    
    /**
    * Optional. The geo-location in which the disk is located. The Location
    * value is derived from storage account that contains the blob in which
    * the disk is located. If the storage account belongs to an affinity group
    * the value is NULL.
    * @return The Location value.
    */
    public String getLocation() {
        return this.location;
    }
    
    /**
    * Optional. The geo-location in which the disk is located. The Location
    * value is derived from storage account that contains the blob in which
    * the disk is located. If the storage account belongs to an affinity group
    * the value is NULL.
    * @param locationValue The Location value.
    */
    public void setLocation(final String locationValue) {
        this.location = locationValue;
    }
    
    private int logicalSizeInGB;
    
    /**
    * Optional. The size, in GB, of the disk.
    * @return The LogicalSizeInGB value.
    */
    public int getLogicalSizeInGB() {
        return this.logicalSizeInGB;
    }
    
    /**
    * Optional. The size, in GB, of the disk.
    * @param logicalSizeInGBValue The LogicalSizeInGB value.
    */
    public void setLogicalSizeInGB(final int logicalSizeInGBValue) {
        this.logicalSizeInGB = logicalSizeInGBValue;
    }
    
    private URI mediaLinkUri;
    
    /**
    * Optional. The location of the blob in the blob store in which the media
    * for the disk is located. The blob location belongs to a storage account
    * in the subscription specified by the SubscriptionId value in the
    * operation call. Example:
    * http://example.blob.core.windows.net/disks/mydisk.vhd
    * @return The MediaLinkUri value.
    */
    public URI getMediaLinkUri() {
        return this.mediaLinkUri;
    }
    
    /**
    * Optional. The location of the blob in the blob store in which the media
    * for the disk is located. The blob location belongs to a storage account
    * in the subscription specified by the SubscriptionId value in the
    * operation call. Example:
    * http://example.blob.core.windows.net/disks/mydisk.vhd
    * @param mediaLinkUriValue The MediaLinkUri value.
    */
    public void setMediaLinkUri(final URI mediaLinkUriValue) {
        this.mediaLinkUri = mediaLinkUriValue;
    }
    
    private String name;
    
    /**
    * Optional. The name of the disk. This is the name that is used when
    * creating one or more virtual machines using the disk.
    * @return The Name value.
    */
    public String getName() {
        return this.name;
    }
    
    /**
    * Optional. The name of the disk. This is the name that is used when
    * creating one or more virtual machines using the disk.
    * @param nameValue The Name value.
    */
    public void setName(final String nameValue) {
        this.name = nameValue;
    }
    
    private String operatingSystem;
    
    /**
    * Optional. The Operating System type for the disk.
    * @return The OperatingSystem value.
    */
    public String getOperatingSystem() {
        return this.operatingSystem;
    }
    
    /**
    * Optional. The Operating System type for the disk.
    * @param operatingSystemValue The OperatingSystem value.
    */
    public void setOperatingSystem(final String operatingSystemValue) {
        this.operatingSystem = operatingSystemValue;
    }
}
