/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.compute.models;

import com.microsoft.windowsazure.core.LazyArrayList;

import java.util.ArrayList;

/**
* Parameters supplied to the Update Virtual Machine operation.
*/
public class VirtualMachineUpdateParameters {
    private String availabilitySetName;
    
    /**
    * Optional. Specifies the name of an availability set to which to add the
    * virtual machine. This value controls the virtual machine allocation in
    * the Azure environment. Virtual machines specified in the same
    * availability set are allocated to different nodes to maximize
    * availability.
    * @return The AvailabilitySetName value.
    */
    public String getAvailabilitySetName() {
        return this.availabilitySetName;
    }
    
    /**
    * Optional. Specifies the name of an availability set to which to add the
    * virtual machine. This value controls the virtual machine allocation in
    * the Azure environment. Virtual machines specified in the same
    * availability set are allocated to different nodes to maximize
    * availability.
    * @param availabilitySetNameValue The AvailabilitySetName value.
    */
    public void setAvailabilitySetName(final String availabilitySetNameValue) {
        this.availabilitySetName = availabilitySetNameValue;
    }
    
    private ArrayList<ConfigurationSet> configurationSets;
    
    /**
    * Optional. Contains the collection of configuration sets that contain
    * system and application configuration settings.
    * @return The ConfigurationSets value.
    */
    public ArrayList<ConfigurationSet> getConfigurationSets() {
        return this.configurationSets;
    }
    
    /**
    * Optional. Contains the collection of configuration sets that contain
    * system and application configuration settings.
    * @param configurationSetsValue The ConfigurationSets value.
    */
    public void setConfigurationSets(final ArrayList<ConfigurationSet> configurationSetsValue) {
        this.configurationSets = configurationSetsValue;
    }
    
    private ArrayList<DataVirtualHardDisk> dataVirtualHardDisks;
    
    /**
    * Optional. Contains the parameters Azure used to create the data disk for
    * the virtual machine.
    * @return The DataVirtualHardDisks value.
    */
    public ArrayList<DataVirtualHardDisk> getDataVirtualHardDisks() {
        return this.dataVirtualHardDisks;
    }
    
    /**
    * Optional. Contains the parameters Azure used to create the data disk for
    * the virtual machine.
    * @param dataVirtualHardDisksValue The DataVirtualHardDisks value.
    */
    public void setDataVirtualHardDisks(final ArrayList<DataVirtualHardDisk> dataVirtualHardDisksValue) {
        this.dataVirtualHardDisks = dataVirtualHardDisksValue;
    }
    
    private String label;
    
    /**
    * Optional. Specifies the friendly name for the virtual machine.
    * @return The Label value.
    */
    public String getLabel() {
        return this.label;
    }
    
    /**
    * Optional. Specifies the friendly name for the virtual machine.
    * @param labelValue The Label value.
    */
    public void setLabel(final String labelValue) {
        this.label = labelValue;
    }
    
    private OSVirtualHardDisk oSVirtualHardDisk;
    
    /**
    * Required. Contains the parameters Azure used to create the operating
    * system disk for the virtual machine.
    * @return The OSVirtualHardDisk value.
    */
    public OSVirtualHardDisk getOSVirtualHardDisk() {
        return this.oSVirtualHardDisk;
    }
    
    /**
    * Required. Contains the parameters Azure used to create the operating
    * system disk for the virtual machine.
    * @param oSVirtualHardDiskValue The OSVirtualHardDisk value.
    */
    public void setOSVirtualHardDisk(final OSVirtualHardDisk oSVirtualHardDiskValue) {
        this.oSVirtualHardDisk = oSVirtualHardDiskValue;
    }
    
    private Boolean provisionGuestAgent;
    
    /**
    * Optional. Indicates whether the WindowsAzureGuestAgent service is
    * installed on the Virtual Machine. To run a resource extension in a
    * Virtual Machine, this service must be installed.
    * @return The ProvisionGuestAgent value.
    */
    public Boolean isProvisionGuestAgent() {
        return this.provisionGuestAgent;
    }
    
    /**
    * Optional. Indicates whether the WindowsAzureGuestAgent service is
    * installed on the Virtual Machine. To run a resource extension in a
    * Virtual Machine, this service must be installed.
    * @param provisionGuestAgentValue The ProvisionGuestAgent value.
    */
    public void setProvisionGuestAgent(final Boolean provisionGuestAgentValue) {
        this.provisionGuestAgent = provisionGuestAgentValue;
    }
    
    private ArrayList<ResourceExtensionReference> resourceExtensionReferences;
    
    /**
    * Optional. Contains a collection of resource extensions that are to be
    * installed on the Virtual Machine. This element is used if
    * ProvisionGuestAgent is set to true.
    * @return The ResourceExtensionReferences value.
    */
    public ArrayList<ResourceExtensionReference> getResourceExtensionReferences() {
        return this.resourceExtensionReferences;
    }
    
    /**
    * Optional. Contains a collection of resource extensions that are to be
    * installed on the Virtual Machine. This element is used if
    * ProvisionGuestAgent is set to true.
    * @param resourceExtensionReferencesValue The ResourceExtensionReferences
    * value.
    */
    public void setResourceExtensionReferences(final ArrayList<ResourceExtensionReference> resourceExtensionReferencesValue) {
        this.resourceExtensionReferences = resourceExtensionReferencesValue;
    }
    
    private String roleName;
    
    /**
    * Required. Specifies the name for the virtual machine. The name must be
    * unique within the deployment.
    * @return The RoleName value.
    */
    public String getRoleName() {
        return this.roleName;
    }
    
    /**
    * Required. Specifies the name for the virtual machine. The name must be
    * unique within the deployment.
    * @param roleNameValue The RoleName value.
    */
    public void setRoleName(final String roleNameValue) {
        this.roleName = roleNameValue;
    }
    
    private String roleSize;
    
    /**
    * Optional. The size of the virtual machine.
    * @return The RoleSize value.
    */
    public String getRoleSize() {
        return this.roleSize;
    }
    
    /**
    * Optional. The size of the virtual machine.
    * @param roleSizeValue The RoleSize value.
    */
    public void setRoleSize(final String roleSizeValue) {
        this.roleSize = roleSizeValue;
    }
    
    /**
    * Initializes a new instance of the VirtualMachineUpdateParameters class.
    *
    */
    public VirtualMachineUpdateParameters() {
        this.setConfigurationSets(new LazyArrayList<ConfigurationSet>());
        this.setDataVirtualHardDisks(new LazyArrayList<DataVirtualHardDisk>());
        this.setResourceExtensionReferences(new LazyArrayList<ResourceExtensionReference>());
    }
    
    /**
    * Initializes a new instance of the VirtualMachineUpdateParameters class
    * with required arguments.
    *
    * @param roleName Specifies the name for the virtual machine. The name must
    * be unique within the deployment.
    * @param oSVirtualHardDisk Contains the parameters Azure used to create the
    * operating system disk for the virtual machine.
    */
    public VirtualMachineUpdateParameters(String roleName, OSVirtualHardDisk oSVirtualHardDisk) {
        this();
        if (roleName == null) {
            throw new NullPointerException("roleName");
        }
        if (oSVirtualHardDisk == null) {
            throw new NullPointerException("oSVirtualHardDisk");
        }
        this.setRoleName(roleName);
        this.setOSVirtualHardDisk(oSVirtualHardDisk);
    }
}
