/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.compute.models;

import com.microsoft.windowsazure.core.LazyArrayList;

import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;

/**
* Parameters supplied to the Update Virtual Machine Image operation.
*/
public class VirtualMachineVMImageUpdateParameters {
    private ArrayList<DataDiskConfigurationUpdateParameters> dataDiskConfigurations;
    
    /**
    * Optional. Optional. The Data Disk Configurations.
    * @return The DataDiskConfigurations value.
    */
    public ArrayList<DataDiskConfigurationUpdateParameters> getDataDiskConfigurations() {
        return this.dataDiskConfigurations;
    }
    
    /**
    * Optional. Optional. The Data Disk Configurations.
    * @param dataDiskConfigurationsValue The DataDiskConfigurations value.
    */
    public void setDataDiskConfigurations(final ArrayList<DataDiskConfigurationUpdateParameters> dataDiskConfigurationsValue) {
        this.dataDiskConfigurations = dataDiskConfigurationsValue;
    }
    
    private String description;
    
    /**
    * Optional. Specifies the description of the OS image.
    * @return The Description value.
    */
    public String getDescription() {
        return this.description;
    }
    
    /**
    * Optional. Specifies the description of the OS image.
    * @param descriptionValue The Description value.
    */
    public void setDescription(final String descriptionValue) {
        this.description = descriptionValue;
    }
    
    private String eula;
    
    /**
    * Optional. Specifies the End User License Agreement that is associated
    * with the image. The value for this element is a string, but it is
    * recommended that the value be a URL that points to a EULA.
    * @return The Eula value.
    */
    public String getEula() {
        return this.eula;
    }
    
    /**
    * Optional. Specifies the End User License Agreement that is associated
    * with the image. The value for this element is a string, but it is
    * recommended that the value be a URL that points to a EULA.
    * @param eulaValue The Eula value.
    */
    public void setEula(final String eulaValue) {
        this.eula = eulaValue;
    }
    
    private String iconUri;
    
    /**
    * Optional. Specifies the URI to the icon that is displayed for the image
    * in the Management Portal.
    * @return The IconUri value.
    */
    public String getIconUri() {
        return this.iconUri;
    }
    
    /**
    * Optional. Specifies the URI to the icon that is displayed for the image
    * in the Management Portal.
    * @param iconUriValue The IconUri value.
    */
    public void setIconUri(final String iconUriValue) {
        this.iconUri = iconUriValue;
    }
    
    private String imageFamily;
    
    /**
    * Optional. Specifies a value that can be used to group OS images.
    * @return The ImageFamily value.
    */
    public String getImageFamily() {
        return this.imageFamily;
    }
    
    /**
    * Optional. Specifies a value that can be used to group OS images.
    * @param imageFamilyValue The ImageFamily value.
    */
    public void setImageFamily(final String imageFamilyValue) {
        this.imageFamily = imageFamilyValue;
    }
    
    private String label;
    
    /**
    * Required. Specifies the friendly name of the image to be updated. You
    * cannot use this operation to update images provided by the Azure
    * platform.
    * @return The Label value.
    */
    public String getLabel() {
        return this.label;
    }
    
    /**
    * Required. Specifies the friendly name of the image to be updated. You
    * cannot use this operation to update images provided by the Azure
    * platform.
    * @param labelValue The Label value.
    */
    public void setLabel(final String labelValue) {
        this.label = labelValue;
    }
    
    private String language;
    
    /**
    * Optional. Specifies the language of the image.
    * @return The Language value.
    */
    public String getLanguage() {
        return this.language;
    }
    
    /**
    * Optional. Specifies the language of the image.
    * @param languageValue The Language value.
    */
    public void setLanguage(final String languageValue) {
        this.language = languageValue;
    }
    
    private OSDiskConfigurationUpdateParameters oSDiskConfiguration;
    
    /**
    * Optional. Optional. The OS Disk Configuration.
    * @return The OSDiskConfiguration value.
    */
    public OSDiskConfigurationUpdateParameters getOSDiskConfiguration() {
        return this.oSDiskConfiguration;
    }
    
    /**
    * Optional. Optional. The OS Disk Configuration.
    * @param oSDiskConfigurationValue The OSDiskConfiguration value.
    */
    public void setOSDiskConfiguration(final OSDiskConfigurationUpdateParameters oSDiskConfigurationValue) {
        this.oSDiskConfiguration = oSDiskConfigurationValue;
    }
    
    private URI privacyUri;
    
    /**
    * Optional. Specifies the URI that points to a document that contains the
    * privacy policy related to the OS image.
    * @return The PrivacyUri value.
    */
    public URI getPrivacyUri() {
        return this.privacyUri;
    }
    
    /**
    * Optional. Specifies the URI that points to a document that contains the
    * privacy policy related to the OS image.
    * @param privacyUriValue The PrivacyUri value.
    */
    public void setPrivacyUri(final URI privacyUriValue) {
        this.privacyUri = privacyUriValue;
    }
    
    private Calendar publishedDate;
    
    /**
    * Optional. Specifies the date when the OS image was added to the image
    * repository.
    * @return The PublishedDate value.
    */
    public Calendar getPublishedDate() {
        return this.publishedDate;
    }
    
    /**
    * Optional. Specifies the date when the OS image was added to the image
    * repository.
    * @param publishedDateValue The PublishedDate value.
    */
    public void setPublishedDate(final Calendar publishedDateValue) {
        this.publishedDate = publishedDateValue;
    }
    
    private String recommendedVMSize;
    
    /**
    * Optional. Specifies the size to use for the virtual machine that is
    * created from the OS image.
    * @return The RecommendedVMSize value.
    */
    public String getRecommendedVMSize() {
        return this.recommendedVMSize;
    }
    
    /**
    * Optional. Specifies the size to use for the virtual machine that is
    * created from the OS image.
    * @param recommendedVMSizeValue The RecommendedVMSize value.
    */
    public void setRecommendedVMSize(final String recommendedVMSizeValue) {
        this.recommendedVMSize = recommendedVMSizeValue;
    }
    
    private Boolean showInGui;
    
    /**
    * Optional. Optional. True or False.
    * @return The ShowInGui value.
    */
    public Boolean isShowInGui() {
        return this.showInGui;
    }
    
    /**
    * Optional. Optional. True or False.
    * @param showInGuiValue The ShowInGui value.
    */
    public void setShowInGui(final Boolean showInGuiValue) {
        this.showInGui = showInGuiValue;
    }
    
    private String smallIconUri;
    
    /**
    * Optional. Specifies the URI to the small icon that is displayed when the
    * image is presented in the Azure Management Portal.
    * @return The SmallIconUri value.
    */
    public String getSmallIconUri() {
        return this.smallIconUri;
    }
    
    /**
    * Optional. Specifies the URI to the small icon that is displayed when the
    * image is presented in the Azure Management Portal.
    * @param smallIconUriValue The SmallIconUri value.
    */
    public void setSmallIconUri(final String smallIconUriValue) {
        this.smallIconUri = smallIconUriValue;
    }
    
    /**
    * Initializes a new instance of the VirtualMachineVMImageUpdateParameters
    * class.
    *
    */
    public VirtualMachineVMImageUpdateParameters() {
        this.setDataDiskConfigurations(new LazyArrayList<DataDiskConfigurationUpdateParameters>());
    }
    
    /**
    * Initializes a new instance of the VirtualMachineVMImageUpdateParameters
    * class with required arguments.
    *
    * @param label Specifies the friendly name of the image to be updated. You
    * cannot use this operation to update images provided by the Azure
    * platform.
    */
    public VirtualMachineVMImageUpdateParameters(String label) {
        this();
        if (label == null) {
            throw new NullPointerException("label");
        }
        this.setLabel(label);
    }
}
