/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.mediaservices;

import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.mediaservices.models.MediaServicesAccountCreateParameters;
import com.microsoft.windowsazure.management.mediaservices.models.MediaServicesAccountCreateResponse;
import com.microsoft.windowsazure.management.mediaservices.models.MediaServicesAccountGetResponse;
import com.microsoft.windowsazure.management.mediaservices.models.MediaServicesAccountListResponse;
import com.microsoft.windowsazure.management.mediaservices.models.MediaServicesKeyType;
import org.xml.sax.SAXException;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.concurrent.Future;

public interface AccountOperations {
    /**
    * The Create Media Services Account operation creates a new media services
    * account in Windows Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn194267.aspx for
    * more information)
    *
    * @param parameters Required. Parameters supplied to the Create Media
    * Services Account operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The Create Media Services Account operation response.
    */
    MediaServicesAccountCreateResponse create(MediaServicesAccountCreateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * The Create Media Services Account operation creates a new media services
    * account in Windows Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn194267.aspx for
    * more information)
    *
    * @param parameters Required. Parameters supplied to the Create Media
    * Services Account operation.
    * @return The Create Media Services Account operation response.
    */
    Future<MediaServicesAccountCreateResponse> createAsync(MediaServicesAccountCreateParameters parameters);
    
    /**
    * The Delete Media Services Account operation deletes an existing media
    * services account in Windows Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn194273.aspx for
    * more information)
    *
    * @param accountName Required. The name of the media services account.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse delete(String accountName) throws IOException, ServiceException;
    
    /**
    * The Delete Media Services Account operation deletes an existing media
    * services account in Windows Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn194273.aspx for
    * more information)
    *
    * @param accountName Required. The name of the media services account.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> deleteAsync(String accountName);
    
    /**
    * The Get Media Services Account operation gets detailed information about
    * a media services account in Windows Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166974.aspx for
    * more information)
    *
    * @param accountName Required. The name of the Media Services account.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The Get Media Services Account operation response.
    */
    MediaServicesAccountGetResponse get(String accountName) throws IOException, ServiceException;
    
    /**
    * The Get Media Services Account operation gets detailed information about
    * a media services account in Windows Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166974.aspx for
    * more information)
    *
    * @param accountName Required. The name of the Media Services account.
    * @return The Get Media Services Account operation response.
    */
    Future<MediaServicesAccountGetResponse> getAsync(String accountName);
    
    /**
    * The List Media Services Account operation gets information about all
    * existing media services accounts associated with the current
    * subscription in Windows Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166989.aspx for
    * more information)
    *
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The List Media Accounts operation response.
    */
    MediaServicesAccountListResponse list() throws IOException, ServiceException, ParserConfigurationException, SAXException, URISyntaxException;
    
    /**
    * The List Media Services Account operation gets information about all
    * existing media services accounts associated with the current
    * subscription in Windows Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166989.aspx for
    * more information)
    *
    * @return The List Media Accounts operation response.
    */
    Future<MediaServicesAccountListResponse> listAsync();
    
    /**
    * The Regenerate Media Services Account Key operation regenerates an
    * account key for the given Media Services account in Windows Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn167010.aspx for
    * more information)
    *
    * @param accountName Required. The name of the Media Services Account.
    * @param keyType Required. The type of key to regenerate (primary or
    * secondary)
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse regenerateKey(String accountName, MediaServicesKeyType keyType) throws IOException, ServiceException;
    
    /**
    * The Regenerate Media Services Account Key operation regenerates an
    * account key for the given Media Services account in Windows Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn167010.aspx for
    * more information)
    *
    * @param accountName Required. The name of the Media Services Account.
    * @param keyType Required. The type of key to regenerate (primary or
    * secondary)
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> regenerateKeyAsync(String accountName, MediaServicesKeyType keyType);
}
