/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.network;

import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.network.models.ApplicationGatewayCertificate;
import com.microsoft.windowsazure.management.network.models.ApplicationGatewayGetCertificate;
import com.microsoft.windowsazure.management.network.models.ApplicationGatewayGetConfiguration;
import com.microsoft.windowsazure.management.network.models.ApplicationGatewayGetResponse;
import com.microsoft.windowsazure.management.network.models.ApplicationGatewayListCertificate;
import com.microsoft.windowsazure.management.network.models.ApplicationGatewayListResponse;
import com.microsoft.windowsazure.management.network.models.ApplicationGatewayOperation;
import com.microsoft.windowsazure.management.network.models.ApplicationGatewayOperationResponse;
import com.microsoft.windowsazure.management.network.models.ApplicationGatewaySetConfiguration;
import com.microsoft.windowsazure.management.network.models.CreateApplicationGatewayParameters;
import com.microsoft.windowsazure.management.network.models.GatewayOperationResponse;
import com.microsoft.windowsazure.management.network.models.UpdateApplicationGatewayParameters;
import org.xml.sax.SAXException;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/**
* The Application Gateway Management API includes operations for managing
* application gateways in your subscription.  (see
* http://msdn.microsoft.com/en-us/library/windowsazure/jj154113.aspx for more
* information)
*/
public interface ApplicationGatewayOperations {
    /**
    * The Add certificate operation adds the ssl certificate to the application
    * gateway  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154114.aspx for
    * more information)
    *
    * @param gatewayName Required. Gateway name
    * @param certificateName Required. Certificate name
    * @param certificate Required. The application gateway ssl certificate
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request.  If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    ApplicationGatewayOperationResponse addCertificate(String gatewayName, String certificateName, ApplicationGatewayCertificate certificate) throws InterruptedException, ExecutionException, ServiceException, IOException;
    
    /**
    * The Add certificate operation adds the ssl certificate to the application
    * gateway  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154114.aspx for
    * more information)
    *
    * @param gatewayName Required. Gateway name
    * @param certificateName Required. Certificate name
    * @param certificate Required. The application gateway ssl certificate
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request.  If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    Future<ApplicationGatewayOperationResponse> addCertificateAsync(String gatewayName, String certificateName, ApplicationGatewayCertificate certificate);
    
    /**
    * The Begin Add certificate operation adds the ssl certificate to the
    * application gateway  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154114.aspx for
    * more information)
    *
    * @param gatewayName Required. Gateway name
    * @param certificateName Required. Certificate name
    * @param certificate Required. The application gateway ssl certificate
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    GatewayOperationResponse beginAddCertificate(String gatewayName, String certificateName, ApplicationGatewayCertificate certificate) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * The Begin Add certificate operation adds the ssl certificate to the
    * application gateway  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154114.aspx for
    * more information)
    *
    * @param gatewayName Required. Gateway name
    * @param certificateName Required. Certificate name
    * @param certificate Required. The application gateway ssl certificate
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<GatewayOperationResponse> beginAddCertificateAsync(String gatewayName, String certificateName, ApplicationGatewayCertificate certificate);
    
    /**
    * The Begin Create Application Gateway operation  creates Application
    * Gateway with the specified  parameters.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154114.aspx for
    * more information)
    *
    * @param parameters Required. Parameters supplied to the Begin
    * CreateApplication Gateway request.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    GatewayOperationResponse beginCreateApplicationGateway(CreateApplicationGatewayParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * The Begin Create Application Gateway operation  creates Application
    * Gateway with the specified  parameters.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154114.aspx for
    * more information)
    *
    * @param parameters Required. Parameters supplied to the Begin
    * CreateApplication Gateway request.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<GatewayOperationResponse> beginCreateApplicationGatewayAsync(CreateApplicationGatewayParameters parameters);
    
    /**
    * The Begin Delete Application Gateway operation  deletes Application
    * Gateway with the specified  parameters.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154114.aspx for
    * more information)
    *
    * @param gatewayName Required. The name of the gateway.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    GatewayOperationResponse beginDeleteApplicationGateway(String gatewayName) throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * The Begin Delete Application Gateway operation  deletes Application
    * Gateway with the specified  parameters.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154114.aspx for
    * more information)
    *
    * @param gatewayName Required. The name of the gateway.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<GatewayOperationResponse> beginDeleteApplicationGatewayAsync(String gatewayName);
    
    /**
    * The Begin Delete Application Gateway certificate.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154114.aspx for
    * more information)
    *
    * @param gatewayName Required. The name of the gateway.
    * @param certificateName Required. The name of the certificate.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    GatewayOperationResponse beginDeleteApplicationGatewayCertificate(String gatewayName, String certificateName) throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * The Begin Delete Application Gateway certificate.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154114.aspx for
    * more information)
    *
    * @param gatewayName Required. The name of the gateway.
    * @param certificateName Required. The name of the certificate.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<GatewayOperationResponse> beginDeleteApplicationGatewayCertificateAsync(String gatewayName, String certificateName);
    
    /**
    * The Execute Application Gateway Operation executes specified operation on
    * Application Gateway .  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154114.aspx for
    * more information)
    *
    * @param gatewayName Required. Name of the gateway
    * @param parameters Required. Parameters supplied to the Begin Execute
    * Operation request.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    GatewayOperationResponse beginExecuteOperation(String gatewayName, ApplicationGatewayOperation parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * The Execute Application Gateway Operation executes specified operation on
    * Application Gateway .  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154114.aspx for
    * more information)
    *
    * @param gatewayName Required. Name of the gateway
    * @param parameters Required. Parameters supplied to the Begin Execute
    * Operation request.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<GatewayOperationResponse> beginExecuteOperationAsync(String gatewayName, ApplicationGatewayOperation parameters);
    
    /**
    * The Begin Set Application Gateway config operation  sets the specified
    * config on the application gateway  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154114.aspx for
    * more information)
    *
    * @param gatewayName Required. Gateway name
    * @param config Required. The Begin Set Application Gateway Config
    * operation  sets the specified config on the application gateway
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    GatewayOperationResponse beginSetConfig(String gatewayName, ApplicationGatewaySetConfiguration config) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * The Begin Set Application Gateway config operation  sets the specified
    * config on the application gateway  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154114.aspx for
    * more information)
    *
    * @param gatewayName Required. Gateway name
    * @param config Required. The Begin Set Application Gateway Config
    * operation  sets the specified config on the application gateway
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<GatewayOperationResponse> beginSetConfigAsync(String gatewayName, ApplicationGatewaySetConfiguration config);
    
    /**
    * The Begin Update Application Gateway operation  updates Application
    * Gateway with the specified  parameters.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154114.aspx for
    * more information)
    *
    * @param gatewayName Required. Gateway name
    * @param updateParameters Required. Parameters supplied to the Begin
    * UpdateApplication Gateway request.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    GatewayOperationResponse beginUpdateApplicationGateway(String gatewayName, UpdateApplicationGatewayParameters updateParameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * The Begin Update Application Gateway operation  updates Application
    * Gateway with the specified  parameters.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154114.aspx for
    * more information)
    *
    * @param gatewayName Required. Gateway name
    * @param updateParameters Required. Parameters supplied to the Begin
    * UpdateApplication Gateway request.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<GatewayOperationResponse> beginUpdateApplicationGatewayAsync(String gatewayName, UpdateApplicationGatewayParameters updateParameters);
    
    /**
    * The Create Application Gateway operation  creates Application Gateway
    * with the specified parameters.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154114.aspx for
    * more information)
    *
    * @param parameters Required. Parameters supplied to CreateApplication
    * Gateway request.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request.  If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    ApplicationGatewayOperationResponse create(CreateApplicationGatewayParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException, ParserConfigurationException, SAXException;
    
    /**
    * The Create Application Gateway operation  creates Application Gateway
    * with the specified parameters.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154114.aspx for
    * more information)
    *
    * @param parameters Required. Parameters supplied to CreateApplication
    * Gateway request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request.  If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    Future<ApplicationGatewayOperationResponse> createAsync(CreateApplicationGatewayParameters parameters);
    
    /**
    * The Delete Application Gateway operation  deletes Application Gateway
    * with the specified  parameters.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154114.aspx for
    * more information)
    *
    * @param gatewayName Required. The name of the gateway.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request.  If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    ApplicationGatewayOperationResponse delete(String gatewayName) throws InterruptedException, ExecutionException, ServiceException, IOException, ParserConfigurationException, SAXException;
    
    /**
    * The Delete Application Gateway operation  deletes Application Gateway
    * with the specified  parameters.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154114.aspx for
    * more information)
    *
    * @param gatewayName Required. The name of the gateway.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request.  If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    Future<ApplicationGatewayOperationResponse> deleteAsync(String gatewayName);
    
    /**
    * The Delete Application Gateway certificate operation.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154114.aspx for
    * more information)
    *
    * @param gatewayName Required. The name of the gateway.
    * @param certificateName Required. The name of the certificate.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request.  If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    ApplicationGatewayOperationResponse deleteCertificate(String gatewayName, String certificateName) throws InterruptedException, ExecutionException, ServiceException, IOException;
    
    /**
    * The Delete Application Gateway certificate operation.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154114.aspx for
    * more information)
    *
    * @param gatewayName Required. The name of the gateway.
    * @param certificateName Required. The name of the certificate.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request.  If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    Future<ApplicationGatewayOperationResponse> deleteCertificateAsync(String gatewayName, String certificateName);
    
    /**
    * The Execute Application Gateway Operation executes specofoed operation in
    * the Application Gateway.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154114.aspx for
    * more information)
    *
    * @param gatewayName Required. Name of the gateway
    * @param parameters Required. Parameters supplied to Execute Operation
    * request.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request.  If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    ApplicationGatewayOperationResponse executeOperation(String gatewayName, ApplicationGatewayOperation parameters) throws InterruptedException, ExecutionException, ServiceException, IOException;
    
    /**
    * The Execute Application Gateway Operation executes specofoed operation in
    * the Application Gateway.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154114.aspx for
    * more information)
    *
    * @param gatewayName Required. Name of the gateway
    * @param parameters Required. Parameters supplied to Execute Operation
    * request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request.  If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    Future<ApplicationGatewayOperationResponse> executeOperationAsync(String gatewayName, ApplicationGatewayOperation parameters);
    
    /**
    * The Get Application Gateway operation retrieves the application gateway
    * provisioned for the given subscription.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157196.aspx for
    * more information)
    *
    * @param gatewayName Required. The name of the gateway.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return The response body contains details of the application gateway.
    */
    ApplicationGatewayGetResponse get(String gatewayName) throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * The Get Application Gateway operation retrieves the application gateway
    * provisioned for the given subscription.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157196.aspx for
    * more information)
    *
    * @param gatewayName Required. The name of the gateway.
    * @return The response body contains details of the application gateway.
    */
    Future<ApplicationGatewayGetResponse> getAsync(String gatewayName);
    
    /**
    * The Get Application Gateway certificate operation retrieves the ssl
    * certificate provisioned for the given gateway.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157196.aspx for
    * more information)
    *
    * @param gatewayName Required. The name of the gateway.
    * @param certificateName Required. The name of the certificate.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return Response of GetApplicationGatewayCertificate request.
    */
    ApplicationGatewayGetCertificate getCertificate(String gatewayName, String certificateName) throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * The Get Application Gateway certificate operation retrieves the ssl
    * certificate provisioned for the given gateway.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157196.aspx for
    * more information)
    *
    * @param gatewayName Required. The name of the gateway.
    * @param certificateName Required. The name of the certificate.
    * @return Response of GetApplicationGatewayCertificate request.
    */
    Future<ApplicationGatewayGetCertificate> getCertificateAsync(String gatewayName, String certificateName);
    
    /**
    * The Get Application Gateway Configuration operation retrieves the
    * configuration of the gateway.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157196.aspx for
    * more information)
    *
    * @param gatewayName Required. The id  of the gateway.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return The response to a GetApplicationGatewayConfiguation  request.
    */
    ApplicationGatewayGetConfiguration getConfig(String gatewayName) throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * The Get Application Gateway Configuration operation retrieves the
    * configuration of the gateway.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157196.aspx for
    * more information)
    *
    * @param gatewayName Required. The id  of the gateway.
    * @return The response to a GetApplicationGatewayConfiguation  request.
    */
    Future<ApplicationGatewayGetConfiguration> getConfigAsync(String gatewayName);
    
    /**
    * The Get Operation Status operation returns the status of the specified
    * operation. After calling an asynchronous operation, you can call Get
    * Operation Status to determine whether the operation has succeeded,
    * failed, or is still in progress.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460783.aspx for
    * more information)
    *
    * @param requestId Required. The request ID for the request you wish to
    * track. The request ID is returned in the x-ms-request-id response header
    * for every request.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request.  If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    ApplicationGatewayOperationResponse getOperationStatus(String requestId) throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * The Get Operation Status operation returns the status of the specified
    * operation. After calling an asynchronous operation, you can call Get
    * Operation Status to determine whether the operation has succeeded,
    * failed, or is still in progress.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460783.aspx for
    * more information)
    *
    * @param requestId Required. The request ID for the request you wish to
    * track. The request ID is returned in the x-ms-request-id response header
    * for every request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request.  If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    Future<ApplicationGatewayOperationResponse> getOperationStatusAsync(String requestId);
    
    /**
    * The List Application Gateway operation retrieves all application gateays
    * for the given subscription.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157196.aspx for
    * more information)
    *
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return The response of ListApplicationGateways request.
    */
    ApplicationGatewayListResponse list() throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * The List Application Gateway operation retrieves all application gateays
    * for the given subscription.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157196.aspx for
    * more information)
    *
    * @return The response of ListApplicationGateways request.
    */
    Future<ApplicationGatewayListResponse> listAsync();
    
    /**
    * The List Application Gateway certificates.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157196.aspx for
    * more information)
    *
    * @param gatewayName Required. Gateway name
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return The response to a ListApplicationGatewayCertificate request.
    */
    ApplicationGatewayListCertificate listCertificate(String gatewayName) throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * The List Application Gateway certificates.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157196.aspx for
    * more information)
    *
    * @param gatewayName Required. Gateway name
    * @return The response to a ListApplicationGatewayCertificate request.
    */
    Future<ApplicationGatewayListCertificate> listCertificateAsync(String gatewayName);
    
    /**
    * The Set Application Gateway Config operation  sets the specified config
    * on the application gateway  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154114.aspx for
    * more information)
    *
    * @param gatewayName Required. Gateway name
    * @param config Required. Parameters supplied to Set Application Gateway
    * config request.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request.  If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    ApplicationGatewayOperationResponse setConfig(String gatewayName, ApplicationGatewaySetConfiguration config) throws InterruptedException, ExecutionException, ServiceException, IOException;
    
    /**
    * The Set Application Gateway Config operation  sets the specified config
    * on the application gateway  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154114.aspx for
    * more information)
    *
    * @param gatewayName Required. Gateway name
    * @param config Required. Parameters supplied to Set Application Gateway
    * config request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request.  If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    Future<ApplicationGatewayOperationResponse> setConfigAsync(String gatewayName, ApplicationGatewaySetConfiguration config);
    
    /**
    * The Update Application Gateway operation  updates Application Gateway
    * with the specified  parameters.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154114.aspx for
    * more information)
    *
    * @param gatewayName Required. Gateway name
    * @param updateParameters Required. Parameters supplied to
    * UpdateApplication Gateway request.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request.  If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    ApplicationGatewayOperationResponse update(String gatewayName, UpdateApplicationGatewayParameters updateParameters) throws InterruptedException, ExecutionException, ServiceException, IOException;
    
    /**
    * The Update Application Gateway operation  updates Application Gateway
    * with the specified  parameters.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154114.aspx for
    * more information)
    *
    * @param gatewayName Required. Gateway name
    * @param updateParameters Required. Parameters supplied to
    * UpdateApplication Gateway request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request.  If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    Future<ApplicationGatewayOperationResponse> updateAsync(String gatewayName, UpdateApplicationGatewayParameters updateParameters);
}
